/*
 * Decompiled with CFR 0.152.
 */
package edu.nwu.ccl.nlogo.extensions.sound;

import edu.nwu.ccl.nlogo.extensions.sound.Dump;
import edu.nwu.ccl.nlogo.extensions.sound.ListDrums;
import edu.nwu.ccl.nlogo.extensions.sound.ListInstruments;
import edu.nwu.ccl.nlogo.extensions.sound.PlayDrum;
import edu.nwu.ccl.nlogo.extensions.sound.PlayNote;
import edu.nwu.ccl.nlogo.extensions.sound.StartNote;
import edu.nwu.ccl.nlogo.extensions.sound.StopInstrument;
import edu.nwu.ccl.nlogo.extensions.sound.StopMusic;
import edu.nwu.ccl.nlogo.extensions.sound.StopNote;
import java.util.Arrays;
import java.util.List;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.Primitive;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.util.Exceptions;

public class SoundExtension
extends DefaultClassManager {
    static final List DRUM_NAMES = Arrays.asList("ACOUSTIC BASS DRUM", "BASS DRUM 1", "SIDE STICK", "ACOUSTIC SNARE", "HAND CLAP", "ELECTRIC SNARE", "LOW FLOOR TOM", "CLOSED HI HAT", "HI FLOOR TOM", "PEDAL HI HAT", "LOW TOM", "OPEN HI HAT", "LOW MID TOM", "HI MID TOM", "CRASH CYMBAL 1", "HI TOM", "RIDE CYMBAL 1", "CHINESE CYMBAL", "RIDE BELL", "TAMBOURINE", "SPLASH CYMBAL", "COWBELL", "CRASH CYMBAL 2", "VIBRASLAP", "RIDE CYMBAL 2", "HI BONGO", "LOW BONGO", "MUTE HI CONGA", "OPEN HI CONGA", "LOW CONGA", "HI TIMBALE", "LOW TIMBALE", "HI AGOGO", "LOW AGOGO", "CABASA", "MARACAS", "SHORT WHISTLE", "LONG WHISTLE", "SHORT GUIRO", "LONG GUIRO", "CLAVES", "HI WOOD BLOCK", "LOW WOOD BLOCK", "MUTE CUICA", "OPEN CUICA", "MUTE TRIANGLE", "OPEN TRIANGLE");
    static final List INSTRUMENT_NAMES = Arrays.asList("ACOUSTIC GRAND PIANO", "BRIGHT ACOUSTIC PIANO", "ELECTRIC GRAND PIANO", "HONKY-TONK PIANO", "ELECTRIC PIANO 1", "ELECTRIC PIANO 2", "HARPSICHORD", "CLAVI", "CELESTA", "GLOCKENSPIEL", "MUSIC BOX", "VIBRAPHONE", "MARIMBA", "XYLOPHONE", "TUBULAR BELLS", "DULCIMER", "DRAWBAR ORGAN", "PERCUSSIVE ORGAN", "ROCK ORGAN", "CHURCH ORGAN", "REED ORGAN", "ACCORDION", "HARMONICA", "TANGO ACCORDION", "NYLON STRING GUITAR", "STEEL ACOUSTIC GUITAR", "JAZZ ELECTRIC GUITAR", "CLEAN ELECTRIC GUITAR", "MUTED ELECTRIC GUITAR", "OVERDRIVEN GUITAR", "DISTORTION GUITAR", "GUITAR HARMONICS", "ACOUSTIC BASS", "FINGERED ELECTRIC BASS", "PICKED ELECTRIC BASS", "FRETLESS BASS", "SLAP BASS 1", "SLAP BASS 2", "SYNTH BASS 1", "SYNTH BASS 2", "VIOLIN", "VIOLA", "CELLO", "CONTRABASS", "TREMOLO STRINGS", "PIZZICATO STRINGS", "ORCHESTRAL HARP", "TIMPANI", "STRING ENSEMBLE 1", "STRING ENSEMBLE 2", "SYNTH STRINGS 1", "SYNTH STRINGS 2", "CHOIR AAHS", "VOICE OOHS", "SYNTH VOICE", "ORCHESTRA HIT", "TRUMPET", "TROMBONE", "TUBA", "MUTED TRUMPET", "FRENCH HORN", "BRASS SECTION", "SYNTH BRASS 1", "SYNTH BRASS 2", "SOPRANO SAX", "ALTO SAX", "TENOR SAX", "BARITONE SAX", "OBOE", "ENGLISH HORN", "BASSOON", "CLARINET", "PICCOLO", "FLUTE", "RECORDER", "PAN FLUTE", "BLOWN BOTTLE", "SHAKUHACHI", "WHISTLE", "OCARINA", "SQUARE WAVE", "SAWTOOTH WAVE", "CALLIOPE", "CHIFF", "CHARANG", "VOICE", "FIFTHS", "BASS AND LEAD", "NEW AGE", "WARM", "POLYSYNTH", "CHOIR", "BOWED", "METAL", "HALO", "SWEEP", "RAIN", "SOUNDTRACK", "CRYSTAL", "ATMOSPHERE", "BRIGHTNESS", "GOBLINS", "ECHOES", "SCI-FI", "SITAR", "BANJO", "SHAMISEN", "KOTO", "KALIMBA", "BAG PIPE", "FIDDLE", "SHANAI", "TINKLE BELL", "AGOGO", "STEEL DRUMS", "WOODBLOCK", "TAIKO DRUM", "MELODIC TOM", "SYNTH DRUM", "REVERSE CYMBAL", "GUITAR FRET NOISE", "BREATH NOISE", "SEASHORE", "BIRD TWEET", "TELEPHONE RING", "HELICOPTER", "APPLAUSE", "GUNSHOT");
    private static final int PERCUSSION_CHANNEL = 9;
    private static Synthesizer synth;
    private static MidiChannel[] channels;
    private static int nextChannel;

    public void load(PrimitiveManager primManager) {
        primManager.addPrimitive("drums", (Primitive)new ListDrums());
        primManager.addPrimitive("instruments", (Primitive)new ListInstruments());
        primManager.addPrimitive("play-drum", (Primitive)new PlayDrum());
        primManager.addPrimitive("play-note", (Primitive)new PlayNote());
        primManager.addPrimitive("start-note", (Primitive)new StartNote());
        primManager.addPrimitive("stop-note", (Primitive)new StopNote());
        primManager.addPrimitive("stop-instrument", (Primitive)new StopInstrument());
        primManager.addPrimitive("stop-music", (Primitive)new StopMusic());
        primManager.addPrimitive("__synth-dump", (Primitive)new Dump());
    }

    public void runOnce() {
        try {
            synth = MidiSystem.getSynthesizer();
            synth.open();
            channels = synth.getChannels();
            Soundbank soundbank = synth.getDefaultSoundbank();
            if (soundbank == null) {
                throw new RuntimeException("Cannot load soundbank");
            }
            boolean bl = synth.loadAllInstruments(soundbank);
        }
        catch (MidiUnavailableException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    static void startNote(int instrument, int note, int velocity) {
        MidiChannel channel = SoundExtension.ensureChannel(instrument);
        channel.noteOn(note, velocity);
    }

    static void stopNote(int instrument, int note) {
        MidiChannel channel = SoundExtension.getChannel(instrument);
        if (channel != null) {
            channel.noteOff(note);
        }
    }

    static void stopNotes(int instrument) {
        MidiChannel channel = SoundExtension.getChannel(instrument);
        if (channel != null) {
            channel.setMute(true);
            channel.setMute(false);
        }
    }

    static void stopNotes() {
        channels[0].allNotesOff();
    }

    static void playNote(int instrument, int note, int velocity, int duration) {
        MidiChannel channel = SoundExtension.ensureChannel(instrument);
        channel.noteOn(note, velocity);
        if (duration > -1) {
            new StopNoteThread(channel, note, duration).start();
        }
    }

    static void playDrum(int drum, int velocity) {
        channels[9].noteOn(drum, velocity);
    }

    static int getInstrument(String name) throws ExtensionException {
        int instrument = INSTRUMENT_NAMES.indexOf(name = name.toUpperCase().intern());
        if (instrument != -1) {
            return instrument;
        }
        throw new ExtensionException("No such instrument: " + name);
    }

    static int getDrum(String name) throws ExtensionException {
        int drum = DRUM_NAMES.indexOf(name = name.toUpperCase().intern());
        if (drum != -1) {
            return drum + 35;
        }
        throw new ExtensionException("No such drum: " + name);
    }

    static String dump() {
        StringBuffer s = new StringBuffer();
        int j = 0;
        while (j < channels.length) {
            String name;
            int instrument = channels[j].getProgram();
            String string = name = instrument > -1 ? instrument + ". " + INSTRUMENT_NAMES.get(instrument) : "N/A";
            if (j == 9) {
                name = name + " <PERCUSSION>";
            }
            s.append("" + j + '\t' + name + '\n');
            ++j;
        }
        return s.toString();
    }

    private static final MidiChannel getChannel(int instrument) {
        int j = 0;
        while (j < channels.length) {
            if (j != 9 && channels[j].getProgram() == instrument) {
                return channels[j];
            }
            ++j;
        }
        return null;
    }

    private static final MidiChannel ensureChannel(int instrument) {
        MidiChannel channel = SoundExtension.getChannel(instrument);
        if (channel != null) {
            return channel;
        }
        channel = channels[nextChannel];
        channel.allNotesOff();
        channel.programChange(instrument);
        if (++nextChannel == 9) {
            ++nextChannel;
        }
        if (nextChannel >= channels.length) {
            nextChannel = 0;
        }
        return channel;
    }

    static {
        nextChannel = 0;
    }

    private static class StopNoteThread
    extends Thread {
        private MidiChannel channel;
        private int note;
        private int duration;

        public void run() {
            try {
                Thread.sleep(this.duration);
            }
            catch (InterruptedException e) {
                Exceptions.ignore((Throwable)e);
            }
            this.channel.noteOff(this.note);
        }

        StopNoteThread(MidiChannel channel, int note, int duration) {
            this.channel = channel;
            this.note = note;
            this.duration = duration;
        }
    }
}

