/*
 * Decompiled with CFR 0.152.
 */
package edu.nwu.ccl.nlogo.extensions.texas;

import edu.nwu.ccl.nlogo.extensions.texas.IOUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import junit.framework.TestCase;
import org.nlogo.agent.LogoList;
import org.nlogo.util.Exceptions;

public strictfp class TestIOUtils
extends TestCase {
    private static final String[][] simpleLines = new String[][]{{"hi there.", "how's it going", "5", "6"}, {"line2", "stuff", "more stuff", "45", "6.8"}, {"line3", "other stuff", "more stuff", "hi", "/twe"}};
    private static final String[][] complexLines = new String[][]{{"hi there.", "how's it going", "5", "6"}, {"line2", "stuff", "more stuff", "45", "6.8"}, {""}, {"line4", "other stuff", "more stuff", "hi", "/twe"}};

    private final ListStringProducer fileCreator(String[][] lines, String lineDelim) {
        StringBuffer buf = new StringBuffer();
        LogoList linesList = new LogoList();
        int i = 0;
        while (i < lines.length) {
            ListStringProducer temp = this.lineCreator(lines[i]);
            linesList.add((Object)temp.expectedList);
            buf.append(temp.inputString);
            if (i + 1 < lines.length) {
                buf.append(lineDelim);
            }
            ++i;
        }
        return new ListStringProducer(linesList, buf);
    }

    private final ListStringProducer lineCreator(String[] tabs) {
        StringBuffer buf = new StringBuffer();
        LogoList l = new LogoList(tabs.length);
        int i = 0;
        while (i < tabs.length) {
            buf.append(tabs[i]);
            l.add((Object)tabs[i]);
            if (i + 1 < tabs.length) {
                buf.append("\t");
            }
            ++i;
        }
        return new ListStringProducer(l, buf);
    }

    private final void splitIntoStringsHelper(String s, LogoList expected) {
        TestIOUtils.assertEquals((Object)expected, (Object)IOUtils.splitIntoLists(s, "\t"));
    }

    public void testSplitEmptyString() {
        LogoList expected = new LogoList();
        LogoList l = new LogoList();
        l.add((Object)"");
        expected.add((Object)l);
        this.splitIntoStringsHelper("", expected);
    }

    public void testSplitEmptyLine() {
        String[] tabs = new String[]{""};
        LogoList expected = new LogoList();
        ListStringProducer temp = this.lineCreator(tabs);
        expected.add((Object)temp.expectedList);
        this.splitIntoStringsHelper(temp.inputString, expected);
    }

    public void testSplitLine() {
        String[] tabs = new String[]{"hi there.", "how's it going", "5", "6"};
        LogoList expected = new LogoList();
        ListStringProducer temp = this.lineCreator(tabs);
        expected.add((Object)temp.expectedList);
        this.splitIntoStringsHelper(temp.inputString, expected);
    }

    public void testSplitFile1() {
        ListStringProducer file = this.fileCreator(simpleLines, "\n");
        this.splitIntoStringsHelper(file.inputString, file.expectedList);
    }

    public void testSplitFile2() {
        ListStringProducer file = this.fileCreator(complexLines, "\n");
        this.splitIntoStringsHelper(file.inputString, file.expectedList);
    }

    public void testSplitFile3() {
        ListStringProducer file = this.fileCreator(complexLines, "\r");
        this.splitIntoStringsHelper(file.inputString, file.expectedList);
    }

    public void testSplitFile4() {
        ListStringProducer file = this.fileCreator(complexLines, "\r\n");
        this.splitIntoStringsHelper(file.inputString, file.expectedList);
    }

    public void testReadURL1() throws IOException {
        try {
            IOUtils.readURL("ghjkfghjfh");
            TestIOUtils.assertTrue((boolean)false);
        }
        catch (MalformedURLException ex) {
            Exceptions.ignore((Throwable)ex);
        }
    }

    public void testReadURL2() {
        try {
            IOUtils.readURL("http://www.ghjfgjkhfgjkfjkgfjkgfhjkgkfjghjkfghjkghjkajkahjkkjjkfhdg5789454.com/");
            TestIOUtils.assertTrue((boolean)false);
        }
        catch (IOException ex) {
            Exceptions.ignore((Throwable)ex);
        }
    }

    public TestIOUtils(String name) {
        super(name);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ListStringProducer {
        public LogoList expectedList;
        public String inputString;

        public ListStringProducer(LogoList l, StringBuffer buf) {
            this.expectedList = l;
            this.inputString = buf.toString();
        }
    }
}

