/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentException;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ImportLexer;
import org.nlogo.agent.ImportLexerOld;
import org.nlogo.agent.NullLabel;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.agent.WorldResizer;
import org.nlogo.util.Exceptions;
import org.nlogo.util.LexerException;
import org.nlogo.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class Importer {
    private static final String SCREEN_EDGE_X_HEADER = "SCREEN-EDGE-X";
    private static final String SCREEN_EDGE_Y_HEADER = "SCREEN-EDGE-Y";
    private static final int ILLEGAL_AGENT_VAR_ERROR = 0;
    private static final int ILLEGAL_SHAPE_ERROR = 1;
    private static final int ILLEGAL_BREED_ERROR = 2;
    private static final int PARSING_ERROR = 3;
    private static final int SETTING_VAR_ERROR = 4;
    private static final int UNDECLARED_AGENT_VAR_ERROR = 5;
    private static final int TOO_MANY_VALUES_ERROR = 6;
    private static final int NON_FATAL_ERRORS = 6;
    private static final int ILLEGAL_CLASS_CAST_ERROR = 7;
    private static final int UNEXPECTED_EOF_ERROR = 8;
    private static final int ERROR_GIVEN = 9;
    private static final int FILE_STRUCTURE_ERROR = 10;
    private static final int UNDECLARED_ESSENTIAL_VAR_ERROR = 11;
    private static final int UNIMPORTED_ESSENTIAL_VAR_ERROR = 12;
    private static final int BLANK_TURTLE_ERROR = 13;
    private static final int CSV_LEXING_ERROR = 14;
    private static final int ILLEGAL_PCOR_ERROR = 15;
    private static final int UNKNOWN_ERROR = 16;
    private static final String NO_DETAILS = "";
    private final WorldResizer resizer;
    private final ErrorHandler errorHandler;
    private final World world;
    private final StringReader stringReader;
    private Set shapesNotToImport;
    private Set breedsNotToImport;
    private List someBreedOwns;
    private BitSet varsToImport;
    private List builtInVars;
    private boolean tooManyValuesForSection;
    private boolean oldImportFormat;
    private Map specialVariables;
    private Map essentialVarHeadersToImport;
    private int lineNum;
    private String nextLine;
    private String[] nextLineFields;
    private String[] sentinels;
    private int numSentinels;
    private int currentSentinel;
    private BufferedReader lines;
    static /* synthetic */ Class class$org$nlogo$agent$Observer;
    static /* synthetic */ Class class$org$nlogo$agent$Turtle;
    static /* synthetic */ Class class$org$nlogo$agent$Patch;

    private final void setupVarsToImport(int size) {
        this.varsToImport = new BitSet(size);
        int j = 0;
        while (j < size) {
            this.varsToImport.set(j);
            ++j;
        }
    }

    public void importWorld(BufferedReader fileBuff) throws IOException {
        block8: {
            this.lines = fileBuff;
            try {
                while (this.hasMoreLines()) {
                    String versionHeader;
                    String[] line = this.nextLine();
                    if (line[0].startsWith(versionHeader = "export-world data (NetLogo ")) {
                        String versionNumber = line[0].substring(versionHeader.length());
                        if (!this.oldImportFormat && (versionNumber.startsWith("1.2") || versionNumber.startsWith("1.1") || versionNumber.startsWith("1.0"))) {
                            this.oldImportFormat = true;
                            this.lines.readLine();
                            ++this.lineNum;
                        }
                    }
                    if (!line[0].trim().equals("RANDOM STATE")) continue;
                    this.hasMoreLines();
                    line = this.nextLine();
                    this.world.random.load(line[0]);
                }
                this.world.clearAll();
                Class clazz = class$org$nlogo$agent$Observer;
                if (clazz == null) {
                    clazz = class$org$nlogo$agent$Observer = Importer.class("[Lorg.nlogo.agent.Observer;", false);
                }
                this.importAgents(clazz);
                Class clazz2 = class$org$nlogo$agent$Turtle;
                if (clazz2 == null) {
                    clazz2 = class$org$nlogo$agent$Turtle = Importer.class("[Lorg.nlogo.agent.Turtle;", false);
                }
                this.importAgents(clazz2);
                Class clazz3 = class$org$nlogo$agent$Patch;
                if (clazz3 == null) {
                    clazz3 = class$org$nlogo$agent$Patch = Importer.class("[Lorg.nlogo.agent.Patch;", false);
                }
                this.importAgents(clazz3);
                this.world.turtles().updateAfterImport();
                this.checkForBlankTurtles();
            }
            catch (AbortingImportException aix) {
                this.world.clearAll();
                if (aix.errorType == 9) break block8;
                this.showError(aix);
            }
        }
    }

    private final void importAgents(Class agentClass) throws IOException {
        this.tooManyValuesForSection = false;
        this.builtInVars = this.getImplicitVariables(agentClass);
        String[] headers = this.getHeaders(agentClass);
        this.setupVarsToImport(headers.length);
        while (this.hasMoreLines()) {
            String[] line = this.nextLine();
            try {
                this.importOneAgent(agentClass, line, headers);
            }
            catch (AgentException ex) {
                Exceptions.handle(ex);
            }
        }
    }

    private final void importOneAgent(Class agentClass, String[] line, String[] headers) throws AgentException {
        Map varVals = this.getVarVals(headers, line, agentClass);
        Agent agent = this.nextAgent(agentClass, varVals);
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = Importer.class("[Lorg.nlogo.agent.Observer;", false);
        }
        if (agentClass == clazz) {
            this.setScreenEdges(varVals);
        }
        int i = 0;
        while (i < headers.length) {
            String header = headers[i];
            if (this.isSpecialVariable(agentClass, header)) {
                this.handleSpecialVariable(agent, header, varVals, i);
            } else {
                Object value;
                int varIndex = this.getVarIndex(agent, header, i);
                if (varIndex != -1 && (value = varVals.get(header)) != null) {
                    this.setVarVal(agent, varIndex, header, value);
                }
            }
            ++i;
        }
    }

    private final Agent nextAgent(Class agentClass, Map varVals) throws AgentException {
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = Importer.class("[Lorg.nlogo.agent.Observer;", false);
        }
        if (agentClass == clazz) {
            return this.world.observer();
        }
        Class clazz2 = class$org$nlogo$agent$Turtle;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Turtle = Importer.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        if (agentClass == clazz2) {
            AgentSet breed = this.getTurtleBreed(varVals, (String)this.builtInVars.get(9));
            int id = this.getTurtleId(varVals, (String)this.builtInVars.get(0));
            Turtle turtle = this.world.getOrCreateTurtle(id);
            turtle.setBreed(breed);
            return turtle;
        }
        Class clazz3 = class$org$nlogo$agent$Patch;
        if (clazz3 == null) {
            clazz3 = class$org$nlogo$agent$Patch = Importer.class("[Lorg.nlogo.agent.Patch;", false);
        }
        if (agentClass == clazz3) {
            return this.getPatch(varVals);
        }
        return null;
    }

    private final void handleSpecialVariable(Agent agent, String header, Map varVals, int headerIndex) {
        try {
            int varIndex;
            if (!(agent instanceof Observer) && (varIndex = this.getVarIndex(agent, header, headerIndex)) != -1) {
                if (agent instanceof Turtle) {
                    this.handleSpecialTurtleVariable((Turtle)agent, varVals.get(header), varIndex);
                } else if (agent instanceof Patch) {
                    this.handleSpecialPatchVariable((Patch)agent, varVals.get(header), varIndex);
                }
            }
        }
        catch (ImportException ix) {
            this.showError(ix);
        }
    }

    private final void handleSpecialTurtleVariable(Turtle turtle, Object val, int varIndex) {
        switch (varIndex) {
            case 5: {
                this.setTurtleShape(turtle, val, (String)this.builtInVars.get(5), varIndex);
                break;
            }
            case 7: {
                this.setVarVal(turtle, varIndex, (String)this.builtInVars.get(7), this.getLabel(val));
                break;
            }
            case 0: 
            case 9: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private final void handleSpecialPatchVariable(Patch patch, Object val, int varIndex) {
        switch (varIndex) {
            case 3: {
                this.setVarVal(patch, varIndex, (String)this.builtInVars.get(3), this.getLabel(val));
                break;
            }
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private final String[] getHeaders(Class agentClass) throws IOException {
        if (!this.hasMoreLines()) {
            String abortingError = "No " + this.printName(agentClass) + " headers have been imported. Globals, Turtles, and Patches must be in the same import file.";
            throw new AbortingImportException(8, abortingError);
        }
        String[] mixedCaseHeaders = this.nextLine();
        ArrayList<String> headers = new ArrayList<String>();
        int i = 0;
        while (i < mixedCaseHeaders.length) {
            if (!mixedCaseHeaders[i].trim().equals(NO_DETAILS)) {
                headers.add(mixedCaseHeaders[i].toUpperCase());
            }
            ++i;
        }
        String[] headersArr = headers.toArray(new String[headers.size()]);
        this.varHeadersImported(agentClass, headersArr, true);
        this.varHeadersImported(agentClass, headersArr, false);
        return headersArr;
    }

    private final Map getVarVals(String[] headersArr, String[] values, Class agentClass) {
        int i;
        HashMap<String, Junk> varVals = new HashMap<String, Junk>();
        if (!this.tooManyValuesForSection && values.length > headersArr.length) {
            i = headersArr.length;
            while (i < values.length) {
                if (!values[i].equals(NO_DETAILS)) {
                    this.tooManyValuesForSection = true;
                    StringBuffer stringBuffer = new StringBuffer("There are a total of ").append(headersArr.length).append(' ').append(this.printName(agentClass)).append(" variables declared in this model (including built-in ");
                    Class clazz = class$org$nlogo$agent$Turtle;
                    if (clazz == null) {
                        clazz = Importer.class("[Lorg.nlogo.agent.Turtle;", false);
                    }
                    this.showError(new ImportException(6, "Too Many Values For Agent", stringBuffer.append(agentClass == clazz ? "and breed " : NO_DETAILS).append("variables).  The import-world file has at least one agent in the ").append(this.printSectionName()).append(" section with more than this number of values.").toString(), "All the extra values will be ignored for this section."));
                }
                ++i;
            }
        }
        i = 0;
        while (i < headersArr.length) {
            Junk value;
            boolean turtleBreedVar;
            boolean bl = false;
            Class clazz = class$org$nlogo$agent$Turtle;
            if (clazz == null) {
                clazz = Importer.class("[Lorg.nlogo.agent.Turtle;", false);
            }
            if (agentClass == clazz && headersArr[i].equals(this.builtInVars.get(9))) {
                bl = turtleBreedVar = true;
            }
            if (this.oldImportFormat && this.validBreed(values[i])) {
                values[i] = values[i].equalsIgnoreCase("TURTLES") ? "{all-turtles}" : (values[i].equalsIgnoreCase("PATCHES") ? "{all-patches}" : "{breed " + values[i] + '}');
            }
            Junk junk = value = values[i].equals(NO_DETAILS) ? new Junk() : this.getTokenValue(values[i], turtleBreedVar);
            if (((List)this.essentialVarHeadersToImport.get(agentClass)).contains(headersArr[i]) && value instanceof Junk) {
                String abortingError = "A " + this.printName(agentClass) + " with the essential variable " + headersArr[i] + " cannot be imported since the agent's value in the import file for " + headersArr[i] + " could not be imported.";
                throw new AbortingImportException(12, abortingError);
            }
            varVals.put(headersArr[i], value);
            ++i;
        }
        return varVals;
    }

    private final boolean validBreed(String breed) {
        boolean bl = false;
        if (this.world.getBreed(breed.toUpperCase()) != null || breed.equalsIgnoreCase("TURTLES") || breed.equalsIgnoreCase("PATCHES")) {
            bl = true;
        }
        return bl;
    }

    Object getTokenValue(String valueString, boolean turtleBreedVar) {
        try {
            return this.stringReader.readFromString(valueString, this.world);
        }
        catch (StringReaderException ex) {
            if (turtleBreedVar) {
                if (!this.breedsNotToImport.contains(valueString)) {
                    this.breedsNotToImport.add(valueString);
                    this.showError(new ImportException(2, "Illegal Breed", ex.getMessage(), "all turtles with this breed will be made as regular turtles"));
                }
                return this.world.turtles();
            }
            this.showError(new ImportException(3, "Parsing Error", "error parsing the values:\n" + valueString, "the import will continue if it can, but values for this agent's variables will be set to an appropriate default", ex.getMessage()));
            return new Junk();
        }
    }

    private final int getVarIndex(Agent agent, String header, int headerIndex) {
        Class<?> agentClass = agent.getClass();
        int varIndex = this.builtInVars.indexOf(header);
        String agentType = this.printName(agentClass);
        if (varIndex == -1) {
            Class clazz = class$org$nlogo$agent$Observer;
            if (clazz == null) {
                clazz = class$org$nlogo$agent$Observer = Importer.class("[Lorg.nlogo.agent.Observer;", false);
            }
            if (agentClass == clazz) {
                varIndex = this.world.observerOwnsIndexOf(header);
            } else {
                Class clazz2 = class$org$nlogo$agent$Patch;
                if (clazz2 == null) {
                    clazz2 = class$org$nlogo$agent$Patch = Importer.class("[Lorg.nlogo.agent.Patch;", false);
                }
                if (agentClass == clazz2) {
                    varIndex = this.world.patchesOwnIndexOf(header);
                } else {
                    Class clazz3 = class$org$nlogo$agent$Turtle;
                    if (clazz3 == null) {
                        clazz3 = class$org$nlogo$agent$Turtle = Importer.class("[Lorg.nlogo.agent.Turtle;", false);
                    }
                    if (agentClass == clazz3 && (varIndex = this.world.turtlesOwnIndexOf(header)) == -1 && (varIndex = this.getBreedVarIndex((Turtle)agent, header)) == -1 && this.someBreedOwns.contains(header)) {
                        return -1;
                    }
                }
            }
        }
        if (this.varsToImport.get(headerIndex) && varIndex == -1) {
            this.varsToImport.clear(headerIndex);
            this.showError(new ImportException(0, "Illegal " + agentType + " Variable", "the " + agentType + " variable " + header + " does not exist in this model.", "the import will continue but this variable will be ignored."));
        }
        return varIndex;
    }

    private final int getBreedVarIndex(Turtle turtle, String header) {
        if (turtle.getBreed() != this.world.turtles() && this.world.breedOwns(turtle.getBreed(), header)) {
            return this.world.breedsOwnIndexOf(turtle.getBreed(), header);
        }
        return -1;
    }

    private final void setVarVal(Agent agent, int index, String header, Object value) {
        try {
            if (value instanceof Junk) {
                value = Utils.ZERO_DOUBLE;
            }
            agent.setVariable(index, value);
        }
        catch (AgentException ae) {
            this.showError(new ImportException(4, "Error Setting Value", "could not set " + agent + "'s variable " + header + " to " + value, "the import will continue, but the variable will be set to an appropriate default."));
        }
    }

    private final Patch getPatch(Map varVals) {
        try {
            int pxcor = (Integer)varVals.get(this.builtInVars.get(0));
            int pycor = (Integer)varVals.get(this.builtInVars.get(1));
            if (!this.world.validPatchCoordinates(pxcor, pycor)) {
                String abortingError = "Illegal Patch Coordinate- pxcor and pycor must be in range.";
                throw new AbortingImportException(15, abortingError);
            }
            return this.world.fastGetPatchAt(pxcor, pycor);
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal Patch Coordinate- pxcor and pycor must be integers.";
            throw new AbortingImportException(7, abortingError);
        }
    }

    private final int getTurtleId(Map varVals, String whoHeaderName) {
        try {
            return (Integer)varVals.get(whoHeaderName);
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal Who- a turtle's who must be an integer.";
            throw new AbortingImportException(7, abortingError);
        }
    }

    private final void setTurtleShape(Turtle turtle, Object shape, String header, int varIndex) {
        try {
            turtle.setVariable(varIndex, shape);
        }
        catch (AgentException ae) {
            if (!this.shapesNotToImport.contains(shape)) {
                this.shapesNotToImport.add(shape);
                throw new ImportException(1, "Illegal Shape", ae.getMessage(), "setting " + turtle + "'s shape to its breed's default shape");
            }
            this.setVarVal(turtle, varIndex, header, this.world.breedShape(turtle.getBreed()));
        }
    }

    private final AgentSet getTurtleBreed(Map varVals, String breedHeaderName) {
        if (varVals.containsKey(breedHeaderName)) {
            return (AgentSet)varVals.get(breedHeaderName);
        }
        return this.world.turtles();
    }

    private final Object getLabel(Object val) {
        if (val instanceof Junk || val instanceof String && ((String)val).equals(NO_DETAILS)) {
            return NullLabel.theNullLabel;
        }
        return val;
    }

    private final void setScreenEdges(Map varVals) {
        try {
            this.resizer.resizeWorld((Integer)varVals.get(SCREEN_EDGE_X_HEADER), (Integer)varVals.get(SCREEN_EDGE_Y_HEADER));
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal Screen-Edge Size- screen-edge-x and screen-edge-y must be integers.";
            throw new AbortingImportException(7, abortingError);
        }
    }

    private final List getAllBreedVars() {
        ArrayList allBreedOwns = new ArrayList();
        Map breeds = this.world.getBreeds();
        if (breeds != null) {
            Iterator breedElt = breeds.values().iterator();
            while (breedElt.hasNext()) {
                AgentSet breed = (AgentSet)breedElt.next();
                List breedOwns = (List)this.world.program().breedsOwn.get(breed.printName());
                if (breedOwns == null) continue;
                int i = 0;
                while (i < breedOwns.size()) {
                    allBreedOwns.add(breedOwns.get(i));
                    ++i;
                }
            }
        }
        return allBreedOwns;
    }

    private final Map fillSpecialVariables() {
        HashMap result = new HashMap();
        ArrayList<String> specialObserverVars = new ArrayList<String>();
        specialObserverVars.add(SCREEN_EDGE_X_HEADER);
        specialObserverVars.add(SCREEN_EDGE_Y_HEADER);
        ArrayList specialTurtleVars = new ArrayList();
        specialTurtleVars.add(Turtle.getImplicitVariables().get(0));
        specialTurtleVars.add(Turtle.getImplicitVariables().get(9));
        specialTurtleVars.add(Turtle.getImplicitVariables().get(7));
        specialTurtleVars.add(Turtle.getImplicitVariables().get(5));
        ArrayList specialPatchVars = new ArrayList();
        specialPatchVars.add(Patch.getImplicitVariables().get(0));
        specialPatchVars.add(Patch.getImplicitVariables().get(1));
        specialPatchVars.add(Patch.getImplicitVariables().get(3));
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = Importer.class("[Lorg.nlogo.agent.Observer;", false);
        }
        result.put(clazz, specialObserverVars);
        Class clazz2 = class$org$nlogo$agent$Turtle;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Turtle = Importer.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        result.put(clazz2, specialTurtleVars);
        Class clazz3 = class$org$nlogo$agent$Patch;
        if (clazz3 == null) {
            clazz3 = class$org$nlogo$agent$Patch = Importer.class("[Lorg.nlogo.agent.Patch;", false);
        }
        result.put(clazz3, specialPatchVars);
        return result;
    }

    private final boolean isSpecialVariable(Class agentClass, String header) {
        return ((List)this.specialVariables.get(agentClass)).contains(header);
    }

    private final Map fillEssentialVarsToImport() {
        HashMap result = new HashMap();
        ArrayList<String> essentialObserverVarHeaders = new ArrayList<String>();
        essentialObserverVarHeaders.add(SCREEN_EDGE_X_HEADER);
        essentialObserverVarHeaders.add(SCREEN_EDGE_Y_HEADER);
        ArrayList essentialTurtleVarHeaders = new ArrayList();
        essentialTurtleVarHeaders.add(Turtle.getImplicitVariables().get(0));
        ArrayList essentialPatchVarHeaders = new ArrayList();
        essentialPatchVarHeaders.add(Patch.getImplicitVariables().get(0));
        essentialPatchVarHeaders.add(Patch.getImplicitVariables().get(1));
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = Importer.class("[Lorg.nlogo.agent.Observer;", false);
        }
        result.put(clazz, essentialObserverVarHeaders);
        Class clazz2 = class$org$nlogo$agent$Turtle;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Turtle = Importer.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        result.put(clazz2, essentialTurtleVarHeaders);
        Class clazz3 = class$org$nlogo$agent$Patch;
        if (clazz3 == null) {
            clazz3 = class$org$nlogo$agent$Patch = Importer.class("[Lorg.nlogo.agent.Patch;", false);
        }
        result.put(clazz3, essentialPatchVarHeaders);
        return result;
    }

    private final void varHeadersImported(Class agentClass, String[] headers, boolean essentialHeaders) {
        List headersToCheckFor = essentialHeaders ? (List)this.essentialVarHeadersToImport.get(agentClass) : this.builtInVars;
        int i = 0;
        while (i < headersToCheckFor.size()) {
            String header = (String)headersToCheckFor.get(i);
            boolean foundHeader = false;
            int j = 0;
            while (j < headers.length) {
                if (header.equals(headers[j])) {
                    foundHeader = true;
                    break;
                }
                ++j;
            }
            if (!foundHeader) {
                if (essentialHeaders) {
                    String abortingError = header + " is not in the list of variables to be imported from the import file in the " + this.printSectionName() + " section. This variable is essential to a model.";
                    throw new AbortingImportException(11, abortingError);
                }
                this.showError(new ImportException(5, "Implicit Variable Not Declared", "the " + this.printName(agentClass) + " variable " + header + " was not declared.", "the import will continue but all agents with this variable will have it set to an appropriate default."));
            }
            ++i;
        }
    }

    private final List getImplicitVariables(Class agentClass) {
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = Importer.class("[Lorg.nlogo.agent.Observer;", false);
        }
        if (agentClass == clazz) {
            return Observer.getImplicitVariables();
        }
        Class clazz2 = class$org$nlogo$agent$Turtle;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Turtle = Importer.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        if (agentClass == clazz2) {
            return Turtle.getImplicitVariables();
        }
        Class clazz3 = class$org$nlogo$agent$Patch;
        if (clazz3 == null) {
            clazz3 = class$org$nlogo$agent$Patch = Importer.class("[Lorg.nlogo.agent.Patch;", false);
        }
        if (agentClass == clazz3) {
            return Patch.getImplicitVariables();
        }
        return null;
    }

    private final boolean hasMoreLines() throws IOException {
        this.nextLine = this.lines.readLine();
        ++this.lineNum;
        if (this.nextLine == null) {
            if (this.currentSentinel != this.numSentinels) {
                String abortingError = "No " + this.sentinels[this.currentSentinel] + " have been imported.  Globals, Turtles, and Patches must be in the same import file.";
                throw new AbortingImportException(8, abortingError);
            }
            return false;
        }
        if (this.nextLine.equals(NO_DETAILS)) {
            return this.hasMoreLines();
        }
        try {
            this.nextLineFields = this.oldImportFormat ? ImportLexerOld.lex(this.nextLine) : ImportLexer.lex(this.nextLine);
        }
        catch (LexerException le) {
            throw new AbortingImportException(14, "At line " + this.lineNum + ": " + le.getMessage());
        }
        if (this.nextLineFields.length <= 0) {
            return this.hasMoreLines();
        }
        if (this.nextLineFields[0].toUpperCase().startsWith(this.sentinels[this.currentSentinel])) {
            ++this.currentSentinel;
            return false;
        }
        if (this.anotherSentinelEquals(this.nextLineFields[0].toUpperCase())) {
            String abortingError = "The agents are in the wrong order in the import file. The global variables should be first, followed by the turtles, followed by the patches.";
            throw new AbortingImportException(10, abortingError);
        }
        return true;
    }

    private final boolean anotherSentinelEquals(String line) {
        int i = 0;
        while (i < this.currentSentinel) {
            if (line.startsWith(this.sentinels[i])) {
                return true;
            }
            ++i;
        }
        i = this.currentSentinel + 1;
        while (i < this.numSentinels) {
            if (line.startsWith(this.sentinels[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final String[] nextLine() {
        return this.nextLineFields;
    }

    private final String printSectionName() {
        return this.currentSentinel > 0 ? this.sentinels[this.currentSentinel - 1] : "UNKNOWN";
    }

    private final String printName(Class agentClass) {
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = Importer.class("[Lorg.nlogo.agent.Observer;", false);
        }
        if (agentClass == clazz) {
            return "Global";
        }
        Class clazz2 = class$org$nlogo$agent$Turtle;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Turtle = Importer.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        if (agentClass == clazz2) {
            return "Turtle";
        }
        Class clazz3 = class$org$nlogo$agent$Patch;
        if (clazz3 == null) {
            clazz3 = class$org$nlogo$agent$Patch = Importer.class("[Lorg.nlogo.agent.Patch;", false);
        }
        if (agentClass == clazz3) {
            return "Patch";
        }
        return NO_DETAILS;
    }

    private final void checkForBlankTurtles() {
        Iterator iter = this.world.turtles().iterator();
        while (iter.hasNext()) {
            Turtle turtle = (Turtle)iter.next();
            if (turtle.getBreed() != null) continue;
            String abortingError = turtle.toString() + " was referenced in an agentset or agent but was not defined in the TURTLES section.";
            throw new AbortingImportException(13, abortingError);
        }
    }

    private final void showError(ImportException ix) {
        if (ix.type > 6) {
            throw new AbortingImportException(16, "An unknown error has occurred. The import will now abort.");
        }
        if (!this.errorHandler.showError("Warning: " + ix.title, "Error Importing at Line " + this.lineNum + ": " + ix.message + "\n\nAction to be Taken: " + ix.action, false)) {
            throw new AbortingImportException(9, NO_DETAILS);
        }
    }

    private final void showError(AbortingImportException aix) {
        this.errorHandler.showError(aix.title, aix.details, true);
    }

    static /* synthetic */ int access$0() {
        return 9;
    }

    static /* synthetic */ int access$1() {
        return 7;
    }

    static /* synthetic */ int access$2() {
        return 8;
    }

    static /* synthetic */ int access$3() {
        return 10;
    }

    static /* synthetic */ int access$4() {
        return 11;
    }

    static /* synthetic */ int access$5() {
        return 12;
    }

    static /* synthetic */ int access$6() {
        return 13;
    }

    static /* synthetic */ int access$7() {
        return 14;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.tooManyValuesForSection = false;
        this.oldImportFormat = false;
        this.lineNum = 0;
        this.sentinels = new String[]{"GLOBALS", "TURTLES", "PATCHES", "DONE"};
        this.numSentinels = this.sentinels.length - 1;
        this.currentSentinel = 0;
    }

    public Importer(ErrorHandler errorHandler, World world, WorldResizer resizer, StringReader stringReader) {
        this.this();
        this.errorHandler = errorHandler;
        this.world = world;
        this.resizer = resizer;
        this.stringReader = stringReader;
        this.shapesNotToImport = new HashSet();
        this.breedsNotToImport = new HashSet();
        this.someBreedOwns = this.getAllBreedVars();
        this.specialVariables = this.fillSpecialVariables();
        this.essentialVarHeadersToImport = this.fillEssentialVarsToImport();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AbortingImportException
    extends RuntimeException {
        int errorType;
        public String title;
        public String details;

        private final String getErrorMessage() {
            String message;
            switch (this.errorType) {
                case 9: {
                    message = "Error Already Given";
                    break;
                }
                case 7: {
                    message = "Illegal Type Cast";
                    break;
                }
                case 8: {
                    message = "Unexpected End of File";
                    break;
                }
                case 10: {
                    message = "Incorrect Structure For Import File";
                    break;
                }
                case 11: {
                    message = "Essential Variable Not Declared";
                    break;
                }
                case 12: {
                    message = "Essential Variable Not Imported";
                    break;
                }
                case 13: {
                    message = "Referenced Turtle Not Defined";
                    break;
                }
                case 14: {
                    message = "Invalid CSV File";
                    break;
                }
                default: {
                    message = "Unknown Fatal Error";
                }
            }
            return message;
        }

        public AbortingImportException(int errorType, String details) {
            super("Fatal Error Type:" + errorType);
            this.errorType = errorType;
            this.title = "Fatal Error- " + this.getErrorMessage();
            this.details = details + "\n\nThe import will now abort.";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class ImportException
    extends RuntimeException {
        public int type;
        public String message;
        public String action;
        public String title;

        public ImportException(int errorType, String errorTitle, String errorMessage, String defaultAction) {
            super(errorTitle + "- Error Type: " + errorType);
            this.type = errorType;
            this.title = errorTitle;
            this.message = errorMessage;
            this.action = defaultAction;
        }

        public ImportException(int errorType, String errorTitle, String errorMessage, String defaultAction, String additionalInfo) {
            this(errorType, errorTitle, errorMessage, defaultAction);
            this.message = this.message + "\n\nAdditional Information: " + additionalInfo;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    strictfp class Junk {
        Junk() {
        }
    }

    public static interface StringReader {
        public Object readFromString(String var1, World var2) throws StringReaderException;
    }

    public strictfp static class StringReaderException
    extends Exception {
        public StringReaderException(String message) {
            super(message);
        }
    }

    public static interface ErrorHandler {
        public boolean showError(String var1, String var2, boolean var3);
    }
}

