/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.awt;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaException;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.util.ImageToBuffer;
import org.nlogo.awt.JMFMovieEncoderDataSource;
import org.nlogo.awt.MovieEncoder;
import org.nlogo.util.Exceptions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class JMFMovieEncoder
implements MovieEncoder,
DataSinkListener,
ControllerListener,
Serializable {
    private boolean isSetup;
    private boolean stopped;
    private float frameRate;
    private String fileName;
    private Processor processor;
    private JMFMovieEncoderDataSource source;
    private DataSink sink;
    private int numFrames;
    private File outFile;
    private Dimension frameSize;
    private Format format;
    private int type;
    private final Object waitSync;
    private boolean stateTransitionOK;
    private final Object waitFileSync;
    private boolean fileDone;
    private boolean fileSuccess;

    public synchronized void setFrameRate(float frameRate) throws IOException {
        if (this.isSetup) {
            throw new IOException("Can't set framerate after setup");
        }
        this.frameRate = frameRate;
    }

    public synchronized float getFrameRate() {
        return this.frameRate;
    }

    public synchronized Dimension getFrameSize() {
        return this.frameSize;
    }

    public synchronized String getFormat() {
        return this.format.toString();
    }

    public synchronized void add(BufferedImage image) throws IOException {
        if (this.numFrames == 0) {
            this.setup(image);
        }
        if (!this.stopped) {
            image = this.preProcess(image);
            this.source.add(image);
            ++this.numFrames;
        }
    }

    public boolean isSetup() {
        return this.isSetup;
    }

    protected synchronized void setup(BufferedImage image) throws IOException {
        this.isSetup = true;
        try {
            this.frameSize = new Dimension(image.getWidth(), image.getHeight());
            this.type = image.getType();
            this.numFrames = 0;
            this.format = ImageToBuffer.createBuffer((Image)image, (float)this.frameRate).getFormat();
            this.source = new JMFMovieEncoderDataSource(this.format, this.frameRate);
            this.processor = Manager.createProcessor((DataSource)this.source);
            this.processor.addControllerListener((ControllerListener)this);
            this.processor.configure();
            if (!this.waitForState(this.processor, 180)) {
                throw new IOException("JMFMovieEncoder error: Failed to configure processor");
            }
            this.processor.setContentDescriptor(new ContentDescriptor("video.quicktime"));
            TrackControl[] tcs = this.processor.getTrackControls();
            Format[] f = tcs[0].getSupportedFormats();
            if (f == null || f.length <= 0) {
                throw new IOException("The mux does not support the input format: " + tcs[0].getFormat());
            }
            tcs[0].setFormat(f[0]);
            this.format = f[0];
            this.processor.realize();
            if (!this.waitForState(this.processor, 300)) {
                throw new IOException("Failed to realize processor");
            }
            this.outFile = new File(this.fileName);
            this.outFile.deleteOnExit();
            this.sink = Manager.createDataSink((DataSource)this.processor.getDataOutput(), (MediaLocator)new MediaLocator(this.outFile.toURL()));
            this.sink.addDataSinkListener((DataSinkListener)this);
            this.sink.open();
            this.processor.start();
            this.sink.start();
        }
        catch (MediaException ex) {
            throw new IOException("Cannot setup movie: " + (Object)((Object)ex));
        }
    }

    public synchronized void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.source.finish();
        this.waitForFileDone();
        this.sink.close();
        this.processor.removeControllerListener((ControllerListener)this);
        this.stopped = true;
    }

    public synchronized void cancel() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.isSetup) {
            this.source.finish();
            this.waitForFileDone();
            this.sink.close();
            this.processor.removeControllerListener((ControllerListener)this);
            this.stopped = true;
            this.outFile.delete();
        }
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    protected BufferedImage preProcess(BufferedImage image) {
        if (image.getWidth() != this.frameSize.width || image.getHeight() != this.frameSize.height || image.getType() != this.type) {
            BufferedImage temp = new BufferedImage(this.frameSize.width, this.frameSize.height, this.type);
            Graphics2D g = temp.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            image = temp;
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean waitForState(Processor p, int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() < state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (InterruptedException ex) {
                Exceptions.ignore(ex);
            }
            return this.stateTransitionOK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
                return;
            }
        }
        if (!(evt instanceof ResourceUnavailableEvent)) {
            if (!(evt instanceof EndOfMediaEvent)) return;
            evt.getSourceController().stop();
            evt.getSourceController().close();
            return;
        }
        Object object = this.waitSync;
        synchronized (object) {
            this.stateTransitionOK = false;
            this.waitSync.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait();
                }
            }
            catch (InterruptedException ex) {
                Exceptions.ignore(ex);
            }
            return this.fileSuccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dataSinkUpdate(DataSinkEvent evt) {
        if (evt instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
                return;
            }
        }
        if (!(evt instanceof DataSinkErrorEvent)) return;
        Object object = this.waitFileSync;
        synchronized (object) {
            this.fileDone = true;
            this.fileSuccess = false;
            this.waitFileSync.notifyAll();
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.isSetup = false;
        this.stopped = false;
        this.numFrames = 0;
        this.waitSync = new Object();
        this.stateTransitionOK = true;
        this.waitFileSync = new Object();
        this.fileDone = false;
        this.fileSuccess = true;
    }

    public JMFMovieEncoder(int frameRate, String fileName) throws IOException {
        this.this();
        this.frameRate = frameRate;
        this.fileName = fileName;
    }
}

