/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.command.Instruction;
import org.nlogo.command.Procedure;
import org.nlogo.compiler.AssembledBlock;
import org.nlogo.compiler.AssembledInstruction;
import org.nlogo.compiler.Token;
import org.nlogo.prim._call;
import org.nlogo.prim._fastrecurse;
import org.nlogo.prim._return;

strictfp class Assembler {
    static List assemble(Procedure procedure, Object[] parseTree) {
        List block = Assembler.assembleParseTree(parseTree);
        _return ret = new _return();
        ret.token(new Token("END", 12, procedure.endPos, procedure.endPos, ret, procedure.fileName));
        block.add(ret);
        Assembler.fastRecursion(procedure, block);
        return block;
    }

    private static final void fastRecursion(Procedure procedure, List code) {
        int i = 0;
        while (i < code.size()) {
            if (code.get(i) instanceof _call) {
                _call call = (_call)code.get(i);
                if (call.procedure.name.equals(procedure.name) && procedure.args.size() == 0) {
                    code.set(i, new _fastrecurse(-i, call));
                }
            }
            ++i;
        }
    }

    private static final List assembleParseTree(Object[] parsetree) {
        ArrayList block = new ArrayList();
        int i = 0;
        while (i < parsetree.length) {
            Object[] commandblock = (Object[])parsetree[i];
            AssembledInstruction instruction = Assembler.assembleInstruction(commandblock);
            int c = 0;
            while (c < instruction.size()) {
                block.add(instruction.get(c));
                ++c;
            }
            ++i;
        }
        return block;
    }

    private static final AssembledInstruction assembleInstruction(Object[] parsetree) {
        ArrayList<ArrayList> argvect = new ArrayList<ArrayList>();
        Instruction ins = (Instruction)parsetree[0];
        Object[] args = (Object[])parsetree[1];
        int i = 0;
        while (i < args.length) {
            Object[] arg = (Object[])args[i];
            if (arg.length == 0 || arg[0] instanceof Object[]) {
                argvect.add(Assembler.assembleBlock(arg));
            } else if (arg[0] instanceof Instruction) {
                argvect.add(Assembler.assembleInstruction(arg));
            }
            ++i;
        }
        return ins.assemble(argvect);
    }

    private static final AssembledBlock assembleBlock(Object[] parsetree) {
        AssembledBlock block = new AssembledBlock();
        int i = 0;
        while (i < parsetree.length) {
            Object[] elt = (Object[])parsetree[i];
            if (elt[0] instanceof Instruction) {
                AssembledInstruction arg = Assembler.assembleInstruction(elt);
                block.addAll(arg);
            }
            ++i;
        }
        return block;
    }

    private Assembler() {
        throw new IllegalStateException();
    }
}

