/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nlogo.agent.Importer;
import org.nlogo.agent.Program;
import org.nlogo.agent.World;
import org.nlogo.api.Primitive;
import org.nlogo.api.Reporter;
import org.nlogo.command.Command;
import org.nlogo.command.Instruction;
import org.nlogo.command.Procedure;
import org.nlogo.compiler.Assembler;
import org.nlogo.compiler.AstNode;
import org.nlogo.compiler.CompilerException;
import org.nlogo.compiler.ConstantParser;
import org.nlogo.compiler.ExpressionParser;
import org.nlogo.compiler.ExtensionManager;
import org.nlogo.compiler.Generator;
import org.nlogo.compiler.IdentifierParser;
import org.nlogo.compiler.Inliner;
import org.nlogo.compiler.LetToLocalsVisitor;
import org.nlogo.compiler.Optimizer;
import org.nlogo.compiler.SetVariableVisitor;
import org.nlogo.compiler.StructureParser;
import org.nlogo.compiler.TemplateVisitor;
import org.nlogo.compiler.Token;
import org.nlogo.compiler.TokenReader;
import org.nlogo.compiler.TokenVector;
import org.nlogo.compiler.Tokenizer;
import org.nlogo.compiler.TypeParser;
import org.nlogo.prim._extern;
import org.nlogo.prim._externreport;
import org.nlogo.util.Exceptions;
import org.nlogo.util.File;
import org.nlogo.util.Version;

public strictfp class Compiler {
    public static final Importer.StringReader STRING_READER = new Importer.StringReader(){

        public final Object readFromString(String s, World world) throws Importer.StringReaderException {
            try {
                return Compiler.readFromString(s, world);
            }
            catch (CompilerException ex) {
                throw new Importer.StringReaderException(ex.getDescription());
            }
        }
    };
    private static final String[] REPLACEMENTS1 = new String[]{"pc", "pcolor", "pc-of", "pcolor-of", "histogram", "histogram-from", "set-plot-pen", "create-temporary-plot-pen", "random", "random-int-or-float"};
    private static final String[] REPLACEMENTS2 = new String[]{"any", "any?", "user-yes-or-no", "user-yes-or-no?"};
    private static final String[] REPLACEMENTS3 = new String[]{"cc", "clear-output"};

    public static Program compileProgram(String source, List interfaceGlobals, ExtensionManager extensionManager) throws CompilerException {
        return (Program)Compiler.compile(source, new Program(interfaceGlobals), false, extensionManager);
    }

    public static Procedure compileMoreCode(String source, Program program, ExtensionManager extensionManager) throws CompilerException {
        return (Procedure)Compiler.compile(source, program, true, extensionManager);
    }

    private static final Object compile(String source, Program program, boolean subprogram, ExtensionManager extensionManager) throws CompilerException {
        Object[] parseTree;
        TokenVector tokens = Tokenizer.tokenize(source);
        if (tokens.getError() != null) {
            throw tokens.getError();
        }
        StructureParser structureParser = new StructureParser(tokens, program, extensionManager);
        Map newProcedures = structureParser.parse(subprogram);
        if (newProcedures == null) {
            return null;
        }
        if (!subprogram) {
            extensionManager.cleanUp();
        }
        HashMap<String, Object[]> parseTrees = new HashMap<String, Object[]>();
        Iterator procs = newProcedures.values().iterator();
        Procedure procedure = null;
        IdentifierParser identifierParser = new IdentifierParser(program, extensionManager);
        while (procs.hasNext()) {
            procedure = (Procedure)procs.next();
            procedure.topLevel = subprogram;
            TokenVector procedureTokens = structureParser.getProcedureTokens(procedure);
            identifierParser.process(procedureTokens, procedure);
            parseTree = ExpressionParser.parse(procedureTokens);
            parseTree.accept(new SetVariableVisitor());
            parseTree.accept(new LetToLocalsVisitor(procedure));
            parseTree.accept(new TemplateVisitor(procedure));
            Object[] uglyParseTree = parseTree.toObjectArray();
            parseTrees.put(procedure.name, uglyParseTree);
        }
        procs = newProcedures.values().iterator();
        TypeParser typeparser = new TypeParser();
        typeparser.parse(procs, parseTrees);
        procs = newProcedures.values().iterator();
        while (procs.hasNext()) {
            procedure = (Procedure)procs.next();
            parseTree = (Object[])parseTrees.get(procedure.name);
            Optimizer.optimize(parseTree);
            List code = Assembler.assemble(procedure, parseTree);
            procedure.code = code.toArray(new Command[code.size()]);
        }
        procs = newProcedures.values().iterator();
        while (procs.hasNext()) {
            Inliner.inline((Procedure)procs.next());
        }
        if (Version.isNewCompiler()) {
            procs = newProcedures.values().iterator();
            Generator generator = new Generator(source);
            while (procs.hasNext()) {
                generator.scan((Procedure)procs.next());
            }
        }
        if (subprogram) {
            return procedure;
        }
        return program;
    }

    static void cAssert(boolean condition, String desc, Token token) throws CompilerException {
        if (!condition) {
            throw new CompilerException(desc, token);
        }
    }

    static void cAssert(boolean condition, String desc, AstNode node) throws CompilerException {
        if (!condition) {
            throw new CompilerException(desc, node);
        }
    }

    public static Object readFromString(String source) throws CompilerException {
        return Compiler.readFromString(source, null);
    }

    public static Object readFromString(String source, World world) throws CompilerException {
        TokenVector tokens = Tokenizer.tokenize(source);
        if (tokens.getError() != null) {
            throw tokens.getError();
        }
        return ConstantParser.getConstantValue(tokens, world);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readFromFile(File currFile, World world) throws CompilerException, IOException {
        TokenReader tokens = new TokenReader(currFile);
        try {
            void parserException;
            int i;
            Object result = ConstantParser.getConstantFromFile(tokens, world);
            do {
                currFile.getBufferedReader().mark(1);
                ++currFile.pos;
            } while ((i = currFile.getBufferedReader().read()) != -1 && Character.isWhitespace((char)i));
            currFile.getBufferedReader().reset();
            --currFile.pos;
            return parserException;
        }
        catch (CompilerException parserException) {
            CompilerException tokenizerException = tokens.getError();
            if (tokenizerException != null) {
                throw tokenizerException;
            }
            throw parserException;
        }
    }

    public static boolean isValidIdentifier(String ident) {
        TokenVector vec = Tokenizer.tokenize(ident);
        if (vec.getError() != null) {
            return false;
        }
        Token token = vec.getNextToken();
        if (token.getType() != 9) {
            return false;
        }
        boolean bl = false;
        if (vec.getNextToken().getType() == 1) {
            bl = true;
        }
        return bl;
    }

    public static Map findProcedurePositions(String source) {
        return StructureParser.findProcedurePositions(source);
    }

    public static Map findIncludes(String sourceFileName, String source) {
        return StructureParser.findIncludes(sourceFileName, source);
    }

    public static Token[] tokenizeForColorization(String source, ExtensionManager extensionManager) {
        Token token;
        TokenVector tokens = Tokenizer.tokenize(source, true);
        ArrayList<Token> result = new ArrayList<Token>();
        while ((token = tokens.getNextToken()).getType() != 1) {
            if (extensionManager.anyExtensionsLoaded() && token.getType() == 9) {
                try {
                    token = Compiler.replaceImports(token, extensionManager);
                }
                catch (CompilerException ex) {
                    Exceptions.handle(ex);
                }
            }
            result.add(token);
        }
        return result.toArray(new Token[0]);
    }

    static Token replaceImports(Token token, ExtensionManager extensionManager) throws CompilerException {
        Instruction instruction;
        String name = (String)token.getValue();
        Primitive prim = extensionManager.replaceIdentifier(name);
        if (prim == null) {
            return token;
        }
        int tokenType = 0;
        if (prim instanceof org.nlogo.api.Command) {
            instruction = new _extern(((org.nlogo.api.Command)prim).newInstance(name));
            tokenType = 10;
        } else if (prim instanceof Reporter) {
            instruction = new _externreport(((Reporter)prim).newInstance(name));
            tokenType = 11;
        } else {
            throw new CompilerException("This imported class appears to be neither a command nor a reporter.", token);
        }
        return new Token(token.getName(), tokenType, token.getStartPosition(), token.getEndPosition(), instruction, token.getFileName());
    }

    public static String autoConvert(String source, String version) {
        if (Version.olderThan20alpha1(version)) {
            source = Compiler.autoConvert(source, REPLACEMENTS1);
        }
        if (Version.olderThan20beta5(version)) {
            source = Compiler.autoConvert(source, REPLACEMENTS2);
        }
        if (Version.olderThan21beta3(version)) {
            source = Compiler.autoConvert(source, REPLACEMENTS3);
        }
        return source;
    }

    private static final String autoConvert(String source, String[] replacements) {
        Token token;
        TokenVector tokens = Tokenizer.tokenize(source);
        if (tokens.getError() != null) {
            return source;
        }
        StringBuffer buf = new StringBuffer(source);
        int offset = 0;
        while ((token = tokens.getNextToken()).getType() != 1) {
            String replacement = Compiler.getReplacement(token.getName(), replacements);
            if (replacement == null) continue;
            buf.delete(token.getStartPosition() + offset, token.getEndPosition() + offset);
            buf.insert(token.getStartPosition() + offset, replacement);
            offset += replacement.length() - token.getName().length();
        }
        return buf.toString();
    }

    private static final String getReplacement(String tokenName, String[] replacements) {
        int i = 0;
        while (i < replacements.length) {
            if (tokenName.toLowerCase().equals(replacements[i])) {
                return replacements[i + 1];
            }
            i += 2;
        }
        return null;
    }

    private Compiler() {
        throw new IllegalStateException();
    }
}

