/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.util.List;
import org.nlogo.agent.Nobody;
import org.nlogo.command.Command;
import org.nlogo.command.Instruction;
import org.nlogo.command.Reporter;
import org.nlogo.compiler.Application;
import org.nlogo.compiler.CommandBlock;
import org.nlogo.compiler.Compiler;
import org.nlogo.compiler.CompilerException;
import org.nlogo.compiler.ConstantParser;
import org.nlogo.compiler.DelayedBlock;
import org.nlogo.compiler.Expression;
import org.nlogo.compiler.Referenceable;
import org.nlogo.compiler.ReporterApp;
import org.nlogo.compiler.ReporterBlock;
import org.nlogo.compiler.Statement;
import org.nlogo.compiler.Statements;
import org.nlogo.compiler.Syntax;
import org.nlogo.compiler.Token;
import org.nlogo.compiler.TokenVector;
import org.nlogo.prim._constboolean;
import org.nlogo.prim._constdouble;
import org.nlogo.prim._constinteger;
import org.nlogo.prim._constlist;
import org.nlogo.prim._conststring;
import org.nlogo.prim._minus;
import org.nlogo.prim._nobody;
import org.nlogo.prim._reference;
import org.nlogo.prim._unaryminus;
import org.nlogo.util.Version;

strictfp class ExpressionParser {
    private static final int MIN_PRECEDENCE = -1;
    private static final String EXPECTED_COMMAND = "Expected command.";
    private static final String EXPECTED_CLOSE_BRACKET = "Expected closing bracket.";
    private static final String EXPECTED_CLOSE_PAREN_HERE = "Expected a closing parenthesis here.";
    private static final String EXPECTED_OPEN_BRACKET = "Internal error: Expected an opening bracket here.";
    private static final String EXPECTED_REFERENCABLE = "Expected a patch variable here.";
    private static final String EXPECTED_REPORTER = "Expected reporter.";
    private static final String INVALID_VARIADIC_CONTEXT = "To use a non-default number of arguments, you need to put parentheses around this.";
    private static final String MISSING_CLOSE_BRACKET = "No closing bracket for this open bracket.";
    private static final String MISSING_CLOSE_PAREN = "No closing parenthesis for this open parenthesis.";
    private static final String MISSING_INPUT_ON_LEFT = "Missing input on the left.";
    private static final String MISSING_INPUT_ON_RIGHT = "Missing input on the right.";

    static Statements parse(TokenVector tokens) throws CompilerException {
        tokens.reset();
        return ExpressionParser.parseStatements(tokens);
    }

    private static final Statements parseStatements(TokenVector tokens) throws CompilerException {
        Statements stmts = new Statements();
        Token token = tokens.lookAhead();
        while (token.getType() != 1) {
            stmts.addStatement(ExpressionParser.parseStatement(tokens, false));
            token = tokens.lookAhead();
        }
        return stmts;
    }

    private static final Statement parseStatement(TokenVector tokens, boolean variadic) throws CompilerException {
        Statement stmt;
        Token token = tokens.lookAhead();
        switch (token.getType()) {
            case 2: {
                Token openParen = token;
                tokens.getNextToken();
                stmt = ExpressionParser.parseStatement(tokens, true);
                token = tokens.lookAhead();
                boolean bl = false;
                if (token.getType() != 1) {
                    bl = true;
                }
                Compiler.cAssert(bl, MISSING_CLOSE_PAREN, openParen);
                boolean bl2 = false;
                if (token.getType() == 3) {
                    bl2 = true;
                }
                Compiler.cAssert(bl2, EXPECTED_CLOSE_PAREN_HERE, token);
                tokens.getNextToken();
                stmt.setStartPosition(openParen.getStartPosition());
                stmt.setEndPosition(token.getEndPosition());
                stmt.setFileName(token.getFileName());
                break;
            }
            case 10: {
                tokens.getNextToken();
                stmt = new Statement((Command)token.getValue());
                stmt.setStartPosition(token.getStartPosition());
                stmt.setEndPosition(token.getEndPosition());
                stmt.setFileName(token.getFileName());
                if (variadic && ExpressionParser.isVariadic(stmt.getHead())) {
                    ExpressionParser.parseVarArgs(stmt, tokens, -1);
                    break;
                }
                ExpressionParser.parseArguments(stmt, tokens, -1);
                break;
            }
            default: {
                throw new CompilerException(EXPECTED_COMMAND, token);
            }
        }
        return stmt;
    }

    private static final void parseArguments(Application app, TokenVector tokens, int precedence) throws CompilerException {
        int numArgs = app.getHead().getSyntax().rightDefault();
        int i = 0;
        while (i < numArgs) {
            Expression arg = ExpressionParser.parseArgExpression(tokens, precedence, app);
            app.addArgument(arg);
            app.setEndPosition(arg.getEndPosition());
            ++i;
        }
        ExpressionParser.resolveTypes(app);
    }

    private static final void parseVarArgs(Application app, TokenVector tokens, int precedence) throws CompilerException {
        Token token = tokens.lookAhead();
        boolean done = false;
        while (!done) {
            if (token.getType() == 3) {
                done = true;
                continue;
            }
            if (token.getType() == 11 && ((Reporter)token.getValue()).getSyntax().isInfix()) {
                boolean bl = false;
                if (app.getArguments().size() == app.getHead().getSyntax().totalDefault()) {
                    bl = true;
                }
                Compiler.cAssert(bl, INVALID_VARIADIC_CONTEXT, app);
                done = true;
                continue;
            }
            Expression arg = ExpressionParser.parseArgExpression(tokens, precedence, app);
            app.addArgument(arg);
            app.setEndPosition(arg.getEndPosition());
            token = tokens.lookAhead();
        }
        ExpressionParser.resolveTypes(app);
    }

    private static final boolean isVariadic(Instruction ins) {
        Syntax syntax = ins.getSyntax();
        int[] types = syntax.right();
        int i = 0;
        while (i < types.length) {
            if (Syntax.typesAreCompatible(types[i], 32768)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final void resolveTypes(Application app) throws CompilerException {
        List args = app.getArguments();
        Syntax syntax = app.getHead().getSyntax();
        int actual1 = 0;
        if (syntax.isInfix()) {
            int type = syntax.left();
            boolean bl = false;
            if (args.size() >= 1) {
                bl = true;
            }
            Compiler.cAssert(bl, MISSING_INPUT_ON_LEFT, app);
            args.set(0, ExpressionParser.resolveType(type, (Expression)args.get(0)));
            actual1 = 1;
        }
        int formal1 = 0;
        int[] types = syntax.right();
        while (formal1 < types.length && !Syntax.typesAreCompatible(32768, types[formal1])) {
            boolean bl = false;
            if (args.size() > actual1) {
                bl = true;
            }
            Compiler.cAssert(bl, MISSING_INPUT_ON_RIGHT, app);
            args.set(actual1, ExpressionParser.resolveType(types[formal1], (Expression)args.get(actual1)));
            ++formal1;
            ++actual1;
        }
        if (formal1 < types.length) {
            int actual2 = args.size() - 1;
            int formal2 = types.length - 1;
            while (formal2 >= 0 && !Syntax.typesAreCompatible(32768, types[formal2])) {
                boolean bl = false;
                if (args.size() > actual2) {
                    bl = true;
                }
                Compiler.cAssert(bl, MISSING_INPUT_ON_RIGHT, app);
                args.set(actual2, ExpressionParser.resolveType(types[formal2], (Expression)args.get(actual2)));
                --formal2;
                --actual2;
            }
            while (actual1 <= actual2) {
                args.set(actual1, ExpressionParser.resolveType(types[formal1], (Expression)args.get(actual1)));
                ++actual1;
            }
        }
    }

    private static final Expression resolveType(int expectedType, Expression arg) throws CompilerException {
        if (arg instanceof DelayedBlock) {
            arg = ExpressionParser.parseDelayedBlock((DelayedBlock)arg, expectedType);
        }
        Compiler.cAssert(Syntax.typesAreCompatible(expectedType, arg.getType()), "Expected " + Syntax.aTypeName(expectedType) + ", but got " + Syntax.aTypeName(arg.getType()) + " instead", arg);
        if (expectedType == 1024) {
            ReporterApp rApp = (ReporterApp)arg;
            Compiler.cAssert(rApp.getReporter() instanceof Referenceable, EXPECTED_REFERENCABLE, arg);
            rApp.setReporter(new _reference(((Referenceable)((Object)rApp.getReporter())).makeReference()));
        }
        return arg;
    }

    static Expression parseExpression(TokenVector tokens, boolean variadic) throws CompilerException {
        try {
            return ExpressionParser.parseExpressionInternal(tokens, variadic, -1);
        }
        catch (MissingPrefixException e) {
            throw new CompilerException(MISSING_INPUT_ON_LEFT, e.token);
        }
        catch (UnexpectedTokenException e) {
            throw new CompilerException(EXPECTED_REPORTER, e.token);
        }
    }

    private static final Expression parseArgExpression(TokenVector tokens, int precedence, Application app) throws CompilerException {
        try {
            return ExpressionParser.parseExpressionInternal(tokens, false, precedence);
        }
        catch (MissingPrefixException e) {
            throw new CompilerException(MISSING_INPUT_ON_RIGHT, app);
        }
        catch (UnexpectedTokenException e) {
            throw new CompilerException(MISSING_INPUT_ON_RIGHT, app);
        }
    }

    private static final Expression parseExpressionInternal(TokenVector tokens, boolean variadic, int precedence) throws CompilerException, MissingPrefixException, UnexpectedTokenException {
        Expression expr;
        Token token = tokens.lookAhead();
        switch (token.getType()) {
            case 2: {
                Token openParen = token;
                tokens.getNextToken();
                expr = ExpressionParser.parseExpression(tokens, true);
                token = tokens.lookAhead();
                boolean bl = false;
                if (token.getType() != 1) {
                    bl = true;
                }
                Compiler.cAssert(bl, MISSING_CLOSE_PAREN, openParen);
                boolean bl2 = false;
                if (token.getType() != 10) {
                    bl2 = true;
                }
                Compiler.cAssert(bl2, MISSING_CLOSE_PAREN, openParen);
                boolean bl3 = false;
                if (token.getType() == 3) {
                    bl3 = true;
                }
                Compiler.cAssert(bl3, EXPECTED_CLOSE_PAREN_HERE, token);
                tokens.getNextToken();
                expr.setStartPosition(openParen.getStartPosition());
                expr.setEndPosition(token.getEndPosition());
                expr.setFileName(token.getFileName());
                break;
            }
            case 4: {
                expr = ExpressionParser.delayBlock(tokens);
                break;
            }
            case 11: {
                Reporter reporter = (Reporter)token.getValue();
                if (reporter.getSyntax().isInfix()) {
                    if (reporter instanceof _minus && variadic) {
                        reporter = new _unaryminus();
                        reporter.token(token);
                    } else {
                        throw new MissingPrefixException(token);
                    }
                }
                tokens.getNextToken();
                ReporterApp tmp = new ReporterApp(reporter);
                tmp.setStartPosition(reporter.token().getStartPosition());
                tmp.setEndPosition(reporter.token().getEndPosition());
                tmp.setFileName(reporter.token().getFileName());
                if (variadic && ExpressionParser.isVariadic(tmp.getHead())) {
                    ExpressionParser.parseVarArgs(tmp, tokens, reporter.getSyntax().precedence());
                } else {
                    ExpressionParser.parseArguments(tmp, tokens, reporter.getSyntax().precedence());
                }
                expr = tmp;
                break;
            }
            case 8: {
                tokens.getNextToken();
                Reporter tmp = ExpressionParser.makeConstant(token.getValue());
                tmp.token(token);
                expr = new ReporterApp(tmp);
                expr.setStartPosition(token.getStartPosition());
                expr.setEndPosition(token.getEndPosition());
                expr.setFileName(token.getFileName());
                break;
            }
            default: {
                throw new UnexpectedTokenException(token);
            }
        }
        return ExpressionParser.parseMore(expr, tokens, precedence);
    }

    static Expression parseMore(Expression expr, TokenVector tokens, int precedence) throws CompilerException {
        boolean done = false;
        while (!done) {
            Token token = tokens.lookAhead();
            if (token.getType() == 11) {
                Reporter reporter = (Reporter)token.getValue();
                Syntax syntax = reporter.getSyntax();
                if (syntax.isInfix() && syntax.precedence() > precedence) {
                    tokens.getNextToken();
                    ReporterApp tmp = new ReporterApp(reporter);
                    boolean bl = false;
                    if (expr != null) {
                        bl = true;
                    }
                    Compiler.cAssert(bl, MISSING_INPUT_ON_LEFT, token);
                    tmp.addArgument(expr);
                    tmp.setStartPosition(expr.getStartPosition());
                    tmp.setEndPosition(token.getEndPosition());
                    tmp.setFileName(token.getFileName());
                    ExpressionParser.parseArguments(tmp, tokens, syntax.precedence());
                    expr = tmp;
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        return expr;
    }

    private static final DelayedBlock delayBlock(TokenVector tokens) throws CompilerException {
        Token openBracket = tokens.lookAhead();
        boolean bl = false;
        if (openBracket.getType() == 4) {
            bl = true;
        }
        Compiler.cAssert(bl, EXPECTED_OPEN_BRACKET, openBracket);
        TokenVector contents = new TokenVector(tokens.fileName);
        int bracketNestingDepth = 1;
        contents.addToken(openBracket);
        tokens.getNextToken();
        Token token = null;
        while (bracketNestingDepth > 0) {
            token = tokens.lookAhead();
            boolean bl2 = false;
            if (token.getType() != 1) {
                bl2 = true;
            }
            Compiler.cAssert(bl2, MISSING_CLOSE_BRACKET, openBracket);
            switch (token.getType()) {
                case 4: {
                    ++bracketNestingDepth;
                    break;
                }
                case 5: {
                    --bracketNestingDepth;
                    break;
                }
            }
            contents.addToken(token);
            tokens.getNextToken();
        }
        return new DelayedBlock(contents, openBracket.getStartPosition(), token.getEndPosition());
    }

    private static final Expression parseDelayedBlock(DelayedBlock block, int goalType) throws CompilerException {
        Expression expr;
        TokenVector tokens = block.getTokens();
        Token openBracket = tokens.lookAhead();
        boolean bl = false;
        if (openBracket.getType() == 4) {
            bl = true;
        }
        Compiler.cAssert(bl, EXPECTED_OPEN_BRACKET, openBracket);
        if (Syntax.typesAreCompatible(goalType, 28672)) {
            tokens.getNextToken();
            expr = ExpressionParser.resolveType(1023, ExpressionParser.parseExpression(tokens, false));
            Token token = tokens.lookAhead();
            boolean bl2 = false;
            if (token.getType() != 1) {
                bl2 = true;
            }
            Compiler.cAssert(bl2, MISSING_CLOSE_BRACKET, openBracket);
            boolean bl3 = false;
            if (token.getType() == 5) {
                bl3 = true;
            }
            Compiler.cAssert(bl3, EXPECTED_CLOSE_BRACKET, token);
            expr = new ReporterBlock(expr, openBracket.getStartPosition(), token.getEndPosition() + 1, token.getFileName());
            tokens.getNextToken();
        } else if (Syntax.typesAreCompatible(goalType, 2048)) {
            tokens.getNextToken();
            Statements stmts = new Statements();
            Token token = tokens.lookAhead();
            while (token.getType() != 5) {
                boolean bl4 = false;
                if (token.getType() != 1) {
                    bl4 = true;
                }
                Compiler.cAssert(bl4, MISSING_CLOSE_BRACKET, openBracket);
                stmts.addStatement(ExpressionParser.parseStatement(tokens, false));
                token = tokens.lookAhead();
            }
            expr = new CommandBlock(stmts, openBracket.getStartPosition(), token.getEndPosition(), token.getFileName());
            tokens.getNextToken();
        } else if (Syntax.typesAreCompatible(goalType, 16)) {
            _constlist tmp = new _constlist(ConstantParser.parseConstantList(tokens, null));
            expr = new ReporterApp(tmp);
            expr.setStartPosition(openBracket.getStartPosition());
            expr.setEndPosition(tokens.lookAhead().getEndPosition());
            expr.setFileName(tokens.lookAhead().getFileName());
            if (Version.isNewCompiler()) {
                tmp.token(new Token(expr.getStartPosition(), expr.getEndPosition(), expr.getFileName()));
            }
            tokens.getNextToken();
        } else {
            throw new CompilerException("Expected " + Syntax.aTypeName(goalType) + " here, rather than a list or block.", block);
        }
        return expr;
    }

    private static final Reporter makeConstant(Object value) {
        if (value instanceof Integer) {
            return new _constinteger((Integer)value);
        }
        if (value instanceof Double) {
            return new _constdouble((Double)value);
        }
        if (value instanceof String) {
            return new _conststring((String)value);
        }
        if (value instanceof Boolean) {
            return new _constboolean((Boolean)value);
        }
        if (value instanceof Nobody) {
            return new _nobody();
        }
        throw new RuntimeException("unknown constant type: " + value);
    }

    private ExpressionParser() {
        throw new IllegalStateException();
    }

    private static class MissingPrefixException
    extends Exception {
        Token token;

        MissingPrefixException(Token token) {
            super("internal error: this should have been handled!");
            this.token = token;
        }
    }

    private static class UnexpectedTokenException
    extends Exception {
        Token token;

        UnexpectedTokenException(Token token) {
            super("internal error: this should have been handled!");
            this.token = token;
        }
    }
}

