/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import org.nlogo.command.Command;
import org.nlogo.command.Instruction;
import org.nlogo.command.Procedure;
import org.nlogo.command.Reporter;
import org.nlogo.compiler.CommandLeaf;
import org.nlogo.compiler.Generatable;
import org.nlogo.compiler.Leaf;
import org.nlogo.compiler.ReporterLeaf;

strictfp class Generator {
    private final String source;

    void scan(Procedure procedure) {
        int i = 0;
        while (i < procedure.code.length) {
            if (this.canGenerate(procedure.code[i])) {
                procedure.code[i] = (Command)this.doGenerate(procedure.code[i]);
            } else {
                this.scan(procedure.code[i]);
            }
            ++i;
        }
    }

    private final void scan(Instruction instruction) {
        int i = 0;
        while (i < instruction.args.length) {
            if (this.canGenerate(instruction.args[i])) {
                instruction.args[i] = (Reporter)this.doGenerate(instruction.args[i]);
            } else {
                this.scan(instruction.args[i]);
            }
            ++i;
        }
    }

    private final boolean canGenerate(Instruction instruction) {
        if (!(instruction instanceof Generatable)) {
            return false;
        }
        int i = 0;
        while (i < instruction.args.length) {
            if (!this.canGenerate(instruction.args[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final Instruction doGenerate(Instruction instruction) {
        Leaf leaf = instruction instanceof Reporter ? new ReporterLeaf(instruction) : new CommandLeaf(instruction);
        ((Generatable)((Object)instruction)).generate(leaf);
        Instruction result = leaf.finish();
        if (instruction.token() == null) {
            result.userSource = "<NO TOKEN>";
        } else {
            int[] posAndLength = instruction.getPositionAndLength();
            try {
                result.userSource = this.source.substring(posAndLength[0], posAndLength[0] + posAndLength[1]);
            }
            catch (RuntimeException ex) {
                result.userSource = ex.getMessage();
            }
        }
        return result;
    }

    Generator(String source) {
        this.source = source;
    }
}

