/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.Program;
import org.nlogo.command.Procedure;
import org.nlogo.command.Reporter;
import org.nlogo.compiler.Compiler;
import org.nlogo.compiler.CompilerException;
import org.nlogo.compiler.ExtensionManager;
import org.nlogo.compiler.Let;
import org.nlogo.compiler.Token;
import org.nlogo.compiler.TokenVector;
import org.nlogo.prim._breed;
import org.nlogo.prim._breedat;
import org.nlogo.prim._breedhere;
import org.nlogo.prim._breedon;
import org.nlogo.prim._breedvariable;
import org.nlogo.prim._breedvariableof;
import org.nlogo.prim._call;
import org.nlogo.prim._callreport;
import org.nlogo.prim._createcustomturtles;
import org.nlogo.prim._createturtles;
import org.nlogo.prim._hatch;
import org.nlogo.prim._letvariable;
import org.nlogo.prim._magicopen;
import org.nlogo.prim._observervariable;
import org.nlogo.prim._otherbreedhere;
import org.nlogo.prim._patchvariable;
import org.nlogo.prim._patchvariableof;
import org.nlogo.prim._procedurevariable;
import org.nlogo.prim._sprout;
import org.nlogo.prim._templatevariable;
import org.nlogo.prim._turtlevariable;
import org.nlogo.prim._turtlevariableof;

strictfp class IdentifierParser {
    private static final String INVALID_TEMPLATE_VARIABLE = "variables may not begin with a question mark unless they are the special variables ?, ?1, ?2, ...";
    private final Program program;
    private final ExtensionManager extensionManager;

    void process(TokenVector tokens, Procedure procedure) throws CompilerException {
        tokens.reset();
        while (true) {
            Token token = tokens.lookAhead();
            switch (token.getType()) {
                case 9: {
                    Token newToken = this.processToken(token, procedure, tokens.getIndex());
                    tokens.remove(tokens.getIndex());
                    tokens.insert(tokens.getIndex(), newToken);
                    break;
                }
                case 1: {
                    return;
                }
            }
            tokens.getNextToken();
        }
    }

    private final Token processToken(Token tok, Procedure procedure, int tokPos) throws CompilerException {
        Token newTok;
        if (this.extensionManager != null && this.extensionManager.anyExtensionsLoaded() && (newTok = Compiler.replaceImports(tok, this.extensionManager)).getType() != 9) {
            return newTok;
        }
        String ident = (String)tok.getValue();
        if (ident.startsWith("?")) {
            int varNumber = 1;
            if (ident.length() > 1) {
                try {
                    varNumber = Integer.parseInt(ident.substring(1));
                }
                catch (NumberFormatException e) {
                    throw new CompilerException(INVALID_TEMPLATE_VARIABLE, tok);
                }
            }
            return new Token(ident, 11, tok.getStartPosition(), tok.getEndPosition(), new _templatevariable(varNumber), tok.getFileName());
        }
        if (procedure.getLetFromArg(ident, tokPos) != null) {
            Let let = procedure.getLetFromArg(ident, tokPos);
            if (ident.endsWith("-OF")) {
                throw new CompilerException("cannot use -OF with let variables", tok);
            }
            return new Token(ident, 11, tok.getStartPosition(), tok.getEndPosition(), new _letvariable(let, ident), tok.getFileName());
        }
        if (procedure.args.contains(ident)) {
            int v = procedure.args.indexOf(ident);
            if (ident.endsWith("-OF")) {
                throw new CompilerException("cannot use -OF with local variables", tok);
            }
            return new Token(ident, 11, tok.getStartPosition(), tok.getEndPosition(), new _procedurevariable(v, ident), tok.getFileName());
        }
        if (this.program.breeds.containsKey(ident)) {
            return new Token(ident, 11, tok.getStartPosition(), tok.getEndPosition(), new _breed(ident), tok.getFileName());
        }
        if (this.program.procedures.get(ident) != null) {
            Procedure callproc = (Procedure)this.program.procedures.get(ident);
            switch (callproc.type) {
                case 1: {
                    return new Token(ident, 10, tok.getStartPosition(), tok.getEndPosition(), new _call(callproc), tok.getFileName());
                }
                case 2: {
                    return new Token(ident, 11, tok.getStartPosition(), tok.getEndPosition(), new _callreport(callproc), tok.getFileName());
                }
            }
            throw new RuntimeException("unknown procedure type");
        }
        if (ident.startsWith("CREATE-") && this.program.breeds.containsKey(ident.substring(7))) {
            String breedName = ident.substring(7);
            return new Token(ident, 10, tok.getStartPosition(), tok.getEndPosition(), new _createturtles(breedName), tok.getFileName());
        }
        if (ident.startsWith("CREATE-CUSTOM-") && this.program.breeds.containsKey(ident.substring(14))) {
            String breedName = ident.substring(14);
            return new Token(ident, 10, tok.getStartPosition(), tok.getEndPosition(), new _createcustomturtles(breedName), tok.getFileName());
        }
        if (ident.startsWith("CCT-") && this.program.breeds.containsKey(ident.substring(4))) {
            String breedName = ident.substring(4);
            return new Token(ident, 10, tok.getStartPosition(), tok.getEndPosition(), new _createcustomturtles(breedName), tok.getFileName());
        }
        if (ident.startsWith("HATCH-") && this.program.breeds.containsKey(ident.substring(6))) {
            String breedName = ident.substring(6);
            return new Token(ident, 10, tok.getStartPosition(), tok.getEndPosition(), new _hatch(breedName), tok.getFileName());
        }
        if (ident.startsWith("SPROUT-") && this.program.breeds.containsKey(ident.substring(7))) {
            String breedName = ident.substring(7);
            return new Token(ident, 10, tok.getStartPosition(), tok.getEndPosition(), new _sprout(breedName), tok.getFileName());
        }
        if (ident.startsWith("OTHER-") && ident.endsWith("-HERE") && this.program.breeds.containsKey(ident.substring(6, ident.length() - 5))) {
            String breedName = ident.substring(6, ident.length() - 5);
            return new Token(ident, 11, tok.getStartPosition(), tok.getEndPosition(), new _otherbreedhere(breedName), tok.getFileName());
        }
        if (ident.endsWith("-HERE") && this.program.breeds.containsKey(ident.substring(0, ident.length() - 5))) {
            String breedName = ident.substring(0, ident.length() - 5);
            return new Token(ident, 11, tok.getStartPosition(), tok.getEndPosition(), new _breedhere(breedName), tok.getFileName());
        }
        if (ident.endsWith("-ON") && this.program.breeds.containsKey(ident.substring(0, ident.length() - 3))) {
            String breedName = ident.substring(0, ident.length() - 3);
            return new Token(ident, 11, tok.getStartPosition(), tok.getEndPosition(), new _breedon(breedName), tok.getFileName());
        }
        if (ident.endsWith("-AT") && this.program.breeds.containsKey(ident.substring(0, ident.length() - 3))) {
            String breedName = ident.substring(0, ident.length() - 3);
            return new Token(ident, 11, tok.getStartPosition(), tok.getEndPosition(), new _breedat(breedName), tok.getFileName());
        }
        if (ident.startsWith("___")) {
            return new Token(ident, 10, tok.getStartPosition(), tok.getEndPosition(), new _magicopen(ident.substring(3)), tok.getFileName());
        }
        return new Token(ident, 11, tok.getStartPosition(), tok.getEndPosition(), this.getAgentVariableReporter(ident, tok), tok.getFileName());
    }

    private final Reporter getAgentVariableReporter(String ident, Token tok) throws CompilerException {
        boolean haveOf = false;
        String varName = ident;
        if (ident.endsWith("-OF")) {
            haveOf = true;
            varName = ident.substring(0, ident.length() - 3);
        }
        if (this.program.turtlesOwn.contains(varName)) {
            int v = this.program.turtlesOwn.indexOf(varName);
            if (haveOf) {
                return new _turtlevariableof(v);
            }
            return new _turtlevariable(v);
        }
        if (this.program.patchesOwn.contains(varName)) {
            int v = this.program.patchesOwn.indexOf(varName);
            if (haveOf) {
                return new _patchvariableof(v);
            }
            return new _patchvariable(v);
        }
        if (this.program.globals.contains(varName)) {
            if (haveOf) {
                throw new CompilerException("cannot use -OF with global variables", tok);
            }
            return new _observervariable(this.program.globals.indexOf(varName));
        }
        Iterator keys = this.program.breedsOwn.keySet().iterator();
        while (keys.hasNext()) {
            List breedOwns = (List)this.program.breedsOwn.get(keys.next());
            if (!breedOwns.contains(varName)) continue;
            if (haveOf) {
                return new _breedvariableof(varName);
            }
            return new _breedvariable(varName);
        }
        throw new CompilerException("Nothing named " + ident + " has been defined", tok);
    }

    IdentifierParser(Program program, ExtensionManager extensionManager) {
        this.program = program;
        this.extensionManager = extensionManager;
    }
}

