/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.nlogo.agent.Program;
import org.nlogo.command.Procedure;
import org.nlogo.compiler.Compiler;
import org.nlogo.compiler.CompilerException;
import org.nlogo.compiler.ErrorSource;
import org.nlogo.compiler.ExtensionManager;
import org.nlogo.compiler.Keyword;
import org.nlogo.compiler.Let;
import org.nlogo.compiler.Token;
import org.nlogo.compiler.TokenVector;
import org.nlogo.compiler.Tokenizer;
import org.nlogo.prim._let;
import org.nlogo.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class StructureParser {
    private final TokenVector tokens;
    private final Program program;
    private final ExtensionManager extensionManager;
    private final Map tokensMap;
    private final Map newProcedures;

    TokenVector getProcedureTokens(Procedure procedure) {
        return (TokenVector)this.tokensMap.get(procedure);
    }

    Map parse(boolean subprogram) throws CompilerException {
        block16: {
            Vector<Object> usingFiles = new Vector<Object>();
            String fileName = "";
            int index = 1;
            this.tokens.reset();
            usingFiles.add(fileName);
            do {
                String source;
                Token token;
                boolean haveGlobals = subprogram;
                boolean haveTurtlesOwn = subprogram;
                boolean havePatchesOwn = subprogram;
                boolean haveBreeds = subprogram;
                while ((token = this.tokens.lookAhead()).getType() != 1) {
                    Compiler.cAssert(token.getValue() instanceof Keyword, "Expected keyword", token);
                    Keyword keyword = (Keyword)token.getValue();
                    if (keyword.getType().equals("TO") || keyword.getType().equals("TO-REPORT")) {
                        this.parseProcedure(this.program, subprogram, token.getFileName());
                        continue;
                    }
                    if (keyword.getType().equals("TURTLES-OWN")) {
                        Compiler.cAssert(haveTurtlesOwn ^ true, "Redeclaration of TURTLES-OWN", token);
                        this.tokens.getNextToken();
                        haveTurtlesOwn = true;
                        this.parseVarList(this.program.turtlesOwn, false, null);
                        continue;
                    }
                    if (keyword.getType().equals("PATCHES-OWN")) {
                        Compiler.cAssert(havePatchesOwn ^ true, "Redeclaration of PATCHES-OWN", token);
                        this.tokens.getNextToken();
                        havePatchesOwn = true;
                        this.parseVarList(this.program.patchesOwn, false, null);
                        continue;
                    }
                    if (keyword.getType().equals("GLOBALS")) {
                        Compiler.cAssert(haveGlobals ^ true, "Redeclaration of GLOBALS", token);
                        this.tokens.getNextToken();
                        haveGlobals = true;
                        this.parseVarList(this.program.globals, false, null);
                        continue;
                    }
                    if (keyword.getType().equals("BREEDS")) {
                        Compiler.cAssert(haveBreeds ^ true, "Redeclaration of breeds", token);
                        this.tokens.getNextToken();
                        haveBreeds = true;
                        ArrayList breedNames = new ArrayList();
                        this.parseVarList(breedNames, false, null);
                        int i = 0;
                        while (i < breedNames.size()) {
                            String breedName = (String)breedNames.get(i);
                            this.program.breeds.put(breedName, breedName);
                            this.program.breedsOwn.put(breedName, new ArrayList());
                            ++i;
                        }
                        continue;
                    }
                    if (keyword.getType().endsWith("-OWN")) {
                        String tokenString = keyword.getType();
                        Compiler.cAssert(haveBreeds, "Must declare breeds before " + tokenString, token);
                        String breedName = tokenString.substring(0, tokenString.length() - 4);
                        Compiler.cAssert(this.program.breeds.containsKey(breedName), "There is no breed named " + breedName, token);
                        this.tokens.getNextToken();
                        if (this.program.breedsOwn.containsKey(tokenString)) {
                            List breedOwns = (List)this.program.breedsOwn.get(tokenString);
                            boolean bl = false;
                            if (breedOwns.size() == 0) {
                                bl = true;
                            }
                            Compiler.cAssert(bl, "Redeclaration of " + tokenString, token);
                        }
                        ArrayList vars = new ArrayList();
                        this.parseVarList(vars, true, null);
                        this.program.breedsOwn.put(breedName, vars);
                        continue;
                    }
                    if (keyword.getType().equals("__EXTENSIONS")) {
                        this.parseImport(this.tokens);
                        continue;
                    }
                    if (keyword.getType().equals("__INCLUDE")) {
                        this.tokens.getNextToken();
                        Token pathToken = this.tokens.lookAhead();
                        boolean bl = false;
                        if (pathToken.getType() == 8 && pathToken.getValue() instanceof String) {
                            bl = true;
                        }
                        Compiler.cAssert(bl, "You need a string after __include", pathToken);
                        pathToken = this.tokens.getNextToken();
                        String filePath = fileName == "" ? this.extensionManager.resolvePath((String)pathToken.getValue()) : StructureParser.resolvePath(fileName, (String)pathToken.getValue());
                        if (usingFiles.contains(filePath)) continue;
                        usingFiles.add(filePath);
                        usingFiles.add(token);
                        continue;
                    }
                    throw new CompilerException("Expected procedure or variable declaration", token);
                }
                if (index >= usingFiles.size()) break block16;
                fileName = (String)usingFiles.elementAt(index++);
                token = (Token)usingFiles.elementAt(index++);
                try {
                    source = Utils.replace(Utils.url2String(fileName), "\r\n", "\n");
                }
                catch (IOException e) {
                    throw new CompilerException("Could not find " + fileName, token);
                }
                this.tokens.merge(Tokenizer.tokenize(source, false, fileName));
            } while (this.tokens.getError() == null);
            throw this.tokens.getError();
        }
        return this.newProcedures;
    }

    private final Procedure parseProcedure(Program program, boolean subprogram, String fileName) throws CompilerException {
        boolean done = false;
        boolean haveTo = false;
        boolean haveName = false;
        boolean haveArgList = false;
        boolean haveLocals = false;
        boolean haveEnd = false;
        Procedure procedure = new Procedure(fileName);
        int start = 0;
        while (!done) {
            Keyword keyword;
            Token token = this.tokens.lookAhead();
            if (token.getType() == 1) {
                throw new CompilerException("Last procedure doesn't end with END", procedure.pos, procedure.endPos, procedure.fileName);
            }
            if (!haveTo) {
                Compiler.cAssert(token.getValue() instanceof Keyword, "Expected TO or TO-REPORT", token);
                keyword = (Keyword)token.getValue();
                if (keyword.getType().equals("TO")) {
                    this.tokens.getNextToken();
                    haveTo = true;
                    procedure.type = 1;
                    procedure.pos = token.getStartPosition();
                    procedure.endPos = token.getEndPosition();
                    continue;
                }
                if (keyword.getType().equals("TO-REPORT")) {
                    this.tokens.getNextToken();
                    haveTo = true;
                    procedure.type = 2;
                    procedure.pos = token.getStartPosition();
                    procedure.endPos = token.getEndPosition();
                    continue;
                }
                throw new CompilerException("Expected TO or TO-REPORT", token);
            }
            if (!haveName) {
                boolean bl = false;
                if (token.getType() == 9) {
                    bl = true;
                }
                Compiler.cAssert(bl, "You can't use this for the name of a procedure", token);
                this.tokens.getNextToken();
                haveName = true;
                procedure.name = token.getName().toUpperCase();
                this.checkName(procedure.name, token, false, null);
                boolean bl2 = false;
                if (this.newProcedures.get(procedure.name) == null) {
                    bl2 = true;
                }
                Compiler.cAssert(bl2, "Cannot redefine " + procedure.name, token);
                procedure.endPos = token.getEndPosition();
                continue;
            }
            if (!haveArgList) {
                if (token.getType() == 4) {
                    this.parseVarList(procedure.args, false, procedure);
                    start = this.tokens.getIndex();
                    haveArgList = true;
                    continue;
                }
                haveArgList = true;
                continue;
            }
            if (!haveLocals) {
                if (token.getType() == 12) {
                    keyword = (Keyword)token.getValue();
                    if (keyword.getType().equals("LOCALS")) {
                        this.tokens.getNextToken();
                        token = this.tokens.lookAhead();
                        boolean bl = false;
                        if (token.getType() == 4) {
                            bl = true;
                        }
                        Compiler.cAssert(bl, "Expected [", token);
                        int originalArgCount = procedure.args.size();
                        this.parseVarList(procedure.args, false, procedure);
                        procedure.localsCount = procedure.args.size() - originalArgCount;
                        start = this.tokens.getIndex();
                        haveLocals = true;
                        continue;
                    }
                    if (keyword.getType().equals("END")) {
                        if (start == 0) {
                            start = this.tokens.getIndex();
                        }
                        this.tokensMap.put(procedure, this.tokens.getSubset(start, this.tokens.getIndex()));
                        this.tokens.getNextToken();
                        procedure.endPos = token.getStartPosition();
                        done = true;
                        continue;
                    }
                    throw new CompilerException("This doesn't make sense here", token);
                }
                start = this.tokens.getIndex();
                haveLocals = true;
                continue;
            }
            if (haveEnd) continue;
            if (token.getType() == 10 && token.getValue() instanceof _let) {
                this.parseLet(procedure, start, new ArrayList());
                continue;
            }
            if (token.getType() == 12) {
                keyword = (Keyword)token.getValue();
                if (keyword.getType().equals("END")) {
                    if (start == 0) {
                        start = this.tokens.getIndex();
                    }
                    procedure.endPos = token.getStartPosition();
                    this.tokensMap.put(procedure, this.tokens.getSubset(start, this.tokens.getIndex()));
                    done = true;
                    this.tokens.getNextToken();
                    continue;
                }
                if (keyword.getType().equals("LOCALS")) {
                    throw new CompilerException("LOCALS may be used only once per procedure, and must be at the top of the procedure", token);
                }
                throw new CompilerException("This doesn't make sense here", token);
            }
            this.tokens.getNextToken();
        }
        if (!subprogram) {
            program.procedures.put(procedure.name, procedure);
        }
        this.newProcedures.put(procedure.name, procedure);
        return procedure;
    }

    private final void parseVarList(List result, boolean isBreedOwns, Procedure procedure) throws CompilerException {
        Token token = this.tokens.getNextToken();
        boolean bl = false;
        if (token.getType() == 4) {
            bl = true;
        }
        Compiler.cAssert(bl, "Expected [", token);
        while ((token = this.tokens.getNextToken()).getType() != 5) {
            boolean bl2 = false;
            if (token.getType() != 10) {
                bl2 = true;
            }
            Compiler.cAssert(bl2, "There is already a primitive with that name", token);
            boolean bl3 = false;
            if (token.getType() != 11) {
                bl3 = true;
            }
            Compiler.cAssert(bl3, "There is already a primitive with that name", token);
            boolean bl4 = false;
            if (token.getType() != 12) {
                bl4 = true;
            }
            Compiler.cAssert(bl4, "There is already a keyword with that name", token);
            boolean bl5 = false;
            if (token.getType() == 9) {
                bl5 = true;
            }
            Compiler.cAssert(bl5, "Expected name or ]", token);
            boolean bl6 = false;
            if (this.newProcedures.get(token.getName().toUpperCase()) == null) {
                bl6 = true;
            }
            Compiler.cAssert(bl6, "There is already a procedure with that name", token);
            Compiler.cAssert(result.contains(token.getValue()) ^ true, "This name is already defined", token);
            this.checkName((String)token.getValue(), token, isBreedOwns, procedure);
            result.add(token.getValue());
        }
    }

    private final void checkName(String var, Token token, boolean isBreedOwns, Procedure procedure) throws CompilerException {
        if (!isBreedOwns) {
            Iterator keys = this.program.breedsOwn.keySet().iterator();
            while (keys.hasNext()) {
                String breedName = (String)keys.next();
                List breedOwns = (List)this.program.breedsOwn.get(breedName);
                Compiler.cAssert(breedOwns.contains(var) ^ true, "You already defined " + var + " as a " + breedName + " variable", token);
            }
        }
        Compiler.cAssert(this.program.turtlesOwn.contains(var) ^ true, "There is already a turtle variable called " + var, token);
        Compiler.cAssert(this.program.patchesOwn.contains(var) ^ true, "There is already a patch variable called " + var, token);
        Compiler.cAssert(this.program.globals.contains(var) ^ true, "There is already a global variable called " + var, token);
        Compiler.cAssert(this.program.breeds.containsKey(var) ^ true, "There is already a breed called " + var, token);
        boolean bl = false;
        if (!var.endsWith("-AT") && !var.endsWith("-OF")) {
            bl = true;
        }
        Compiler.cAssert(bl, "You can't have a name ending with -AT or -OF", token);
        if (procedure != null) {
            Compiler.cAssert(var.equals(procedure.name) ^ true, "There is already a procedure with that name", token);
            Compiler.cAssert(procedure.args.contains(var) ^ true, "There is already a local variable called " + var + " here", token);
        }
        Map map = this.program.procedures;
        boolean bl2 = false;
        if (procedure != null) {
            bl2 = true;
        }
        this.checkNameAgainstProceduresMap(var, token, map, bl2);
        boolean bl3 = false;
        if (procedure != null) {
            bl3 = true;
        }
        this.checkNameAgainstProceduresMap(var, token, this.newProcedures, bl3);
    }

    private final void checkNameAgainstProceduresMap(String var, Token token, Map procedures, boolean isLocal) throws CompilerException {
        Compiler.cAssert(procedures.containsKey(var) ^ true, "There is already a procedure with that name", token);
        if (!isLocal) {
            Iterator iter = procedures.keySet().iterator();
            while (iter.hasNext()) {
                Procedure proc = (Procedure)procedures.get(iter.next());
                Compiler.cAssert(proc.args.contains(var) ^ true, "There is already a local variable called " + var + " in the " + proc.name + " procedure", token);
                Iterator iter2 = proc.lets.iterator();
                while (iter2.hasNext()) {
                    Let let = (Let)iter2.next();
                    Compiler.cAssert(var.equals(let.varName) ^ true, "There is already a local variable called " + var + " in the " + proc.name + " procedure", token);
                }
            }
        }
    }

    private final void parseImport(TokenVector tokens) throws CompilerException {
        tokens.getNextToken();
        Token token = tokens.getNextToken();
        boolean bl = false;
        if (token.getType() == 4) {
            bl = true;
        }
        Compiler.cAssert(bl, "Expected [", token);
        while ((token = tokens.getNextToken()).getType() != 5) {
            boolean bl2 = false;
            if (token.getType() == 8 && token.getValue() instanceof String) {
                bl2 = true;
            }
            Compiler.cAssert(bl2, "Expected string or ]", token);
            String jarPath = (String)token.getValue();
            this.extensionManager.importExtension(jarPath, new ErrorSource(token));
        }
    }

    Let parseLet(Procedure procedure, int offset, ArrayList ancestorNames) throws CompilerException {
        Token token = this.tokens.getNextToken();
        Let newLet = ((_let)token.getValue()).let;
        newLet.startPos = this.tokens.getIndex() - offset;
        token = this.tokens.lookAhead();
        boolean bl = false;
        if (token.getType() == 9) {
            bl = true;
        }
        Compiler.cAssert(bl, "Expected variable name here", token);
        newLet.varName = (String)token.getValue();
        Compiler.cAssert(ancestorNames.contains(newLet.varName) ^ true, "There is already a local variable called " + newLet.varName + " here", token);
        this.checkName(newLet.varName, token, false, procedure);
        procedure.lets.add(newLet);
        int level = 1;
        while (true) {
            if ((token = this.tokens.lookAhead()).getType() == 1) {
                throw new CompilerException("Expected ] or END", token);
            }
            if (token.getType() == 4) {
                ++level;
            } else if (token.getType() == 5) {
                if (--level == 0) {
                    newLet.endPos = this.tokens.getIndex() - offset;
                    return newLet;
                }
            } else if (token.getType() == 10 && token.getValue() instanceof _let) {
                ancestorNames = new ArrayList<String>(ancestorNames);
                ancestorNames.add(newLet.varName);
                newLet.children.add(this.parseLet(procedure, offset, ancestorNames));
                this.tokens.setIndex(this.tokens.getIndex() - 1);
            } else if (token.getType() == 12) {
                Keyword keyword = (Keyword)token.getValue();
                if (!keyword.getType().equals("END")) {
                    throw new CompilerException("Expected ] or END", token);
                }
                newLet.endPos = this.tokens.getIndex() - offset;
                return newLet;
            }
            this.tokens.getNextToken();
        }
    }

    static Map findProcedurePositions(String source) {
        HashMap procsTable = new HashMap();
        TokenVector tokenVector = Tokenizer.tokenize(source);
        Token token = tokenVector.getNextToken();
        while (token.getType() != 1) {
            Keyword keyword;
            if (token.getType() == 12 && ((keyword = (Keyword)token.getValue()).getType().equals("TO") || keyword.getType().equals("TO-REPORT"))) {
                int toPos = token.getStartPosition();
                Token nameToken = tokenVector.lookAhead();
                if (nameToken.getType() == 9) {
                    String name = nameToken.getName();
                    int namePos = nameToken.getStartPosition();
                    while ((token = tokenVector.getNextToken()).getType() != 1) {
                        if (token.getType() == 12) {
                            keyword = (Keyword)token.getValue();
                        }
                        if (!keyword.getType().equals("END")) continue;
                    }
                    int endPos = token.getStartPosition();
                    ArrayList<Object> index = new ArrayList<Object>(4);
                    index.add(name);
                    index.add(new Integer(toPos));
                    index.add(new Integer(namePos));
                    index.add(new Integer(endPos));
                    procsTable.put(name, index);
                }
            }
            token = tokenVector.getNextToken();
        }
        return procsTable;
    }

    public static Map findIncludes(String sourceFileName, String source) {
        HashMap<String, String> includedFiles = new HashMap<String, String>();
        TokenVector myTokens = Tokenizer.tokenize(source);
        Token token = myTokens.getNextToken();
        while (token.getType() != 1) {
            Keyword keyword;
            if (token.getType() == 12 && (keyword = (Keyword)token.getValue()).getType().equals("__INCLUDE")) {
                Token pathToken = myTokens.lookAhead();
                if (pathToken.getType() == 8 && pathToken.getValue() instanceof String) {
                    pathToken = myTokens.getNextToken();
                    String filePath = StructureParser.resolvePath(sourceFileName, (String)pathToken.getValue());
                    includedFiles.put((String)pathToken.getValue(), filePath);
                } else {
                    System.out.println("got busted __include: " + pathToken);
                }
            }
            token = myTokens.getNextToken();
        }
        return includedFiles;
    }

    private static final String resolvePath(String fileName, String path) {
        int lastSlash = fileName.lastIndexOf(47);
        String currentDir = lastSlash != -1 ? fileName.substring(0, lastSlash + 1) : fileName;
        if (path.startsWith("./", 0)) {
            return currentDir + path.substring(2);
        }
        if (path.startsWith("../", 0)) {
            do {
                path = path.substring(3);
                lastSlash = currentDir.lastIndexOf(47);
                if (lastSlash == -1) continue;
                currentDir = currentDir.substring(0, lastSlash + 1);
            } while (path.startsWith("../", 0));
            return currentDir + path;
        }
        return path;
    }

    private final /* synthetic */ void this() {
        this.tokensMap = new HashMap();
        this.newProcedures = new LinkedHashMap();
    }

    StructureParser(TokenVector tokens, Program program, ExtensionManager extensionManager) {
        this.this();
        this.tokens = tokens;
        this.program = program;
        this.extensionManager = extensionManager;
    }
}

