/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import org.nlogo.agent.AgentSet;
import org.nlogo.agent.LogoList;
import org.nlogo.agent.Nobody;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;

public strictfp class Syntax {
    public static final int TYPE_VOID = 0;
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_NUMBER = 3;
    public static final int TYPE_BOOLEAN = 4;
    public static final int TYPE_STRING = 8;
    public static final int TYPE_LIST = 16;
    public static final int TYPE_TURTLESET = 32;
    public static final int TYPE_PATCHSET = 64;
    public static final int TYPE_AGENTSET = 96;
    public static final int TYPE_NOBODY = 128;
    public static final int TYPE_TURTLE = 256;
    public static final int TYPE_PATCH = 512;
    public static final int TYPE_AGENT = 768;
    public static final int TYPE_READABLE = 159;
    public static final int TYPE_WILDCARD = 1023;
    public static final int TYPE_REFERENCE = 1024;
    public static final int TYPE_COMMAND_BLOCK = 2048;
    public static final int TYPE_BOOLEAN_BLOCK = 4096;
    public static final int TYPE_NUMBER_BLOCK = 8192;
    public static final int TYPE_OTHER_BLOCK = 16384;
    public static final int TYPE_REPORTER_BLOCK = 28672;
    public static final int TYPE_BRACKETED = 30736;
    public static final int TYPE_REPEATABLE = 32768;
    public static final int MAX_PRECEDENCE = 20;
    public static final int COMMAND_PRECEDENCE = 0;
    public static final int NORMAL_PRECEDENCE = 10;
    private static final Syntax EMPTY_SYNTAX = new Syntax(0, new int[0], 0, 10, 0);
    private final int left;
    private final int[] right;
    private final int ret;
    private final int precedence;
    private final int dfault;

    public int[] right() {
        return this.right;
    }

    public int left() {
        return this.left;
    }

    public int ret() {
        return this.ret;
    }

    public int precedence() {
        return this.precedence;
    }

    public static Syntax commandSyntax() {
        return EMPTY_SYNTAX;
    }

    public static Syntax commandSyntax(int[] right) {
        return new Syntax(0, right, 0, 0, right.length);
    }

    public static Syntax commandSyntax(int[] right, int dfault) {
        return new Syntax(0, right, 0, 0, dfault);
    }

    public static Syntax reporterSyntax(int ret) {
        return new Syntax(0, new int[0], ret, 10, 0);
    }

    public static Syntax reporterSyntax(int left, int[] right, int ret, int precedence) {
        return new Syntax(left, right, ret, precedence, right.length);
    }

    public static Syntax reporterSyntax(int[] right, int ret) {
        return new Syntax(0, right, ret, 10, right.length);
    }

    public static Syntax reporterSyntax(int[] right, int ret, int dfault) {
        return new Syntax(0, right, ret, 10, dfault);
    }

    public static Syntax extensionSyntax(int left, int[] right, int ret, int precedence, int dfault) {
        return new Syntax(left, right, ret, precedence, dfault);
    }

    public boolean isInfix() {
        boolean bl = false;
        if (this.left != 0) {
            bl = true;
        }
        return bl;
    }

    public int rightDefault() {
        return this.dfault;
    }

    public int totalDefault() {
        return this.isInfix() ? this.dfault + 1 : this.dfault;
    }

    public static boolean typesAreCompatible(int mask, int value) {
        boolean bl = false;
        if ((mask & value) > 0) {
            bl = true;
        }
        return bl;
    }

    public static String aTypeName(Object obj) {
        String result = Syntax.typeName(obj);
        if (obj instanceof Nobody) {
            return result;
        }
        return Syntax.addAOrAn(result);
    }

    public static String typeName(Object obj) {
        if (obj instanceof Number) {
            return Syntax.typeName(3);
        }
        if (obj instanceof Boolean) {
            return Syntax.typeName(4);
        }
        if (obj instanceof String) {
            return Syntax.typeName(8);
        }
        if (obj instanceof LogoList) {
            return Syntax.typeName(16);
        }
        if (obj instanceof AgentSet) {
            return Syntax.typeName(96);
        }
        if (obj instanceof Nobody) {
            return Syntax.typeName(128);
        }
        if (obj instanceof Turtle) {
            return Syntax.typeName(256);
        }
        if (obj instanceof Patch) {
            return Syntax.typeName(512);
        }
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName();
    }

    public static String aTypeName(int mask) {
        String result = Syntax.typeName(mask);
        if (result.equals("nobody")) {
            return result;
        }
        return Syntax.addAOrAn(result);
    }

    public static String typeName(int mask) {
        String result = "(none)";
        if (Syntax.typesAreCompatible(mask, 32768)) {
            mask = Syntax.subtractMasks(mask, 32768);
        }
        if (Syntax.typesAreCompatible(mask, 1024)) {
            result = "variable";
            mask = 0;
        } else if ((mask & 0x7810) == 30736) {
            result = "list or block";
            mask = Syntax.subtractMasks(mask, 30736);
        } else if ((mask & 0x3FF) == 1023) {
            result = "anything";
            mask = Syntax.subtractMasks(mask, 1023);
        } else if ((mask & 0x300) == 768) {
            result = "agent";
            mask = Syntax.subtractMasks(mask, 896);
        } else if (Syntax.typesAreCompatible(mask, 3)) {
            result = "number";
            mask = Syntax.subtractMasks(mask, 3);
        } else if (Syntax.typesAreCompatible(mask, 4)) {
            result = "true/false";
            mask = Syntax.subtractMasks(mask, 4);
        } else if (Syntax.typesAreCompatible(mask, 8)) {
            result = "string";
            mask = Syntax.subtractMasks(mask, 8);
        } else if (Syntax.typesAreCompatible(mask, 16)) {
            result = "list";
            mask = Syntax.subtractMasks(mask, 16);
        } else if (Syntax.typesAreCompatible(mask, 96)) {
            result = "agentset";
            mask = Syntax.subtractMasks(mask, 96);
        } else if (Syntax.typesAreCompatible(mask, 256)) {
            result = "turtle";
            mask = Syntax.subtractMasks(mask, 384);
        } else if (Syntax.typesAreCompatible(mask, 512)) {
            result = "patch";
            mask = Syntax.subtractMasks(mask, 640);
        } else if (Syntax.typesAreCompatible(mask, 128)) {
            result = "nobody";
            mask = Syntax.subtractMasks(mask, 128);
        } else if (Syntax.typesAreCompatible(mask, 2048)) {
            result = "command block";
            mask = Syntax.subtractMasks(mask, 2048);
        } else if ((mask & 0x7000) == 28672) {
            result = "reporter block";
            mask = Syntax.subtractMasks(mask, 28672);
        } else if (Syntax.typesAreCompatible(mask, 16384)) {
            result = "different kind of block";
            mask = Syntax.subtractMasks(mask, 28672);
        } else if (Syntax.typesAreCompatible(mask, 4096)) {
            result = "true/false block";
            mask = Syntax.subtractMasks(mask, 4096);
        } else if (Syntax.typesAreCompatible(mask, 8192)) {
            result = "number block";
            mask = Syntax.subtractMasks(mask, 8192);
        }
        if (mask == 0) {
            return result;
        }
        return result + " or " + Syntax.typeName(mask);
    }

    private static final String addAOrAn(String str) {
        switch (str.toUpperCase().charAt(0)) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': {
                return "an " + str;
            }
        }
        return "a " + str;
    }

    private static final int subtractMasks(int mask1, int mask2) {
        return mask1 - (mask1 & mask2);
    }

    private Syntax(int left, int[] right, int ret, int precedence, int dfault) {
        this.left = left;
        this.right = right;
        this.ret = ret;
        this.precedence = precedence;
        this.dfault = dfault;
    }
}

