/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import org.nlogo.compiler.CompilerException;
import org.nlogo.compiler.Token;
import org.nlogo.compiler.TokenVector;
import org.nlogo.compiler.Tokenizer;
import org.nlogo.util.Exceptions;
import org.nlogo.util.File;

strictfp class TokenReader
extends TokenVector {
    private BufferedReader buffReader;
    private File openedFile;

    Token getNextToken() {
        if (this.currTok < this.tokens.size()) {
            return super.getNextToken();
        }
        Token t = this.getToken();
        if (t == null) {
            return super.getNextToken();
        }
        this.insert(this.currTok++, t);
        return t;
    }

    Token lookAhead() {
        if (this.currTok < this.tokens.size()) {
            return super.lookAhead();
        }
        Token t = this.getToken();
        if (t == null) {
            return super.lookAhead();
        }
        this.insert(this.currTok, t);
        return t;
    }

    private final Token getToken() {
        Token token = null;
        try {
            this.buffReader.mark(500);
            try {
                token = Tokenizer.nextToken(this.buffReader);
            }
            catch (CompilerException err) {
                this.setError(err);
            }
            if (token == null) {
                return token;
            }
            try {
                this.buffReader.reset();
            }
            catch (IOException ex) {
                long pos = this.openedFile.pos;
                this.openedFile.close(true);
                this.openedFile.open(1);
                this.buffReader = this.openedFile.getBufferedReader();
                this.buffReader.skip(pos);
                this.openedFile.pos = pos;
            }
            this.buffReader.skip(token.getEndPosition());
            this.openedFile.pos += (long)token.getEndPosition();
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
        return token;
    }

    TokenReader(File openedFile) {
        super(null);
        this.openedFile = openedFile;
        this.buffReader = openedFile.getBufferedReader();
    }
}

