/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import org.nlogo.compiler.CompilerException;
import org.nlogo.compiler.Token;
import org.nlogo.compiler.TokenVector;
import org.nlogo.compiler.Yylex;
import org.nlogo.util.Exceptions;

strictfp class Tokenizer {
    static TokenVector tokenize(String source) {
        return Tokenizer.tokenize(source, false, "");
    }

    static TokenVector tokenize(String source, boolean includeCommentTokens) {
        return Tokenizer.tokenize(source, includeCommentTokens, "");
    }

    static TokenVector tokenize(String source, boolean includeCommentTokens, String fileName) {
        TokenVector result = new TokenVector(fileName);
        try {
            Token t;
            Yylex yy = new Yylex(source.toCharArray());
            yy.fileName = fileName;
            while ((t = yy.yylex()) != null) {
                if (!includeCommentTokens && t.getType() == 14) continue;
                result.addToken(t);
            }
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
        catch (CompilerException error) {
            result.setError(error);
        }
        return result;
    }

    static Token nextToken(BufferedReader myReader) throws CompilerException {
        Token result = null;
        try {
            Yylex yy = new Yylex(myReader);
            result = yy.yylex();
            return result;
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
            return result;
        }
    }

    private Tokenizer() {
        throw new IllegalStateException();
    }
}

