/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.nlogo.command.Instruction;
import org.nlogo.command.Procedure;
import org.nlogo.compiler.CompilerException;
import org.nlogo.prim._call;
import org.nlogo.prim._callreport;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class TypeParser {
    private final Map procedures;
    private String currentProcedureName;
    static /* synthetic */ Class class$org$nlogo$agent$Observer;
    static /* synthetic */ Class class$org$nlogo$agent$Turtle;
    static /* synthetic */ Class class$org$nlogo$agent$Patch;

    void parse(Iterator procs, Map parseTrees) throws CompilerException {
        HashSet<Procedure> forReparse = new HashSet<Procedure>();
        int size = 0;
        do {
            size = forReparse.size();
            forReparse.clear();
            while (procs.hasNext()) {
                Procedure procedure = (Procedure)procs.next();
                this.currentProcedureName = procedure.name;
                this.procedures.put(this.currentProcedureName, procedure);
                procedure.usableBy = this.parseBlock((Object[])parseTrees.get(this.currentProcedureName), "OTP");
                if (procedure.usableBy == null || !procedure.usableBy.endsWith("?")) continue;
                forReparse.add(procedure);
            }
            procs = new HashSet(forReparse).iterator();
        } while (size != forReparse.size());
    }

    private final String parseBlock(Object[] block, String usableBy) throws CompilerException {
        int i = 0;
        while (i < block.length) {
            usableBy = this.parseInstructionNode((Object[])block[i], usableBy);
            ++i;
        }
        return usableBy;
    }

    private final String parseInstructionNode(Object[] node, String usableBy) throws CompilerException {
        Instruction instruction = (Instruction)node[0];
        Object[] args = (Object[])node[1];
        usableBy = this.parseArgs(args, this.typeCheck(instruction, usableBy), instruction.blockAgentClassString);
        instruction.agentClassString(this.convertUsableByToAgentClassString(usableBy));
        return usableBy;
    }

    private final String parseArgs(Object[] args, String usableBy, String blockAgentClassString) throws CompilerException {
        String possibleAgentTypeForBlock = "-TP";
        int i = 0;
        while (i < args.length) {
            Object[] arg = (Object[])args[i];
            if (arg.length > 0 && arg[0] instanceof Instruction) {
                usableBy = this.parseInstructionNode(arg, usableBy);
                possibleAgentTypeForBlock = this.getReportedAgentType(arg);
            } else if (blockAgentClassString == null) {
                usableBy = this.parseBlock(arg, usableBy);
            } else {
                String agentTypeForBlock = blockAgentClassString.equals("?") ? possibleAgentTypeForBlock : blockAgentClassString;
                if (this.parseBlock(arg, agentTypeForBlock).indexOf("?") != -1) {
                    usableBy = usableBy + '?';
                }
            }
            ++i;
        }
        return usableBy;
    }

    private final String getReportedAgentType(Object[] instructionNode) {
        Instruction instruction = (Instruction)instructionNode[0];
        switch (instruction.getSyntax().ret()) {
            case 32: 
            case 256: {
                return "-T-";
            }
            case 64: 
            case 512: {
                return "--P";
            }
            case 96: 
            case 768: {
                if (((Object[])instructionNode[1]).length > 0) {
                    return this.getReportedAgentType((Object[])((Object[])instructionNode[1])[0]);
                }
                return "-TP";
            }
        }
        return "-TP";
    }

    private final String typeCheck(Instruction instruction, String usableBy) throws CompilerException {
        String instructionUsableBy;
        String originalUsableBy = usableBy;
        if (instruction instanceof _call || instruction instanceof _callreport) {
            Procedure proc = instruction instanceof _call ? ((_call)instruction).procedure : ((_callreport)instruction).procedure;
            instructionUsableBy = proc.usableBy;
            if (instructionUsableBy == null || instructionUsableBy.indexOf("?") != -1 && !proc.name.equals(this.currentProcedureName)) {
                return usableBy + '?';
            }
        } else {
            instructionUsableBy = this.getUsableBy(instruction);
        }
        if (instructionUsableBy.charAt(0) == '-' && usableBy.charAt(0) == 'O') {
            usableBy = usableBy.replace('O', '-');
        }
        if (instructionUsableBy.charAt(1) == '-' && usableBy.charAt(1) == 'T') {
            usableBy = usableBy.replace('T', '-');
        }
        if (instructionUsableBy.charAt(2) == '-' && usableBy.charAt(2) == 'P') {
            usableBy = usableBy.replace('P', '-');
        }
        if (usableBy.startsWith("---")) {
            String name = instruction.token().getName();
            throw new CompilerException("You can't use " + name + " in " + this.usableByToEnglish(originalUsableBy, true) + " context, because " + name + " is " + this.usableByToEnglish(instructionUsableBy, false) + "-only.", instruction.token());
        }
        return usableBy;
    }

    private final String getUsableBy(Instruction instruction) {
        String usableBy = "";
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = TypeParser.class("[Lorg.nlogo.agent.Observer;", false);
        }
        usableBy = instruction.agentClassCanPerform(clazz) ? usableBy.concat("O") : usableBy.concat("-");
        Class clazz2 = class$org$nlogo$agent$Turtle;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Turtle = TypeParser.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        usableBy = instruction.agentClassCanPerform(clazz2) ? usableBy.concat("T") : usableBy.concat("-");
        Class clazz3 = class$org$nlogo$agent$Patch;
        if (clazz3 == null) {
            clazz3 = class$org$nlogo$agent$Patch = TypeParser.class("[Lorg.nlogo.agent.Patch;", false);
        }
        usableBy = instruction.agentClassCanPerform(clazz3) ? usableBy.concat("P") : usableBy.concat("-");
        return usableBy;
    }

    private final String usableByToEnglish(String usableBy, boolean addAOrAn) {
        String english = "";
        if (usableBy.charAt(0) == 'O') {
            english = english.concat("observer");
        }
        if (usableBy.charAt(1) == 'T') {
            if (!english.equals("")) {
                english = english.concat("/");
            }
            english = english.concat("turtle");
        }
        if (usableBy.charAt(2) == 'P') {
            if (!english.equals("")) {
                english = english.concat("/");
            }
            english = english.concat("patch");
        }
        if (addAOrAn) {
            if (english.charAt(0) == 'o') {
                return "an " + english;
            }
            return "a " + english;
        }
        return english;
    }

    private final String convertUsableByToAgentClassString(String usableBy) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < usableBy.length()) {
            char c = usableBy.charAt(i);
            if (c != '?' && c != '-') {
                result.append(c);
            }
            ++i;
        }
        if (result.length() == 0) {
            throw new RuntimeException("can't convert: \"" + usableBy + '\"');
        }
        return result.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.procedures = new HashMap();
    }

    TypeParser() {
        this.this();
    }
}

