/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import java.util.Iterator;
import java.util.Map;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.World;
import org.nlogo.command.Procedure;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.JobOwner;
import org.nlogo.nvm.LogoException;
import org.nlogo.nvm.ReporterActivation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp final class Job {
    static final short RUNNING = 0;
    static final short DONE = 1;
    static final short REMOVED = 2;
    public boolean exclusive;
    public final JobOwner owner;
    short state;
    public Map lastRunTimes;
    boolean stopping;
    public boolean updateDisplay;
    private Context[] contexts;
    final Context parentContext;
    final Activation topLevelActivation;
    Object lock;

    public final boolean stopping() {
        return this.stopping;
    }

    final void makeLock() {
        if (this.lock != null) {
            throw new IllegalStateException("can't call makeLock() twice on same Job");
        }
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void initialize(AgentSet agentset, int address, Agent myself) {
        World world = agentset.world();
        synchronized (world) {
            this.contexts = new Context[agentset.count()];
            int count = 0;
            Iterator iter = agentset.iterator();
            while (iter.hasNext()) {
                Agent agent = (Agent)iter.next();
                this.newAgentJoining(agent, count++, address, myself);
            }
            return;
        }
    }

    final void newAgentJoining(Agent agent, int count, int address, Agent myself) {
        Context context = new Context(this, agent, address, this.parentContext == null ? this.topLevelActivation : this.parentContext.activation, myself);
        if (count == -1) {
            count = this.contexts.length;
            Context[] newContexts = new Context[count + 1];
            System.arraycopy(this.contexts, 0, newContexts, 0, count);
            this.contexts = newContexts;
        }
        this.contexts[count] = context;
    }

    final void step() throws LogoException {
        int max = this.contexts.length;
        boolean allContextsDone = true;
        Context context = null;
        try {
            int i = 0;
            while (i < max && this.state == 0) {
                context = this.contexts[i];
                if (context != null) {
                    if (!context.finished) {
                        if (!context.waiting) {
                            context.step();
                        }
                        allContextsDone = false;
                    } else {
                        this.contexts[i] = null;
                        if (this.lastRunTimes != null) {
                            this.lastRunTimes.remove(context.agent);
                        }
                    }
                }
                ++i;
            }
        }
        catch (LogoException ex) {
            this.finish();
            if (!Context.halting) {
                context.runtimeError(ex);
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            this.finish();
            context.runtimeError(ex);
            throw ex;
        }
        if (this.state == 0 && allContextsDone) {
            this.finish();
        }
    }

    public final void runExclusive(AgentSet agentset, int address, Agent myself) throws LogoException {
        this.exclusive = true;
        Agent[] agents = agentset.toArray();
        Context context = new Context(this, null, 0, null, myself);
        int i = 0;
        while (i < agents.length) {
            if (agents[i] == null) break;
            context.agent = agents[i];
            context.activation = this.parentContext.activation;
            context.ip = address;
            context.finished = false;
            context.runExclusive();
            ++i;
        }
    }

    final void finish() {
        this.state = 1;
        if (this.parentContext != null) {
            this.parentContext.waiting = false;
        }
        int max = this.contexts.length;
        int i = 0;
        while (i < max) {
            Context context = this.contexts[i];
            if (context != null) {
                context.finished = true;
            }
            ++i;
        }
    }

    final Object result() {
        return ((ReporterActivation)this.topLevelActivation).result;
    }

    final boolean isTurtleForeverButtonJob() {
        boolean bl = false;
        if (this.topLevelActivation != null && this.owner != null && this.owner.isTurtleForeverButton()) {
            bl = true;
        }
        return bl;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("(owner: {" + this.owner + "}, state:");
        switch (this.state) {
            case 0: {
                buf.append("running");
                break;
            }
            case 1: {
                buf.append("done");
                break;
            }
            case 2: {
                buf.append("removed");
                break;
            }
            default: {
                throw new IllegalStateException("unknown state: " + this.state);
            }
        }
        buf.append(")");
        return buf.toString();
    }

    private final /* synthetic */ void this() {
        this.exclusive = false;
        this.state = 0;
        this.stopping = false;
        this.updateDisplay = false;
    }

    Job(JobOwner owner) {
        this(owner, owner.agents(), owner.procedure(), 0);
    }

    public Job(JobOwner owner, AgentSet agentset, Procedure procedure, int address) {
        this.this();
        this.owner = owner;
        this.parentContext = null;
        this.topLevelActivation = procedure.type == 2 ? new ReporterActivation(procedure, null, 0, 0) : new Activation(procedure, null, 0, 0);
        this.initialize(agentset, address, null);
    }

    Job(JobOwner owner, AgentSet agentset, int address, Context parentContext, Agent myself) {
        this.this();
        this.owner = owner;
        this.parentContext = parentContext;
        this.topLevelActivation = null;
        this.initialize(agentset, address, myself);
    }

    Job(JobOwner owner, Context parentContext) {
        this.this();
        this.owner = owner;
        this.parentContext = parentContext;
        this.topLevelActivation = null;
    }
}

