/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.Turtle;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.JobManagerOwner;
import org.nlogo.nvm.JobOwner;
import org.nlogo.nvm.JobThread;
import org.nlogo.util.Exceptions;

public strictfp final class JobManager {
    public static final int PERIODIC_UPDATE_DELAY = 200;
    private final JobThread thread;

    public final void die() throws InterruptedException {
        this.thread.die();
    }

    public final float speed() {
        return this.thread.speed;
    }

    public final void speed(float speed) {
        this.thread.speed = speed;
    }

    public final void timeToRunSecondaryJobs() {
        this.thread.isTimeToRunSecondaryJobs = true;
    }

    public final boolean anyPrimaryJobs() {
        return this.thread.primaryJobs.isEmpty() ^ true;
    }

    public final void addJob(Job job, boolean waitForCompletion) {
        if (waitForCompletion) {
            job.makeLock();
            this.add(job, this.thread.primaryJobs);
            this.waitFor(job, false);
        } else {
            this.add(job, this.thread.primaryJobs);
        }
    }

    public final Object addReporterJobAndWait(Job job) {
        job.makeLock();
        this.add(job, this.thread.primaryJobs);
        this.waitFor(job, false);
        return job.result();
    }

    public final void addJobFromJobThread(Job job) {
        this.thread.primaryJobs.add(job);
    }

    public final void addJob(JobOwner owner) {
        this.add(new Job(owner), this.thread.primaryJobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void addSecondaryJob(JobOwner owner) {
        List list = this.thread.secondaryJobs;
        synchronized (list) {
            Job secondaryJob;
            Iterator iter = this.thread.secondaryJobs.iterator();
            do {
                if (iter.hasNext()) continue;
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                this.add(new Job(owner), this.thread.secondaryJobs);
                return;
            } while ((secondaryJob = (Job)iter.next()) == null || secondaryJob.owner != owner || secondaryJob.state != 0);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void add(Job job, List jobs) {
        jobs.add(job);
        if (job.isTurtleForeverButtonJob()) {
            this.thread.turtleForeverButtonJobs.add(job);
        }
        if (job.topLevelActivation == null) return;
        Object object = this.thread.newJobsCondition;
        synchronized (object) {
            this.thread.newJobsCondition.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void joinForeverButtons(Turtle turtle) {
        List list = this.thread.turtleForeverButtonJobs;
        synchronized (list) {
            Iterator iter = this.thread.turtleForeverButtonJobs.iterator();
            while (iter.hasNext()) {
                Job job = (Job)iter.next();
                job.newAgentJoining(turtle, -1, 0, null);
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void waitForFinishedJobs() {
        Context.haltingOwner = null;
        Context.halting = true;
        try {
            this.finishJobs(this.thread.primaryJobs, null);
            this.waitForFinishedJobs(this.thread.primaryJobs);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Context.halting = false;
            throw throwable;
        }
        {
            Object var2_3 = null;
            Context.halting = false;
            return;
        }
    }

    public final void finishJobs(JobOwner owner) {
        this.finishJobs(this.thread.primaryJobs, owner);
    }

    public final void finishSecondaryJobs(JobOwner owner) {
        this.finishJobs(this.thread.secondaryJobs, owner);
        this.thread.lastSecondaryRun = 0L;
        this.timeToRunSecondaryJobs();
    }

    public final void waitForFinishedSecondaryJobs() {
        this.finishJobs(this.thread.secondaryJobs, null);
        this.thread.lastSecondaryRun = 0L;
        this.timeToRunSecondaryJobs();
        this.waitForFinishedJobs(this.thread.secondaryJobs);
    }

    public final void stoppingJobs(JobOwner owner) {
        this.stoppingJobs(this.thread.primaryJobs, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void waitFor(Job job, boolean kill) {
        while (job.state != 2 && this.thread.isAlive()) {
            if (kill) {
                this.thread.interrupt();
            }
            this.thread.isTimeToRunSecondaryJobs = true;
            if (job.lock == null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    Exceptions.ignore(ex);
                }
                continue;
            }
            try {
                Object ex = job.lock;
                synchronized (ex) {
                    job.lock.wait(50L);
                }
            }
            catch (InterruptedException ex) {
                Exceptions.ignore(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void finishJobs(List jobs, JobOwner owner) {
        List list = jobs;
        synchronized (list) {
            Iterator iter = jobs.iterator();
            while (iter.hasNext()) {
                Job job = (Job)iter.next();
                if (job == null || owner != null && job.owner != owner) continue;
                job.finish();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void waitForFinishedJobs(List jobs) {
        while (this.thread.isAlive()) {
            Job jobToWaitFor = null;
            List list = jobs;
            // MONITORENTER : list
            Iterator iter = jobs.iterator();
            while (iter.hasNext()) {
                Job job = (Job)iter.next();
                if (job == null) continue;
                jobToWaitFor = job;
                break;
            }
            // MONITOREXIT : list
            if (jobToWaitFor == null) {
                return;
            }
            this.waitFor(jobToWaitFor, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void stoppingJobs(List jobs, JobOwner owner) {
        List list = jobs;
        synchronized (list) {
            Iterator iter = jobs.iterator();
            while (iter.hasNext()) {
                Job job = (Job)iter.next();
                if (job == null || owner != null && job.owner != owner) continue;
                job.stopping = true;
            }
            return;
        }
    }

    public JobManager(JobManagerOwner jobManagerOwner, Object lock) {
        this.thread = new JobThread(this, jobManagerOwner, lock);
    }
}

