/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.prim;

import org.nlogo.command.Reporter;
import org.nlogo.compiler.Syntax;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.LogoException;
import org.nlogo.util.Utils;

public strictfp final class _pow
extends Reporter {
    public final Object report(Context context) throws LogoException {
        Number n1 = this.arg0.reportNumber(context);
        Number n2 = this.arg1.reportNumber(context);
        try {
            if (n1 instanceof Integer && n2 instanceof Integer) {
                double d2 = n2.doubleValue();
                double d1 = n1.doubleValue();
                double result = StrictMath.pow(d1, d2);
                this.validDouble(result);
                if (d2 >= 0.0) {
                    return Utils.reuseInteger((int)StrictMath.rint(result));
                }
                return new Double(result);
            }
            return this.newValidDouble(StrictMath.pow(n1.doubleValue(), n2.doubleValue()));
        }
        catch (LogoException ex) {
            throw new LogoException(this, this.describeError(n1, n2));
        }
    }

    public final double reportDoubleValue(Context context) throws LogoException {
        return this.validDouble(StrictMath.pow(this.arg0.reportDoubleValue(context), this.arg1.reportDoubleValue(context)));
    }

    public final int reportIntValue(Context context) throws LogoException {
        Number n1 = this.arg0.reportNumber(context);
        Number n2 = this.arg1.reportNumber(context);
        try {
            if (n1 instanceof Integer && n2 instanceof Integer) {
                double d2 = n2.doubleValue();
                double d1 = n1.doubleValue();
                double result = StrictMath.pow(d1, d2);
                this.validDouble(result);
                if (d2 >= 0.0) {
                    return (int)StrictMath.rint(result);
                }
                return (int)result;
            }
            return (int)this.validDouble(StrictMath.pow(n1.doubleValue(), n2.doubleValue()));
        }
        catch (LogoException ex) {
            throw new LogoException(this, this.describeError(n1, n2));
        }
    }

    private final String describeError(Number n1, Number n2) throws LogoException {
        StringBuffer message = new StringBuffer();
        message.append("the operation " + n1 + " ^ " + n2 + " resulted in an error");
        if (n1.doubleValue() < 0.0 && !(n2 instanceof Integer)) {
            message.append(", since a negative base cannot be raised to a non-integer power");
        } else if (n1.doubleValue() == 0.0 && n2.doubleValue() < 0.0) {
            message.append(", since zero cannot be raised to a negative power");
        }
        return message.toString();
    }

    public final Syntax getSyntax() {
        int left = 3;
        int[] right = new int[]{3};
        int ret = 3;
        return Syntax.reporterSyntax(left, right, ret, 10);
    }

    public _pow() {
        super("OTP");
    }
}

