/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.nlogo.shapes.Element;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp abstract class Curve
extends Element
implements Cloneable {
    protected ArrayList xcoords;
    protected ArrayList ycoords;
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;

    public void setFilled(boolean fill) {
    }

    public Rectangle getBounds() {
        return this.createRect(new Point(this.xmin, this.ymin), new Point(this.xmax, this.ymax));
    }

    public void modify(Point start, Point next) {
        this.xcoords.add(new Integer(next.x));
        this.ycoords.add(new Integer(next.y));
        this.updateBounds(next);
    }

    public void draw(Graphics g, Color turtleColor) {
        int[] xArray = new int[this.xcoords.size()];
        int[] yArray = new int[this.xcoords.size()];
        int i = 0;
        while (i < this.xcoords.size()) {
            xArray[i] = this.getElt(i, this.xcoords);
            yArray[i] = this.getElt(i, this.ycoords);
            ++i;
        }
        g.setColor(this.getColor());
        g.drawPolyline(xArray, yArray, this.xcoords.size());
    }

    public void rotateLeft() {
        int i = 0;
        while (i < this.xcoords.size()) {
            int temp = this.getElt(i, this.xcoords);
            this.xcoords.set(i, new Integer(this.getElt(i, this.ycoords)));
            this.ycoords.set(i, new Integer(300 - temp));
            ++i;
        }
    }

    public void rotateRight() {
        int i = 0;
        while (i < this.xcoords.size()) {
            int temp = this.getElt(i, this.xcoords);
            this.xcoords.set(i, new Integer(300 - this.getElt(i, this.ycoords)));
            this.ycoords.set(i, new Integer(temp));
            ++i;
        }
    }

    public void flipHorizontal() {
        int i = 0;
        while (i < this.xcoords.size()) {
            this.xcoords.set(i, new Integer(300 - this.getElt(i, this.xcoords)));
            ++i;
        }
    }

    public void flipVertical() {
        int i = 0;
        while (i < this.ycoords.size()) {
            this.ycoords.set(i, new Integer(300 - this.getElt(i, this.ycoords)));
            ++i;
        }
    }

    public void rotate(Point pivot, int angle) {
        Point newPoint = new Point();
        int i = 0;
        while (i < this.xcoords.size()) {
            newPoint = this.rotatePoint(new Point(this.getElt(i, this.xcoords), this.getElt(i, this.ycoords)), pivot, angle);
            this.xcoords.set(i, new Integer(newPoint.x));
            this.ycoords.set(i, new Integer(newPoint.y));
            ++i;
        }
    }

    public void scale(double xscale, double yscale) {
        int i = 0;
        while (i < this.xcoords.size()) {
            this.xcoords.set(i, new Integer(Element.round((double)this.getElt(i, this.xcoords) * xscale)));
            this.ycoords.set(i, new Integer(Element.round((double)this.getElt(i, this.ycoords) * yscale)));
            ++i;
        }
    }

    public void translate(int x, int y) {
        int i = 0;
        while (i < this.xcoords.size()) {
            this.xcoords.set(i, new Integer(this.getElt(i, this.xcoords) + x));
            this.ycoords.set(i, new Integer(this.getElt(i, this.ycoords) + y));
            ++i;
        }
    }

    private final void updateBounds(Point newPoint) {
        this.xmin = StrictMath.min(this.xmin, newPoint.x);
        this.xmax = StrictMath.max(this.xmax, newPoint.x);
        this.ymin = StrictMath.min(this.ymin, newPoint.y);
        this.ymax = StrictMath.max(this.ymax, newPoint.y);
    }

    public String toReadableString() {
        return "Type: Curve, color: " + this.c + ",\n bounds: " + this.getBounds();
    }

    private final /* synthetic */ void this() {
        this.xcoords = new ArrayList();
        this.ycoords = new ArrayList();
    }

    public Curve() {
        this.this();
    }

    public Curve(Color c) {
        super(c);
        this.this();
    }

    public Curve(Point start, Point next, Color color) {
        super(color);
        this.this();
        this.xcoords.add(new Integer(start.x));
        this.ycoords.add(new Integer(start.y));
        this.xcoords.add(new Integer(next.x));
        this.ycoords.add(new Integer(next.y));
        this.xmin = start.x;
        this.xmax = start.x;
        this.ymin = start.y;
        this.ymax = start.y;
        this.updateBounds(next);
    }
}

