/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.StringTokenizer;
import org.nlogo.shapes.Element;
import org.nlogo.util.Exceptions;

public strictfp class Line
extends Element
implements Cloneable {
    private Point start;
    private Point end;
    private String modifiedPoint;

    public void setFilled(boolean fill) {
    }

    public Object clone() {
        Line newLine = (Line)super.clone();
        newLine.start = (Point)newLine.start.clone();
        newLine.end = (Point)newLine.end.clone();
        return newLine;
    }

    public Rectangle getBounds() {
        return this.createRect(this.start, this.end);
    }

    public boolean contains(Point p) {
        Line2D.Double check = new Line2D.Double(this.start, this.end);
        boolean bl = false;
        if (check.ptSegDist(p) < (double)3) {
            bl = true;
        }
        return bl;
    }

    public void modify(Point start, Point last) {
        this.end.x = last.x;
        this.end.y = last.y;
    }

    public void reshapeElement(Point oldPoint, Point newPoint) {
        if (this.modifiedPoint == "start") {
            this.start = newPoint;
        }
        if (this.modifiedPoint == "end") {
            this.end = newPoint;
        }
    }

    public void moveElement(Point oldPoint, Point newPoint) {
        this.translate(newPoint.x - oldPoint.x, newPoint.y - oldPoint.y);
    }

    public Point[] getHandles() {
        return new Point[]{this.start, this.end};
    }

    public void rotateLeft() {
        int temp = this.start.x;
        this.start.x = this.start.y;
        this.start.y = 300 - temp;
        temp = this.end.x;
        this.end.x = this.end.y;
        this.end.y = 300 - temp;
    }

    public void rotateRight() {
        int temp = this.start.x;
        this.start.x = 300 - this.start.y;
        this.start.y = temp;
        temp = this.end.x;
        this.end.x = 300 - this.end.y;
        this.end.y = temp;
    }

    public void flipHorizontal() {
        this.start.x = 300 - this.start.x;
        this.end.x = 300 - this.end.x;
    }

    public void flipVertical() {
        this.start.y = 300 - this.start.y;
        this.end.y = 300 - this.end.y;
    }

    public void rotate(Point pivot, int angle) {
        this.start = this.rotatePoint(this.start, pivot, angle);
        this.end = this.rotatePoint(this.end, pivot, angle);
    }

    public void scale(double xscale, double yscale) {
        this.start.x = Line.round((double)this.start.x * xscale);
        this.start.y = Line.round((double)this.start.y * yscale);
        this.end.x = Line.round((double)this.end.x * xscale);
        this.end.y = Line.round((double)this.end.y * yscale);
    }

    public void translate(int x, int y) {
        this.start.x += x;
        this.start.y += y;
        this.end.x += x;
        this.end.y += y;
    }

    public void draw(Graphics g, Color turtleColor) {
        if (this.marked && turtleColor != null) {
            g.setColor(turtleColor);
        } else {
            g.setColor(this.getColor());
        }
        g.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
    }

    public void fill(Graphics g) {
    }

    public String toString() {
        return "Line " + this.c.getRGB() + ' ' + this.marked + ' ' + this.start.x + ' ' + this.start.y + ' ' + this.end.x + ' ' + this.end.y;
    }

    public String toReadableString() {
        return "Line with color " + this.c + " and bounds " + this.getBounds();
    }

    public static Line parseLine(String text) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(text);
            tokenizer.nextToken();
            String color = tokenizer.nextToken();
            boolean b1 = Boolean.valueOf(tokenizer.nextToken());
            int x1 = Integer.valueOf(tokenizer.nextToken());
            int y1 = Integer.valueOf(tokenizer.nextToken());
            int x2 = Integer.valueOf(tokenizer.nextToken());
            int y2 = Integer.valueOf(tokenizer.nextToken());
            if (x1 == x2 && y1 == y2) {
                return null;
            }
            Line line = new Line(new Point(x1, y1), new Point(x2, y2), Color.decode(color));
            line.setMarked(b1);
            return line;
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
            return null;
        }
    }

    public void setModifiedPoint(Point modified) {
        if (modified.equals(this.start)) {
            this.modifiedPoint = "start";
        } else if (modified.equals(this.end)) {
            this.modifiedPoint = "end";
        }
    }

    public Point getStart() {
        return this.start;
    }

    public Point getEnd() {
        return this.end;
    }

    public Line() {
        this.start = new Point();
        this.end = new Point();
    }

    public Line(Point start, Point last, Color color) {
        super(color);
        this.start = start;
        this.end = last;
    }
}

