/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.nlogo.shapes.Curve;
import org.nlogo.util.Exceptions;
import org.nlogo.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class Polygon
extends Curve
implements Cloneable {
    private int modifiedPointIndex;
    public int latestIndex;
    public boolean notCompleted;

    public ArrayList getXcoords() {
        return this.xcoords;
    }

    public ArrayList getYcoords() {
        return this.ycoords;
    }

    public void setFilled(boolean fill) {
        this.filled = fill;
    }

    public Object clone() {
        Polygon newPoly = (Polygon)super.clone();
        newPoly.xcoords = new ArrayList(newPoly.xcoords);
        newPoly.ycoords = new ArrayList(newPoly.ycoords);
        return newPoly;
    }

    public Rectangle getBounds() {
        int[] xArray = new int[this.xcoords.size()];
        int[] yArray = new int[this.xcoords.size()];
        int i = 0;
        while (i < this.xcoords.size()) {
            xArray[i] = this.getElt(i, this.xcoords);
            yArray[i] = this.getElt(i, this.ycoords);
            ++i;
        }
        System.out.println("Max ycoord: " + this.max(yArray) + ", Min ycoord: " + this.min(yArray));
        return new java.awt.Polygon(xArray, yArray, this.xcoords.size()).getBounds();
    }

    public void addNewPoint(Point newPoint) {
        this.xcoords.add(new Integer(newPoint.x));
        this.ycoords.add(new Integer(newPoint.y));
        ++this.latestIndex;
    }

    public void modifyPoint(Point newPoint) {
        this.xcoords.set(this.latestIndex, new Integer(newPoint.x));
        this.ycoords.set(this.latestIndex, new Integer(newPoint.y));
    }

    public void modify(Point start, Point end) {
        this.xcoords.set(this.latestIndex, new Integer(end.x));
        this.ycoords.set(this.latestIndex, new Integer(end.y));
    }

    public void reshapeElement(Point oldPoint, Point newPoint) {
        this.xcoords.set(this.modifiedPointIndex, Utils.reuseInteger(newPoint.x));
        this.ycoords.set(this.modifiedPointIndex, Utils.reuseInteger(newPoint.y));
    }

    public void moveElement(Point oldPoint, Point newPoint) {
        this.translate(newPoint.x - oldPoint.x, newPoint.y - oldPoint.y);
    }

    public Point[] getHandles() {
        Point[] handles = new Point[this.xcoords.size()];
        int i = 0;
        while (i < this.xcoords.size()) {
            handles[i] = new Point((Integer)this.xcoords.get(i), (Integer)this.ycoords.get(i));
            ++i;
        }
        return handles;
    }

    public boolean contains(Point p) {
        int ncoords = this.xcoords.size();
        Object[] tmpXArray = this.xcoords.toArray();
        Object[] tmpYArray = this.ycoords.toArray();
        int[] xCoordArray = new int[ncoords];
        int[] yCoordArray = new int[ncoords];
        int i = 0;
        while (i < ncoords) {
            xCoordArray[i] = (Integer)tmpXArray[i];
            yCoordArray[i] = (Integer)tmpYArray[i];
            ++i;
        }
        java.awt.Polygon check = new java.awt.Polygon(xCoordArray, yCoordArray, ncoords);
        return check.contains(p);
    }

    public void draw(Graphics g, Color turtleColor) {
        if (this.notCompleted) {
            super.draw(g, null);
        } else {
            int[] xArray = new int[this.xcoords.size()];
            int[] yArray = new int[this.xcoords.size()];
            int i = 0;
            while (i < this.xcoords.size()) {
                xArray[i] = this.getElt(i, this.xcoords);
                yArray[i] = this.getElt(i, this.ycoords);
                ++i;
            }
            if (this.marked && turtleColor != null) {
                g.setColor(turtleColor);
            } else {
                g.setColor(this.getColor());
            }
            if (this.filled) {
                g.fillPolygon(xArray, yArray, this.xcoords.size());
            } else {
                g.drawPolygon(xArray, yArray, this.xcoords.size());
            }
        }
    }

    public void finishUp() {
        this.xcoords.remove(this.latestIndex);
        this.ycoords.remove(this.latestIndex);
        this.xcoords.remove(this.latestIndex - 1);
        this.ycoords.remove(this.latestIndex - 1);
        this.xcoords.remove(this.latestIndex - 2);
        this.ycoords.remove(this.latestIndex - 2);
        this.notCompleted = false;
    }

    public void selfClose() {
        this.xcoords.remove(this.latestIndex);
        this.ycoords.remove(this.latestIndex);
        this.notCompleted = false;
    }

    public String toReadableString() {
        return "Polygon - color: " + this.c + ",\n          bounds: " + this.getBounds();
    }

    public void translate(int x, int y) {
        int ncoords = this.xcoords.size();
        int i = 0;
        while (i < ncoords) {
            this.xcoords.set(i, Utils.reuseInteger((Integer)this.xcoords.get(i) + x));
            this.ycoords.set(i, Utils.reuseInteger((Integer)this.ycoords.get(i) + y));
            ++i;
        }
    }

    boolean shouldSave() {
        boolean bl = false;
        if (this.xcoords.size() >= 2) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        String ret = "";
        ret = ret + "Polygon " + this.c.getRGB() + ' ' + this.filled + ' ' + this.marked;
        int i = 0;
        while (i < this.xcoords.size()) {
            ret = ret + ' ' + this.getElt(i, this.xcoords) + ' ' + this.getElt(i, this.ycoords);
            ++i;
        }
        return ret;
    }

    public static Polygon parsePolygon(String text) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(text);
            tokenizer.nextToken();
            String color = tokenizer.nextToken();
            boolean b1 = new Boolean(tokenizer.nextToken());
            boolean b2 = new Boolean(tokenizer.nextToken());
            ArrayList<Integer> xs = new ArrayList<Integer>();
            ArrayList<Integer> ys = new ArrayList<Integer>();
            Integer lastx = null;
            Integer lasty = null;
            while (tokenizer.hasMoreTokens()) {
                Integer newx = Integer.valueOf(tokenizer.nextToken());
                Integer newy = Integer.valueOf(tokenizer.nextToken());
                if (!newx.equals(lastx) || !newy.equals(lasty)) {
                    xs.add(newx);
                    ys.add(newy);
                }
                lastx = newx;
                lasty = newy;
            }
            if (xs.size() < 2) {
                return null;
            }
            Polygon polygon = new Polygon(xs, ys, Color.decode(color));
            polygon.setFilled(b1);
            polygon.setMarked(b2);
            return polygon;
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
            return null;
        }
    }

    public void setModifiedPoint(Point modified) {
        int i = 0;
        while (i < this.xcoords.size()) {
            if (this.xcoords.get(i).equals(Utils.reuseInteger(modified.x)) && this.ycoords.get(i).equals(Utils.reuseInteger(modified.y))) {
                this.modifiedPointIndex = i;
            }
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.latestIndex = 1;
        this.notCompleted = false;
    }

    public Polygon() {
        this.this();
    }

    public Polygon(ArrayList xcoords, ArrayList ycoords, Color c) {
        super(c);
        this.this();
        this.xcoords = xcoords;
        this.ycoords = ycoords;
    }

    public Polygon(Point start, Color color) {
        super(color);
        this.this();
        this.notCompleted = true;
        this.xcoords.add(new Integer(start.x));
        this.ycoords.add(new Integer(start.y));
        this.xcoords.add(new Integer(start.x));
        this.ycoords.add(new Integer(start.y));
    }
}

