/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;
import org.nlogo.shapes.Element;
import org.nlogo.util.Exceptions;

public strictfp class Rectangle
extends Element
implements Cloneable {
    protected Point upperLeft;
    protected Point upperRight;
    protected Point lowerRight;
    protected Point lowerLeft;
    protected int xmin;
    protected int xmax;
    protected int ymin;
    protected int ymax;
    private String modifiedPoint;

    public void setFilled(boolean fill) {
        this.filled = fill;
    }

    public Object clone() {
        Rectangle newRect = (Rectangle)super.clone();
        newRect.upperLeft = (Point)newRect.upperLeft.clone();
        newRect.upperRight = (Point)newRect.upperRight.clone();
        newRect.lowerLeft = (Point)newRect.lowerLeft.clone();
        newRect.lowerRight = (Point)newRect.lowerRight.clone();
        return newRect;
    }

    public java.awt.Rectangle getBounds() {
        this.setMaxsAndMins();
        return new java.awt.Rectangle(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public boolean contains(Point p) {
        return this.getBounds().contains(p);
    }

    public void modify(Point start, Point last) {
        int width = StrictMath.abs(start.x - last.x);
        int height = StrictMath.abs(start.y - last.y);
        this.upperLeft.x = StrictMath.min(start.x, last.x);
        this.upperLeft.y = StrictMath.min(start.y, last.y);
        this.upperRight.x = this.upperLeft.x + width;
        this.upperRight.y = this.upperLeft.y;
        this.lowerRight.x = this.upperLeft.x + width;
        this.lowerRight.y = this.upperLeft.y + height;
        this.lowerLeft.x = this.upperLeft.x;
        this.lowerLeft.y = this.upperLeft.y + height;
    }

    public void reshapeElement(Point oldPoint, Point newPoint) {
        if (this.modifiedPoint == "upperLeft") {
            this.upperLeft = newPoint;
            this.lowerLeft.x = newPoint.x;
            this.upperRight.y = newPoint.y;
        }
        if (this.modifiedPoint == "upperRight") {
            this.upperRight = newPoint;
            this.lowerRight.x = newPoint.x;
            this.upperLeft.y = newPoint.y;
        }
        if (this.modifiedPoint == "lowerRight") {
            this.lowerRight = newPoint;
            this.upperRight.x = newPoint.x;
            this.lowerLeft.y = newPoint.y;
        }
        if (this.modifiedPoint == "lowerLeft") {
            this.lowerLeft = newPoint;
            this.upperLeft.x = newPoint.x;
            this.lowerRight.y = newPoint.y;
        }
        this.xmin = this.upperLeft.x;
        this.xmax = this.upperRight.x;
        this.ymin = this.upperLeft.y;
        this.ymax = this.lowerLeft.y;
    }

    public void moveElement(Point oldPoint, Point newPoint) {
        this.translate(newPoint.x - oldPoint.x, newPoint.y - oldPoint.y);
    }

    public Point[] getHandles() {
        int[] xcoords = new int[]{this.upperLeft.x, this.upperRight.x, this.lowerRight.x, this.lowerLeft.x};
        int[] ycoords = new int[]{this.upperLeft.y, this.upperRight.y, this.lowerRight.y, this.lowerLeft.y};
        Point[] handles = new Point[4];
        int i = 0;
        while (i < xcoords.length) {
            handles[i] = new Point(xcoords[i], ycoords[i]);
            ++i;
        }
        return handles;
    }

    public void setMaxsAndMins() {
        int[] xcoords = new int[]{this.upperLeft.x, this.upperRight.x, this.lowerRight.x, this.lowerLeft.x};
        int[] ycoords = new int[]{this.upperLeft.y, this.upperRight.y, this.lowerRight.y, this.lowerLeft.y};
        this.xmin = this.min(xcoords);
        this.xmax = this.max(xcoords);
        this.ymin = this.min(ycoords);
        this.ymax = this.max(ycoords);
    }

    public void draw(Graphics g, Color turtleColor) {
        int[] xcoords = new int[]{this.upperLeft.x, this.upperRight.x, this.lowerRight.x, this.lowerLeft.x};
        int[] ycoords = new int[]{this.upperLeft.y, this.upperRight.y, this.lowerRight.y, this.lowerLeft.y};
        if (this.marked && turtleColor != null) {
            g.setColor(turtleColor);
        } else {
            g.setColor(this.getColor());
        }
        if (this.filled) {
            g.fillPolygon(xcoords, ycoords, 4);
        } else {
            g.drawPolygon(xcoords, ycoords, 4);
        }
    }

    public void rotateLeft() {
        Point temp = this.upperLeft;
        this.upperLeft = this.lowerLeft;
        this.lowerLeft = this.lowerRight;
        this.lowerRight = this.upperRight;
        this.upperRight = temp;
        int temp2 = this.upperLeft.x;
        this.upperLeft.x = this.upperLeft.y;
        this.upperLeft.y = 300 - temp2;
        temp2 = this.upperRight.x;
        this.upperRight.x = this.upperRight.y;
        this.upperRight.y = 300 - temp2;
        temp2 = this.lowerLeft.x;
        this.lowerLeft.x = this.lowerLeft.y;
        this.lowerLeft.y = 300 - temp2;
        temp2 = this.lowerRight.x;
        this.lowerRight.x = this.lowerRight.y;
        this.lowerRight.y = 300 - temp2;
    }

    public void rotateRight() {
        Point temp = this.upperLeft;
        this.upperLeft = this.upperRight;
        this.upperRight = this.lowerRight;
        this.lowerRight = this.lowerLeft;
        this.lowerLeft = temp;
        int temp2 = this.upperLeft.x;
        this.upperLeft.x = 300 - this.upperLeft.y;
        this.upperLeft.y = temp2;
        temp2 = this.lowerLeft.x;
        this.lowerLeft.x = 300 - this.lowerLeft.y;
        this.lowerLeft.y = temp2;
        temp2 = this.upperRight.x;
        this.upperRight.x = 300 - this.upperRight.y;
        this.upperRight.y = temp2;
        temp2 = this.lowerRight.x;
        this.lowerRight.x = 300 - this.lowerRight.y;
        this.lowerRight.y = temp2;
    }

    public void flipHorizontal() {
        Point temp = this.upperLeft;
        this.upperLeft = this.upperRight;
        this.upperRight = temp;
        temp = this.lowerLeft;
        this.lowerLeft = this.lowerRight;
        this.lowerRight = temp;
        this.upperLeft.x = 300 - this.upperLeft.x;
        this.upperRight.x = 300 - this.upperRight.x;
        this.lowerLeft.x = 300 - this.lowerLeft.x;
        this.lowerRight.x = 300 - this.lowerRight.x;
    }

    public void flipVertical() {
        Point temp = this.upperLeft;
        this.upperLeft = this.lowerLeft;
        this.lowerLeft = temp;
        temp = this.lowerRight;
        this.lowerRight = this.upperRight;
        this.upperRight = temp;
        this.upperLeft.y = 300 - this.upperLeft.y;
        this.upperRight.y = 300 - this.upperRight.y;
        this.lowerLeft.y = 300 - this.lowerLeft.y;
        this.lowerRight.y = 300 - this.lowerRight.y;
    }

    public void rotate(Point pivot, int angle) {
        this.upperLeft = this.rotatePoint(this.upperLeft, pivot, angle);
        this.upperRight = this.rotatePoint(this.upperRight, pivot, angle);
        this.lowerRight = this.rotatePoint(this.lowerRight, pivot, angle);
        this.lowerLeft = this.rotatePoint(this.lowerLeft, pivot, angle);
    }

    public void scale(double xscale, double yscale) {
        this.upperLeft.x = Rectangle.round((double)this.upperLeft.x * xscale);
        this.upperLeft.y = Rectangle.round((double)this.upperLeft.y * xscale);
        this.upperRight.x = Rectangle.round((double)this.upperRight.x * xscale);
        this.upperRight.y = Rectangle.round((double)this.upperRight.y * xscale);
        this.lowerRight.x = Rectangle.round((double)this.lowerRight.x * xscale);
        this.lowerRight.y = Rectangle.round((double)this.lowerRight.y * xscale);
        this.lowerLeft.x = Rectangle.round((double)this.lowerLeft.x * xscale);
        this.lowerLeft.y = Rectangle.round((double)this.lowerLeft.y * xscale);
    }

    public void translate(int x, int y) {
        this.upperLeft.x += x;
        this.upperLeft.y += y;
        this.upperRight.x += x;
        this.upperRight.y += y;
        this.lowerLeft.x += x;
        this.lowerLeft.y += y;
        this.lowerRight.x += x;
        this.lowerRight.y += y;
    }

    public String toReadableString() {
        return "Type: Rectangle, color: " + this.c + ",\n bounds: " + this.getBounds();
    }

    public String toString() {
        return "Rectangle " + this.c.getRGB() + ' ' + this.filled + ' ' + this.marked + ' ' + this.upperLeft.x + ' ' + this.upperLeft.y + ' ' + this.lowerRight.x + ' ' + this.lowerRight.y;
    }

    public static Rectangle parseRectangle(String text) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(text);
            tokenizer.nextToken();
            String color = tokenizer.nextToken();
            boolean b1 = new Boolean(tokenizer.nextToken());
            boolean b2 = new Boolean(tokenizer.nextToken());
            int x1 = Integer.valueOf(tokenizer.nextToken());
            int y1 = Integer.valueOf(tokenizer.nextToken());
            int x2 = Integer.valueOf(tokenizer.nextToken());
            int y2 = Integer.valueOf(tokenizer.nextToken());
            if (x1 == x2 && y1 == y2) {
                return null;
            }
            Rectangle rect = new Rectangle(new Point(x1, y1), new Point(x2, y2), Color.decode(color));
            rect.setFilled(b1);
            rect.setMarked(b2);
            return rect;
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
            return null;
        }
    }

    public void setModifiedPoint(Point modified) {
        if (modified.equals(this.upperLeft)) {
            this.modifiedPoint = "upperLeft";
        } else if (modified.equals(this.upperRight)) {
            this.modifiedPoint = "upperRight";
        } else if (modified.equals(this.lowerRight)) {
            this.modifiedPoint = "lowerRight";
        } else if (modified.equals(this.lowerLeft)) {
            this.modifiedPoint = "lowerLeft";
        }
    }

    public int[] getXcoords() {
        int[] xcoords = new int[]{this.upperLeft.x, this.upperRight.x, this.lowerRight.x, this.lowerLeft.x};
        return xcoords;
    }

    public int[] getYcoords() {
        int[] ycoords = new int[]{this.upperLeft.y, this.upperRight.y, this.lowerRight.y, this.lowerLeft.y};
        return ycoords;
    }

    public int getX() {
        return this.upperLeft.x;
    }

    public int getY() {
        return this.upperLeft.y;
    }

    public int getWidth() {
        return this.lowerRight.x - this.upperLeft.x;
    }

    public int getHeight() {
        return this.lowerRight.y - this.upperLeft.y;
    }

    public Rectangle() {
        this.upperLeft = new Point();
        this.upperRight = new Point();
        this.lowerLeft = new Point();
        this.lowerRight = new Point();
    }

    public Rectangle(Point start, Point end, Color color) {
        super(color);
        this.upperLeft = new Point(start);
        this.upperRight = new Point(end.x, start.y);
        this.lowerLeft = new Point(start.x, end.y);
        this.lowerRight = new Point(end);
    }
}

