/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import org.nlogo.util.File;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp final class Utils {
    private static final int MAX_CACHED_INTEGER = 511;
    private static Integer[] cachedPositiveIntegers;
    private static Integer[] cachedNegativeIntegers;
    public static final Integer ZERO;
    public static final Integer ONE;
    public static final Integer FIVE;
    public static final Integer MINUS_ONE;
    public static final Double ZERO_DOUBLE;
    public static final Double ONE_DOUBLE;
    public static final double INFINITESIMAL = 3.2E-15;
    static /* synthetic */ Class class$org$nlogo$util$Utils;
    static /* synthetic */ Class class$java$lang$String;

    public static final double approximate(double n, int places) {
        if (places >= 17) {
            return n;
        }
        double multiplier = StrictMath.pow(10.0, places);
        return StrictMath.floor(n * multiplier + 0.5) / multiplier;
    }

    public static final double approximateCeiling(double n, int places) {
        if (places >= 17) {
            return n;
        }
        double multiplier = StrictMath.pow(10.0, places);
        return StrictMath.ceil(n * multiplier) / multiplier;
    }

    public static final double mod(double num, double base) {
        int cleanDivisions = (int)StrictMath.floor(num / base);
        return num - base * (double)cleanDivisions;
    }

    public static final String escapeSpacesInURL(String url) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < url.length()) {
            char c = url.charAt(i);
            if (c == ' ') {
                buf.append("%20");
            } else {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public static final String unescapeSpacesInURL(String url) {
        StringBuffer buf = new StringBuffer();
        while (url.length() > 0) {
            if (url.length() >= 3 && url.substring(0, 3).equals("%20")) {
                buf.append(' ');
                url = url.substring(3);
                continue;
            }
            buf.append(url.charAt(0));
            url = url.substring(1);
        }
        return buf.toString();
    }

    public static final String makeURLFromFile(java.io.File file) {
        return Utils.makeURLFromFilePath(file.getAbsolutePath());
    }

    public static final String makeURLFromFilePath(String filePath) {
        try {
            return new URI("file", filePath, null).toURL().toString();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final String getResourceAsString(String path) {
        try {
            return Utils.url2String(path);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final String[] getResourceAsStringArray(String path) {
        try {
            String line;
            ArrayList<String> result = new ArrayList<String>();
            Class clazz = class$org$nlogo$util$Utils;
            if (clazz == null) {
                clazz = class$org$nlogo$util$Utils = Utils.class("[Lorg.nlogo.util.Utils;", false);
            }
            InputStream stream = clazz.getResourceAsStream(path);
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            while ((line = in.readLine()) != null) {
                result.add(line);
            }
            return result.toArray(new String[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final String url2String(String sampleURL) throws IOException {
        String line;
        if (!sampleURL.startsWith("/")) {
            String badStart;
            if (!System.getProperty("os.name").startsWith("Mac") && sampleURL.indexOf(badStart = "file://") != -1) {
                sampleURL = "file:/" + sampleURL.substring(sampleURL.indexOf(badStart) + badStart.length(), sampleURL.length());
            }
            URL url = new URL(sampleURL);
            InputStream is = url.openStream();
            return File.inputStream2String(is);
        }
        Class clazz = class$org$nlogo$util$Utils;
        if (clazz == null) {
            clazz = class$org$nlogo$util$Utils = Utils.class("[Lorg.nlogo.util.Utils;", false);
        }
        InputStream program = clazz.getResourceAsStream(sampleURL);
        BufferedReader in = new BufferedReader(new InputStreamReader(program));
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null) {
            buf.append(line + '\n');
        }
        return buf.toString();
    }

    public static final String getProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (RuntimeException ex) {
            System.out.println("couldn't read system property: " + property);
            return null;
        }
    }

    public static final String getVMInfoString() {
        String result = "Java VM: " + Utils.getProperty("java.version") + " (" + Utils.getProperty("java.vendor");
        if (Utils.getProperty("mrj.version") != null) {
            result = result + "; MRJ " + Utils.getProperty("mrj.version");
        }
        if (Utils.getProperty("java.fullversion") != null) {
            result = result + "; " + Utils.getProperty("java.fullversion");
        } else if (Utils.getProperty("java.runtime.version") != null) {
            result = result + "; " + Utils.getProperty("java.runtime.version");
        }
        result = result + ')';
        return result;
    }

    public static final String getOSInfoString() {
        return "operating system: " + Utils.getProperty("os.name") + ' ' + Utils.getProperty("os.version") + " (" + Utils.getProperty("os.arch") + " processor)";
    }

    public static final String getMemoryInfoString() {
        Runtime runtime = Runtime.getRuntime();
        System.gc();
        long total = runtime.totalMemory() / 1024L / 1024L;
        long free = runtime.freeMemory() / 1024L / 1024L;
        long max = runtime.maxMemory() / 1024L / 1024L;
        return "Java heap: used = " + (total - free) + " MB, free = " + free + " MB, max = " + max + " MB";
    }

    public static final String getBrowserInfoString() {
        try {
            String vendor;
            String version;
            int nulls = 0;
            String browser = Utils.getProperty("browser");
            if (browser == null) {
                ++nulls;
                browser = "(unknown browser)";
            }
            if ((version = Utils.getProperty("browser.version")) == null) {
                ++nulls;
                version = "(unknown version)";
            }
            if ((vendor = Utils.getProperty("browser.vendor")) == null) {
                ++nulls;
                vendor = "";
            } else {
                vendor = " (" + vendor + ')';
            }
            if (nulls == 3) {
                return null;
            }
            return browser + ' ' + version + vendor;
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    private static final void cacheIntegers() {
        cachedPositiveIntegers = new Integer[1023];
        cachedNegativeIntegers = new Integer[1023];
        Utils.cachedPositiveIntegers[0] = ZERO;
        Utils.cachedPositiveIntegers[1] = ONE;
        Utils.cachedPositiveIntegers[5] = FIVE;
        Utils.cachedNegativeIntegers[1] = MINUS_ONE;
        int i = 0;
        while (i <= 511) {
            if (cachedPositiveIntegers[i] == null) {
                Utils.cachedPositiveIntegers[i] = new Integer(i);
            }
            if (cachedNegativeIntegers[i] == null) {
                Utils.cachedNegativeIntegers[i] = new Integer(-i);
            }
            ++i;
        }
    }

    public static final Integer reuseInteger(int i) {
        if (i >= 0) {
            if (i <= 511) {
                return cachedPositiveIntegers[i];
            }
            return new Integer(i);
        }
        if (i >= -511) {
            return cachedNegativeIntegers[-i];
        }
        return new Integer(i);
    }

    public static final String escapeString(String st) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < st.length()) {
            char ch = st.charAt(i);
            switch (ch) {
                case '\n': {
                    buff.append("\\n");
                    break;
                }
                case '\r': {
                    buff.append("\\r");
                    break;
                }
                case '\t': {
                    buff.append("\\t");
                    break;
                }
                case '\\': {
                    buff.append("\\\\");
                    break;
                }
                case '\"': {
                    buff.append("\\\"");
                    break;
                }
                default: {
                    buff.append(ch);
                }
            }
            ++i;
        }
        return buff.toString();
    }

    public static final String unEscapeString(String s) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\\' && i != s.length() - 1) {
                switch (s.charAt(++i)) {
                    case 'n': {
                        buf.append('\n');
                        break;
                    }
                    case 'r': {
                        buf.append('\r');
                        break;
                    }
                    case 't': {
                        buf.append('\t');
                        break;
                    }
                    case '\\': {
                        buf.append('\\');
                        break;
                    }
                    case '\"': {
                        buf.append('\"');
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid escape sequence in \"" + s + '\"');
                    }
                }
            } else {
                buf.append(s.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    public static final String replace(String s, String oldString, String newString) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (i + oldString.length() <= s.length() && oldString.equals(s.substring(i, i + oldString.length()))) {
                buf.append(newString);
                i += oldString.length();
                continue;
            }
            buf.append(s.charAt(i));
            ++i;
        }
        return buf.toString();
    }

    public static final String getUnqualifiedClassName(Class theClass) {
        String fullName = theClass.getName();
        int period = fullName.lastIndexOf(46);
        if (period == -1) {
            return fullName;
        }
        return fullName.substring(period + 1);
    }

    public static final String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString().replace('\t', ' ');
    }

    public static final Class[] getAllInterfaces(Class theClass) {
        ArrayList<Class> result = new ArrayList<Class>();
        Stack stack = new Stack();
        stack.addElement(theClass);
        while (!stack.empty()) {
            theClass = (Class)stack.pop();
            if (theClass.isInterface()) {
                result.add(theClass);
            } else if (theClass.getSuperclass() != null) {
                stack.push(theClass.getSuperclass());
            }
            Class<?>[] interfaces = theClass.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                stack.push(interfaces[i]);
                ++i;
            }
        }
        return result.toArray(new Class[0]);
    }

    public static final float[] convertRGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : (float)4 + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static final String makeTempPath(String filename) {
        return Utils.makeTempPath(filename, false);
    }

    public static final String makeTempPath(String filename, boolean escapePath) {
        if (escapePath) {
            return Utils.escapeString(Utils.tempPath() + filename);
        }
        return Utils.tempPath() + filename;
    }

    public static final String tempPath() {
        return System.getProperty("java.io.tmpdir") + (System.getProperty("java.io.tmpdir").endsWith(System.getProperty("file.separator")) ? "" : System.getProperty("file.separator"));
    }

    public static final void sortNumbers(List list) {
        Collections.sort(list, new Comparator(){

            public final int compare(Object o1, Object o2) {
                return Double.compare(((Number)o1).doubleValue(), ((Number)o2).doubleValue());
            }
        });
    }

    public static final String getUserDirectory() {
        return Utils.getProperty("user.home");
    }

    public static final Object newInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static final Object beanShellEval(String bshForm) {
        Object bsh = Utils.newInstance("bsh.Interpreter");
        Class[] classArray = new Class[1];
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = Utils.class("[Ljava.lang.String;", false);
        }
        classArray[0] = clazz;
        Class[] parameterTypes = classArray;
        String result = null;
        Object[] arguments = new Object[]{bshForm};
        try {
            Class<?> c = Class.forName("bsh.Interpreter");
            Method evalMethod = c.getMethod("eval", parameterTypes);
            result = (String)evalMethod.invoke(bsh, arguments);
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
        }
        catch (NoSuchMethodException e) {
            System.out.println(e);
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
        }
        catch (InvocationTargetException e) {
            System.out.println(e);
        }
        return result;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Utils() {
        throw new IllegalStateException();
    }

    static {
        Utils.cacheIntegers();
        ZERO = new Integer(0);
        ONE = new Integer(1);
        FIVE = new Integer(5);
        MINUS_ONE = new Integer(-1);
        ZERO_DOUBLE = new Double(0.0);
        ONE_DOUBLE = new Double(1.0);
    }
}

