/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.util;

import org.nlogo.workspace.Workspace;

public strictfp class Version {
    public static final String VERSION = "NetLogo 2.1.0";
    public static final String REVISION = "";
    private static final String BUILD_DATE = "Monday, December 13, 2004";
    private static final String[] OLD_VERSIONS = new String[]{"NetLogo 2.1.0", "NetLogo 2.1beta", "NetLogo 2.1pre", "NetLogo 2.0", "NetLogo 1.", "NetLogo (no version)"};

    public static boolean isCities() {
        boolean bl = false;
        if (!Workspace.isApplet() && Boolean.getBoolean("org.nlogo.isCities")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isNewCompiler() {
        boolean bl = false;
        if (!Workspace.isApplet() && Boolean.getBoolean("org.nlogo.isNewCompiler")) {
            bl = true;
        }
        return bl;
    }

    public static boolean knownVersion(String version) {
        version = Version.removeRev(version.trim());
        int i = 0;
        while (i < OLD_VERSIONS.length) {
            if (version.startsWith(OLD_VERSIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String removeRev(String version) {
        if (version.lastIndexOf(" (Rev ") == version.length() - 8) {
            return version.substring(0, version.length() - 8);
        }
        return version;
    }

    public static String version() {
        if (REVISION.equals(REVISION)) {
            return VERSION;
        }
        return "NetLogo 2.1.0 (Rev )";
    }

    public static String versionNoRev() {
        return VERSION;
    }

    public static String versionNumberOnlyNoRev() {
        String s = Version.versionNoRev();
        return s.substring("NetLogo ".length());
    }

    public static String buildDate() {
        return Version.isCities() ? "Monday, December 13, 2004 [CITIES]" : BUILD_DATE;
    }

    public static boolean olderThan13pre1(String version) {
        boolean bl = false;
        if (version.startsWith("NetLogo 1.0") || version.startsWith("NetLogo 1.1") || version.startsWith("NetLogo 1.2")) {
            bl = true;
        }
        return bl;
    }

    public static boolean olderThan20alpha1(String version) {
        boolean bl = false;
        if (version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.0pre")) {
            bl = true;
        }
        return bl;
    }

    public static boolean olderThan20beta5(String version) {
        boolean bl = false;
        if (version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.0pre") || version.startsWith("NetLogo 2.0alpha") || version.startsWith("NetLogo 2.0beta1") || version.startsWith("NetLogo 2.0beta2") || version.startsWith("NetLogo 2.0beta3") || version.startsWith("NetLogo 2.0beta4")) {
            bl = true;
        }
        return bl;
    }

    public static boolean olderThan21beta3(String version) {
        boolean bl = false;
        if (version.startsWith("NetLogo 1.") || version.startsWith("NetLogo 2.0") || version.startsWith("NetLogo 2.1pre") || version.startsWith("NetLogo 2.1beta1") || version.startsWith("NetLogo 2.1beta2")) {
            bl = true;
        }
        return bl;
    }

    private Version() {
        throw new IllegalStateException();
    }
}

