/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.nlogo.awt.DarkenImageFilter;
import org.nlogo.awt.Utils;
import org.nlogo.command.Procedure;
import org.nlogo.compiler.Compiler;
import org.nlogo.event.AddJobEvent;
import org.nlogo.event.JobRemovedEvent;
import org.nlogo.event.JobStoppingEvent;
import org.nlogo.event.RemoveJobEvent;
import org.nlogo.util.File;
import org.nlogo.util.Option;
import org.nlogo.util.Options;
import org.nlogo.window.Editable;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.JobWidget;
import org.nlogo.window.PropertyDescription;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class ButtonWidget
extends JobWidget
implements MouseListener,
MouseMotionListener,
Editable,
JobStoppingEvent.Raiser,
JobRemovedEvent.Handler {
    private static final ImageIcon FOREVER_GRAPHIC;
    private static final ImageIcon FOREVER_GRAPHIC_DARK;
    private static final ImageIcon TURTLE_GRAPHIC;
    private static final ImageIcon TURTLE_GRAPHIC_DARK;
    private static final ImageIcon PATCH_GRAPHIC;
    private static final ImageIcon PATCH_GRAPHIC_DARK;
    private static final ImageIcon OBSERVER_GRAPHIC;
    private static final ImageIcon OBSERVER_GRAPHIC_DARK;
    private boolean foreverOn;
    private boolean buttonUp;
    protected boolean forever;
    private char actionKey;
    private boolean keyEnabled;
    private boolean lastMousePressedWasPopupTrigger;
    private Options agentOptions;
    private boolean running;
    private boolean stopping;
    private String name;
    private boolean autoUpdate;
    static /* synthetic */ Class class$org$nlogo$window$ButtonWidget;
    static /* synthetic */ Class class$org$nlogo$agent$Observer;
    static /* synthetic */ Class class$org$nlogo$agent$Turtle;
    static /* synthetic */ Class class$org$nlogo$agent$Patch;

    public boolean foreverOn() {
        return this.foreverOn;
    }

    public void foreverOn(boolean foreverOn) {
        this.foreverOn = foreverOn;
    }

    public boolean buttonUp() {
        return this.buttonUp;
    }

    public void buttonUp(boolean buttonUp) {
        if (buttonUp) {
            this.foreverOn = false;
        }
        this.buttonUp = buttonUp;
        if (buttonUp) {
            this.setBorder(this.widgetBorder);
        } else {
            this.setBorder(this.widgetPressedBorder);
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public boolean forever() {
        return this.forever;
    }

    public void forever(boolean forever) {
        if (forever != this.forever) {
            this.forever = forever;
            this.stopping = false;
            this.recompile();
            this.repaint();
        }
    }

    public char actionKey() {
        return this.actionKey;
    }

    public void actionKey(char actionKey) {
        this.actionKey = actionKey;
    }

    private final String actionKeyString() {
        return this.actionKey == '\u0000' ? "" : Character.toString(this.actionKey);
    }

    public boolean keyEnabled() {
        return this.keyEnabled;
    }

    public void keyEnabled(boolean keyEnabled) {
        if (this.keyEnabled != keyEnabled) {
            this.keyEnabled = keyEnabled;
            this.repaint();
        }
    }

    public void keyTriggered() {
        this.buttonUp(false);
        this.respondToClick(true);
    }

    public void mouseReleased(MouseEvent e) {
        if (!e.isPopupTrigger() && this.isEnabled() && !this.lastMousePressedWasPopupTrigger) {
            e.translatePoint(this.getX(), this.getY());
            this.respondToClick(this.getBounds().contains(e.getPoint()));
        }
    }

    private final void respondToClick(boolean inBounds) {
        if (this.forever()) {
            if (inBounds) {
                this.foreverOn ^= true;
                this.buttonUp(this.foreverOn ^ true);
                this.action();
            } else {
                this.buttonUp(this.foreverOn ^ true);
            }
        } else {
            this.buttonUp(true);
            if (inBounds) {
                this.action();
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        this.lastMousePressedWasPopupTrigger = e.isPopupTrigger();
        if (!e.isPopupTrigger() && Utils.button1Mask(e) && this.isEnabled()) {
            this.buttonUp(false);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (Utils.button1Mask(e) && this.isEnabled()) {
            e.translatePoint(this.getX(), this.getY());
            if (this.getBounds().contains(e.getPoint())) {
                this.buttonUp(false);
            } else if (!this.forever() || !this.foreverOn) {
                this.buttonUp(true);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public String classDisplayName() {
        return "Button";
    }

    public List propertySet() {
        ArrayList<PropertyDescription> propertySet = new ArrayList<PropertyDescription>();
        propertySet.add(new PropertyDescription("agentOptions", "Agent(s)", "Options", -1, false));
        propertySet.add(new PropertyDescription("forever", "Forever", "Boolean", 0, false));
        propertySet.add(new PropertyDescription("wrapSource", "Commands", "Commands", 0, true));
        propertySet.add(new PropertyDescription("name", "Display name", "String", 0, false));
        propertySet.add(new PropertyDescription("actionKey", "Action key", "Key", 0, false));
        propertySet.add(new PropertyDescription("autoUpdate", "Force display update after each run", "Checking this box produces smoother animation, but may make the button run more slowly.", "Boolean", 0, false));
        return propertySet;
    }

    public Options agentOptions() {
        return this.agentOptions;
    }

    public void agentOptions(Options agentOptions) {
        if (agentOptions.chosenOption().source() == this.agentClass()) {
            return;
        }
        this.agentOptions = agentOptions;
        this.agentClass((Class)agentOptions.chosenOption().source());
        this.recompile();
    }

    public void running(boolean running) {
        this.running = running;
    }

    public boolean running() {
        return this.running;
    }

    public boolean stopping() {
        return this.stopping;
    }

    public void stopping(boolean stopping) {
        this.stopping = stopping;
    }

    public boolean isTurtleForeverButton() {
        boolean bl = false;
        Class clazz = this.agentClass();
        Class clazz2 = class$org$nlogo$agent$Turtle;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Turtle = ButtonWidget.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        if (clazz == clazz2 && this.forever()) {
            bl = true;
        }
        return bl;
    }

    public void name(String name) {
        this.name = name;
        this.chooseDisplayName();
    }

    public String name() {
        return this.name;
    }

    public boolean autoUpdate() {
        return this.autoUpdate;
    }

    public void autoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public void agentClass(Class agentClass) {
        super.agentClass(agentClass);
        this.agentOptions().selectObject(this.agentClass());
        this.repaint();
    }

    public void action() {
        if (this.forever() || !this.running()) {
            if (!this.forever() || this.running()) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
            if (this.forever() && this.running()) {
                this.foreverOn = true;
                this.buttonUp(false);
                this.stopping(true);
            } else {
                this.stopping(false);
                this.running(true);
            }
            if (this.forever() && this.buttonUp()) {
                new RemoveJobEvent(this, this).raise();
            } else if (this.forever() && !this.buttonUp() && this.stopping()) {
                new JobStoppingEvent(this, this).raise();
            } else {
                new AddJobEvent(this, this).raise();
            }
        }
    }

    public void procedure(Procedure procedure) {
        super.procedure(procedure);
        boolean bl = false;
        if (procedure != null) {
            bl = true;
        }
        this.setEnabled(bl);
        this.setForeground(procedure == null ? Color.RED : null);
    }

    public void handleJobRemovedEvent(JobRemovedEvent e) {
        if (e.owner() == this) {
            this.popUpStoppingButton();
        }
    }

    public void popUpStoppingButton() {
        this.buttonUp(true);
        this.running(false);
        this.stopping(false);
        this.repaint();
        this.setCursor(null);
    }

    private final void chooseDisplayName() {
        if (this.name().equals("")) {
            this.displayName(this.getSourceName());
        } else {
            this.displayName(this.name());
        }
    }

    private final String getSourceName() {
        return this.innerSource.trim().replaceAll("\\s+", " ");
    }

    public void innerSource(String innerSource) {
        super.innerSource(innerSource);
        this.chooseDisplayName();
    }

    public String wrapSource() {
        return this.innerSource();
    }

    public void wrapSource(String innerSource) {
        if (innerSource.equals(this.innerSource())) {
            return;
        }
        this.innerSource(innerSource);
        this.recompile();
    }

    private final void recompile() {
        String header = "to __button [] ";
        Class type = this.agentClass();
        if (type != null) {
            Class clazz;
            Class clazz2;
            Class clazz3 = class$org$nlogo$agent$Observer;
            if (clazz3 == null) {
                clazz3 = class$org$nlogo$agent$Observer = ButtonWidget.class("[Lorg.nlogo.agent.Observer;", false);
            }
            if (clazz3.equals(this.agentClass)) {
                header = header + " __observercode ";
            }
            if ((clazz2 = class$org$nlogo$agent$Turtle) == null) {
                clazz2 = class$org$nlogo$agent$Turtle = ButtonWidget.class("[Lorg.nlogo.agent.Turtle;", false);
            }
            if (clazz2.equals(this.agentClass)) {
                header = header + " __turtlecode ";
            }
            if ((clazz = class$org$nlogo$agent$Patch) == null) {
                clazz = class$org$nlogo$agent$Patch = ButtonWidget.class("[Lorg.nlogo.agent.Patch;", false);
            }
            if (clazz.equals(this.agentClass)) {
                header = header + " __patchcode ";
            }
            if (this.forever()) {
                header = header + " loop [ ";
            }
        }
        String footer = "";
        if (type != null) {
            footer = footer + "__buttonend";
            if (this.forever()) {
                footer = footer + " ] ";
            }
        }
        footer = footer + " __done end ";
        new RemoveJobEvent(this, this).raise();
        this.source(header, this.innerSource, "\n" + footer);
        this.chooseDisplayName();
    }

    public Dimension getMinimumSize() {
        return new Dimension(55, 33);
    }

    public Dimension getPreferredSize(Font font) {
        Dimension size = this.getMinimumSize();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        size.width = StrictMath.max(size.width, fontMetrics.stringWidth(this.displayName()) + 28);
        size.height = StrictMath.max(size.height, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 12);
        return size;
    }

    public void paintComponent(Graphics g) {
        boolean drawAsUp;
        boolean bl = false;
        if (this.buttonUp() && !this.running()) {
            bl = true;
        }
        g.setColor((drawAsUp = bl) ? this.getBackground() : this.getForeground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Dimension size = this.getSize();
        FontMetrics fontMetrics = g.getFontMetrics();
        int labelHeight = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        this.renderImages(g, drawAsUp ^ true);
        String displayName = this.displayName();
        int availableWidth = size.width - 8;
        int stringWidth = fontMetrics.stringWidth(displayName);
        g.setColor(drawAsUp ? this.getForeground() : this.getBackground());
        String shortString = Utils.shortenStringToFit(displayName, availableWidth, fontMetrics);
        int nx = stringWidth > availableWidth ? 4 : size.width / 2 - stringWidth / 2;
        int ny = size.height / 2 + labelHeight / 2;
        g.drawString(shortString, nx, ny);
        if (!this.actionKeyString().equals("")) {
            int ax = size.width - 4 - fontMetrics.stringWidth(this.actionKeyString());
            int ay = fontMetrics.getMaxAscent() + 2;
            if (drawAsUp) {
                g.setColor(this.keyEnabled ? Color.BLACK : Color.GRAY);
            } else {
                g.setColor(this.keyEnabled && this.forever() ? this.getBackground() : Color.BLACK);
            }
            g.drawString(this.actionKeyString(), ax - 1, ay);
        }
    }

    private final void renderImages(Graphics g, boolean dark) {
        ImageIcon image = dark ? FOREVER_GRAPHIC_DARK : FOREVER_GRAPHIC;
        int imageHeight = 0;
        int imageWidth = 0;
        if (image != null) {
            imageHeight = image.getIconHeight();
            imageWidth = image.getIconWidth();
            if (this.forever()) {
                image.paintIcon(this, g, this.getWidth() - imageWidth - 4, this.getHeight() - imageHeight - 4);
            }
        }
        image = null;
        Class clazz = this.agentClass();
        Class clazz2 = class$org$nlogo$agent$Turtle;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Turtle = ButtonWidget.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        if (clazz == clazz2) {
            image = dark ? TURTLE_GRAPHIC_DARK : TURTLE_GRAPHIC;
        }
        Class clazz3 = this.agentClass();
        Class clazz4 = class$org$nlogo$agent$Patch;
        if (clazz4 == null) {
            clazz4 = class$org$nlogo$agent$Patch = ButtonWidget.class("[Lorg.nlogo.agent.Patch;", false);
        }
        if (clazz3 == clazz4) {
            image = dark ? PATCH_GRAPHIC_DARK : PATCH_GRAPHIC;
        }
        Class clazz5 = this.agentClass();
        Class clazz6 = class$org$nlogo$agent$Observer;
        if (clazz6 == null) {
            clazz6 = class$org$nlogo$agent$Observer = ButtonWidget.class("[Lorg.nlogo.agent.Observer;", false);
        }
        if (clazz5 == clazz6) {
            ImageIcon imageIcon = image = dark ? OBSERVER_GRAPHIC_DARK : OBSERVER_GRAPHIC;
        }
        if (image != null) {
            imageHeight = image.getIconHeight();
            imageWidth = image.getIconWidth();
            image.paintIcon(this, g, 3, 3);
        }
    }

    public String save() {
        StringBuffer s = new StringBuffer();
        s.append("BUTTON\n");
        s.append(this.getBoundsString());
        if (!this.name().equals("")) {
            s.append(this.name() + '\n');
        } else {
            s.append("NIL\n");
        }
        if (this.innerSource() != null && !this.innerSource().equals("")) {
            s.append(File.stripLines(this.innerSource()) + '\n');
        } else {
            s.append("NIL\n");
        }
        if (this.forever()) {
            s.append("T\n");
        } else {
            s.append("NIL\n");
        }
        s.append("1\n");
        s.append("T\n");
        String temp = "OBSERVER\n";
        Class clazz = class$org$nlogo$agent$Turtle;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Turtle = ButtonWidget.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        if (clazz.equals(this.agentClass)) {
            temp = "TURTLE\n";
        } else {
            Class clazz2 = class$org$nlogo$agent$Patch;
            if (clazz2 == null) {
                clazz2 = class$org$nlogo$agent$Patch = ButtonWidget.class("[Lorg.nlogo.agent.Patch;", false);
            }
            if (clazz2.equals(this.agentClass)) {
                temp = "PATCH\n";
            }
        }
        s.append(temp);
        if (this.autoUpdate()) {
            s.append("T\n");
        } else {
            s.append("NIL\n");
        }
        if (this.actionKey == '\u0000') {
            s.append("NIL\n");
        } else {
            s.append("" + this.actionKey + '\n');
        }
        return s.toString();
    }

    public Object load(String[] strings, String version) {
        String source;
        String aType;
        String foreverStr = strings[7];
        this.forever(foreverStr.equals("T"));
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = ButtonWidget.class("[Lorg.nlogo.agent.Observer;", false);
        }
        this.agentClass(clazz);
        if (10 < strings.length && !(aType = strings[10]).equals("NIL")) {
            if (aType.equals("TURTLE")) {
                Class clazz2 = class$org$nlogo$agent$Turtle;
                if (clazz2 == null) {
                    clazz2 = class$org$nlogo$agent$Turtle = ButtonWidget.class("[Lorg.nlogo.agent.Turtle;", false);
                }
                this.agentClass(clazz2);
            } else if (aType.equals("PATCH")) {
                Class clazz3 = class$org$nlogo$agent$Patch;
                if (clazz3 == null) {
                    clazz3 = class$org$nlogo$agent$Patch = ButtonWidget.class("[Lorg.nlogo.agent.Patch;", false);
                }
                this.agentClass(clazz3);
            }
        }
        if (strings.length > 11) {
            this.autoUpdate = strings[11].equals("T");
        }
        if (strings.length > 12 && !strings[12].equals("NIL")) {
            this.actionKey(strings[12].charAt(0));
        }
        this.name("");
        String dName = strings[5];
        if (!dName.equals("NIL")) {
            this.name(dName);
        }
        if ((source = File.restoreLines(strings[6])).equals("NIL")) {
            source = "";
        }
        this.wrapSource(Compiler.autoConvert(source, version));
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1, y2 - y1);
        this.chooseDisplayName();
        return this;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.foreverOn = false;
        this.buttonUp = true;
        this.forever = false;
        this.actionKey = '\u0000';
        this.keyEnabled = false;
        this.lastMousePressedWasPopupTrigger = false;
        this.agentOptions = new Options();
        this.stopping = false;
        this.name = "";
        this.autoUpdate = true;
    }

    public ButtonWidget() {
        this.this();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(InterfaceColors.BUTTON_BACKGROUND);
        this.setBorder(this.widgetBorder);
        Options options = this.agentOptions();
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = ButtonWidget.class("[Lorg.nlogo.agent.Observer;", false);
        }
        options.addOption(new Option("Observer", clazz));
        Options options2 = this.agentOptions();
        Class clazz2 = class$org$nlogo$agent$Turtle;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Turtle = ButtonWidget.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        options2.addOption(new Option("Turtles", clazz2));
        Options options3 = this.agentOptions();
        Class clazz3 = class$org$nlogo$agent$Patch;
        if (clazz3 == null) {
            clazz3 = class$org$nlogo$agent$Patch = ButtonWidget.class("[Lorg.nlogo.agent.Patch;", false);
        }
        options3.addOption(new Option("Patches", clazz3));
        Class clazz4 = class$org$nlogo$agent$Observer;
        if (clazz4 == null) {
            clazz4 = class$org$nlogo$agent$Observer = ButtonWidget.class("[Lorg.nlogo.agent.Observer;", false);
        }
        this.agentClass(clazz4);
        this.agentOptions().selectObject(this.agentClass());
        Utils.adjustDefaultFont(this);
    }

    static {
        Class clazz = class$org$nlogo$window$ButtonWidget;
        if (clazz == null) {
            clazz = class$org$nlogo$window$ButtonWidget = ButtonWidget.class("[Lorg.nlogo.window.ButtonWidget;", false);
        }
        FOREVER_GRAPHIC = new ImageIcon(clazz.getResource("/images/forever2.gif"));
        Class clazz2 = class$org$nlogo$window$ButtonWidget;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$window$ButtonWidget = ButtonWidget.class("[Lorg.nlogo.window.ButtonWidget;", false);
        }
        FOREVER_GRAPHIC_DARK = new ImageIcon(clazz2.getResource("/images/forever.gif"));
        Class clazz3 = class$org$nlogo$window$ButtonWidget;
        if (clazz3 == null) {
            clazz3 = class$org$nlogo$window$ButtonWidget = ButtonWidget.class("[Lorg.nlogo.window.ButtonWidget;", false);
        }
        TURTLE_GRAPHIC = new ImageIcon(clazz3.getResource("/images/turtle.gif"));
        TURTLE_GRAPHIC_DARK = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(TURTLE_GRAPHIC.getImage().getSource(), new DarkenImageFilter(0.5))));
        Class clazz4 = class$org$nlogo$window$ButtonWidget;
        if (clazz4 == null) {
            clazz4 = class$org$nlogo$window$ButtonWidget = ButtonWidget.class("[Lorg.nlogo.window.ButtonWidget;", false);
        }
        PATCH_GRAPHIC = new ImageIcon(clazz4.getResource("/images/patch.gif"));
        PATCH_GRAPHIC_DARK = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(PATCH_GRAPHIC.getImage().getSource(), new DarkenImageFilter(0.5))));
        Class clazz5 = class$org$nlogo$window$ButtonWidget;
        if (clazz5 == null) {
            clazz5 = class$org$nlogo$window$ButtonWidget = ButtonWidget.class("[Lorg.nlogo.window.ButtonWidget;", false);
        }
        OBSERVER_GRAPHIC = new ImageIcon(clazz5.getResource("/images/observer.gif"));
        OBSERVER_GRAPHIC_DARK = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(OBSERVER_GRAPHIC.getImage().getSource(), new DarkenImageFilter(0.5))));
    }
}

