/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.agent.Dump;
import org.nlogo.agent.LogoList;
import org.nlogo.awt.Utils;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.Widget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class Chooser
extends Widget {
    private static final int MIN_WIDTH = 92;
    private static final int MIN_PREFERRED_WIDTH = 120;
    private static final int CHOOSER_HEIGHT = 45;
    private static final int MARGIN = 4;
    private static final int PADDING = 14;
    private final ChooserClickControl control;
    protected LogoList choices;
    private String name;
    private int index;

    public void doLayout() {
        int controlHeight = this.getHeight() / 2;
        this.control.setBounds(4, this.getHeight() - 4 - controlHeight, this.getWidth() - 8, controlHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(92, 45);
    }

    public Dimension getMaximumSize() {
        return new Dimension(10000, 45);
    }

    public Dimension getPreferredSize(Font font) {
        int width = 120;
        FontMetrics metrics = this.getFontMetrics(font);
        width = StrictMath.max(width, metrics.stringWidth(this.name) + 8 + 14);
        width = StrictMath.max(width, this.longestChoiceWidth(metrics) + this.triangleSize() + 20 + 14 + 2);
        return new Dimension(width, 45);
    }

    private final int longestChoiceWidth(FontMetrics metrics) {
        int result = 0;
        int i = 0;
        while (i < this.choices.size()) {
            int width = metrics.stringWidth(Dump.logoObject(this.choices.get(i)));
            result = StrictMath.max(result, width);
            ++i;
        }
        return result;
    }

    private final int triangleSize() {
        return this.control.getBounds().height / 2 - 4;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
        this.repaint();
    }

    protected int index() {
        return this.index;
    }

    protected void index(int index) {
        this.index = index;
        this.repaint();
    }

    public Object value() {
        if (!this.choices.isEmpty()) {
            return this.choices.get(this.index);
        }
        return "";
    }

    public void popup() {
        JPopupMenu menu = new JPopupMenu();
        this.populate(menu);
        menu.show(this, this.control.getBounds().x + 3, this.control.getBounds().y + this.control.getBounds().height);
    }

    public void populate(JPopupMenu menu) {
        if (this.choices.isEmpty()) {
            JMenuItem nullItem = new JMenuItem("<No Choices>");
            nullItem.setEnabled(false);
            menu.add(nullItem);
        } else {
            int i = 0;
            while (i < this.choices.size()) {
                JMenuItem item = new JMenuItem(Dump.logoObject(this.choices.get(i)));
                final int iFinal = i++;
                item.addActionListener(new ActionListener(){

                    public final void actionPerformed(ActionEvent e) {
                        Chooser.this.index(iFinal);
                    }
                });
                menu.add(item);
            }
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        Rectangle cb = this.control.getBounds();
        g.setColor(this.getForeground());
        FontMetrics metrics = g.getFontMetrics();
        int fontAscent = metrics.getMaxAscent();
        int fontHeight = fontAscent + metrics.getMaxDescent();
        String shortenedName = Utils.shortenStringToFit(this.name, size.width - 8, metrics);
        g.drawString(shortenedName, 4, 4 + (cb.y - 4 - fontHeight) / 2 + fontAscent);
        String shortenedValue = Utils.shortenStringToFit(Dump.logoObject(this.value()), cb.width - 12 - this.triangleSize() - 2, metrics);
        g.drawString(shortenedValue, cb.x + 4, cb.y + (cb.height - fontHeight) / 2 + fontAscent);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Chooser.filledDownTriangle(g, cb.x + cb.width - 4 - this.triangleSize() - 2, cb.y + (cb.height - this.triangleSize()) / 2 + 1, this.triangleSize());
    }

    private static final void filledDownTriangle(Graphics g, int x, int y, int size) {
        Polygon shadowTriangle = new Polygon();
        shadowTriangle.addPoint(x + size / 2, y + size + 2);
        shadowTriangle.addPoint(x - 1, y - 1);
        shadowTriangle.addPoint(x + size + 2, y - 1);
        g.setColor(Color.DARK_GRAY);
        g.fillPolygon(shadowTriangle);
        Polygon downTriangle = new Polygon();
        downTriangle.addPoint(x + size / 2, y + size);
        downTriangle.addPoint(x, y);
        downTriangle.addPoint(x + size, y);
        g.setColor(InterfaceColors.SLIDER_HANDLE);
        g.fillPolygon(downTriangle);
    }

    private final /* synthetic */ void this() {
        this.control = new ChooserClickControl();
        this.choices = new LogoList();
        this.name = "";
        this.index = 0;
    }

    public Chooser() {
        this.this();
        this.setOpaque(true);
        this.setBackground(InterfaceColors.SLIDER_BACKGROUND);
        this.setLayout(null);
        this.add(this.control);
        this.doLayout();
        Utils.adjustDefaultFont(this);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class ChooserClickControl
    extends JComponent {
        ChooserClickControl() {
            this.setBackground(InterfaceColors.SLIDER_BACKGROUND);
            this.setBorder(Chooser.this.widgetBorder);
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                public final void mousePressed(MouseEvent e) {
                    Chooser.this.popup();
                }
            });
        }
    }
}

