/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.nlogo.agent.Program;
import org.nlogo.command.Procedure;
import org.nlogo.compiler.Compiler;
import org.nlogo.compiler.CompilerException;
import org.nlogo.event.CompileAllEvent;
import org.nlogo.event.CompileMoreSourceEvent;
import org.nlogo.event.CompiledEvent;
import org.nlogo.event.EventLinkComponent;
import org.nlogo.event.InterfaceGlobalEvent;
import org.nlogo.event.LoadBeginEvent;
import org.nlogo.event.LoadEndEvent;
import org.nlogo.event.RemoveAllJobsEvent;
import org.nlogo.event.WidgetAddedEvent;
import org.nlogo.event.WidgetRemovedEvent;
import org.nlogo.nvm.JobOwner;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InterfaceGlobalWidget;
import org.nlogo.window.PopUpInterface;
import org.nlogo.window.ProceduresInterface;
import org.nlogo.window.Widget;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class CompilerManager
implements EventLinkComponent,
CompiledEvent.Raiser,
RemoveAllJobsEvent.Raiser,
CompileMoreSourceEvent.Handler,
InterfaceGlobalEvent.Handler,
LoadBeginEvent.Handler,
LoadEndEvent.Handler,
WidgetAddedEvent.Handler,
WidgetRemovedEvent.Handler,
CompileAllEvent.Handler {
    private final GUIWorkspace workspace;
    private final ProceduresInterface proceduresInterface;
    public final Set widgets;
    public final Set globalWidgets;
    private boolean isLoading;

    public Object getLinkParent() {
        return this.workspace;
    }

    public void handleLoadBeginEvent(LoadBeginEvent e) {
        this.isLoading = true;
        this.widgets.clear();
        this.globalWidgets.clear();
        this.workspace.world.oldProgram(new Program());
        this.workspace.world.program(new Program());
        this.workspace.world.setUpBreedShapes(true);
    }

    public void handleLoadEndEvent(LoadEndEvent e) {
        this.isLoading = false;
        this.compileAll();
    }

    private final void compileAll() {
        new RemoveAllJobsEvent(this).raise();
        this.workspace.world.displayOn(true);
        this.workspace.displaySwitchOn(true);
        if (!this.isLoading) {
            boolean proceed = this.compileProcedures();
            if (proceed) {
                this.workspace.world.realloc();
                this.workspace.world.oldProgram(this.workspace.world.program());
                this.setGlobalVariables();
                this.compileWidgets();
            } else {
                this.resetWidgetProcedures();
            }
        }
    }

    private final boolean compileProcedures() {
        List globalVariableNames = this.getGlobalVariableNames();
        this.workspace.world.program(new Program());
        try {
            Program program = Compiler.compileProgram(this.proceduresInterface.innerSource(), globalVariableNames, this.workspace.getExtensionManager());
            Iterator procedures = program.getProcedures();
            while (procedures.hasNext()) {
                Procedure procedure = (Procedure)procedures.next();
                procedure.owner = procedure.fileName.equals("") ? this.proceduresInterface : new PopUpInterface(procedure.fileName);
            }
            this.workspace.init(program);
            this.workspace.world.program(program);
            new CompiledEvent(this, this.proceduresInterface, program, null, null).raise();
            return true;
        }
        catch (CompilerException error) {
            if (Workspace.isApplet()) {
                System.err.println("CompilerException: " + error);
                error.printStackTrace();
            }
            if (error.getFileName().equals("")) {
                new CompiledEvent(this, this.proceduresInterface, null, null, error).raise();
            } else {
                new CompiledEvent(this, new PopUpInterface(error.getFileName()), null, null, error).raise();
            }
            return false;
        }
    }

    private final void setGlobalVariables() {
        Iterator iter = this.globalWidgets.iterator();
        while (iter.hasNext()) {
            InterfaceGlobalWidget w = (InterfaceGlobalWidget)iter.next();
            this.workspace.world.setObserverVariableByName(w.name(), w.valueObject());
        }
    }

    private final void compileWidgets() {
        ArrayList<CompiledEvent> errorEvents = new ArrayList<CompiledEvent>();
        Iterator iter = this.widgets.iterator();
        while (iter.hasNext()) {
            JobOwner owner = (JobOwner)iter.next();
            if (owner.isCommandCenter()) continue;
            try {
                Procedure procedure = Compiler.compileMoreCode(owner.source(), this.workspace.world.program(), this.workspace.getExtensionManager());
                if (procedure == null) continue;
                procedure.owner = owner;
                procedure.init(this.workspace);
                new CompiledEvent(this, owner, this.workspace.world.program(), procedure, null).raise();
            }
            catch (CompilerException error) {
                errorEvents.add(new CompiledEvent(this, owner, this.workspace.world.program(), null, error));
            }
        }
        iter = errorEvents.iterator();
        while (iter.hasNext()) {
            ((CompiledEvent)iter.next()).raise();
        }
    }

    private final void resetWidgetProcedures() {
        Iterator iter = this.widgets.iterator();
        while (iter.hasNext()) {
            JobOwner owner = (JobOwner)iter.next();
            owner.procedure(null);
        }
    }

    public void handleCompileMoreSourceEvent(CompileMoreSourceEvent e) {
        JobOwner owner = e.owner();
        if (this.isLoading) {
            this.widgets.add(owner);
            return;
        }
        if (owner.isCommandCenter()) {
            try {
                Procedure proc = Compiler.compileMoreCode(owner.source(), this.workspace.world.program(), this.workspace.getExtensionManager());
                proc.owner = owner;
                proc.init(this.workspace);
                new CompiledEvent(this, owner, this.workspace.world.program(), proc, null).raise();
            }
            catch (CompilerException error) {
                new CompiledEvent(this, owner, this.workspace.world.program(), null, error).raise();
            }
        } else {
            this.compileWidgets();
        }
    }

    public void handleInterfaceGlobalEvent(InterfaceGlobalEvent e) {
        InterfaceGlobalWidget widget = e.widget();
        this.globalWidgets.add(e.widget());
        if (e.nameChanged()) {
            this.compileAll();
        } else if (this.workspace.world.observerOwnsIndexOf(widget.name().toUpperCase()) != -1) {
            if (e.updating()) {
                widget.valueObject(this.workspace.world.getObserverVariableByName(widget.name()));
            }
            this.workspace.world.setObserverVariableByName(widget.name(), widget.valueObject());
        }
    }

    public void handleWidgetAddedEvent(WidgetAddedEvent e) {
        Widget w = e.widget();
        if (w instanceof JobOwner) {
            this.widgets.add(w);
        }
        if (w instanceof InterfaceGlobalWidget) {
            this.globalWidgets.add(w);
        }
    }

    public void handleCompileAllEvent(CompileAllEvent e) {
        this.compileAll();
    }

    public void handleWidgetRemovedEvent(WidgetRemovedEvent e) {
        this.widgets.remove(e.widget());
        this.globalWidgets.remove(e.widget());
    }

    private final List getGlobalVariableNames() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = this.globalWidgets.iterator();
        while (iter.hasNext()) {
            InterfaceGlobalWidget w = (InterfaceGlobalWidget)iter.next();
            result.add(w.name());
        }
        return result;
    }

    private final /* synthetic */ void this() {
        this.widgets = new HashSet();
        this.globalWidgets = new HashSet();
        this.isLoading = false;
    }

    public CompilerManager(GUIWorkspace workspace, ProceduresInterface proceduresInterface) {
        this.this();
        this.workspace = workspace;
        this.proceduresInterface = proceduresInterface;
    }
}

