/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.nlogo.agent.Agent;
import org.nlogo.agent.CSV;
import org.nlogo.agent.Importer;
import org.nlogo.agent.LogoList;
import org.nlogo.agent.Shape;
import org.nlogo.awt.MovieEncoder;
import org.nlogo.awt.Utils;
import org.nlogo.command.Instruction;
import org.nlogo.compiler.CompilerException;
import org.nlogo.event.AboutToQuitEvent;
import org.nlogo.event.AddJobEvent;
import org.nlogo.event.AfterLoadEvent;
import org.nlogo.event.AppEvent;
import org.nlogo.event.BeforeLoadEvent;
import org.nlogo.event.EventLinkComponent;
import org.nlogo.event.ExportInterfaceEvent;
import org.nlogo.event.ExportOutputEvent;
import org.nlogo.event.ExportPlotEvent;
import org.nlogo.event.JobRemovedEvent;
import org.nlogo.event.JobStoppingEvent;
import org.nlogo.event.LoadSectionEvent;
import org.nlogo.event.OutputEvent;
import org.nlogo.event.PatchesCreatedEvent;
import org.nlogo.event.PeriodicUpdateEvent;
import org.nlogo.event.RemoveAllJobsEvent;
import org.nlogo.event.RemoveJobEvent;
import org.nlogo.event.RuntimeErrorEvent;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.JobOwner;
import org.nlogo.nvm.LogoException;
import org.nlogo.nvm.SourceOwner;
import org.nlogo.shapes.ShapesManagerInterface;
import org.nlogo.shapes.VectorShape;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.util.Exceptions;
import org.nlogo.util.OutputObject;
import org.nlogo.window.Applet;
import org.nlogo.window.GraphicsWidget;
import org.nlogo.window.GraphicsWindow;
import org.nlogo.window.JobWidget;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.PeriodicUpdater;
import org.nlogo.window.RuntimeErrorDialog;
import org.nlogo.window.ThreadUtils;
import org.nlogo.window.WidgetContainer;
import org.nlogo.window.graphing.GraphManager;
import org.nlogo.window.graphing.GraphWidget;
import org.nlogo.workspace.Exporter;
import org.nlogo.workspace.ModelReader;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class GUIWorkspace
extends Workspace
implements EventLinkComponent,
AppEvent.Raiser,
ExportInterfaceEvent.Raiser,
ExportOutputEvent.Raiser,
ExportPlotEvent.Raiser,
JobRemovedEvent.Raiser,
OutputEvent.Raiser,
PatchesCreatedEvent.Raiser,
PeriodicUpdateEvent.Raiser,
RuntimeErrorEvent.Raiser,
AboutToQuitEvent.Handler,
AddJobEvent.Handler,
AfterLoadEvent.Handler,
BeforeLoadEvent.Handler,
ExportPlotEvent.Handler,
JobStoppingEvent.Handler,
LoadSectionEvent.Handler,
RemoveAllJobsEvent.Handler,
RemoveJobEvent.Handler {
    public static final int KIOSK_NO = 0;
    public static final int KIOSK_MODERATE = 1;
    public static final int KIOSK_FULL = 2;
    public final int kioskLevel;
    private final Frame frame;
    private final Component linkParent;
    public final GraphicsWidget graphicsWidget;
    public final GraphicsWindow graphicsWindow;
    private final PeriodicUpdater periodicUpdater;
    public ShapesManagerInterface shapesManager;
    public GraphManager graphManager;
    private WidgetContainer widgetContainer;
    public String previewCommands;
    public MovieEncoder movieEncoder;
    private long lastUpdateTime;
    private boolean updateHubNetDisplay;
    private final Runnable updateRunner;
    private boolean periodicUpdatesEnabled;
    public final Action hubNetControlCenterAction;
    static /* synthetic */ Class class$org$nlogo$agent$Observer;

    public WidgetContainer getWidgetContainer() {
        return this.widgetContainer;
    }

    public void setWidgetContainer(WidgetContainer widgetContainer) {
        this.widgetContainer = widgetContainer;
    }

    public boolean headless() {
        return false;
    }

    public Object getLinkParent() {
        return this.linkParent;
    }

    public boolean warningMessage(String message) {
        Object[] options = new String[]{"Continue", "Cancel"};
        message = "Warning: " + message;
        switch (OptionDialog.show(this.getFrame(), "Warning", message, options)) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    public void resizeWorld(int screenEdgeX, int screenEdgeY) {
        Rectangle oldBounds = this.graphicsWindow.getBounds();
        this.graphicsWindow.graphicsPainter.patchSizeNew(StrictMath.max((double)oldBounds.width / (double)(2 * screenEdgeX + 1), (double)oldBounds.height / (double)(2 * screenEdgeY + 1)));
        this.graphicsWidget.screenEdgeXAndY(screenEdgeX, screenEdgeY);
    }

    public void patchesCreatedNotify() {
        new PatchesCreatedEvent(this).raise();
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void reload() {
        new AppEvent(this, 0, new Object[0]).raiseLater();
    }

    public void magicOpen(String name) {
        new AppEvent(this, 1, new Object[]{name}).raiseLater();
    }

    public void benchmark(String name, int iterations, boolean withGraphics) {
        new AppEvent(this, 2, new Object[]{name, new Integer(iterations), new Boolean(withGraphics)}).raiseLater();
    }

    public void dumpModels() {
        new AppEvent(this, 3, new Object[0]).raiseLater();
    }

    public void makePreviews(boolean allModels) {
        new AppEvent(this, 4, new Object[]{new Boolean(allModels)}).raiseLater();
    }

    public void compileLots(int sleepMillis, LogoList buttonNames) {
        new AppEvent(this, 5, new Object[]{new Integer(sleepMillis), buttonNames}).raiseLater();
    }

    public Shape getDefaultShape() {
        VectorShape defaultShape = new VectorShape();
        defaultShape.setName("default");
        defaultShape.setRotatable(true);
        defaultShape.setEditableColorIndex(0);
        defaultShape.addElement("Polygon -7566196 true true 150 5 40 250 150 205 260 250");
        return defaultShape;
    }

    public boolean displaySwitchOn() {
        return this.graphicsWidget.controlStrip.displaySwitchOn();
    }

    public void displaySwitchOn(boolean on) {
        this.graphicsWidget.controlStrip.displaySwitchOn(on);
    }

    public boolean shapesOn() {
        return this.graphicsWindow.graphicsPainter.shapesOn();
    }

    public void updateDisplay(boolean force) {
        this.graphicsWindow.dirty();
        if (!this.graphicsWindow.iconified && this.graphicsWindow.isShowing() && this.world.displayOn() && this.displaySwitchOn()) {
            if (force || System.currentTimeMillis() - this.lastUpdateTime > 50L) {
                this.graphicsWindow.incrementalUpdate();
            } else {
                this.graphicsWindow.framesSkipped();
            }
        }
    }

    void hubNetUpdateDisplay() {
        Utils.mustBeEventDispatchThread();
        if (this.hubNetManager != null && this.computerHubNetRunning && this.updateHubNetDisplay) {
            this.hubNetManager.updateDisplay();
            this.updateHubNetDisplay = false;
        }
    }

    public void donePainting() {
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void setPeriodicUpdatesEnabled(boolean periodicUpdatesEnabled) {
        this.periodicUpdatesEnabled = periodicUpdatesEnabled;
    }

    public void periodicUpdate() {
        if (this.periodicUpdatesEnabled) {
            if (this.hubNetManager != null && this.computerHubNetRunning) {
                this.updateHubNetDisplay = true;
            }
            try {
                Utils.invokeAndWait(this.updateRunner);
            }
            catch (InterruptedException ex) {
                Exceptions.ignore(ex);
            }
        }
    }

    public void halt() {
        new ModalProgressTask(this.getFrame(), new Runnable(){

            public final void run() {
                try {
                    GUIWorkspace.this.jobManager.waitForFinishedJobs();
                    GUIWorkspace.this.world.displayOn(true);
                    GUIWorkspace.this.displaySwitchOn(true);
                    GUIWorkspace.this.graphicsWindow.dirty();
                    GUIWorkspace.this.graphicsWindow.repaint();
                }
                catch (RuntimeException ex) {
                    Exceptions.handle(ex);
                }
            }
        }, "Halting...");
    }

    public void clearAll() throws LogoException {
        super.clearAll();
        ThreadUtils.waitFor(this, new ThreadUtils.CommandRunnable(){

            public final void run() {
                GUIWorkspace.this.graphManager.clearAll();
            }
        });
    }

    public void handleAfterLoadEvent(AfterLoadEvent e) {
        try {
            Class clazz = class$org$nlogo$agent$Observer;
            if (clazz == null) {
                clazz = class$org$nlogo$agent$Observer = GUIWorkspace.class("[Lorg.nlogo.agent.Observer;", false);
            }
            this.evaluator.evaluateCommands("startup", clazz, false);
        }
        catch (CompilerException error) {
            Exceptions.ignore(error);
        }
        this.setPeriodicUpdatesEnabled(true);
    }

    public void ownerFinished(JobOwner owner) {
        new JobRemovedEvent(this, owner).raiseLater();
    }

    public void handleAddJobEvent(AddJobEvent e) {
        JobWidget widget;
        JobOwner owner = e.owner();
        if (owner instanceof JobWidget && (widget = (JobWidget)owner).useAgentClass()) {
            widget.agents(this.world.agentClassToAgentSet(widget.agentClass()));
        }
        if (owner.ownsPrimaryJobs()) {
            if (owner.procedure() != null) {
                this.jobManager.addJob(owner);
            } else {
                new JobRemovedEvent(this, owner).raiseLater();
            }
        } else {
            this.jobManager.addSecondaryJob(owner);
        }
    }

    public void handleRemoveJobEvent(RemoveJobEvent e) {
        JobOwner owner = e.owner();
        if (owner.ownsPrimaryJobs()) {
            this.jobManager.finishJobs(owner);
        } else {
            this.jobManager.finishSecondaryJobs(owner);
        }
    }

    public void handleJobStoppingEvent(JobStoppingEvent e) {
        this.jobManager.stoppingJobs(e.owner());
    }

    public void handleRemoveAllJobsEvent(RemoveAllJobsEvent e) {
        this.jobManager.waitForFinishedJobs();
        this.jobManager.waitForFinishedSecondaryJobs();
    }

    public void resetTimer() {
        super.resetTimer();
        this.graphicsWindow.frameCount = 0;
    }

    public abstract void inspectAgent(Class var1, Agent var2);

    public void clearOutput() throws LogoException {
        ThreadUtils.waitFor(this, new ThreadUtils.CommandRunnable(){

            public final void run() {
                new OutputEvent(GUIWorkspace.this, true, null, false, false).raise();
            }
        });
    }

    protected void sendOutput(final OutputObject oo, final boolean toOutputArea) throws LogoException {
        ThreadUtils.waitFor(this, new ThreadUtils.CommandRunnable(){

            public final void run() {
                new OutputEvent(GUIWorkspace.this, false, oo, false, toOutputArea ^ true).raise();
            }
        });
    }

    protected void doImport(Workspace.Importer importer) throws IOException {
        if (GUIWorkspace.isApplet()) {
            importer.doImport(new BufferedReader(new StringReader(org.nlogo.util.Utils.url2String(new URL(Applet.applet.getCodeBase(), importer.filename).toString()))));
        } else {
            super.doImport(importer);
        }
    }

    protected Importer.ErrorHandler getImporterErrorHandler() {
        return new Importer.ErrorHandler(){

            public final boolean showError(String title, String errorDetails, boolean fatalError) {
                Object[] objectArray;
                Utils.mustBeEventDispatchThread();
                if (fatalError) {
                    Object[] objectArray2 = new String[1];
                    objectArray = objectArray2;
                    objectArray2[0] = "OK";
                } else {
                    String[] stringArray = new String[2];
                    stringArray[0] = "Continue";
                    objectArray = stringArray;
                    stringArray[1] = "Cancel";
                }
                Object[] options = objectArray;
                boolean bl = false;
                if (OptionDialog.show(GUIWorkspace.this.getFrame(), title, errorDetails, options) == 0) {
                    bl = true;
                }
                return bl;
            }
        };
    }

    public void exportGraphics(String filename, String format) throws IOException {
        FileOutputStream stream = new FileOutputStream(new File(filename));
        ImageIO.write((RenderedImage)this.graphicsWindow.exportGraphics(), format, stream);
        stream.close();
    }

    public void exportInterface(String filename) throws IOException {
        FileOutputStream stream = new FileOutputStream(new File(filename));
        IOException[] exceptionBox = new IOException[1];
        new ExportInterfaceEvent(this, stream, exceptionBox).raise();
        stream.close();
        if (exceptionBox[0] != null) {
            throw exceptionBox[0];
        }
    }

    public void exportPlot(int whichGraphs, GraphWidget graph, String filename) {
        new ExportPlotEvent(this, whichGraphs, graph, filename).raise();
    }

    public void exportOutput(String filename) {
        new ExportOutputEvent(this, filename).raise();
    }

    public void handleExportPlotEvent(ExportPlotEvent e) {
        switch (e.getWhichGraphs()) {
            case 1: {
                if (this.graphManager.getGraphNames().length == 0) {
                    OptionDialog.show(this.getFrame(), "Export Plot", "There are no plots to export.", new String[]{"OK"});
                    break;
                }
                new Exporter(e.getFilename()){

                    protected final void export(PrintWriter writer) throws IOException {
                        GUIWorkspace.this.exportInterfaceGlobals(writer);
                        String[] graphNames = GUIWorkspace.this.graphManager.getGraphNames();
                        int i = 0;
                        while (i < graphNames.length) {
                            GUIWorkspace.this.graphManager.getGraph(graphNames[i]).export(writer);
                            writer.println();
                            ++i;
                        }
                    }
                }.export("plots", this.getModelFileName(), "");
                break;
            }
            default: {
                String plotName;
                GraphWidget graph = e.getGraph();
                if (graph == null && (plotName = GUIWorkspace.choosePlotName(this.graphManager.getGraphNames(), this.getFrame())) != null) {
                    graph = this.graphManager.getGraph(plotName);
                }
                if (graph == null) break;
                final GraphWidget graph2 = graph;
                new Exporter(e.getFilename()){

                    protected final void export(PrintWriter writer) {
                        if (graph2.includeInterfaceGlobalsInExport()) {
                            GUIWorkspace.this.exportInterfaceGlobals(writer);
                        }
                        graph2.export(writer);
                    }
                }.export("plot", this.getModelFileName(), "");
                break;
            }
        }
    }

    private final void exportInterfaceGlobals(PrintWriter writer) {
        writer.println(CSV.header("MODEL SETTINGS"));
        List widgets = this.world.program().interfaceGlobals;
        writer.println(CSV.variableNameRow(widgets));
        Object[] values = new Object[widgets.size()];
        int i = 0;
        Iterator iter = widgets.iterator();
        while (iter.hasNext()) {
            values[i] = this.world.getObserverVariableByName((String)iter.next());
            ++i;
        }
        writer.println(CSV.dataRow(values));
        writer.println();
    }

    static String choosePlotName(String[] rawPlotNames, Frame frame) {
        Object[] plotNames = new String[rawPlotNames.length];
        int j = 0;
        int i = 0;
        while (i < rawPlotNames.length) {
            if (!rawPlotNames[i].equals("Behavior Plot")) {
                plotNames[j] = rawPlotNames[i];
                ++j;
            }
            ++i;
        }
        if (j < 1) {
            String message = "There are no plots to export.";
            Object[] options = new String[]{"OK"};
            OptionDialog.show(frame, "Export Plot", message, options);
            return null;
        }
        String message = "Which plot would you like to export?";
        int plotnum = OptionDialog.showAsList(frame, "Export Plot", message, plotNames);
        if (plotnum < 0) {
            return null;
        }
        return plotNames[plotnum];
    }

    public void runtimeError(final JobOwner owner, final Context context, final Instruction instruction, final Exception ex) {
        final Thread thread = Thread.currentThread();
        Utils.invokeLater(new Runnable(){

            public final void run() {
                GUIWorkspace.this.runtimeErrorPrivate(owner, context, instruction, thread, ex);
            }
        });
    }

    private final void runtimeErrorPrivate(JobOwner owner, final Context context, final Instruction instruction, final Thread thread, final Exception ex) {
        try {
            if (ex instanceof HaltException && ((HaltException)ex).haltAll) {
                this.halt();
            } else if (!(owner instanceof MonitorWidget)) {
                this.world.displayOn(true);
                this.displaySwitchOn(true);
            }
        }
        catch (RuntimeException e) {
            Exceptions.handle(e);
        }
        try {
            if (owner != null && !(ex instanceof HaltException)) {
                int[] posAndLength;
                SourceOwner sourceOwner = context.activation.procedure.owner;
                if (instruction.token() == null) {
                    int[] nArray = new int[2];
                    nArray[0] = -1;
                    posAndLength = nArray;
                } else {
                    posAndLength = instruction.getPositionAndLength();
                }
                new RuntimeErrorEvent(this, owner, sourceOwner, posAndLength[0], posAndLength[1]).raiseLater();
            }
        }
        catch (RuntimeException e) {
            Exceptions.handle(e);
        }
        try {
            if (!(owner instanceof MonitorWidget) && !(ex instanceof HaltException)) {
                Utils.invokeLater(new Runnable(){

                    public final void run() {
                        RuntimeErrorDialog.show("Runtime Error", context, instruction, thread, ex);
                    }
                });
            }
        }
        catch (RuntimeException e) {
            Exceptions.handle(e);
        }
    }

    public void handleBeforeLoadEvent(BeforeLoadEvent e) {
        this.setPeriodicUpdatesEnabled(false);
        if (!GUIWorkspace.isApplet()) {
            this.setModelPath(e.modelPath());
            this.setModelType(e.modelType());
        }
        if (this.hubNetManager != null && this.hubNetManager.connectionsExist()) {
            this.hubNetManager.disconnect();
        }
        this.getExtensionManager().reset();
        this.fileManager.handleModelChange();
        this.previewCommands = "";
    }

    public void modelSaved(String newModelPath) {
        this.setModelPath(newModelPath);
        this.setModelType(1);
    }

    public void handleAboutToQuitEvent(AboutToQuitEvent e) {
        if (this.hubNetManager != null && this.hubNetManager.connectionsExist()) {
            this.hubNetManager.disconnect();
        }
    }

    public void handleLoadSectionEvent(LoadSectionEvent e) {
        if (e.section() == ModelReader.PREVIEW_COMMANDS) {
            this.previewCommands = e.text();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.widgetContainer = null;
        this.previewCommands = "";
        this.movieEncoder = null;
        this.lastUpdateTime = 0L;
        this.updateHubNetDisplay = false;
        this.updateRunner = new Runnable(){

            public final void run() {
                new PeriodicUpdateEvent(GUIWorkspace.this).raise();
            }
        };
        this.periodicUpdatesEnabled = false;
        this.hubNetControlCenterAction = new AbstractAction("HubNet Control Center"){

            public final void actionPerformed(ActionEvent e) {
                GUIWorkspace.this.hubNetManager.showControlCenter();
            }
        };
        this.hubNetControlCenterAction.setEnabled(false);
    }

    public GUIWorkspace(int kioskLevel, Frame frame, Workspace.HubNetManagerFactory hubNetManagerFactory) {
        this(kioskLevel, frame, frame, hubNetManagerFactory);
    }

    public GUIWorkspace(int kioskLevel, Frame frame, Component linkParent, Workspace.HubNetManagerFactory hubNetManagerFactory) {
        super(hubNetManagerFactory);
        this.this();
        this.kioskLevel = kioskLevel;
        this.frame = frame;
        this.linkParent = linkParent;
        this.graphicsWidget = new GraphicsWidget(this);
        this.graphicsWindow = this.graphicsWidget.graphicsWindow;
        this.graphManager = new GraphManager();
        this.periodicUpdater = new PeriodicUpdater(this.jobManager);
        this.periodicUpdater.start();
    }
}

