/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.nlogo.agent.Shape;
import org.nlogo.agent.World;
import org.nlogo.awt.Utils;
import org.nlogo.event.CompiledEvent;
import org.nlogo.event.DirtyEvent;
import org.nlogo.event.IconifiedEvent;
import org.nlogo.event.LoadBeginEvent;
import org.nlogo.event.LoadEndEvent;
import org.nlogo.event.LoadSectionEvent;
import org.nlogo.shapes.VectorShape;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.GraphicsPainter;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.ProceduresInterface;
import org.nlogo.workspace.ModelReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class GraphicsWindow
extends JComponent
implements MouseListener,
MouseMotionListener,
DirtyEvent.Raiser,
LoadBeginEvent.Handler,
LoadSectionEvent.Handler,
LoadEndEvent.Handler,
CompiledEvent.Handler,
IconifiedEvent.Handler {
    private final GUIWorkspace workspace;
    GraphicsPainter graphicsPainter;
    private boolean paintingImmediately;
    private boolean framesSkipped;
    private final Runnable paintRunnable;
    boolean iconified;
    private Image offscreenImage;
    private Graphics gOff;
    private boolean dirty;
    public int frameCount;
    private boolean frozen;
    boolean mouseDown;
    double mouseXCor;
    double mouseYCor;
    boolean mouseInside;

    void incrementalUpdate() {
        if (!this.iconified) {
            try {
                Utils.invokeAndWait(this.paintRunnable);
            }
            catch (InterruptedException ex) {
                this.repaint();
            }
        }
    }

    public void dirty() {
        this.dirty = true;
    }

    public void framesSkipped() {
        this.framesSkipped = true;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.workspace.world.screenSizeX(), this.workspace.world.screenSizeY());
    }

    public Dimension getPreferredSize() {
        int width = (int)((double)this.workspace.world.screenSizeX() * this.graphicsPainter.patchSize());
        int height = (int)((double)this.workspace.world.screenSizeY() * this.graphicsPainter.patchSize());
        return new Dimension(width, height);
    }

    public String getCacheReport() {
        return this.graphicsPainter.getCacheReport();
    }

    public boolean shapesOn() {
        return this.graphicsPainter.shapesOn();
    }

    public void handleIconifiedEvent(IconifiedEvent e) {
        if (e.frame() == Utils.getFrame(this)) {
            this.iconified = e.iconified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void beClean() {
        if (!this.dirty) return;
        if (this.offscreenImage == null) {
            this.offscreenImage = this.createImage(this.getWidth(), this.getHeight());
            this.gOff = this.offscreenImage.getGraphics();
        }
        World world = this.workspace.world;
        synchronized (world) {
            this.graphicsPainter.paint(this.gOff);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
            this.dirty = false;
            return;
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        Rectangle bounds = this.getBounds();
        if (width != bounds.width || height != bounds.height || x != bounds.x || y != bounds.y) {
            super.setBounds(x, y, width, height);
            this.offscreenImage = null;
            this.gOff = null;
            this.dirty = true;
        }
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.workspace.donePainting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintComponent(Graphics g) {
        ++this.frameCount;
        if (this.frozen || !this.workspace.world.displayOn()) {
            if (this.dirty) {
                this.graphicsPainter.fillWith(g, InterfaceColors.GRAPHICS_BACKGROUND);
            } else {
                g.drawImage(this.offscreenImage, 0, 0, null);
                this.workspace.hubNetUpdateDisplay();
            }
        } else if (this.paintingImmediately) {
            World world = this.workspace.world;
            synchronized (world) {
                this.graphicsPainter.paint(g);
                this.workspace.hubNetUpdateDisplay();
            }
        } else {
            this.beClean();
            g.drawImage(this.offscreenImage, 0, 0, null);
            this.workspace.hubNetUpdateDisplay();
        }
        this.framesSkipped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage exportGraphics() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        World world = this.workspace.world;
        synchronized (world) {
            this.graphicsPainter.paint(image.getGraphics());
            return image;
        }
    }

    void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            if (this.workspace.world.displayOn()) {
                this.beClean();
            }
        }
    }

    void thaw() {
        if (this.frozen) {
            this.frozen = false;
            this.repaint();
        }
    }

    public void shapeChanged(Shape shape) {
        this.dirty = true;
        new DirtyEvent(this).raise();
        this.workspace.world.invalidateTurtleShape(shape);
        this.graphicsPainter.resetCache();
        this.repaint();
    }

    public void handleLoadSectionEvent(LoadSectionEvent e) {
        if (e.section() == ModelReader.SHAPES) {
            this.workspace.world.shapeList.clearShapes();
            this.workspace.world.shapeList.addNewShapes(VectorShape.parseShapes(e.lines()));
            if (this.workspace.shapesManager != null) {
                this.workspace.shapesManager.update();
                this.workspace.shapesManager.selectShapeName("default");
            }
            this.repaint();
        }
    }

    public void handleLoadBeginEvent(LoadBeginEvent e) {
        this.setVisible(false);
        this.graphicsPainter = new GraphicsPainter(this.workspace.world, this, this.workspace.world.shapeList);
    }

    public void handleLoadEndEvent(LoadEndEvent e) {
        this.setVisible(true);
    }

    public void handleCompiledEvent(CompiledEvent e) {
        if (e.sourceOwner() instanceof ProceduresInterface) {
            this.graphicsPainter.resetCache();
        }
    }

    public void mouseDown(boolean mouseDown) {
        this.mouseDown = mouseDown;
    }

    public boolean mouseDown() {
        return this.mouseDown;
    }

    public double mouseXCor() {
        return this.mouseXCor;
    }

    public void mouseXCor(double mouseXCor) {
        this.mouseXCor = mouseXCor;
    }

    public double mouseYCor() {
        return this.mouseYCor;
    }

    public void mouseYCor(double mouseYCor) {
        this.mouseYCor = mouseYCor;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!e.isPopupTrigger() && Utils.button1Mask(e)) {
            this.mouseDown(true);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!e.isPopupTrigger() && Utils.button1Mask(e)) {
            this.mouseDown(false);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseDown(true);
        if (this.contains(e.getPoint())) {
            this.translatePointToXCorYCor(e.getPoint());
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.translatePointToXCorYCor(e.getPoint());
    }

    void translatePointToXCorYCor(Point p) {
        Rectangle rect = this.getBounds();
        double sex = this.workspace.world.screenEdgeX();
        double dx = (double)p.x / (double)rect.width;
        double newMouseX = (double)this.workspace.world.screenSizeX() * (dx - 0.5);
        if (newMouseX < -(sex + 0.5)) {
            newMouseX = -(sex + 0.5);
        } else if (newMouseX >= sex + 0.5) {
            newMouseX = sex + 0.4999999;
        }
        if (this.graphicsPainter.patchSize() <= 1.0) {
            newMouseX = org.nlogo.util.Utils.approximate(newMouseX, 0);
        }
        this.mouseXCor(newMouseX);
        double sey = this.workspace.world.screenEdgeY();
        double dy = (double)p.y / (double)rect.height;
        double newMouseY = (double)this.workspace.world.screenSizeY() * (0.5 - dy);
        if (newMouseY < -(sey + 0.5)) {
            newMouseY = -(sey + 0.5);
        } else if (newMouseY >= sey + 0.5) {
            newMouseY = sey + 0.4999999;
        }
        if (this.graphicsPainter.patchSize() <= 1.0) {
            newMouseY = org.nlogo.util.Utils.approximate(newMouseY, 0);
        }
        this.mouseYCor(newMouseY);
    }

    static /* synthetic */ boolean access$0(GraphicsWindow graphicsWindow) {
        return graphicsWindow.paintingImmediately;
    }

    private final /* synthetic */ void this() {
        this.paintingImmediately = false;
        this.framesSkipped = false;
        this.paintRunnable = new Runnable(){

            public final void run() {
                GraphicsWindow.this.paintingImmediately = true;
                GraphicsWindow.this.paintImmediately(0, 0, GraphicsWindow.this.getWidth(), GraphicsWindow.this.getHeight());
                GraphicsWindow.this.paintingImmediately = false;
            }
        };
        this.iconified = false;
        this.offscreenImage = null;
        this.gOff = null;
        this.dirty = true;
        this.frameCount = 0;
        this.frozen = false;
        this.mouseDown = false;
        this.mouseXCor = 0.0;
        this.mouseYCor = 0.0;
        this.mouseInside = false;
    }

    public GraphicsWindow(final GUIWorkspace workspace) {
        this.this();
        this.workspace = workspace;
        this.setOpaque(true);
        this.graphicsPainter = new GraphicsPainter(workspace.world, this, workspace.world.shapeList);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        AbstractAction repaintAction = new AbstractAction(){

            public final void actionPerformed(ActionEvent e) {
                if (!GraphicsWindow.this.iconified && GraphicsWindow.this.isShowing() && workspace.world.displayOn() && workspace.displaySwitchOn() && !((GraphicsWindow)GraphicsWindow.this).workspace.jobManager.anyPrimaryJobs()) {
                    if (GraphicsWindow.this.framesSkipped) {
                        GraphicsWindow.this.paintingImmediately = true;
                        GraphicsWindow.this.paintImmediately(0, 0, GraphicsWindow.this.getWidth(), GraphicsWindow.this.getHeight());
                        GraphicsWindow.this.paintingImmediately = false;
                    }
                    workspace.hubNetUpdateDisplay();
                }
            }
        };
        new Timer(100, repaintAction).start();
    }
}

