/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicButtonUI;
import org.nlogo.agent.Dump;
import org.nlogo.awt.Utils;
import org.nlogo.event.InterfaceGlobalEvent;
import org.nlogo.event.PeriodicUpdateEvent;
import org.nlogo.nvm.LogoException;
import org.nlogo.swing.FileDialog;
import org.nlogo.util.Exceptions;
import org.nlogo.util.File;
import org.nlogo.util.FileIO;
import org.nlogo.util.UserCancelException;
import org.nlogo.window.Editable;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.InterfaceGlobalWidget;
import org.nlogo.window.PropertyDescription;
import org.nlogo.window.Widget;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class InputBoxWidget
extends Widget
implements InterfaceGlobalWidget,
Editable,
InterfaceGlobalEvent.Raiser,
PeriodicUpdateEvent.Handler {
    private static final int MIN_WIDTH = 90;
    private static final int MIN_HEIGHT = 104;
    private static final Font FIXED_WIDTH_FONT = new Font(Utils.platformMonospacedFont(), 0, 12);
    private List propertySet;
    public JButton inPlaceOkButton;
    public JButton inPlaceCancelButton;
    private final JButton changeButton;
    private final JLabel widgetLabel;
    private final JTextArea textDisplayArea;
    private InputDialog inputDialog;
    private boolean editing;
    private String name;
    private boolean editinseperatewindow;
    private String text;

    public String classDisplayName() {
        return "Input Box";
    }

    public List propertySet() {
        return this.propertySet;
    }

    public void propertySet(List propertySet) {
        this.propertySet = propertySet;
    }

    private final void stopEdit() {
        this.editing = false;
        this.transferFocus();
        this.textDisplayArea.setForeground(Color.BLACK);
        this.inPlaceOkButton.setVisible(false);
        this.inPlaceCancelButton.setVisible(false);
    }

    public void removeNotify() {
        if (!Workspace.isApplet() && this.inputDialog != null && this.inputDialog.isVisible()) {
            this.inputDialog.setVisible(false);
        }
        super.removeNotify();
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name(name, true);
    }

    private final void name(String name, boolean sendEvent) {
        this.name = name;
        this.displayName(name);
        if (sendEvent) {
            new InterfaceGlobalEvent(this, this, true, false).raise();
        }
        this.widgetLabel.setText(name);
        this.inputDialog.setTitle("Change value for " + name);
    }

    public String nameWrapper() {
        return this.name();
    }

    public void nameWrapper(String name) {
        this.name(name, false);
    }

    public void editFinished() {
        super.editFinished();
        this.name(this.name(), true);
    }

    public boolean editinseperatewindow() {
        return this.editinseperatewindow;
    }

    public void editinseperatewindow(boolean editinseperatewindow) {
        if (this.editing) {
            this.stopEdit();
        }
        this.editinseperatewindow = editinseperatewindow;
        this.textDisplayArea.setEditable(editinseperatewindow ^ true);
        this.changeButton.setVisible(editinseperatewindow);
        this.inPlaceOkButton.setVisible(false);
        this.inPlaceCancelButton.setVisible(false);
    }

    public void handlePeriodicUpdateEvent(PeriodicUpdateEvent e) {
        if (!this.editing) {
            new InterfaceGlobalEvent(this, this, false, true).raise();
        }
    }

    public Object valueObject() {
        return this.text;
    }

    public void valueObject(Object value) {
        this.valueObject(value, false);
    }

    public void valueObject(Object value, boolean raiseEvent) {
        this.text = Dump.logoObject(value);
        if (!this.text.equals(this.textDisplayArea.getText())) {
            this.textDisplayArea.setText(this.text);
        }
        if (raiseEvent) {
            new InterfaceGlobalEvent(this, this, false, false).raise();
        }
    }

    private final void inputText(String input) {
        if (input != null) {
            this.valueObject(input, true);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(90, 104);
    }

    public Dimension getPreferredSize(Font font) {
        Dimension result = super.getPreferredSize(font);
        return new Dimension(StrictMath.max(90, result.width), StrictMath.max(104, result.height));
    }

    public String save() {
        StringBuffer s = new StringBuffer();
        s.append("INPUTBOX\n");
        s.append(this.getBoundsString());
        if (this.name() != null && !this.name().equals("")) {
            s.append(this.name() + '\n');
        } else {
            s.append("NIL\n");
        }
        if (this.text != null && !this.text.equals("")) {
            s.append(File.stripLines(this.text) + '\n');
        } else {
            s.append("NIL\n");
        }
        s.append("true\n");
        s.append("" + this.editinseperatewindow + '\n');
        s.append("true\n");
        return s.toString();
    }

    public Object load(String[] strings, String version) {
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        String displayName = strings[5];
        if (displayName.equals("NIL")) {
            this.name("");
        } else {
            this.name(displayName);
        }
        String contents = File.restoreLines(strings[6]);
        if (contents.equals("NIL")) {
            contents = "";
        }
        this.valueObject(contents, true);
        if (strings.length == 8) {
            this.editinseperatewindow(true);
        } else {
            String editinseperatewindowStr = strings[8];
            this.editinseperatewindow(editinseperatewindowStr.equals("true"));
        }
        this.inputDialog.setTitle("Change value for " + this.name);
        this.setSize(x2 - x1, y2 - y1);
        return this;
    }

    public boolean needsPreferredWidthFudgeFactor() {
        return false;
    }

    public boolean hasContextMenu() {
        return true;
    }

    public void populateContextMenu(JPopupMenu menu, Point p) {
        JMenuItem exportItem = new JMenuItem("Export...");
        exportItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                try {
                    String exportPath = FileDialog.show(InputBoxWidget.this, "Exporting", 1, "export.txt");
                    FileIO.writeFile(exportPath, InputBoxWidget.this.text, true);
                }
                catch (UserCancelException uce) {
                    Exceptions.ignore(uce);
                }
                catch (IOException ioe) {
                    Exceptions.handle(new LogoException("Unable to export the text to the requested file."));
                }
            }
        });
        menu.add(exportItem);
    }

    public boolean zoomSubcomponents() {
        return true;
    }

    static /* synthetic */ boolean access$4(InputBoxWidget inputBoxWidget) {
        return inputBoxWidget.editing;
    }

    private final /* synthetic */ void this() {
        this.propertySet = null;
        this.inPlaceOkButton = new NLButton("Done");
        this.inPlaceCancelButton = new NLButton("Cancel");
        this.changeButton = new NLButton("Change");
        this.changeButton.setOpaque(false);
        this.changeButton.setFocusable(false);
        this.changeButton.setFont(new Font(Utils.platformFont(), 0, 10));
        this.changeButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                if (!InputBoxWidget.this.inputDialog.isVisible()) {
                    InputBoxWidget.this.inputDialog.setText(InputBoxWidget.this.text);
                    InputBoxWidget.this.inputDialog.setVisible(true);
                } else {
                    InputBoxWidget.this.inputDialog.toFront();
                }
            }
        });
        this.widgetLabel = new JLabel();
        this.textDisplayArea = new JTextArea();
        this.editing = false;
        this.name = "";
        this.editinseperatewindow = false;
        this.text = "";
    }

    public InputBoxWidget() {
        this.this();
        this.propertySet(new ArrayList());
        this.propertySet().add(new PropertyDescription("nameWrapper", "Global Variable", "VariableName", 1, true));
        this.propertySet.add(new PropertyDescription("editinseperatewindow", "Edit in Separate Window", "Boolean", 1, false));
        this.setBackground(InterfaceColors.SLIDER_BACKGROUND);
        this.setBorder(this.widgetBorder);
        this.setOpaque(true);
        Utils.adjustDefaultFont(this);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 4, 4);
        layout.setConstraints(this.widgetLabel, c);
        this.add(this.widgetLabel);
        this.widgetLabel.setFont(new Font(Utils.platformFont(), 0, 10));
        c.gridx = 1;
        c.anchor = 13;
        layout.setConstraints(this.changeButton, c);
        this.add(this.changeButton);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 17;
        JScrollPane scroller = new JScrollPane(this.textDisplayArea);
        layout.setConstraints(scroller, c);
        this.add(scroller);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 13;
        c.fill = 1;
        c.anchor = 13;
        layout.setConstraints(buttonPanel, c);
        this.add(buttonPanel);
        buttonPanel.setOpaque(false);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.setAlignmentX(1.0f);
        this.inPlaceCancelButton.setOpaque(false);
        this.inPlaceCancelButton.setFont(new Font(Utils.platformFont(), 0, 10));
        this.inPlaceCancelButton.setAlignmentX(1.0f);
        buttonPanel.add(this.inPlaceCancelButton);
        buttonPanel.add(Box.createHorizontalStrut(4));
        this.inPlaceOkButton.setOpaque(false);
        this.inPlaceOkButton.setFont(new Font(Utils.platformFont(), 0, 10));
        this.inPlaceOkButton.setAlignmentX(1.0f);
        buttonPanel.add(this.inPlaceOkButton);
        buttonPanel.add(Box.createVerticalStrut(16));
        this.textDisplayArea.setEditable(false);
        this.textDisplayArea.setDragEnabled(false);
        this.textDisplayArea.setFont(FIXED_WIDTH_FONT);
        this.inputDialog = new InputDialog(Utils.getFrame(this), "Change value");
        this.textDisplayArea.addFocusListener(new FocusListener(){

            public final void focusGained(FocusEvent e) {
                if (InputBoxWidget.this.editinseperatewindow) {
                    return;
                }
                InputBoxWidget.this.editing = true;
                InputBoxWidget.this.inPlaceOkButton.setVisible(true);
                InputBoxWidget.this.inPlaceCancelButton.setVisible(true);
                InputBoxWidget.this.textDisplayArea.setForeground(Color.DARK_GRAY);
                InputBoxWidget.this.textDisplayArea.selectAll();
            }

            public final void focusLost(FocusEvent e) {
            }
        });
        this.inPlaceOkButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                String value = InputBoxWidget.this.textDisplayArea.getText();
                InputBoxWidget.this.text = value;
                InputBoxWidget.this.inputText(value);
                InputBoxWidget.this.stopEdit();
            }
        });
        this.inPlaceOkButton.setVisible(false);
        this.inPlaceCancelButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                InputBoxWidget.this.stopEdit();
            }
        });
        this.inPlaceCancelButton.setVisible(false);
        this.editinseperatewindow(this.editinseperatewindow);
        this.textDisplayArea.setEditable(true);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class InputDialog
    extends JDialog {
        private static final int DEFAULT_ROWS = 10;
        private static final int DEFAULT_COLUMNS = 50;
        private final JTextArea textArea;
        private JButton applyButton;
        private final Action okAction;
        private final Action cancelAction;
        private final Action applyAction;

        public void setText(String text) {
            this.textArea.setText(text);
            this.textArea.selectAll();
        }

        private final /* synthetic */ void this() {
            this.textArea = new JTextArea(10, 50);
            this.okAction = new AbstractAction("OK"){

                public final void actionPerformed(ActionEvent e) {
                    InputBoxWidget.this.inputText(InputDialog.this.textArea.getText());
                    InputDialog.this.setVisible(false);
                }
            };
            this.cancelAction = new AbstractAction("Cancel"){

                public final void actionPerformed(ActionEvent e) {
                    InputDialog.this.setVisible(false);
                }
            };
            this.applyAction = new AbstractAction("Apply"){

                public final void actionPerformed(ActionEvent e) {
                    InputBoxWidget.this.inputText(InputDialog.this.textArea.getText());
                }
            };
        }

        public InputDialog(Frame parent, String title) {
            super(parent, title);
            this.this();
            this.setResizable(true);
            this.setText("");
            this.textArea.setFont(FIXED_WIDTH_FONT);
            this.applyButton = new JButton(this.applyAction);
            Object[] options = new JButton[]{new JButton(this.okAction), this.applyButton, new JButton(this.cancelAction)};
            this.setContentPane(new JOptionPane(new JScrollPane(this.textArea), -1, 1, null, options, options[1]));
            org.nlogo.swing.Utils.addEscKeyAction(this, this.cancelAction);
            org.nlogo.swing.Utils.addEscKeyAction((JOptionPane)this.getContentPane(), this.cancelAction);
            this.pack();
            Utils.center(this, parent);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NLButton
    extends JButton {
        public void updateUI() {
            this.setUI(new BasicButtonUI());
        }

        public NLButton(String text) {
            super(text);
            this.setFont(new Font(Utils.platformFont(), 0, 10));
            this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
            this.setBorder(org.nlogo.swing.Utils.createWidgetBorder());
            this.setFocusable(false);
        }
    }
}

