/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.event.LoadSectionEvent;
import org.nlogo.event.OutputEvent;
import org.nlogo.util.Exceptions;
import org.nlogo.util.Utils;
import org.nlogo.util.Version;
import org.nlogo.window.ButtonWidget;
import org.nlogo.window.ChooserWidget;
import org.nlogo.window.CommandCenterInterface;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.GraphicsWidget;
import org.nlogo.window.GraphicsWidgetInterface;
import org.nlogo.window.InputBoxWidget;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.OutputWidget;
import org.nlogo.window.SliderWidget;
import org.nlogo.window.SwitchWidget;
import org.nlogo.window.TextBoxWidget;
import org.nlogo.window.Widget;
import org.nlogo.window.WidgetContainer;
import org.nlogo.window.graphing.GraphManager;
import org.nlogo.window.graphing.GraphWidget;
import org.nlogo.workspace.ModelReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class InterfacePanelLite
extends JLayeredPane
implements WidgetContainer,
FocusListener,
LoadSectionEvent.Handler,
OutputEvent.Handler {
    private Map widgets;
    private GraphManager graphManager;
    private GraphicsWidgetInterface graphicsWidget;
    private CommandCenterInterface commandCenter;
    boolean hasFocus;
    private boolean sliderEventOnReleaseOnly;

    public GraphicsWidgetInterface graphicsWidget() {
        return this.graphicsWidget;
    }

    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        this.enableButtonKeys(true);
    }

    public void requestFocus() {
        this.requestFocusInWindow();
    }

    public void reset() {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] instanceof GraphWidget) {
                this.graphManager.forgetGraph((GraphWidget)comps[i]);
            }
            if (!(comps[i] instanceof GraphicsWidget)) {
                this.remove(comps[i]);
            }
            ++i;
        }
    }

    private final void enableButtonKeys(boolean enabled) {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] instanceof ButtonWidget) {
                ButtonWidget button = (ButtonWidget)comps[i];
                button.keyEnabled(enabled);
            }
            ++i;
        }
    }

    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        this.enableButtonKeys(false);
    }

    private final ButtonWidget findActionButton(char key) {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            ButtonWidget button;
            if (comps[i] instanceof ButtonWidget && Character.toUpperCase((button = (ButtonWidget)comps[i]).actionKey()) == Character.toUpperCase(key)) {
                return button;
            }
            ++i;
        }
        return null;
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void setCommandCenter(CommandCenterInterface cc) {
        this.commandCenter = cc;
    }

    public Dimension getPreferredSize() {
        int maxX = 0;
        int maxY = 0;
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] instanceof Widget) {
                Point location = comps[i].getLocation();
                Dimension size = comps[i].getSize();
                int x = location.x + size.width;
                int y = location.y + size.height;
                if (x > maxX) {
                    maxX = x;
                }
                if (y > maxY) {
                    maxY = y;
                }
            }
            ++i;
        }
        return new Dimension(maxX, maxY);
    }

    private final OutputWidget getOutputWidget() {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] instanceof OutputWidget) {
                return (OutputWidget)comps[i];
            }
            ++i;
        }
        return null;
    }

    public void handleOutputEvent(OutputEvent e) {
        if (this.getOutputWidget() != null && !e.toCommandCenter()) {
            if (e.clear()) {
                this.getOutputWidget().outputArea.clear();
            }
            if (e.outputObject() != null) {
                this.getOutputWidget().outputArea.append(e.outputObject(), e.wrapLines());
            }
        }
    }

    public String getBoundsString(Widget widget) {
        StringBuffer buf = new StringBuffer();
        Rectangle r = this.getUnzoomedBounds(widget);
        buf.append("" + r.x + '\n');
        buf.append("" + r.y + '\n');
        buf.append("" + (r.x + r.width) + '\n');
        buf.append("" + (r.y + r.height) + '\n');
        return buf.toString();
    }

    public Rectangle getUnzoomedBounds(Component component) {
        return component.getBounds();
    }

    public int getUnzoomedFontSize(Component component) {
        return component.getFont().getSize();
    }

    public void resetZoomInfo(Widget widget) {
    }

    public void resetSizeInfo(Widget widget) {
    }

    public boolean isZoomed() {
        return false;
    }

    private final void doPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(Version.version());
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem(Utils.getOSInfoString());
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem(Utils.getVMInfoString());
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem(Utils.getMemoryInfoString());
        item.setEnabled(false);
        menu.add(item);
        menu.show(this, e.getX(), e.getY());
    }

    private final void addWidget(Widget widget, int x, int y) {
        this.widgets.put(widget.displayName(), widget);
        widget.addPopupListeners();
        this.add((Component)widget, DEFAULT_LAYER);
        this.moveToFront(widget);
        widget.setLocation(x, y);
        widget.validate();
    }

    public void hideWidget(String widgetName) {
        Widget widget = (Widget)this.widgets.get(widgetName);
        if (widget != null) {
            widget.setVisible(false);
        }
    }

    public void showWidget(String widgetName) {
        Widget widget = (Widget)this.widgets.get(widgetName);
        if (widget != null) {
            widget.setVisible(true);
        }
    }

    public boolean sliderEventOnReleaseOnly() {
        return this.sliderEventOnReleaseOnly;
    }

    public void sliderEventOnReleaseOnly(boolean sliderEventOnReleaseOnly) {
        this.sliderEventOnReleaseOnly = sliderEventOnReleaseOnly;
    }

    public Widget loadWidget(String[] strings, String modelVersion) {
        try {
            String type = strings[0];
            int x = Integer.parseInt(strings[1]);
            int y = Integer.parseInt(strings[2]);
            if (this.graphicsWidget instanceof GraphicsWidget && !type.equals("GRAPHICS-WINDOW") && Version.olderThan13pre1(modelVersion)) {
                y += ((GraphicsWidget)this.graphicsWidget).getExtraHeight() + ((GraphicsWidget)this.graphicsWidget).controlStrip.getHeight();
            }
            if (type.equals("GRAPHICS-WINDOW")) {
                try {
                    this.graphicsWidget.asWidget().load(strings, modelVersion);
                }
                catch (RuntimeException ex) {
                    Exceptions.handle(ex);
                }
                this.graphicsWidget.asWidget().setSize(this.graphicsWidget.asWidget().getSize());
                this.graphicsWidget.asWidget().setLocation(x, y);
                return this.graphicsWidget.asWidget();
            }
            Widget newGuy = null;
            try {
                if (type.equals("MONITOR")) {
                    newGuy = new MonitorWidget();
                } else if (type.equals("PLOT")) {
                    newGuy = this.graphManager.createUntitledGraph();
                } else if (type.equals("SLIDER")) {
                    newGuy = new SliderWidget(this.sliderEventOnReleaseOnly);
                } else if (type.equals("SWITCH")) {
                    newGuy = new SwitchWidget();
                } else if (type.equals("CHOOSER") || type.equals("CHOICE")) {
                    newGuy = new ChooserWidget();
                } else if (type.equals("TEXTBOX")) {
                    newGuy = new TextBoxWidget();
                } else if (type.equals("INPUTBOX")) {
                    newGuy = new InputBoxWidget();
                } else if (type.equals("BUTTON")) {
                    newGuy = new ButtonWidget();
                } else if (type.equals("OUTPUT")) {
                    newGuy = new OutputWidget();
                } else if (type.equals("CC-WINDOW")) {
                    newGuy = (Widget)((Object)this.commandCenter);
                }
            }
            catch (RuntimeException ex) {
                Exceptions.handle(ex);
            }
            if (newGuy != null) {
                ((Widget)newGuy).load(strings, modelVersion);
                this.addWidget(newGuy, x, y);
            }
            return newGuy;
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleLoadSectionEvent(LoadSectionEvent e) {
        if (e.section() != ModelReader.WIDGETS) return;
        try {
            List v = ModelReader.parseWidgets(e.lines());
            if (v != null) {
                this.setVisible(false);
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    List v2 = (List)iter.next();
                    String[] strings = v2.toArray(new String[v2.size()]);
                    this.loadWidget(strings, e.version());
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.setVisible(true);
            this.revalidate();
            throw throwable;
        }
        {
            Object var3_8 = null;
        }
        this.setVisible(true);
        this.revalidate();
    }

    private final /* synthetic */ void this() {
        this.hasFocus = true;
        this.sliderEventOnReleaseOnly = false;
    }

    public InterfacePanelLite(GraphicsWidgetInterface graphicsWidget, GUIWorkspace workspace, GraphManager graphManager, CommandCenterInterface commandCenter) {
        this.this();
        this.graphicsWidget = graphicsWidget;
        this.graphManager = graphManager;
        this.commandCenter = commandCenter;
        this.widgets = new HashMap();
        if (workspace != null) {
            workspace.setWidgetContainer(this);
        }
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.addFocusListener(this);
        this.addMouseListener(new MouseAdapter(){

            public final void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    InterfacePanelLite.this.doPopup(e);
                } else {
                    InterfacePanelLite.this.requestFocus();
                }
            }

            public final void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    InterfacePanelLite.this.doPopup(e);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public final void keyTyped(KeyEvent e) {
                ButtonWidget button;
                if (e.getKeyChar() != (char)-1 && !e.isActionKey() && (e.getModifiers() & InterfacePanelLite.this.getToolkit().getMenuShortcutKeyMask()) == 0 && (button = InterfacePanelLite.this.findActionButton(e.getKeyChar())) != null) {
                    button.keyTriggered();
                }
            }
        });
        this.addWidget((Widget)((Object)graphicsWidget), 0, 0);
    }
}

