/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import org.nlogo.agent.Agent;
import org.nlogo.awt.Utils;
import org.nlogo.event.Event;
import org.nlogo.event.EventLinkContainer;
import org.nlogo.nvm.LogoException;
import org.nlogo.util.Exceptions;
import org.nlogo.util.ExceptionsHandler;
import org.nlogo.util.FileIO;
import org.nlogo.window.CompilerManager;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.GraphicsWidget;
import org.nlogo.window.InterfacePanelLite;
import org.nlogo.window.ModelLoader;
import org.nlogo.window.ProceduresLite;
import org.nlogo.window.RuntimeErrorDialog;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class LiteApplet
extends JApplet
implements ExceptionsHandler,
EventLinkContainer {
    private InterfacePanelLite iP;
    private final List linkComponents;

    public void init() {
        org.nlogo.swing.Utils.detectBadJVMs();
        Utils.invokeLater(new Runnable(){

            public final void run() {
                LiteApplet.this.setup();
                LiteApplet.this.go(null);
            }
        });
    }

    public void setup() {
        RuntimeErrorDialog.init(this);
        Exceptions.setHandler(this);
        this.getContentPane().setLayout(new BorderLayout());
        GUIWorkspace workspace = new GUIWorkspace(1, Utils.getFrame(this), null){

            public final void inspectAgent(Class agentClass, Agent agent) {
            }
        };
        this.addLinkComponent(workspace);
        ProceduresLite procedures = new ProceduresLite(workspace);
        this.addLinkComponent(procedures);
        this.addLinkComponent(new CompilerManager(workspace, procedures));
        this.iP = new InterfacePanelLite(workspace.graphicsWidget, workspace, workspace.graphManager, null);
        this.getContentPane().add((Component)this.iP, "Center");
    }

    public void go(String path) {
        try {
            String source;
            String name;
            if (!Workspace.isApplet()) {
                if (path == null) {
                    FileDialog dialog = new FileDialog(Utils.getFrame(this), "Open: NetLogo Model", 0);
                    dialog.setVisible(true);
                    if (dialog.getDirectory() == null) {
                        System.exit(0);
                    }
                    path = dialog.getDirectory() + dialog.getFile();
                }
                name = new File(path).getName();
                source = FileIO.file2String(path);
            } else {
                name = this.getParameter("DefaultModel");
                if (this.getCodeBase().toString().indexOf("file:") == 0 && System.getProperty("os.name").startsWith("Windows")) {
                    name = org.nlogo.util.Utils.unescapeSpacesInURL(name);
                }
                source = org.nlogo.util.Utils.url2String(new URL(this.getCodeBase(), name).toString());
            }
            RuntimeErrorDialog.modelName = name;
            ModelLoader.load((Container)this, name, 2, source);
            this.iP.setSize(this.getSize());
            if (!System.getProperty("os.name").startsWith("Mac") && !System.getProperty("os.name").startsWith("Windows")) {
                ((GraphicsWidget)this.iP.graphicsWidget()).controlStrip.doLayout();
                ((GraphicsWidget)this.iP.graphicsWidget()).controlStrip.speedSlider.doLayout();
            }
            Utils.invokeLater(new Runnable(){

                public final void run() {
                    LiteApplet.this.iP.requestFocus();
                }
            });
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    public void requestFocus() {
        if (this.iP != null) {
            this.iP.requestFocus();
        }
    }

    public void handle(final Throwable throwable) {
        try {
            if (!(throwable instanceof LogoException)) {
                throwable.printStackTrace();
            }
            final Thread thread = Thread.currentThread();
            Utils.invokeLater(new Runnable(){

                public final void run() {
                    RuntimeErrorDialog.show("Runtime Error", null, null, thread, throwable);
                }
            });
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.showGrowBox", "true");
        Workspace.isApplet(false);
        org.nlogo.swing.Utils.detectBadJVMs();
        String path = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--events")) {
                Event.logEvents = true;
            } else {
                path = args[i];
            }
            ++i;
        }
        final String finalPath = path;
        Utils.invokeLater(new Runnable(){

            public final void run() {
                LiteApplet applet = new LiteApplet();
                final Frame frame = new Frame("NetLogo Model");
                frame.setResizable(false);
                frame.addWindowListener(new WindowAdapter(){

                    public final void windowClosing(WindowEvent e) {
                        frame.setVisible(false);
                        frame.dispose();
                        LiteApplet.main(new String[0]);
                    }
                });
                frame.setLayout(new BorderLayout());
                frame.add((Component)applet, "Center");
                applet.setup();
                frame.pack();
                applet.go(finalPath);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public void addLinkComponent(Object c) {
        this.linkComponents.add(c);
    }

    public Object[] getLinkComponents() {
        return this.linkComponents.toArray();
    }

    private final /* synthetic */ void this() {
        this.linkComponents = new ArrayList();
    }

    public LiteApplet() {
        this.this();
    }
}

