/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.agent.Dump;
import org.nlogo.awt.Utils;
import org.nlogo.command.Procedure;
import org.nlogo.compiler.Compiler;
import org.nlogo.event.AddJobEvent;
import org.nlogo.event.JobRemovedEvent;
import org.nlogo.event.PeriodicUpdateEvent;
import org.nlogo.event.RemoveJobEvent;
import org.nlogo.event.RuntimeErrorEvent;
import org.nlogo.util.Exceptions;
import org.nlogo.util.File;
import org.nlogo.window.Editable;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.JobWidget;
import org.nlogo.window.PropertyDescription;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class MonitorWidget
extends JobWidget
implements Editable,
RuntimeErrorEvent.Handler,
PeriodicUpdateEvent.Handler,
JobRemovedEvent.Handler {
    private static final int LEFT_MARGIN = 5;
    private static final int RIGHT_MARGIN = 6;
    private static final int TOP_MARGIN = 5;
    private static final int BOTTOM_MARGIN = 6;
    private static final int INSIDE_BOTTOM_MARGIN = 3;
    private static final int MIN_WIDTH = 50;
    private static final int MAX_HEIGHT = 49;
    private static final boolean WIN2K = System.getProperty("os.name").equals("Windows 2000");
    private boolean jobRunning;
    private boolean error;
    private String name;
    private List propertySet;
    private Object value;
    private String valueString;
    private int decimalPlaces;
    static /* synthetic */ Class class$org$nlogo$agent$Observer;

    public void name(String name) {
        this.name = name;
        this.chooseDisplayName();
    }

    public String name() {
        return this.name;
    }

    public String classDisplayName() {
        return "Monitor";
    }

    public Class agentClass() {
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = MonitorWidget.class("[Lorg.nlogo.agent.Observer;", false);
        }
        return clazz;
    }

    public boolean ownsPrimaryJobs() {
        return false;
    }

    public void procedure(Procedure procedure) {
        super.procedure(procedure);
        this.setForeground(procedure == null ? Color.RED : null);
        this.halt();
        if (procedure != null) {
            this.error = false;
            new AddJobEvent(this, this).raise();
            this.jobRunning = true;
        }
        this.repaint();
    }

    public List propertySet() {
        return this.propertySet;
    }

    public void propertySet(List propertySet) {
        this.propertySet = propertySet;
    }

    public Object value() {
        return this.value;
    }

    public void value(Object value) {
        this.value = value;
        String newString = Dump.logoObject(value);
        if (!newString.equals(this.valueString)) {
            this.valueString = newString;
            this.repaint();
        }
    }

    private final void addProperties() {
        this.propertySet(new ArrayList());
        this.propertySet().add(new PropertyDescription("wrapSource", "Reporter", "Reporter", 0, true));
        this.propertySet().add(new PropertyDescription("name", "Display name", "String", 0, false));
        this.propertySet().add(new PropertyDescription("decimalPlaces", "Decimal places", "Integer", -1, false));
    }

    private final void chooseDisplayName() {
        if (this.name() == null || this.name().equals("")) {
            this.displayName(this.getSourceName());
        } else {
            this.displayName(this.name());
        }
    }

    private final String getSourceName() {
        return this.innerSource.trim().replaceAll("\\s+", " ");
    }

    public void removeNotify() {
        try {
            if (!Workspace.isApplet()) {
                this.halt();
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
        super.removeNotify();
    }

    public void suppressRecompiles(boolean suppressRecompiles) {
        if (this.innerSource().trim().equals("")) {
            this.recompilePending = false;
        }
        super.suppressRecompiles(suppressRecompiles);
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, 49);
    }

    public Dimension getMaximumSize() {
        return new Dimension(10000, 49);
    }

    public Dimension getPreferredSize(Font font) {
        Dimension size = this.getMinimumSize();
        int pad = 12;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        size.width = StrictMath.max(size.width, fontMetrics.stringWidth(this.displayName()) + pad);
        size.height = StrictMath.max(size.height, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + pad);
        return size;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fm = g.getFontMetrics();
        int labelHeight = fm.getMaxDescent() + fm.getMaxAscent();
        Dimension d = this.getSize();
        g.setColor(this.getForeground());
        String displayName = this.displayName();
        if (WIN2K) {
            g.drawString(displayName, 5, 5 + fm.getMaxAscent() - fm.getMaxDescent());
        } else {
            g.drawString(displayName, 5, 5 + fm.getMaxAscent());
        }
        g.setColor(Color.WHITE);
        int boxHeight = (int)StrictMath.ceil((double)labelHeight * 1.4);
        g.fillRect(5, d.height - 6 - boxHeight, d.width - 5 - 6 - 1, boxHeight);
        g.setColor(Color.BLACK);
        if (!this.valueString.equals("")) {
            g.drawString(this.valueString, 10, d.height - 6 - 3 - fm.getMaxDescent());
        }
    }

    public int decimalPlaces() {
        return this.decimalPlaces;
    }

    public void decimalPlaces(int decimalPlaces) {
        if (decimalPlaces != this.decimalPlaces) {
            this.decimalPlaces = decimalPlaces;
            this.wrapSource(this.innerSource());
        }
    }

    public void innerSource(String innerSource) {
        super.innerSource(innerSource);
        this.chooseDisplayName();
    }

    public void wrapSource(String innerSource) {
        if (innerSource.trim().equals("")) {
            this.source(null, "", null);
            this.halt();
        } else {
            this.source("to __monitor [] __observercode loop [ __updatemonitor __monitorprecision (", innerSource, "\n) " + this.decimalPlaces() + " ] end");
        }
        this.chooseDisplayName();
    }

    public String wrapSource() {
        return this.innerSource();
    }

    public void handleRuntimeErrorEvent(RuntimeErrorEvent e) {
        if (this == e.jobOwner()) {
            this.error = true;
            this.halt();
        }
    }

    public void handlePeriodicUpdateEvent(PeriodicUpdateEvent e) {
        if (!this.jobRunning && this.procedure() != null) {
            this.error = false;
            this.jobRunning = true;
            new AddJobEvent(this, this).raise();
        }
    }

    public void handleJobRemovedEvent(JobRemovedEvent e) {
        if (e.owner() == this) {
            this.jobRunning = false;
            this.value(this.error ? "N/A" : "");
        }
    }

    private final void halt() {
        new RemoveJobEvent(this, this).raise();
    }

    public String save() {
        StringBuffer s = new StringBuffer();
        s.append("MONITOR\n");
        s.append(this.getBoundsString());
        if (this.name() != null && !this.name().equals("")) {
            s.append(this.name() + '\n');
        } else {
            s.append("NIL\n");
        }
        if (!this.innerSource.equals("")) {
            s.append(File.stripLines(this.innerSource()) + '\n');
        } else {
            s.append("NIL\n");
        }
        s.append("" + this.decimalPlaces + '\n');
        s.append("1\n");
        return s.toString();
    }

    public Object load(String[] strings, String version) {
        String displayName = strings[5];
        String source = File.restoreLines(strings[6]);
        if (displayName.equals("NIL")) {
            this.name("");
        } else {
            this.name(displayName);
        }
        if (strings.length > 7) {
            this.decimalPlaces = Integer.parseInt(strings[7]);
        }
        if (!source.equals("NIL")) {
            this.wrapSource(Compiler.autoConvert(source, version));
        }
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1, y2 - y1);
        this.chooseDisplayName();
        return this;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.jobRunning = false;
        this.error = false;
        this.name = "";
        this.propertySet = null;
        this.value = null;
        this.valueString = "";
        this.decimalPlaces = 3;
    }

    public MonitorWidget() {
        this.this();
        this.addProperties();
        this.setBackground(InterfaceColors.MONITOR_BACKGROUND);
        this.setBorder(this.widgetBorder);
        Utils.adjustDefaultFont(this);
    }
}

