/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.nlogo.awt.Utils;
import org.nlogo.event.InterfaceGlobalEvent;
import org.nlogo.event.PeriodicUpdateEvent;
import org.nlogo.util.File;
import org.nlogo.window.Editable;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.InterfaceGlobalWidget;
import org.nlogo.window.PropertyDescription;
import org.nlogo.window.Widget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class SwitchWidget
extends Widget
implements Editable,
InterfaceGlobalWidget,
InterfaceGlobalEvent.Raiser,
PeriodicUpdateEvent.Handler {
    private static final int BORDERX = 3;
    private static final int BORDERY = 3;
    private static final int MINWIDTH = 90;
    public static final int CHANNEL_WIDTH = 15;
    public static final int CHANNEL_HEIGHT = 28;
    private static final int MINHEIGHT = 33;
    private final Channel channel;
    private final Dragger dragger;
    private final List propertySet;
    private boolean on;
    private String name;

    public String classDisplayName() {
        return "Switch";
    }

    public List propertySet() {
        return this.propertySet;
    }

    public Dimension getPreferredSize(Font font) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int height = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 6;
        int width = 18 + this.channel.getWidth() + fontMetrics.stringWidth(this.displayName()) + fontMetrics.stringWidth("Off");
        return new Dimension(StrictMath.max(90, width), StrictMath.max(33, height));
    }

    public Dimension getMinimumSize() {
        return new Dimension(90, 33);
    }

    public Dimension getMaximumSize() {
        return new Dimension(10000, 33);
    }

    public void doLayout() {
        super.doLayout();
        float scaleFactor = (float)this.getHeight() / 33.0f;
        this.channel.setSize((int)(15.0f * scaleFactor), (int)(28.0f * scaleFactor));
        this.channel.setLocation(3, (this.getHeight() - this.channel.getHeight()) / 2);
        this.dragger.setSize((int)((double)this.channel.getWidth() * 0.9), (int)((double)this.channel.getHeight() * 0.35));
        this.dragger.setLocation(3 + (this.channel.getWidth() - this.dragger.getWidth()) / 2, this.channel.getY() + (this.isOn() ? (int)(0.1 * (double)this.channel.getHeight()) : this.channel.getHeight() - this.dragger.getHeight() - (int)(0.1 * (double)this.channel.getHeight())));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fontMetrics = g.getFontMetrics();
        int stringAscent = fontMetrics.getMaxAscent();
        Rectangle controlRect = this.channel.getBounds();
        g.setColor(this.getForeground());
        g.drawString("On", controlRect.width + 3, (this.getHeight() - 2 * stringAscent - 6) / 2 + stringAscent + 1);
        g.drawString("Off", controlRect.width + 3, (this.getHeight() - 2 * stringAscent - 6) / 2 + 2 * stringAscent + 1);
        int controlLabelWidth = StrictMath.max(fontMetrics.stringWidth("On"), fontMetrics.stringWidth("Off")) + controlRect.width + 6;
        g.setColor(this.getForeground());
        g.drawString(Utils.shortenStringToFit(this.displayName(), this.getWidth() - 9 - controlLabelWidth, fontMetrics), controlLabelWidth + 6, (this.getHeight() - fontMetrics.getHeight() - 6) / 2 + stringAscent + 1);
    }

    public boolean isOn() {
        return this.on;
    }

    public void isOn(boolean on) {
        if (this.on == on) {
            return;
        }
        this.on = on;
        new InterfaceGlobalEvent(this, this, false, false).raise();
        this.doLayout();
    }

    public Object valueObject() {
        return this.isOn() ? Boolean.TRUE : Boolean.FALSE;
    }

    public void valueObject(Object value) {
        if (value instanceof Boolean) {
            this.isOn((Boolean)value);
        }
    }

    public String name() {
        return this.name;
    }

    public void name(String name, boolean sendEvent) {
        this.name = name;
        this.displayName(name);
        this.repaint();
        if (sendEvent) {
            new InterfaceGlobalEvent(this, this, true, true).raise();
        }
    }

    public String nameWrapper() {
        return this.name();
    }

    public void nameWrapper(String name) {
        this.name(name, false);
    }

    public void editFinished() {
        super.editFinished();
        this.name(this.name(), true);
    }

    public void handlePeriodicUpdateEvent(PeriodicUpdateEvent e) {
        new InterfaceGlobalEvent(this, this, false, true).raise();
    }

    public String save() {
        StringBuffer s = new StringBuffer();
        s.append("SWITCH\n");
        s.append(this.getBoundsString());
        if (this.displayName() != null && !this.displayName().equals("")) {
            s.append(this.displayName() + '\n');
        } else {
            s.append("NIL\n");
        }
        if (this.name() != null && !this.name().equals("")) {
            s.append(this.name() + '\n');
        } else {
            s.append("NIL\n");
        }
        if (this.isOn()) {
            s.append("0\n");
        } else {
            s.append("1\n");
        }
        s.append("1\n");
        s.append("-1000\n");
        return s.toString();
    }

    public Object load(String[] strings, String version) {
        this.name(File.restoreLines(strings[6]), true);
        boolean bl = false;
        if (Double.valueOf(strings[7]) == 0.0) {
            bl = true;
        }
        this.isOn(bl);
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1, y2 - y1);
        return this;
    }

    private final /* synthetic */ void this() {
        this.channel = new Channel();
        this.dragger = new Dragger();
        this.propertySet = new ArrayList();
        this.on = false;
        this.name = "";
    }

    public SwitchWidget() {
        this.this();
        this.propertySet().add(new PropertyDescription("nameWrapper", "Global variable", "VariableName", 0, true));
        this.setBackground(InterfaceColors.SWITCH_BACKGROUND);
        this.setBorder(this.widgetBorder);
        this.setOpaque(true);
        Utils.adjustDefaultFont(this);
        this.add(this.dragger);
        this.add(this.channel);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class Channel
    extends JComponent {
        public void paintComponent(Graphics g) {
            int x = (int)((double)this.getWidth() * 0.2);
            int y = (int)((double)this.getHeight() * 0.1);
            int width = (int)((double)this.getWidth() * 0.6);
            int height = (int)((double)this.getHeight() * 0.8);
            g.setColor(this.getBackground());
            g.fillRect(x, y, width, height);
            org.nlogo.swing.Utils.createWidgetBorder().paintBorder(this, g, x, y, width, height);
        }

        Channel() {
            this.setOpaque(false);
            this.setBackground(Utils.mixColors(InterfaceColors.SWITCH_BACKGROUND, Color.BLACK, 0.5));
            this.addMouseListener(new MouseAdapter(){

                public final void mousePressed(MouseEvent e) {
                    if (Utils.button1Mask(e)) {
                        SwitchWidget.this.isOn(SwitchWidget.this.isOn() ^ true);
                    }
                }
            });
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class Dragger
    extends JPanel {
        Dragger() {
            this.setBackground(InterfaceColors.SWITCH_HANDLE);
            this.setBorder(org.nlogo.swing.Utils.createWidgetBorder());
            this.addMouseListener(new MouseAdapter(){

                public final void mousePressed(MouseEvent e) {
                    SwitchWidget.this.isOn(SwitchWidget.this.isOn() ^ true);
                }
            });
        }
    }
}

