/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.awt.Utils;
import org.nlogo.util.File;
import org.nlogo.window.Editable;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.PropertyDescription;
import org.nlogo.window.Widget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class TextBoxWidget
extends Widget
implements Editable {
    private static final int MIN_WIDTH = 15;
    private static final int DEFAULT_WIDTH = 150;
    private static final int MIN_HEIGHT = 18;
    private int width;
    private String text;
    private List propertySet;

    public String text() {
        return this.text;
    }

    public void text(String text) {
        this.text = text;
        this.repaint();
    }

    public String classDisplayName() {
        return "Text Box";
    }

    public List propertySet() {
        return this.propertySet;
    }

    public void propertySet(List propertySet) {
        this.propertySet = propertySet;
    }

    public void setBounds(Rectangle r) {
        if (r.width > 0) {
            this.width = r.width;
        }
        super.setBounds(r);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (width > 0) {
            this.width = width;
        }
        super.setBounds(x, y, width, height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(15, 18);
    }

    public Dimension getPreferredSize(Font font) {
        FontMetrics metrics = this.getFontMetrics(font);
        int height = Utils.breakLines(this.text(), metrics, this.width).size() * (metrics.getMaxDescent() + metrics.getMaxAscent());
        return new Dimension(StrictMath.max(15, this.width), StrictMath.max(18, height));
    }

    public boolean needsPreferredWidthFudgeFactor() {
        return false;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics metrics = g.getFontMetrics();
        int stringHeight = metrics.getMaxDescent() + metrics.getMaxAscent();
        int stringAscent = metrics.getMaxAscent();
        List lines = Utils.breakLines(this.text(), metrics, this.width);
        int i = 0;
        while (i < lines.size()) {
            String line = (String)lines.get(i);
            g.drawString(line, 0, i * stringHeight + stringAscent);
            ++i;
        }
    }

    public String save() {
        StringBuffer s = new StringBuffer();
        s.append("TEXTBOX\n");
        s.append(this.getBoundsString());
        s.append(File.stripLines(this.text()) + '\n');
        return s.toString();
    }

    public Object load(String[] strings, String version) {
        this.text(File.restoreLines(strings[5]));
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1, y2 - y1);
        return this;
    }

    private final /* synthetic */ void this() {
        this.width = 150;
        this.text = "";
        this.propertySet = null;
    }

    public TextBoxWidget() {
        this.this();
        this.setBackground(InterfaceColors.TEXT_BOX_BACKGROUND);
        this.propertySet(new ArrayList());
        this.propertySet().add(new PropertyDescription("text", "Text", "BigString", 0, true));
        Utils.adjustDefaultFont(this);
    }
}

