/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import org.nlogo.agent.World;
import org.nlogo.awt.Utils;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.LogoException;
import org.nlogo.workspace.Workspace;

public strictfp class ThreadUtils {
    private static final CommandRunnable DO_NOTHING = new CommandRunnable(){

        public final void run() throws LogoException {
        }
    };

    public static void waitForQueuedEvents(Workspace workspace) throws LogoException {
        ThreadUtils.waitFor(workspace, DO_NOTHING);
    }

    public static void waitFor(Workspace workspace, final CommandRunnable runnable) throws LogoException {
        ThreadUtils.waitForResult(workspace, new ReporterRunnable(){

            public final Object run() throws LogoException {
                runnable.run();
                return Boolean.TRUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object waitForResult(final Workspace workspace, final ReporterRunnable runnable) throws LogoException {
        if (workspace.headless()) {
            return runnable.run();
        }
        Object notDoneYet = new Object();
        final Object[] result = new Object[]{notDoneYet};
        try {
            Utils.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void run() {
                    try {
                        result[0] = runnable.run();
                        World world = workspace.world;
                        synchronized (world) {
                            workspace.world.notifyAll();
                            return;
                        }
                    }
                    catch (LogoException ex) {
                        result[0] = ex;
                        return;
                    }
                    catch (RuntimeException ex) {
                        result[0] = ex;
                    }
                }
            });
            while (true) {
                if (result[0] != notDoneYet) {
                    if (!(result[0] instanceof LogoException)) break;
                    throw (LogoException)result[0];
                }
                World world = workspace.world;
                synchronized (world) {
                    workspace.world.wait(50L);
                }
            }
            if (result[0] instanceof RuntimeException) {
                throw (RuntimeException)result[0];
            }
            return result[0];
        }
        catch (InterruptedException ex) {
            throw new HaltException(false);
        }
    }

    private ThreadUtils() {
        throw new IllegalStateException();
    }

    public static interface ReporterRunnable {
        public Object run() throws LogoException;
    }

    public static interface CommandRunnable {
        public void run() throws LogoException;
    }
}

