/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window.graphing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.nlogo.awt.Utils;
import org.nlogo.window.graphing.GraphPoint;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class GraphPen
extends JComponent {
    public static final int LINE_MODE = 0;
    public static final int BAR_MODE = 1;
    public static final int POINT_MODE = 2;
    public static final int LAST_PLOT_PEN_MODE = 2;
    public static final int NUM_PLOT_PEN_MODES = 3;
    private static final String[] PLOT_PEN_MODE_NAMES = new String[]{"Line", "Bar", "Point"};
    private GraphPoint currentPenState;
    private List points;
    private String displayName;
    private boolean penDown;
    private double plotInterval;
    private GraphPoint edgePoint1;
    private GraphPoint edgePoint2;
    private int plotPenMode;
    private boolean penModeChanged;
    private boolean histogramming;
    private boolean showInPensLegend;
    private boolean temporary;

    public Object clone() {
        Utils.mustBeEventDispatchThread();
        return this.clone(false);
    }

    public Object clone(boolean keepPoints) {
        Utils.mustBeEventDispatchThread();
        GraphPen clonedPen = new GraphPen();
        clonedPen.currentPenState(new GraphPoint(this.currentPenState));
        clonedPen.displayName(this.displayName);
        clonedPen.penDown(this.penDown);
        clonedPen.temporary(this.temporary);
        clonedPen.plotInterval(this.plotInterval);
        clonedPen.plotPenMode(this.plotPenMode);
        clonedPen.penModeChanged(this.penModeChanged);
        clonedPen.showInPensLegend(this.showInPensLegend);
        if (keepPoints) {
            clonedPen.points(this.points);
            clonedPen.edgePoint1(this.edgePoint1);
            clonedPen.edgePoint2(this.edgePoint2);
        }
        return clonedPen;
    }

    private final GraphPoint currentPenState() {
        return this.currentPenState;
    }

    private final void currentPenState(GraphPoint currentPenState) {
        this.currentPenState = currentPenState;
    }

    public double xcor() {
        Utils.mustBeEventDispatchThread();
        return this.currentPenState().xcor();
    }

    public double ycor() {
        Utils.mustBeEventDispatchThread();
        return this.currentPenState().ycor();
    }

    List points() {
        return this.points;
    }

    private final void points(List points) {
        this.points = points;
    }

    public void displayName(String displayName) {
        Utils.mustBeEventDispatchThread();
        this.displayName = displayName;
    }

    public String displayName() {
        Utils.mustBeEventDispatchThread();
        return this.displayName;
    }

    void penDown(boolean penDown) {
        if (this.penDown != penDown) {
            this.penDown = penDown;
            if (penDown) {
                this.plot(this.currentPenState.xcor(), this.currentPenState.ycor());
            } else if (this.points.size() > 0) {
                ((GraphPoint)this.points.get(this.points.size() - 1)).penDown(penDown);
            }
        }
    }

    public boolean penDown() {
        Utils.mustBeEventDispatchThread();
        return this.penDown;
    }

    void penDownWOPlotting(boolean penDown) {
        this.penDown = penDown;
    }

    public void plotInterval(double plotInterval) {
        Utils.mustBeEventDispatchThread();
        this.plotInterval = plotInterval;
    }

    public double plotInterval() {
        Utils.mustBeEventDispatchThread();
        return this.plotInterval;
    }

    private final void edgePoint1(GraphPoint edgePoint1) {
        this.edgePoint1 = edgePoint1;
    }

    GraphPoint edgePoint1() {
        return this.edgePoint1;
    }

    private final void edgePoint2(GraphPoint edgePoint2) {
        this.edgePoint2 = edgePoint2;
    }

    GraphPoint edgePoint2() {
        return this.edgePoint2;
    }

    public static List getPlotPenModeNames() {
        return Arrays.asList(PLOT_PEN_MODE_NAMES);
    }

    public void plotPenMode(int plotPenMode) {
        Utils.mustBeEventDispatchThread();
        if (this.plotPenMode != plotPenMode) {
            this.penModeChanged(true);
            this.plotPenMode = plotPenMode;
        }
    }

    public int plotPenMode() {
        Utils.mustBeEventDispatchThread();
        return this.plotPenMode;
    }

    boolean validPlotPenMode(int plotPenMode) {
        return plotPenMode <= 2 && plotPenMode >= 0;
    }

    void penModeChanged(boolean penModeChanged) {
        this.penModeChanged = penModeChanged;
    }

    boolean penModeChanged() {
        return this.penModeChanged;
    }

    void histogramming(boolean histogramming) {
        this.histogramming = histogramming;
    }

    boolean histogramming() {
        return this.histogramming;
    }

    public void showInPensLegend(boolean showInPensLegend) {
        Utils.mustBeEventDispatchThread();
        this.showInPensLegend = showInPensLegend;
    }

    public boolean showInPensLegend() {
        Utils.mustBeEventDispatchThread();
        return this.showInPensLegend;
    }

    public void color(Color c) {
        Utils.mustBeEventDispatchThread();
        this.currentPenState.color(c);
    }

    public Color color() {
        Utils.mustBeEventDispatchThread();
        return this.currentPenState.color();
    }

    void temporary(boolean temporary) {
        this.temporary = temporary;
    }

    boolean temporary() {
        return this.temporary;
    }

    void reset(boolean resetPoints, GraphPen resetPen) {
        this.currentPenState(new GraphPoint());
        this.plotPenMode(resetPen.plotPenMode());
        this.color(resetPen.color());
        this.penDownWOPlotting(true);
        this.plotInterval(resetPen.plotInterval());
        if (resetPoints) {
            this.points(new ArrayList());
        }
        this.edgePoint1(new GraphPoint());
        this.edgePoint2(new GraphPoint());
    }

    void reset(boolean resetPoints) {
        Color oldColor = this.currentPenState.color();
        this.currentPenState(new GraphPoint());
        this.currentPenState().color(oldColor);
        this.penDownWOPlotting(true);
        if (resetPoints) {
            this.points(new ArrayList());
        }
        this.edgePoint1(new GraphPoint());
        this.edgePoint2(new GraphPoint());
    }

    void plot(double v) {
        if (this.points().size() > 0) {
            this.currentPenState().xcor(this.currentPenState().xcor() + this.plotInterval());
        }
        this.plot(this.currentPenState().xcor(), v);
    }

    void plot(double x, double y) {
        this.currentPenState().xcor(x);
        this.currentPenState().ycor(y);
        this.currentPenState().penDown(this.penDown());
        if (this.penDown()) {
            GraphPoint secondLastPoint;
            this.points().add(new GraphPoint(this.currentPenState()));
            GraphPoint lastPoint = (GraphPoint)this.points().get(this.points().size() - 1);
            if (lastPoint.penDown()) {
                this.edgePoint2(lastPoint);
            }
            if (this.points().size() >= 2 && (secondLastPoint = (GraphPoint)this.points().get(this.points().size() - 2)).penDown()) {
                this.edgePoint1(secondLastPoint);
            }
        }
    }

    public void paintComponent(Graphics g) {
        int ascent = g.getFontMetrics().getMaxAscent();
        g.setColor(this.getForeground());
        g.setColor(this.color());
        g.fillRect(0, 0, ascent, ascent);
        g.setColor(this.getForeground());
        g.drawRect(0, 0, ascent, ascent);
        g.drawString(this.displayName(), ascent + 4, ascent);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        return new Dimension(metrics.stringWidth(this.displayName()) + metrics.getMaxAscent() + 4, StrictMath.max(8, metrics.getMaxDescent() + metrics.getMaxAscent()));
    }

    public String toString() {
        return (this.temporary ? "Temporary " : "Default ") + (this.showInPensLegend ? "" : "Not-") + "Displayed GraphPen:" + this.displayName + (this.penDown ? " ppd " : " ppu ") + " in mode " + this.plotPenMode + " with color " + this.color() + " and plotInterval " + this.plotInterval;
    }

    private final /* synthetic */ void this() {
        this.currentPenState = new GraphPoint();
        this.points = new ArrayList();
        this.displayName = null;
        this.penDown = true;
        this.plotInterval = 1.0;
        this.edgePoint1 = new GraphPoint();
        this.edgePoint2 = new GraphPoint();
        this.plotPenMode = 0;
        this.penModeChanged = false;
        this.histogramming = false;
        this.showInPensLegend = true;
        this.temporary = false;
    }

    public GraphPen() {
        this.this();
        Utils.mustBeEventDispatchThread();
        Utils.adjustDefaultFont(this);
        this.setOpaque(false);
    }
}

