/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.nlogo.api.ClassManager;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.Primitive;
import org.nlogo.api.Reporter;
import org.nlogo.compiler.CompilerException;
import org.nlogo.compiler.ErrorSource;
import org.nlogo.util.Exceptions;
import org.nlogo.util.RemoteFile;
import org.nlogo.util.Version;
import org.nlogo.workspace.ExtensionPrimitiveManager;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class ExtensionManager
implements org.nlogo.compiler.ExtensionManager {
    private final Map jars;
    private Workspace workspace;
    private int jarsLoaded;

    public boolean anyExtensionsLoaded() {
        boolean bl = false;
        if (this.jarsLoaded > 0) {
            bl = true;
        }
        return bl;
    }

    public void importExtension(String jarPath, ErrorSource errors) throws CompilerException {
        try {
            jarPath = this.resolvePath(jarPath);
        }
        catch (RuntimeException ex) {
            errors.signalError("Can't find extension: " + jarPath + " error: " + ex);
            return;
        }
        try {
            URLClassLoader myClassLoader = this.getClassLoader(jarPath, errors);
            if (myClassLoader == null) {
                return;
            }
            ClassManager classManager = this.getClassManager(jarPath, myClassLoader, errors);
            if (classManager == null) {
                return;
            }
            JarContainer theJarContainer = (JarContainer)this.jars.get(jarPath);
            long modified = this.getModified(jarPath, errors);
            if (theJarContainer == null || theJarContainer.modified != modified) {
                if (theJarContainer != null) {
                    theJarContainer.classManager.unload();
                }
                theJarContainer = new JarContainer(jarPath, myClassLoader, modified);
                this.jars.put(jarPath, theJarContainer);
                classManager.runOnce();
            }
            if (!theJarContainer.loaded) {
                ++this.jarsLoaded;
                theJarContainer.loaded = true;
                theJarContainer.classManager = classManager;
                theJarContainer.primManager = new ExtensionPrimitiveManager();
                theJarContainer.primManager.addConfigurable(this.workspace.getHubNetManager());
                classManager.load(theJarContainer.primManager);
            }
            theJarContainer.reloaded = true;
            theJarContainer.prefix = this.getExtensionName(jarPath, errors);
        }
        catch (ExtensionException ex) {
            errors.signalError("Bad extension: Error during initialization: " + ex);
        }
        catch (IncompatibleClassChangeError ex) {
            errors.signalError("The extension does not work with this version of NetLogo");
        }
    }

    public String resolvePath(String path) {
        if (Workspace.isApplet()) {
            String jarPath = this.workspace.fileManager.attachPrefix(path);
            if (RemoteFile.exists(jarPath)) {
                return jarPath;
            }
            throw new RuntimeException("Can't find extension: " + path + " using URL: " + jarPath);
        }
        try {
            URL jarURL = new URL(path);
            return jarURL.toString();
        }
        catch (MalformedURLException ex) {
            File jarFile;
            Exceptions.ignore(ex);
            if (path.indexOf("/") > -1) {
                try {
                    jarFile = new File(this.workspace.attachModelDir(path));
                    if (jarFile.exists()) {
                        return jarFile.toURL().toString();
                    }
                }
                catch (MalformedURLException ex2) {
                    Exceptions.handle(ex2);
                }
            }
            try {
                jarFile = new File(this.workspace.attachModelDir(path));
                if (jarFile.exists()) {
                    return jarFile.toURL().toString();
                }
            }
            catch (MalformedURLException ex3) {
                Exceptions.ignore(ex3);
            }
            try {
                jarFile = new File("extensions" + File.separator + path);
                if (jarFile.exists()) {
                    return jarFile.toURL().toString();
                }
            }
            catch (MalformedURLException ex4) {
                Exceptions.ignore(ex4);
            }
            throw new RuntimeException("Can't find extension: " + path);
        }
    }

    private final URLClassLoader getClassLoader(String jarPath, ErrorSource errors) throws CompilerException {
        JarContainer theJarContainer = (JarContainer)this.jars.get(jarPath);
        if (theJarContainer != null) {
            return theJarContainer.jarClassLoader;
        }
        try {
            URL jarURL = new URL(jarPath);
            List urls = this.getAdditionalJars();
            urls.add(jarURL);
            return new URLClassLoader(urls.toArray(new URL[0]));
        }
        catch (MalformedURLException ex) {
            errors.signalError("Invalid URL syntax");
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
        return null;
    }

    private final ClassManager getClassManager(String jarPath, URLClassLoader myClassLoader, ErrorSource errors) throws CompilerException {
        JarContainer theJarContainer = (JarContainer)this.jars.get(jarPath);
        if (theJarContainer != null && theJarContainer.loaded) {
            return theJarContainer.classManager;
        }
        String classMangName = null;
        try {
            classMangName = this.getClassManagerName(jarPath, errors);
            if (classMangName == null) {
                errors.signalError("Bad extension: Couldn't locate Class-Manager tag in Manifest File");
            }
            Object classMang = myClassLoader.loadClass(classMangName).newInstance();
            try {
                return (ClassManager)classMang;
            }
            catch (ClassCastException ex) {
                errors.signalError("Bad extension: The Class-Manager needs to implement org.nlogo.api.ClassManager");
            }
        }
        catch (FileNotFoundException ex) {
            errors.signalError("Cannot find JAR " + jarPath);
        }
        catch (IOException ex) {
            errors.signalError("Cannot open JAR " + jarPath);
        }
        catch (InstantiationException ex) {
            Exceptions.handle(ex);
        }
        catch (IllegalAccessException ex) {
            Exceptions.handle(ex);
        }
        catch (ClassNotFoundException ex) {
            errors.signalError("Could not find class " + classMangName + " in JAR");
        }
        return null;
    }

    private final String getClassManagerName(String jarPath, ErrorSource errors) throws IOException, CompilerException {
        URL jarURL = new URL("jar", "", jarPath + "!/");
        JarURLConnection jarConnection = (JarURLConnection)jarURL.openConnection();
        String name = null;
        if (jarConnection.getManifest() == null) {
            errors.signalError("Could not find a Manifest file in JAR");
        }
        Attributes attr = jarConnection.getManifest().getMainAttributes();
        name = attr.getValue("Class-Manager");
        if (!this.checkVersion(attr)) {
            errors.signalError("User halted compilation.");
        }
        return name;
    }

    private final String getExtensionName(String jarPath, ErrorSource errors) throws CompilerException {
        try {
            Attributes attr;
            URL jarURL = new URL("jar", "", jarPath + "!/");
            JarURLConnection jarConnection = (JarURLConnection)jarURL.openConnection();
            String name = null;
            if (jarConnection.getManifest() == null) {
                errors.signalError("Could not find a Manifest file in JAR");
            }
            if ((name = (attr = jarConnection.getManifest().getMainAttributes()).getValue("Extension-Name")) == null) {
                errors.signalError("Bad extension: Could not find extension name in Manifest.");
            }
            return name;
        }
        catch (FileNotFoundException ex) {
            errors.signalError("Cannot find JAR " + jarPath);
        }
        catch (IOException ex) {
            errors.signalError("Cannot open JAR " + jarPath);
        }
        return null;
    }

    public Primitive replaceIdentifier(String name) {
        Primitive prim = null;
        JarContainer theJarContainer = null;
        Iterator values = this.jars.values().iterator();
        while (values.hasNext() && prim == null) {
            theJarContainer = (JarContainer)values.next();
            if (!theJarContainer.loaded || name == null) continue;
            prim = theJarContainer.primManager.getPrimitive(name);
        }
        return prim;
    }

    public String[] listExtensions() {
        ArrayList<String> extensionNames = new ArrayList<String>();
        Iterator values = this.jars.values().iterator();
        while (values.hasNext()) {
            JarContainer theJarContainer = (JarContainer)values.next();
            extensionNames.add(theJarContainer.jarName);
        }
        return (String[])extensionNames.toArray();
    }

    public String dumpExtensions() {
        String str = "EXTENSION\tLOADED\tMODIFIED\tJARPATH\n";
        str = str + "---------\t------\t---------\t---\n";
        JarContainer theJarContainer = null;
        Iterator values = this.jars.values().iterator();
        while (values.hasNext()) {
            theJarContainer = (JarContainer)values.next();
            str = str + theJarContainer.prefix + '\t' + theJarContainer.loaded + '\t' + theJarContainer.modified + '\t' + theJarContainer.jarName + '\n';
        }
        return str;
    }

    public String dumpExtensionPrimitives() {
        String pstr = "\n\nEXTENSION\tPRIMITIVE\tTYPE\n";
        pstr = pstr + "----------\t---------\t----\n";
        JarContainer theJarContainer = null;
        Iterator values = this.jars.values().iterator();
        while (values.hasNext()) {
            theJarContainer = (JarContainer)values.next();
            Iterator k = theJarContainer.primManager.getPrimitiveNames();
            while (k.hasNext()) {
                String name = (String)k.next();
                Primitive p = theJarContainer.primManager.getPrimitive(name);
                String type = p instanceof Reporter ? "Reporter" : "Command";
                pstr = pstr + theJarContainer.prefix + '\t' + name + '\t' + type + '\n';
            }
        }
        return pstr;
    }

    public void reset() {
        this.jars.clear();
        this.jarsLoaded = 0;
    }

    List getAdditionalJars() {
        ArrayList<URL> urls = new ArrayList<URL>();
        File folder = new File("extensions");
        if (folder.exists() && folder.isDirectory()) {
            File[] files = folder.listFiles();
            int n = 0;
            while (n < files.length) {
                if (files[n].isFile() && files[n].getName().toUpperCase().endsWith(".JAR")) {
                    try {
                        urls.add(files[n].toURL());
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.handle(ex);
                    }
                }
                ++n;
            }
        }
        return urls;
    }

    public void cleanUp() {
        Iterator values = this.jars.values().iterator();
        while (values.hasNext()) {
            try {
                JarContainer nextJarContainer = (JarContainer)values.next();
                if (nextJarContainer.loaded && !nextJarContainer.reloaded) {
                    --this.jarsLoaded;
                    this.jars.remove(nextJarContainer.prefix);
                    nextJarContainer.loaded = false;
                    nextJarContainer.classManager.unload();
                }
                nextJarContainer.reloaded = false;
            }
            catch (ExtensionException ex) {
                System.err.println("Error unloading extension: " + ex);
            }
        }
    }

    private final boolean checkVersion(Attributes attr) {
        String currentVer = Version.versionNumberOnlyNoRev();
        String jarVer = attr.getValue("NetLogo-Version");
        if (jarVer == null) {
            return this.workspace.warningMessage("Could not determine version of NetLogo extension.  NetLogo can try to load the extension, but it may or may not work.");
        }
        if (!currentVer.equals(jarVer)) {
            return this.workspace.warningMessage("You are attempting to open a NetLogo extension file that was created using for a different version of NetLogo.  (This is NetLogo " + currentVer + "; the extension uses NetLogo " + jarVer + ".)  NetLogo can try to load the extension file, but it may or may not work.");
        }
        return true;
    }

    private final long getModified(String jarPath, ErrorSource errors) throws CompilerException {
        try {
            URL jarURL = new URL(jarPath);
            URLConnection jarConnect = jarURL.openConnection();
            return jarConnect.getLastModified();
        }
        catch (IOException ex) {
            errors.signalError("Cannot open JAR file");
            throw new IllegalStateException("this code is unreachable");
        }
    }

    private final /* synthetic */ void this() {
        this.jars = new HashMap();
        this.jarsLoaded = 0;
    }

    public ExtensionManager(Workspace workspace) {
        this.this();
        this.workspace = workspace;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class JarContainer {
        public final String jarName;
        public URLClassLoader jarClassLoader;
        public final long modified;
        public ExtensionPrimitiveManager primManager;
        public ClassManager classManager;
        public boolean loaded;
        public boolean reloaded;
        public String prefix;

        JarContainer(String jarName, URLClassLoader jarClassLoader, long modified) throws CompilerException {
            this.jarName = jarName;
            this.jarClassLoader = jarClassLoader;
            this.loaded = false;
            this.reloaded = false;
            this.prefix = null;
            this.modified = modified;
        }
    }
}

