/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.World;
import org.nlogo.compiler.Compiler;
import org.nlogo.compiler.CompilerException;
import org.nlogo.nvm.LogoException;
import org.nlogo.util.Exceptions;
import org.nlogo.util.LocalFile;
import org.nlogo.util.OutputObject;
import org.nlogo.util.RemoteFile;
import org.nlogo.util.Utils;
import org.nlogo.window.Applet;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp final class FileManager {
    private List openFiles;
    private org.nlogo.util.File currentFile;
    private String prefix;
    private Workspace workspace;

    public final String getErrorInfo() throws LogoException, IOException {
        long position = this.currentFile.pos;
        this.currentFile.close(true);
        this.currentFile.open(1);
        int lineNumber = 1;
        long prevPosition = 0L;
        String lastLine = this.readLine();
        while (this.currentFile.pos < position) {
            ++lineNumber;
            prevPosition = this.currentFile.pos;
            lastLine = this.readLine();
        }
        int charPos = (int)(position - prevPosition);
        if (charPos >= lastLine.length() && !this.eof()) {
            lastLine = this.readLine();
            charPos = 0;
            ++lineNumber;
        }
        this.closeCurrentFile();
        return "\nLine Number: " + lineNumber + "\nCharacter: " + (charPos + 1);
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(String newPrefix) {
        if (newPrefix.charAt(newPrefix.length() - 1) != File.separatorChar) {
            newPrefix = newPrefix + File.separatorChar;
        }
        if (new File(newPrefix).isAbsolute()) {
            this.prefix = newPrefix;
        } else {
            this.prefix = this.relativePath(newPrefix);
            if (this.prefix.charAt(this.prefix.length() - 1) != File.separatorChar) {
                this.prefix = this.prefix + File.separatorChar;
            }
        }
    }

    public final String attachPrefix(String filename) {
        if (Workspace.isApplet() && Applet.applet != null) {
            try {
                return new URL(Applet.applet.getCodeBase(), filename).toString();
            }
            catch (MalformedURLException ex) {
                return filename;
            }
        }
        File fileForm = new File(filename);
        if (fileForm.isAbsolute() || this.prefix == null) {
            return filename;
        }
        return this.relativePath(filename);
    }

    private final String relativePath(String newPath) {
        try {
            URL urlForm = new URL(new File(this.prefix + "dummy").toURL(), newPath);
            return new File(urlForm.getFile()).getAbsolutePath();
        }
        catch (MalformedURLException ex) {
            Exceptions.handle(ex);
            return null;
        }
    }

    public final boolean hasCurrentFile() {
        boolean bl = false;
        if (this.currentFile != null && this.isFileOpen(this.currentFile.getAbsolutePath())) {
            bl = true;
        }
        return bl;
    }

    private final boolean isFileOpen(String fileName) {
        boolean bl = false;
        if (this.findOpenFile(fileName) != null) {
            bl = true;
        }
        return bl;
    }

    private final org.nlogo.util.File findOpenFile(String fileName) {
        if (Workspace.isApplet()) {
            Iterator files = this.openFiles.iterator();
            while (files.hasNext()) {
                org.nlogo.util.File nextFile = (org.nlogo.util.File)files.next();
                if (!fileName.equals(nextFile.getPath())) continue;
                return nextFile;
            }
        } else {
            File newFile = new File(fileName);
            Iterator files = this.openFiles.iterator();
            while (files.hasNext()) {
                org.nlogo.util.File nextFile = (org.nlogo.util.File)files.next();
                if (!newFile.getAbsolutePath().equals(nextFile.getAbsolutePath())) continue;
                return nextFile;
            }
        }
        return null;
    }

    private final boolean isFileCurrent(org.nlogo.util.File checkFile) {
        boolean bl = false;
        if (this.currentFile == checkFile) {
            bl = true;
        }
        return bl;
    }

    public final void setCurrentFile(org.nlogo.util.File newFile) {
        if (!this.isFileCurrent(newFile)) {
            this.currentFile = newFile;
        }
    }

    public final void ensureMode(int openMode) throws LogoException {
        if (!this.hasCurrentFile()) {
            throw new LogoException("No file has been opened");
        }
        if (this.currentFile.getMode() == 0) {
            try {
                this.currentFile.open(openMode);
            }
            catch (FileNotFoundException ex) {
                throw new LogoException("The file " + this.currentFile.getAbsolutePath() + " cannot be found");
            }
            catch (IOException ex) {
                throw new LogoException(ex.getMessage());
            }
        } else if (this.currentFile.getMode() != openMode) {
            String mode = this.currentFile.getMode() == 1 ? "READING" : "WRITING";
            throw new LogoException("You can only use " + mode + " primitives with this file");
        }
    }

    public final boolean fileExists(String filePath) {
        if (Workspace.isApplet()) {
            return RemoteFile.exists(this.attachPrefix(filePath));
        }
        File checkFile = new File(filePath);
        return checkFile.exists();
    }

    public final void deleteFile(String filePath) throws LogoException {
        org.nlogo.util.File file = this.findOpenFile(filePath);
        if (file != null) {
            throw new LogoException("You need to close the file before deletion");
        }
        if (file instanceof RemoteFile) {
            throw new LogoException("You cannot delete remote files.");
        }
        File checkFile = new File(filePath);
        if (!checkFile.exists()) {
            throw new LogoException("Attempt to delete a non-existant file");
        }
        if (!checkFile.canWrite()) {
            throw new LogoException("Modification to this file is denied");
        }
        if (!checkFile.isFile()) {
            throw new LogoException("You can only delete files");
        }
        if (!checkFile.delete()) {
            throw new LogoException("Deletion failed");
        }
    }

    public final void openFile(String newFileName) {
        org.nlogo.util.File newFile = this.findOpenFile(this.attachPrefix(newFileName));
        if (newFile == null) {
            newFile = Workspace.isApplet() ? new RemoteFile(this.attachPrefix(newFileName)) : new LocalFile(this.attachPrefix(newFileName));
            this.openFiles.add(newFile);
        }
        this.setCurrentFile(newFile);
    }

    public final void closeCurrentFile() throws IOException, LogoException {
        if (!this.hasCurrentFile()) {
            this.closeAllFiles();
            throw new LogoException("There is no file to close");
        }
        this.closeFile(this.currentFile.getAbsolutePath());
        this.setCurrentFile(null);
    }

    private final void closeFile(String closeFileName) throws IOException {
        org.nlogo.util.File closeFile = this.findOpenFile(closeFileName);
        closeFile.close(true);
        this.openFiles.remove(closeFile);
    }

    public final String readLine() throws IOException, LogoException {
        if (this.eof()) {
            throw new EOFException();
        }
        BufferedReader buffReader = this.currentFile.getBufferedReader();
        String retString = "";
        char[] charbuff = new char[80];
        int charsRead = 80;
        int skip = 1;
        while (charsRead == 80) {
            buffReader.mark(82);
            charsRead = buffReader.read(charbuff, 0, 80);
            int i = 0;
            while (i < charsRead) {
                if (charbuff[i] == '\r') {
                    if (i < 79 && charbuff[i + 1] == '\n' || i == 79 && buffReader.read() == 10) {
                        skip = 2;
                    }
                    charsRead = i;
                } else if (charbuff[i] == '\n') {
                    charsRead = i;
                }
                ++i;
            }
            this.currentFile.pos += (long)charsRead;
            retString = retString + new String(charbuff, 0, charsRead);
        }
        buffReader.reset();
        this.currentFile.pos += buffReader.skip(charsRead + skip) - (long)charsRead;
        return retString;
    }

    public final String readChars(int num) throws IOException, LogoException {
        if (this.eof()) {
            throw new EOFException();
        }
        char[] charbuff = new char[num];
        BufferedReader buffReader = this.currentFile.getBufferedReader();
        this.currentFile.pos += (long)buffReader.read(charbuff, 0, num);
        return String.valueOf(charbuff);
    }

    public final String readRemainder() throws IOException, LogoException {
        if (this.eof()) {
            throw new EOFException();
        }
        String remainder = "";
        String line = this.readLine();
        while (line != null) {
            remainder = remainder + line;
            line = this.readLine();
            this.currentFile.pos += (long)line.length();
        }
        return remainder;
    }

    public final Object read(World world) throws IOException, CompilerException, LogoException {
        if (this.eof()) {
            throw new EOFException();
        }
        return Compiler.readFromFile(this.currentFile, world);
    }

    public final boolean eof() throws IOException, LogoException {
        this.ensureMode(1);
        if (!this.currentFile.eof) {
            BufferedReader buffReader = this.currentFile.getBufferedReader();
            buffReader.mark(2);
            boolean bl = false;
            if (buffReader.read() == -1) {
                bl = true;
            }
            this.currentFile.eof = bl;
            buffReader.reset();
        }
        return this.currentFile.eof;
    }

    public final void closeAllFiles() throws IOException {
        Iterator files = this.openFiles.iterator();
        while (files.hasNext()) {
            org.nlogo.util.File nextFile = (org.nlogo.util.File)files.next();
            this.closeFile(nextFile.getAbsolutePath());
            files = this.openFiles.iterator();
        }
        this.setCurrentFile(null);
    }

    public final void writeOutputObject(OutputObject oo) {
        PrintWriter w = this.currentFile.getPrintWriter();
        w.print(oo.get());
    }

    public final void handleModelChange() {
        if (this.workspace.getModelDir() != null) {
            this.setPrefix(this.workspace.getModelDir());
        } else if (Workspace.isApp()) {
            this.setPrefix(Utils.getUserDirectory());
        }
        try {
            this.closeAllFiles();
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
    }

    private final /* synthetic */ void this() {
        this.openFiles = new ArrayList(3);
    }

    public FileManager(Workspace workspace) {
        this.this();
        this.workspace = workspace;
        if (Workspace.isApp()) {
            this.setPrefix(Utils.getUserDirectory());
        }
    }
}

