/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.util.Utils;

public strictfp final class Color {
    public static final int MAX_COLOR = 140;
    public static final double BLACK = 0.0;
    public static final double GRAY = 5.0;
    public static final double WHITE = 9.9999;
    public static final double RED = 15.0;
    public static final double ORANGE = 25.0;
    public static final double BROWN = 35.0;
    public static final double YELLOW = 45.0;
    public static final double GREEN = 55.0;
    public static final double LIME = 65.0;
    public static final double TURQUOISE = 75.0;
    public static final double CYAN = 85.0;
    public static final double SKY = 95.0;
    public static final double BLUE = 105.0;
    public static final double VIOLET = 115.0;
    public static final double MAGENTA = 125.0;
    public static final double PINK = 135.0;
    public static final Double BOXED_BLACK = Utils.ZERO_DOUBLE;
    public static final Double BOXED_WHITE = new Double(9.9999);
    public static final int BASE_COLORS = 16;
    public static final int BASE_HUES = 15;
    private static final String[] SLT_COLOR_NAMES = new String[]{"gray", "red", "orange", "brown", "yellow", "green", "lime", "turquoise", "cyan", "sky", "blue", "violet", "magenta", "pink", "black", "white"};
    static final int[] SLT_COLORS_R;
    static final int[] SLT_COLORS_G;
    static final int[] SLT_COLORS_B;
    private static final int[] SLT_COLORS_HUE;

    public static final String[] getColorNamesArray() {
        return SLT_COLOR_NAMES;
    }

    public static final String getBaseColorName(int index) {
        return SLT_COLOR_NAMES[index];
    }

    public static final int modulateInteger(Integer color) {
        return Color.modulateInteger((int)color);
    }

    public static final int modulateInteger(int color) {
        if ((color < 0 || color >= 140) && (color %= 140) < 0) {
            color += 140;
        }
        return color;
    }

    public static final double modulateDouble(Double color) {
        return Color.modulateDouble((double)color);
    }

    public static final double modulateDouble(double color) {
        if ((color < 0.0 || color >= 140.0) && (color %= 140.0) < 0.0 && (color += 140.0) >= 140.0) {
            color = 139.9999999999999;
        }
        return color;
    }

    public static final double getPrimaryColor(double color) {
        if (color < 0.0 || color >= 140.0) {
            color = Color.modulateDouble(color);
        }
        return ((double)((int)(color / 10.0)) + 0.5) * 10.0;
    }

    public static final double getNetLogoColor(float h, float s, float b) {
        h = (float)StrictMath.max(0.0, StrictMath.min(1.0, (double)h));
        s = (float)StrictMath.max(0.0, StrictMath.min(1.0, (double)s));
        b = (float)StrictMath.max(0.0, StrictMath.min(1.0, (double)b));
        int closestID = 0;
        float closest = 360.0f;
        int i = 1;
        while (i < 15) {
            if (StrictMath.abs((float)SLT_COLORS_HUE[i] / 360.0f - h) < closest) {
                closest = StrictMath.abs((float)SLT_COLORS_HUE[i] / 360.0f - h);
                closestID = i;
            }
            ++i;
        }
        if (closestID == 3 && (double)b > 0.5) {
            closestID = 2;
        } else if (closestID == 6 && (double)b < 0.5) {
            closestID = 5;
        }
        double returnVal = closestID == 14 ? 15.0 : (double)((closestID + 1) * 10 - 5);
        returnVal = s == 0.0f ? (double)b * 9.9999 : (returnVal += (double)(b - s) * (double)5);
        returnVal = returnVal % 10.0 >= 9.95 ? returnVal - returnVal % 10.0 + 9.9999 : (double)StrictMath.round(returnVal * 10.0) / 10.0;
        return returnVal;
    }

    public static final int computeColor(double modulatedColor) {
        if (modulatedColor == 0.0) {
            return -16777216;
        }
        int baseIndex = (int)(modulatedColor / 10.0);
        int r = SLT_COLORS_R[baseIndex];
        int g = SLT_COLORS_G[baseIndex];
        int b = SLT_COLORS_B[baseIndex];
        double step = (modulatedColor - (double)baseIndex * 10.0 - (double)5) / (double)5;
        if (step < 0.0) {
            r += (int)((double)r * step);
            g += (int)((double)g * step);
            b += (int)((double)b * step);
        } else if (step > 0.0) {
            r += (int)((double)(255 - r) * step);
            g += (int)((double)(255 - g) * step);
            b += (int)((double)(255 - b) * step);
        }
        return -16777216 + (r << 16) + (g << 8) + b;
    }

    public static final int getBaseColor(String name) {
        int i = 0;
        while (i < SLT_COLOR_NAMES.length) {
            if (name.equals(Color.getBaseColorName(i))) {
                return Color.getBaseColor(i);
            }
            ++i;
        }
        throw new IllegalStateException(name);
    }

    public static final int getBaseColor(int index) {
        return -16777216 + (SLT_COLORS_R[index] << 16) + (SLT_COLORS_G[index] << 8) + SLT_COLORS_B[index];
    }

    private Color() {
        throw new IllegalStateException();
    }

    static {
        int[] nArray = new int[16];
        nArray[0] = 140;
        nArray[1] = 255;
        nArray[2] = 255;
        nArray[3] = 156;
        nArray[4] = 255;
        nArray[5] = 82;
        nArray[11] = 123;
        nArray[12] = 255;
        nArray[13] = 255;
        nArray[15] = 255;
        SLT_COLORS_R = nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = 140;
        nArray2[2] = 82;
        nArray2[3] = 115;
        nArray2[4] = 255;
        nArray2[5] = 198;
        nArray2[6] = 255;
        nArray2[7] = 255;
        nArray2[8] = 255;
        nArray2[9] = 123;
        nArray2[15] = 255;
        SLT_COLORS_G = nArray2;
        int[] nArray3 = new int[16];
        nArray3[0] = 140;
        nArray3[3] = 82;
        nArray3[7] = 198;
        nArray3[8] = 255;
        nArray3[9] = 255;
        nArray3[10] = 255;
        nArray3[11] = 255;
        nArray3[12] = 255;
        nArray3[13] = 123;
        nArray3[15] = 255;
        SLT_COLORS_B = nArray3;
        int[] nArray4 = new int[15];
        nArray4[2] = 20;
        nArray4[3] = 25;
        nArray4[4] = 60;
        nArray4[5] = 90;
        nArray4[6] = 120;
        nArray4[7] = 166;
        nArray4[8] = 180;
        nArray4[9] = 210;
        nArray4[10] = 240;
        nArray4[11] = 270;
        nArray4[12] = 300;
        nArray4[13] = 330;
        nArray4[14] = 360;
        SLT_COLORS_HUE = nArray4;
    }
}

