/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.CSV;
import org.nlogo.agent.Dump;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.util.Utils;

strictfp class Exporter {
    private World world;

    void exportWorld(PrintWriter writer, boolean full) {
        this.exportRandomState(writer);
        this.exportGlobals(writer);
        if (full) {
            this.exportTurtles(writer);
            this.exportPatches(writer);
        }
    }

    private final void exportRandomState(PrintWriter writer) {
        writer.println(CSV.encode("RANDOM STATE"));
        writer.println(CSV.encode(this.world.random.save()));
        writer.println();
    }

    private final void exportGlobals(PrintWriter writer) {
        writer.println(CSV.encode("GLOBALS"));
        writer.print(CSV.encode("screen-edge-x") + ',' + CSV.encode("screen-edge-y"));
        List globals = this.world.program().globals;
        writer.print("," + CSV.variableNameRow(globals));
        writer.println();
        writer.print(CSV.encode(Integer.toString(this.world.screenEdgeX())) + ',' + CSV.encode(Integer.toString(this.world.screenEdgeY())));
        int i = 0;
        while (i < globals.size()) {
            writer.print(",");
            writer.print(Dump.csvLogoObject(this.world.observer().getObserverVariable(i)));
            ++i;
        }
        writer.println();
        writer.println();
    }

    private final void exportTurtles(PrintWriter writer) {
        writer.println(CSV.encode("TURTLES"));
        ArrayList<String> allTurtleVars = new ArrayList<String>(this.world.program().turtlesOwn);
        int turtlesVarSize = this.world.program().turtlesOwn.size();
        HashMap<String, Integer> breedVarIndices = new HashMap<String, Integer>();
        Iterator keys = this.world.program().breedsOwn.keySet().iterator();
        while (keys.hasNext()) {
            String current = (String)keys.next();
            List breedOwns = (List)this.world.program().breedsOwn.get(current);
            int i = 0;
            while (i < breedOwns.size()) {
                String breedVarName = (String)breedOwns.get(i);
                if (breedVarIndices.get(breedVarName) == null) {
                    allTurtleVars.add(breedVarName);
                    breedVarIndices.put(breedVarName, Utils.reuseInteger(allTurtleVars.size() - 1));
                }
                ++i;
            }
        }
        writer.println(CSV.variableNameRow(allTurtleVars));
        Agent[] turtles = this.world.turtles().agents;
        int i = 0;
        while (i < turtles.length) {
            Turtle turtle = (Turtle)turtles[i];
            if (turtle != null) {
                writer.print(CSV.data(turtle.getTurtleVariable(0)));
                AgentSet breed = (AgentSet)turtle.getTurtleVariable(9);
                String key = breed.printName();
                List breedOwns = null;
                int[] thisBreedVarIndices = null;
                String[] sortedBreedOwns = null;
                if (!key.equals("TURTLES")) {
                    breedOwns = (List)this.world.program().breedsOwn.get(key);
                    thisBreedVarIndices = new int[breedOwns.size()];
                    sortedBreedOwns = new String[breedOwns.size()];
                    int j = 0;
                    while (j < breedOwns.size()) {
                        sortedBreedOwns[j] = (String)breedOwns.get(j);
                        thisBreedVarIndices[j] = (Integer)breedVarIndices.get(breedOwns.get(j));
                        ++j;
                    }
                    this.sortIndicesAndVars(sortedBreedOwns, thisBreedVarIndices);
                } else {
                    thisBreedVarIndices = new int[]{};
                }
                int index = 0;
                int j = 1;
                while (j < allTurtleVars.size()) {
                    writer.print(",");
                    if (j < turtlesVarSize) {
                        writer.print(Dump.csvLogoObject(turtle.getTurtleVariable(j)));
                    } else if (index < thisBreedVarIndices.length && j == thisBreedVarIndices[index]) {
                        writer.print(Dump.csvLogoObject(turtle.getTurtleVariable(this.world.breedsOwnIndexOf(breed, sortedBreedOwns[index]))));
                        ++index;
                    }
                    ++j;
                }
                writer.println();
            }
            ++i;
        }
        writer.println();
    }

    private final void exportPatches(PrintWriter writer) {
        writer.println(CSV.encode("PATCHES"));
        List vars = this.world.program().patchesOwn;
        writer.println(CSV.variableNameRow(vars));
        Agent[] patches = this.world.patches().agents;
        int i = 0;
        while (i < patches.length) {
            Patch patch = (Patch)patches[i];
            if (patch != null) {
                int j = 0;
                while (j < vars.size()) {
                    if (j > 0) {
                        writer.print(",");
                    }
                    writer.print(Dump.csvLogoObject(patch.getPatchVariable(j)));
                    ++j;
                }
                writer.println();
            }
            ++i;
        }
        writer.println();
    }

    private final void sortIndicesAndVars(String[] vars, int[] indices) {
        int i = 0;
        while (i < indices.length) {
            int min = indices[i];
            int minIndex = i;
            int j = i;
            while (j < indices.length) {
                if (indices[j] < min) {
                    min = indices[j];
                    minIndex = j;
                }
                ++j;
            }
            if (i != minIndex) {
                int intTemp = indices[i];
                String stringTemp = vars[i];
                indices[i] = indices[minIndex];
                vars[i] = vars[minIndex];
                indices[minIndex] = intTemp;
                vars[minIndex] = stringTemp;
            }
            ++i;
        }
    }

    Exporter(World world) {
        this.world = world;
    }
}

