/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nlogo.agent.Shape;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class ShapeList {
    public static final String DEFAULT_SHAPE_NAME = "default";
    private final Shape defaultShape;
    private final Map shapes;

    public Shape shape(String name) {
        Shape shapeModel = (Shape)this.shapes.get(name);
        if (shapeModel == null) {
            shapeModel = (Shape)this.shapes.get(DEFAULT_SHAPE_NAME);
        }
        return shapeModel;
    }

    public List getShapes() {
        ArrayList<Shape> currentShapes = new ArrayList<Shape>();
        if (this.shapes.isEmpty()) {
            return currentShapes;
        }
        Iterator shapesIter = this.shapes.values().iterator();
        while (shapesIter.hasNext()) {
            Shape nextShape = (Shape)shapesIter.next();
            if (nextShape.getName().equals(DEFAULT_SHAPE_NAME)) continue;
            currentShapes.add(nextShape);
        }
        List sortedShapes = ShapeList.sortShapes(currentShapes);
        sortedShapes.add(0, this.shapes.get(DEFAULT_SHAPE_NAME));
        return sortedShapes;
    }

    public static final List sortShapes(List unsortedShapes) {
        ArrayList result = new ArrayList(unsortedShapes);
        Collections.sort(result, new Comparator(){

            public final int compare(Object o1, Object o2) {
                Shape shape1 = (Shape)o1;
                Shape shape2 = (Shape)o2;
                return shape1.getName().compareTo(shape2.getName());
            }
        });
        return result;
    }

    public Set getNames() {
        return this.shapes.keySet();
    }

    public boolean exists(String name) {
        return this.shapes.containsKey(name);
    }

    public void clearShapes() {
        this.shapes.clear();
        this.shapes.put(DEFAULT_SHAPE_NAME, this.defaultShape);
    }

    public Shape addNewShape(Shape newShape) {
        return this.shapes.put(newShape.getName(), newShape);
    }

    public void addNewShapes(Collection collection) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.addNewShape((Shape)iter.next());
        }
    }

    public Shape removeShape(Shape shapeToRemove) {
        if (shapeToRemove == null || shapeToRemove.getName().equals(DEFAULT_SHAPE_NAME) || !this.shapes.containsValue(shapeToRemove)) {
            return null;
        }
        return (Shape)this.shapes.remove(shapeToRemove.getName());
    }

    private final /* synthetic */ void this() {
        this.shapes = new HashMap();
    }

    public ShapeList(Shape defaultShape) {
        this.this();
        this.defaultShape = defaultShape;
        this.shapes.put(DEFAULT_SHAPE_NAME, defaultShape);
    }
}

