/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentException;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Color;
import org.nlogo.agent.Dump;
import org.nlogo.agent.NullLabel;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Shape;
import org.nlogo.agent.World;
import org.nlogo.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp final class Turtle
extends Agent
implements org.nlogo.api.Turtle {
    public static final int VAR_WHO = 0;
    public static final int VAR_COLOR = 1;
    private static final int VAR_HEADING = 2;
    private static final int VAR_XCOR = 3;
    private static final int VAR_YCOR = 4;
    public static final int VAR_SHAPE = 5;
    private static final int VAR_PENDOWN = 6;
    public static final int VAR_LABEL = 7;
    private static final int VAR_LABELCOLOR = 8;
    public static final int VAR_BREED = 9;
    private static final int VAR_HIDDEN = 10;
    private static final int VAR_SIZE = 11;
    public static final int LAST_PREDEFINED_VAR = 11;
    public static final int NUMBER_PREDEFINED_VARS = 12;
    private int breedId;
    private Patch currentPatch;
    private double heading;
    private double xcor;
    private double ycor;
    private Shape cachedShape;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$nlogo$agent$AgentSet;

    final void id(int id) {
        this.id = id;
        this.variables[0] = null;
    }

    public final Turtle hatch() {
        Turtle child = new Turtle(this.world);
        child.heading = this.heading;
        child.xcor = this.xcor;
        child.ycor = this.ycor;
        child.variables = (Object[])this.variables.clone();
        child.id(this.world.turtles().add(child));
        if (this.getBreed() != this.world.turtles()) {
            child.breedId = this.getBreed().add(child);
        }
        child.getPatchHere().turtlesHere.add(child);
        return child;
    }

    public final void die() {
        Patch patch = this.getPatchHere();
        patch.turtlesHere.remove(this);
        AgentSet breed = this.getBreed();
        if (breed != this.world.turtles()) {
            breed.remove(this.breedId);
        }
        this.world.turtles().remove(this.id);
        this.id(-1);
    }

    public static final List getImplicitVariables() {
        return Arrays.asList("WHO", "COLOR", "HEADING", "XCOR", "YCOR", "SHAPE", "PEN-DOWN?", "LABEL", "LABEL-COLOR", "BREED", "HIDDEN?", "SIZE");
    }

    public static final boolean isDoubleVariable(int vn) {
        boolean bl = false;
        if (vn == 1 || vn == 2 || vn == 3 || vn == 4 || vn == 8 || vn == 11) {
            bl = true;
        }
        return bl;
    }

    public final Patch getPatchAtOffsets(double dx, double dy) {
        return this.world.getPatchAt(this.xcor + dx, this.ycor + dy);
    }

    final void realloc(boolean compiling) {
        this.realloc(compiling, null);
    }

    final void realloc(boolean compiling, AgentSet oldBreed) {
        int oldpos;
        String name;
        int i;
        if (compiling && this.getBreed() != this.world.turtles() && this.world.getBreed(this.getBreed().printName()) == null) {
            this.variables[9] = this.world.turtles();
            this.shape(this.world.breedShape(this.world.turtles()));
        }
        Object[] oldvars = this.variables;
        this.variables = new Object[this.world.getVariablesArraySize(this, this.getBreed())];
        int turtlesOwnSize = this.world.getVariablesArraySize(null, this.world.turtles());
        int numberToCopyDirectly = compiling ? 12 : turtlesOwnSize;
        System.arraycopy(oldvars, 0, this.variables, 0, numberToCopyDirectly);
        if (compiling) {
            i = 12;
            while (i < turtlesOwnSize) {
                name = this.world.turtlesOwnNameAt(i);
                oldpos = this.world.oldTurtlesOwnIndexOf(name);
                if (oldpos == -1) {
                    this.variables[i] = Utils.ZERO_DOUBLE;
                } else {
                    this.variables[i] = oldvars[oldpos];
                    oldvars[oldpos] = null;
                }
                ++i;
            }
        }
        i = turtlesOwnSize;
        while (i < this.variables.length) {
            name = this.world.breedsOwnNameAt(this.getBreed(), i);
            int n = oldpos = compiling ? this.world.oldBreedsOwnIndexOf(this.getBreed(), name) : this.world.breedsOwnIndexOf(oldBreed, name);
            if (oldpos == -1) {
                this.variables[i] = Utils.ZERO_DOUBLE;
            } else {
                this.variables[i] = oldvars[oldpos];
                oldvars[oldpos] = null;
            }
            ++i;
        }
    }

    public final void jump(double distance) {
        Patch targetPatch;
        double headingRadians = StrictMath.toRadians(this.heading());
        double cos = StrictMath.cos(headingRadians);
        double sin = StrictMath.sin(headingRadians);
        if (StrictMath.abs(cos) < 3.2E-15) {
            cos = 0.0;
        }
        if (StrictMath.abs(sin) < 3.2E-15) {
            sin = 0.0;
        }
        Patch originalPatch = this.getPatchHere();
        this.xandycor(this.world.wrapX(this.xcor + distance * sin), this.world.wrapY(this.ycor + distance * cos));
        if (this.penDown() && originalPatch != (targetPatch = this.getPatchHere())) {
            originalPatch.pcolorDoubleUnchecked(this.color());
        }
    }

    public final Patch getPatchHere() {
        if (this.currentPatch == null) {
            this.currentPatch = this.world.getPatchAt(this.xcor, this.ycor);
        }
        return this.currentPatch;
    }

    private final void mustOwn(String name) throws AgentException {
        if (name != null && !this.world.breedOwns(this.getBreed(), name)) {
            throw new AgentException(this.getBreed().printName() + " breed does not own variable " + name);
        }
    }

    public final Object getVariable(int vn) {
        return this.getTurtleVariable(vn);
    }

    public final void setVariable(int vn, Object value) throws AgentException {
        this.setTurtleVariable(vn, value);
    }

    public final Object getObserverVariable(int vn) {
        return this.world.observer().getObserverVariable(vn);
    }

    public final Object getTurtleVariable(int vn) {
        if (vn == 0) {
            if (this.variables[0] == null) {
                this.variables[0] = Utils.reuseInteger(this.id);
            }
        } else if (vn == 2) {
            if (this.variables[2] == null) {
                this.variables[2] = new Double(this.heading);
            }
        } else if (vn == 3) {
            if (this.variables[3] == null) {
                this.variables[3] = new Double(this.xcor);
            }
        } else if (vn == 4 && this.variables[4] == null) {
            this.variables[4] = new Double(this.ycor);
        }
        return this.variables[vn];
    }

    public final double getTurtleVariableDouble(int vn) {
        switch (vn) {
            case 1: {
                return this.color();
            }
            case 2: {
                return this.heading;
            }
            case 3: {
                return this.xcor;
            }
            case 4: {
                return this.ycor;
            }
            case 8: {
                return this.labelColor();
            }
            case 11: {
                return this.size();
            }
        }
        throw new RuntimeException(vn + " is not a double variable");
    }

    public final Object getBreedVariable(String name) throws AgentException {
        this.mustOwn(name);
        int vn = this.world.breedsOwnIndexOf(this.getBreed(), name);
        return this.getTurtleVariable(vn);
    }

    public final Object getPatchVariable(int vn) {
        return this.getPatchHere().getPatchVariable(vn);
    }

    public final double getPatchVariableDouble(int vn) {
        return this.getPatchHere().getPatchVariableDouble(vn);
    }

    public final void setObserverVariable(int vn, Object value) {
        this.world.observer().setObserverVariable(vn, value);
    }

    public final void setTurtleVariable(int vn, double value) throws AgentException {
        switch (vn) {
            case 1: {
                this.colorDouble(new Double(value));
                break;
            }
            case 2: {
                this.heading(value);
                break;
            }
            case 3: {
                this.xcor(value);
                break;
            }
            case 4: {
                this.ycor(value);
                break;
            }
            case 8: {
                this.labelColor(value);
                break;
            }
            case 11: {
                this.size(value);
                break;
            }
            default: {
                throw new RuntimeException(vn + " is not a double variable");
            }
        }
    }

    public final void setTurtleVariable(int vn, Object value) throws AgentException {
        if (vn > 11) {
            this.variables[vn] = value;
        } else {
            switch (vn) {
                case 1: {
                    if (value instanceof Double) {
                        this.colorDouble((Double)value);
                        break;
                    }
                    if (value instanceof Integer) {
                        this.colorInteger((Integer)value);
                        break;
                    }
                    String string = (String)Turtle.getImplicitVariables().get(vn);
                    Class clazz = class$java$lang$Number;
                    if (clazz == null) {
                        clazz = class$java$lang$Number = Turtle.class("[Ljava.lang.Number;", false);
                    }
                    this.wrongTypeForVariable(string, clazz, value);
                    break;
                }
                case 2: {
                    if (value instanceof Double) {
                        this.heading((Double)value);
                        break;
                    }
                    if (value instanceof Integer) {
                        this.heading(((Integer)value).doubleValue());
                        break;
                    }
                    String string = (String)Turtle.getImplicitVariables().get(vn);
                    Class clazz = class$java$lang$Number;
                    if (clazz == null) {
                        clazz = class$java$lang$Number = Turtle.class("[Ljava.lang.Number;", false);
                    }
                    this.wrongTypeForVariable(string, clazz, value);
                    break;
                }
                case 3: {
                    if (value instanceof Double) {
                        this.xcor((Double)value);
                        break;
                    }
                    if (value instanceof Integer) {
                        this.xcor(((Integer)value).doubleValue());
                        break;
                    }
                    String string = (String)Turtle.getImplicitVariables().get(vn);
                    Class clazz = class$java$lang$Number;
                    if (clazz == null) {
                        clazz = class$java$lang$Number = Turtle.class("[Ljava.lang.Number;", false);
                    }
                    this.wrongTypeForVariable(string, clazz, value);
                    break;
                }
                case 4: {
                    if (value instanceof Double) {
                        this.ycor((Double)value);
                        break;
                    }
                    if (value instanceof Integer) {
                        this.ycor(((Integer)value).doubleValue());
                        break;
                    }
                    String string = (String)Turtle.getImplicitVariables().get(vn);
                    Class clazz = class$java$lang$Number;
                    if (clazz == null) {
                        clazz = class$java$lang$Number = Turtle.class("[Ljava.lang.Number;", false);
                    }
                    this.wrongTypeForVariable(string, clazz, value);
                    break;
                }
                case 5: {
                    if (value instanceof String) {
                        String newShape = this.world.checkShapeName((String)value);
                        if (newShape == null) {
                            throw new AgentException("\"" + (String)value + "\" is not a currently defined shape");
                        }
                        this.shape(newShape);
                        break;
                    }
                    String string = (String)Turtle.getImplicitVariables().get(vn);
                    Class clazz = class$java$lang$String;
                    if (clazz == null) {
                        clazz = class$java$lang$String = Turtle.class("[Ljava.lang.String;", false);
                    }
                    this.wrongTypeForVariable(string, clazz, value);
                    break;
                }
                case 6: {
                    if (value instanceof Boolean) {
                        this.penDown((Boolean)value);
                        break;
                    }
                    String string = (String)Turtle.getImplicitVariables().get(vn);
                    Class clazz = class$java$lang$Boolean;
                    if (clazz == null) {
                        clazz = class$java$lang$Boolean = Turtle.class("[Ljava.lang.Boolean;", false);
                    }
                    this.wrongTypeForVariable(string, clazz, value);
                    break;
                }
                case 7: {
                    this.label(value);
                    break;
                }
                case 8: {
                    if (value instanceof Number) {
                        this.labelColor(((Number)value).doubleValue());
                        break;
                    }
                    String string = (String)Turtle.getImplicitVariables().get(vn);
                    Class clazz = class$java$lang$Number;
                    if (clazz == null) {
                        clazz = class$java$lang$Number = Turtle.class("[Ljava.lang.Number;", false);
                    }
                    this.wrongTypeForVariable(string, clazz, value);
                    break;
                }
                case 9: {
                    if (value instanceof AgentSet) {
                        AgentSet breed = (AgentSet)value;
                        if (breed != this.world.turtles() && !this.world.isBreed(breed)) {
                            throw new AgentException("can't set BREED to a non-breed agentset");
                        }
                        this.setBreed(breed);
                        break;
                    }
                    String string = (String)Turtle.getImplicitVariables().get(vn);
                    Class clazz = class$org$nlogo$agent$AgentSet;
                    if (clazz == null) {
                        clazz = class$org$nlogo$agent$AgentSet = Turtle.class("[Lorg.nlogo.agent.AgentSet;", false);
                    }
                    this.wrongTypeForVariable(string, clazz, value);
                    break;
                }
                case 10: {
                    if (value instanceof Boolean) {
                        this.hidden((Boolean)value);
                        break;
                    }
                    String string = (String)Turtle.getImplicitVariables().get(vn);
                    Class clazz = class$java$lang$Boolean;
                    if (clazz == null) {
                        clazz = class$java$lang$Boolean = Turtle.class("[Ljava.lang.Boolean;", false);
                    }
                    this.wrongTypeForVariable(string, clazz, value);
                    break;
                }
                case 11: {
                    if (value instanceof Number) {
                        this.size(((Number)value).doubleValue());
                        break;
                    }
                    String string = (String)Turtle.getImplicitVariables().get(vn);
                    Class clazz = class$java$lang$Number;
                    if (clazz == null) {
                        clazz = class$java$lang$Number = Turtle.class("[Ljava.lang.Number;", false);
                    }
                    this.wrongTypeForVariable(string, clazz, value);
                    break;
                }
                case 0: {
                    throw new AgentException("you can't change a turtle's ID number");
                }
                default: {
                    return;
                }
            }
        }
    }

    public final void setBreedVariable(String name, Object value) throws AgentException {
        this.mustOwn(name);
        int vn = this.world.breedsOwnIndexOf(this.getBreed(), name);
        this.setTurtleVariable(vn, value);
    }

    public final void setPatchVariable(int vn, Object value) throws AgentException {
        this.getPatchHere().setPatchVariable(vn, value);
    }

    public final void setPatchVariable(int vn, double value) throws AgentException {
        this.getPatchHere().setPatchVariable(vn, value);
    }

    public final Double color() {
        return (Double)this.variables[1];
    }

    public final void colorDouble(Double boxedColor) {
        double c = boxedColor;
        if (c < 0.0 || c >= 140.0) {
            c = Color.modulateDouble(c);
            boxedColor = new Double(c);
        }
        this.variables[1] = boxedColor;
    }

    public final void colorInteger(Integer boxedColor) {
        double c = boxedColor.doubleValue();
        if (c < 0.0 || c >= 140.0) {
            this.colorDoubleUnchecked(new Double(Color.modulateDouble(c)));
        } else {
            this.colorDoubleUnchecked(new Double(c));
        }
    }

    public final void colorDoubleUnchecked(Double boxedColor) {
        this.variables[1] = boxedColor;
    }

    public final double heading() {
        return this.heading;
    }

    public final void heading(double heading) {
        this.heading = (heading % 360.0 + 360.0) % 360.0;
        this.variables[2] = null;
    }

    public final void heading(Double heading) {
        double wrapped;
        double h = heading;
        this.heading = wrapped = (h % 360.0 + 360.0) % 360.0;
        this.variables[2] = h == wrapped ? heading : null;
    }

    public final double xcor() {
        return this.xcor;
    }

    public final void xcor(double xcor) {
        Patch originalPatch = this.getPatchHere();
        this.xcor = this.world.wrapX(xcor);
        this.variables[3] = null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.turtlesHere.remove(this);
            targetPatch.turtlesHere.add(this);
        }
    }

    public final void xcor(Double xcor) {
        double wrapped;
        Patch originalPatch = this.getPatchHere();
        double x = xcor;
        this.xcor = wrapped = this.world.wrapX(x);
        this.variables[3] = x == wrapped ? xcor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.turtlesHere.remove(this);
            targetPatch.turtlesHere.add(this);
        }
    }

    public final double ycor() {
        return this.ycor;
    }

    public final void ycor(double ycor) {
        Patch originalPatch = this.getPatchHere();
        this.ycor = this.world.wrapY(ycor);
        this.variables[4] = null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.turtlesHere.remove(this);
            targetPatch.turtlesHere.add(this);
        }
    }

    public final void ycor(Double ycor) {
        double wrapped;
        Patch originalPatch = this.getPatchHere();
        double y = ycor;
        this.ycor = wrapped = this.world.wrapY(y);
        this.variables[4] = y == wrapped ? ycor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.turtlesHere.remove(this);
            targetPatch.turtlesHere.add(this);
        }
    }

    public final void xandycor(double xcor, double ycor) {
        Patch originalPatch = this.getPatchHere();
        this.xcor = this.world.wrapX(xcor);
        this.ycor = this.world.wrapY(ycor);
        this.variables[3] = null;
        this.variables[4] = null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.turtlesHere.remove(this);
            targetPatch.turtlesHere.add(this);
        }
    }

    public final void xandycor(Double xcor, Double ycor) {
        Patch originalPatch = this.getPatchHere();
        double x = xcor;
        double y = ycor;
        double wrappedX = this.world.wrapX(x);
        double wrappedY = this.world.wrapY(y);
        this.xcor = wrappedX;
        this.ycor = wrappedY;
        this.variables[3] = x == wrappedX ? xcor : null;
        this.variables[4] = y == wrappedY ? ycor : null;
        this.currentPatch = null;
        Patch targetPatch = this.getPatchHere();
        if (originalPatch != targetPatch) {
            originalPatch.turtlesHere.remove(this);
            targetPatch.turtlesHere.add(this);
        }
    }

    public final String shape() {
        return (String)this.variables[5];
    }

    private final void shape(String shape) {
        this.variables[5] = shape;
        this.cachedShape = null;
    }

    public final boolean penDown() {
        return (Boolean)this.variables[6];
    }

    public final void penDown(boolean penDown) {
        this.variables[6] = penDown ? Boolean.TRUE : Boolean.FALSE;
    }

    public final Object label() {
        return this.variables[7];
    }

    public final boolean hasLabel() {
        boolean bl = false;
        if (this.label() != NullLabel.theNullLabel) {
            bl = true;
        }
        return bl;
    }

    public final String labelString() {
        return Dump.logoObject(this.variables[7]);
    }

    public final void label(Object label) {
        this.variables[7] = label;
    }

    public final double labelColor() {
        return ((Number)this.variables[8]).doubleValue();
    }

    public final void labelColor(double labelColor) {
        this.variables[8] = new Double(Color.modulateDouble(labelColor));
    }

    public final AgentSet getBreed() {
        return (AgentSet)this.variables[9];
    }

    public final int getBreedIndex() {
        AgentSet mybreed = this.getBreed();
        if (mybreed == this.world.turtles()) {
            return 0;
        }
        int j = 1;
        Iterator iter = this.world.program().breeds.values().iterator();
        while (iter.hasNext()) {
            if (mybreed == (AgentSet)iter.next()) {
                return j;
            }
            ++j;
        }
        throw new RuntimeException("Error getting breed index");
    }

    public final void setBreed(AgentSet breed) {
        AgentSet oldBreed = null;
        if (this.variables[9] instanceof AgentSet) {
            oldBreed = (AgentSet)this.variables[9];
            if (breed == oldBreed) {
                return;
            }
            if (oldBreed != this.world.turtles()) {
                ((AgentSet)this.variables[9]).remove(this.breedId);
            }
        }
        if (breed != this.world.turtles()) {
            this.breedId = breed.add(this);
        }
        this.variables[9] = breed;
        this.shape(this.world.breedShape(breed));
        this.realloc(false, oldBreed);
    }

    public final Shape cachedShape() {
        return this.cachedShape;
    }

    public final void cachedShape(Shape newShape) {
        this.cachedShape = newShape;
    }

    public final boolean hidden() {
        return (Boolean)this.variables[10];
    }

    public final void hidden(boolean hidden) {
        this.variables[10] = hidden ? Boolean.TRUE : Boolean.FALSE;
    }

    public final double size() {
        return ((Number)this.variables[11]).doubleValue();
    }

    public final void size(double size) {
        this.variables[11] = new Double(size);
    }

    public final String toString() {
        return "turtle " + this.id;
    }

    public final String classDisplayName() {
        return "turtle";
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.currentPatch = null;
        this.heading = 0.0;
    }

    public Turtle(World world, AgentSet breed, Number xcor, Number ycor) {
        this(world, breed, xcor, ycor, true);
    }

    private Turtle(World world, AgentSet breed, Number xcor, Number ycor, boolean getId) {
        super(world);
        this.this();
        this.variables = new Object[world.getVariablesArraySize(this, breed)];
        if (getId) {
            this.id(world.turtles().add(this));
        }
        this.variables[1] = Color.BOXED_BLACK;
        this.heading = 0.0;
        this.variables[2] = Utils.ZERO_DOUBLE;
        this.xcor = xcor.doubleValue();
        if (xcor instanceof Double) {
            this.variables[3] = (Double)xcor;
        }
        this.ycor = ycor.doubleValue();
        if (ycor instanceof Double) {
            this.variables[4] = (Double)ycor;
        }
        this.variables[5] = world.breedShape(breed);
        this.variables[6] = Boolean.FALSE;
        this.variables[7] = NullLabel.theNullLabel;
        this.variables[8] = Color.BOXED_WHITE;
        this.variables[9] = breed;
        this.variables[10] = Boolean.FALSE;
        this.variables[11] = Utils.ONE_DOUBLE;
        int i = 12;
        while (i < this.variables.length) {
            this.variables[i] = Utils.ZERO_DOUBLE;
            ++i;
        }
        if (breed != world.turtles()) {
            this.breedId = breed.add(this);
        }
        this.getPatchHere().turtlesHere.add(this);
    }

    Turtle(World world, int id) {
        this(world, world.turtles(), Utils.ZERO_DOUBLE, Utils.ZERO_DOUBLE, false);
        this.id(id);
        world.turtles().addAgentInSpot(this, id);
    }

    Turtle(World world) {
        super(world);
        this.this();
    }

    public Turtle(double color, double heading, Shape shape, boolean hidden) {
        super(null);
        this.this();
        this.variables = new Object[12];
        this.variables[1] = new Double(color);
        this.heading = heading;
        this.variables[10] = new Boolean(hidden);
        this.cachedShape(shape);
    }
}

