/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentException;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Color;
import org.nlogo.agent.DummyShapeList;
import org.nlogo.agent.Exporter;
import org.nlogo.agent.LogoList;
import org.nlogo.agent.Nobody;
import org.nlogo.agent.NullLabel;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Program;
import org.nlogo.agent.Shape;
import org.nlogo.agent.ShapeList;
import org.nlogo.agent.Turtle;
import org.nlogo.util.Exceptions;
import org.nlogo.util.MersenneTwisterFast;
import org.nlogo.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp final class World {
    public final ShapeList shapeList;
    public final MersenneTwisterFast random;
    private int screenEdgeX;
    private int screenEdgeY;
    private int screenSizeX;
    private int screenSizeY;
    private double[] rootsTable;
    private int rootsTableSize;
    private AgentSet observers;
    private Observer observer;
    private AgentSet patches;
    private AgentSet turtles;
    int[] patchColors;
    boolean patchesAllBlack;
    public int patchesWithLabels;
    private double[][] patchScratch;
    private final Object breedShapesLock;
    private Map breedShapes;
    private Program program;
    private Program oldProgram;
    private boolean displayOn;
    private long timer;
    static /* synthetic */ Class class$org$nlogo$agent$Observer;
    static /* synthetic */ Class class$org$nlogo$agent$Patch;
    static /* synthetic */ Class class$org$nlogo$agent$Turtle;

    public final void exportWorld(PrintWriter writer, boolean full) {
        new Exporter(this).exportWorld(writer, full);
    }

    public static final boolean recursivelyEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            double o1d = ((Number)o1).doubleValue();
            double o2d = ((Number)o2).doubleValue();
            boolean bl = false;
            if (o1d == o2d) {
                bl = true;
            }
            return bl;
        }
        if (o1 instanceof LogoList && o2 instanceof LogoList) {
            LogoList v1 = (LogoList)o1;
            LogoList v2 = (LogoList)o2;
            if (v1.size() != v2.size()) {
                return false;
            }
            int i = 0;
            while (i < v1.size()) {
                if (!World.recursivelyEqual(v1.get(i), v2.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (o1 instanceof Turtle && o2 instanceof Turtle) {
            boolean bl = false;
            if (((Turtle)o1).id == ((Turtle)o2).id) {
                bl = true;
            }
            return bl;
        }
        if (o1 instanceof Nobody) {
            boolean bl = false;
            if (o2 instanceof Nobody || o2 instanceof Turtle && ((Turtle)o2).id == -1) {
                bl = true;
            }
            return bl;
        }
        if (o2 instanceof Nobody) {
            boolean bl = false;
            if (o1 instanceof Turtle && ((Turtle)o1).id == -1) {
                bl = true;
            }
            return bl;
        }
        return o1.equals(o2);
    }

    public final int screenEdgeX() {
        return this.screenEdgeX;
    }

    public final int screenEdgeY() {
        return this.screenEdgeY;
    }

    public final int screenSizeX() {
        return this.screenSizeX;
    }

    public final int screenSizeY() {
        return this.screenSizeY;
    }

    public final int roundX(double x) {
        if ((x = this.wrapX(x)) > 0.0) {
            return (int)(x + 0.5);
        }
        int intPart = (int)x;
        double fractPart = (double)intPart - x;
        return fractPart > 0.5 ? intPart - 1 : intPart;
    }

    public final int roundY(double y) {
        if ((y = this.wrapY(y)) > 0.0) {
            return (int)(y + 0.5);
        }
        int intPart = (int)y;
        double fractPart = (double)intPart - y;
        return fractPart > 0.5 ? intPart - 1 : intPart;
    }

    public final double wrapX(double x) {
        return this.wrap(x, (double)this.screenEdgeX + 0.5);
    }

    public final double wrapY(double y) {
        return this.wrap(y, (double)this.screenEdgeY + 0.5);
    }

    private final double wrap(double pos, double max) {
        if (pos >= max) {
            double result = pos % (max * (double)2);
            return result >= max ? result - max * (double)2 : result;
        }
        if (pos < -max) {
            double result = pos % (max * (double)2);
            return result < -max ? result + max * (double)2 : result;
        }
        return pos;
    }

    public final double distance(Agent agent1, Agent agent2, boolean wrap) {
        double y1;
        double x1;
        if (agent1 instanceof Turtle) {
            Turtle turtle = (Turtle)agent1;
            x1 = turtle.xcor();
            y1 = turtle.ycor();
        } else {
            Patch patch = (Patch)agent1;
            x1 = patch.pxcor();
            y1 = patch.pycor();
        }
        return this.distance(agent2, x1, y1, wrap);
    }

    public final double distance(Agent agent, double x1, double y1, boolean wrap) {
        double y2;
        double x2;
        if (agent instanceof Turtle) {
            Turtle turtle = (Turtle)agent;
            x2 = turtle.xcor();
            y2 = turtle.ycor();
        } else {
            Patch patch = (Patch)agent;
            x2 = patch.pxcor();
            y2 = patch.pycor();
        }
        return this.distance(x1, y1, x2, y2, wrap);
    }

    public final double gridRoot(double val) {
        int intVal = (int)val;
        if (val == (double)intVal) {
            return this.gridRoot(intVal);
        }
        return StrictMath.sqrt(val);
    }

    public final double gridRoot(int val) {
        try {
            return this.rootsTable[val];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return StrictMath.sqrt(val);
        }
    }

    public final double distance(double x1, double y1, double x2, double y2, boolean wrap) {
        double distanceWrap;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double distanceNoWrap = this.gridRoot(dx * dx + dy * dy);
        if (wrap && (distanceWrap = this.gridRoot((dx = this.wrapX(dx)) * dx + (dy = this.wrapY(dy)) * dy)) < distanceNoWrap) {
            return distanceWrap;
        }
        return distanceNoWrap;
    }

    public final Patch getPatchAtHeadingAndDistance(double x, double y, double heading, double distance) {
        double headingRadians = StrictMath.toRadians(heading);
        double cos = StrictMath.cos(headingRadians);
        double sin = StrictMath.sin(headingRadians);
        if (StrictMath.abs(cos) < 3.2E-15) {
            cos = 0.0;
        }
        if (StrictMath.abs(sin) < 3.2E-15) {
            sin = 0.0;
        }
        return this.getPatchAt(this.wrapX(x + distance * sin), this.wrapY(y + distance * cos));
    }

    public final double towards(Agent fromAgent, Agent toAgent, boolean wrap) throws AgentException {
        double y;
        double x;
        if (fromAgent == toAgent) {
            throw new AgentException("no heading is defined from an agent to itself");
        }
        if (toAgent instanceof Turtle) {
            Turtle turtle = (Turtle)toAgent;
            x = turtle.xcor();
            y = turtle.ycor();
        } else {
            Patch patch = (Patch)toAgent;
            x = patch.pxcor();
            y = patch.pycor();
        }
        return this.towards(fromAgent, x, y, wrap);
    }

    public final double towards(Agent fromAgent, double toX, double toY, boolean wrap) throws AgentException {
        double fromY;
        double fromX;
        if (fromAgent instanceof Turtle) {
            Turtle turtle = (Turtle)fromAgent;
            fromX = turtle.xcor();
            fromY = turtle.ycor();
        } else {
            Patch patch = (Patch)fromAgent;
            fromX = patch.pxcor();
            fromY = patch.pycor();
        }
        return this.towards(fromX, fromY, toX, toY, wrap);
    }

    public final double towards(double fromX, double fromY, double toX, double toY, boolean wrap) throws AgentException {
        if (fromX == toX && fromY == toY) {
            throw new AgentException("no heading is defined from a point (" + fromX + ',' + fromY + ") to that same point");
        }
        double dx = toX - fromX;
        double dy = toY - fromY;
        if (wrap) {
            dx = this.wrapX(dx);
            dy = this.wrapY(dy);
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-dy, dx))) % 360.0;
    }

    public final List inRadius(Agent agent, AgentSet sourceSet, double radius, boolean wrap) {
        Patch startPatch;
        ArrayList<Agent> result = new ArrayList<Agent>();
        Turtle startTurtle = null;
        if (agent instanceof Turtle) {
            startTurtle = (Turtle)agent;
            startPatch = startTurtle.getPatchHere();
        } else {
            startPatch = (Patch)agent;
        }
        int dxmax = StrictMath.min((int)StrictMath.ceil(radius), this.screenEdgeX);
        int dymax = StrictMath.min((int)StrictMath.ceil(radius), this.screenEdgeY);
        int dy = -dymax;
        while (dy <= dymax) {
            int dx = -dxmax;
            while (dx <= dxmax) {
                block15: {
                    Patch patch;
                    block13: {
                        block14: {
                            patch = startPatch.getPatchAtOffsets(dx, dy);
                            Class clazz = sourceSet.type();
                            Class clazz2 = class$org$nlogo$agent$Patch;
                            if (clazz2 == null) {
                                clazz2 = World.class("[Lorg.nlogo.agent.Patch;", false);
                            }
                            if (clazz != clazz2) break block13;
                            if (startTurtle != null) break block14;
                            if (this.distance(patch.pxcor(), patch.pycor(), startPatch.pxcor(), startPatch.pycor(), wrap) <= radius && (sourceSet == this.patches || sourceSet.contains(patch))) {
                                result.add(patch);
                            }
                            break block15;
                        }
                        if (!(this.distance(patch.pxcor(), patch.pycor(), startTurtle.xcor(), startTurtle.ycor(), wrap) <= radius) || sourceSet != this.patches && !sourceSet.contains(patch)) break block15;
                        result.add(patch);
                        break block15;
                    }
                    if (this.gridRoot(dx * dx + dy * dy) <= radius + 1.415) {
                        int j = 0;
                        while (j < patch.turtlesHere.size()) {
                            Turtle turtle = (Turtle)patch.turtlesHere.get(j);
                            if (sourceSet == this.turtles || sourceSet.printName() != null && sourceSet == turtle.getBreed() || sourceSet.printName() == null && sourceSet.contains(turtle)) {
                                if (startTurtle == null) {
                                    if (this.distance(turtle.xcor(), turtle.ycor(), startPatch.pxcor(), startPatch.pycor(), wrap) <= radius) {
                                        result.add(turtle);
                                    }
                                } else if (this.distance(turtle.xcor(), turtle.ycor(), startTurtle.xcor(), startTurtle.ycor(), wrap) <= radius) {
                                    result.add(turtle);
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++dx;
            }
            ++dy;
        }
        return result;
    }

    public final AgentSet observers() {
        return this.observers;
    }

    public final Observer observer() {
        return this.observer;
    }

    public final AgentSet patches() {
        return this.patches;
    }

    public final AgentSet turtles() {
        return this.turtles;
    }

    public final AgentSet agentClassToAgentSet(Class agentClass) {
        Class clazz = class$org$nlogo$agent$Turtle;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Turtle = World.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        if (agentClass == clazz) {
            return this.turtles;
        }
        Class clazz2 = class$org$nlogo$agent$Patch;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Patch = World.class("[Lorg.nlogo.agent.Patch;", false);
        }
        if (agentClass == clazz2) {
            return this.patches;
        }
        Class clazz3 = class$org$nlogo$agent$Observer;
        if (clazz3 == null) {
            clazz3 = class$org$nlogo$agent$Observer = World.class("[Lorg.nlogo.agent.Observer;", false);
        }
        if (agentClass == clazz3) {
            return this.observers;
        }
        throw new IllegalArgumentException("agentClass = " + agentClass);
    }

    public final Patch getPatch(int id) {
        return (Patch)this.patches.agents[id];
    }

    public final Patch getPatchAt(double x, double y) {
        int xc = this.roundX(x);
        int yc = this.roundY(y);
        int id = (this.screenSizeY - 1 - (yc + this.screenEdgeY)) * this.screenSizeX + (xc + this.screenEdgeX);
        return (Patch)this.patches.agents[id];
    }

    public final boolean validPatchCoordinates(int xc, int yc) {
        boolean bl = false;
        if (StrictMath.abs(xc) <= this.screenEdgeX && StrictMath.abs(yc) <= this.screenEdgeY) {
            bl = true;
        }
        return bl;
    }

    public final Patch fastGetPatchAt(int xc, int yc) {
        return (Patch)this.patches.agents[(2 * this.screenEdgeY - (yc + this.screenEdgeY)) * (2 * this.screenEdgeX + 1) + (xc + this.screenEdgeX)];
    }

    public final Turtle getTurtle(int id) {
        Agent[] agents = this.turtles.agents;
        if (id >= 0 && id < agents.length) {
            return (Turtle)this.turtles.agents[id];
        }
        return null;
    }

    public final Turtle getOrCreateTurtle(int id) {
        Turtle turtle = this.getTurtle(id);
        if (turtle == null) {
            turtle = new Turtle(this, id);
        }
        return turtle;
    }

    public final boolean patchesAllBlack() {
        return this.patchesAllBlack;
    }

    public final int[] patchColors() {
        return this.patchColors;
    }

    public final void createPatches(int screenEdgeX, int screenEdgeY) {
        Class clazz;
        this.patchScratch = null;
        this.screenEdgeX = screenEdgeX;
        this.screenEdgeY = screenEdgeY;
        this.screenSizeX = 2 * screenEdgeX + 1;
        this.screenSizeY = 2 * screenEdgeY + 1;
        if (this.program.breeds != null) {
            Iterator iter = this.program.breeds.values().iterator();
            while (iter.hasNext()) {
                ((AgentSet)iter.next()).clear();
            }
        }
        if ((clazz = class$org$nlogo$agent$Turtle) == null) {
            clazz = class$org$nlogo$agent$Turtle = World.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        this.turtles = new AgentSet(clazz, 1000, "TURTLES", true, this);
        int x = -screenEdgeX;
        int y = screenEdgeY;
        Agent[] patchArray = new Agent[this.screenSizeX * this.screenSizeY];
        this.patchColors = new int[this.screenSizeX * this.screenSizeY];
        Arrays.fill(this.patchColors, Color.computeColor(0.0));
        int numVariables = this.program().patchesOwn.size();
        int i = 0;
        while (this.screenSizeX * this.screenSizeY != i) {
            Patch patch = new Patch(this, i, x, y, numVariables);
            if (++x == screenEdgeX + 1) {
                x = -screenEdgeX;
                --y;
            }
            patchArray[i] = patch;
            ++i;
        }
        Class clazz2 = class$org$nlogo$agent$Patch;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Patch = World.class("[Lorg.nlogo.agent.Patch;", false);
        }
        this.patches = new AgentSet(clazz2, patchArray, "patches", this);
        this.patchesWithLabels = 0;
        this.patchesAllBlack = true;
        this.rootsTableSize = this.screenSizeX * this.screenSizeX + this.screenSizeY * this.screenSizeY;
        this.rootsTable = new double[this.rootsTableSize];
        i = 0;
        while (i < this.rootsTableSize) {
            this.rootsTable[i] = StrictMath.sqrt(i);
            ++i;
        }
    }

    public final void clearAll() {
        this.clearTurtles();
        this.clearPatches();
        this.clearGlobals();
    }

    public final void clearPatches() {
        int variablesLength = this.patches.agents[0].variables.length;
        int i = 0;
        while (i < this.patches.count()) {
            Patch patch = (Patch)this.patches.agents[i];
            patch.pcolorDoubleUnchecked(Color.BOXED_BLACK);
            patch.label(NullLabel.theNullLabel);
            patch.labelColor(Color.BOXED_WHITE);
            try {
                int j = 5;
                while (j < variablesLength) {
                    patch.setPatchVariable(j, Utils.ZERO_DOUBLE);
                    ++j;
                }
            }
            catch (AgentException ex) {
                Exceptions.handle(ex);
            }
            ++i;
        }
        this.patchesAllBlack = true;
    }

    public final void clearTurtles() {
        Iterator iter;
        if (this.program.breeds != null) {
            iter = this.program.breeds.values().iterator();
            while (iter.hasNext()) {
                ((AgentSet)iter.next()).clear();
            }
        }
        iter = this.turtles.iterator();
        while (iter.hasNext()) {
            Turtle turtle = (Turtle)iter.next();
            turtle.id(-1);
        }
        this.turtles.clear();
        Agent[] agents = this.patches.agents;
        int i = 0;
        while (i < this.patches.count()) {
            ((Patch)agents[i]).turtlesHere.clear();
            ++i;
        }
    }

    public final void clearGlobals() {
        int j = this.program().interfaceGlobals.size();
        while (j < this.observer.variables.length) {
            this.observer.setObserverVariable(j, Utils.ZERO);
            ++j;
        }
    }

    public final void realloc() {
        Agent agent;
        Iterator breedNames = this.program.breeds.keySet().iterator();
        while (breedNames.hasNext()) {
            String breedName = (String)breedNames.next();
            AgentSet breed = (AgentSet)this.oldProgram.breeds.get(breedName);
            if (breed == null) {
                Map map = this.program.breeds;
                Class clazz = class$org$nlogo$agent$Turtle;
                if (clazz == null) {
                    clazz = World.class("[Lorg.nlogo.agent.Turtle;", false);
                }
                map.put(breedName, new AgentSet(clazz, 100, breedName.toUpperCase(), true, this));
                continue;
            }
            this.program.breeds.put(breedName, breed);
        }
        try {
            if (this.turtles != null) {
                int i = 0;
                while (i < this.turtles.agents.length) {
                    agent = this.turtles.agents[i];
                    if (agent != null) {
                        agent.realloc(true);
                    }
                    ++i;
                }
            }
        }
        catch (AgentException ex) {
            Exceptions.handle(ex);
        }
        try {
            if (this.patches != null) {
                int i = 0;
                while (i < this.patches.agents.length) {
                    agent = this.patches.agents[i];
                    if (agent != null) {
                        agent.realloc(true);
                    }
                    ++i;
                }
            }
        }
        catch (AgentException ex) {
            Exceptions.handle(ex);
        }
        this.observer.realloc(true);
        this.setUpBreedShapes(false);
    }

    public final double[][] getPatchScratch() {
        if (this.patchScratch == null) {
            this.patchScratch = new double[2 * this.screenEdgeX + 1][2 * this.screenEdgeY + 1];
        }
        return this.patchScratch;
    }

    public final int indexOfVariable(Class agentClass, String name) {
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = World.class("[Lorg.nlogo.agent.Observer;", false);
        }
        if (agentClass == clazz) {
            return this.observerOwnsIndexOf(name);
        }
        Class clazz2 = class$org$nlogo$agent$Turtle;
        if (clazz2 == null) {
            clazz2 = class$org$nlogo$agent$Turtle = World.class("[Lorg.nlogo.agent.Turtle;", false);
        }
        if (agentClass == clazz2) {
            return this.turtlesOwnIndexOf(name);
        }
        return this.patchesOwnIndexOf(name);
    }

    public final int indexOfVariable(Agent agent, String name) {
        if (agent instanceof Observer) {
            return this.observerOwnsIndexOf(name);
        }
        if (agent instanceof Turtle) {
            int result;
            AgentSet breed = ((Turtle)agent).getBreed();
            if (breed != this.turtles && (result = this.breedsOwnIndexOf(breed, name)) != -1) {
                return result;
            }
            return this.turtlesOwnIndexOf(name);
        }
        return this.patchesOwnIndexOf(name);
    }

    public final String turtlesOwnNameAt(int index) {
        return (String)this.program.turtlesOwn.get(index);
    }

    public final int turtlesOwnIndexOf(String name) {
        return this.program.turtlesOwn.indexOf(name);
    }

    public final int oldTurtlesOwnIndexOf(String name) {
        return this.oldProgram.turtlesOwn.indexOf(name);
    }

    public final String breedsOwnNameAt(AgentSet breed, int index) {
        List breedOwns = (List)this.program.breedsOwn.get(breed.printName());
        return (String)breedOwns.get(index - this.program.turtlesOwn.size());
    }

    public final int breedsOwnIndexOf(AgentSet breed, String name) {
        List breedOwns = (List)this.program.breedsOwn.get(breed.printName());
        if (breedOwns == null) {
            return -1;
        }
        int result = breedOwns.indexOf(name);
        if (result == -1) {
            return -1;
        }
        return this.program.turtlesOwn.size() + result;
    }

    final int oldBreedsOwnIndexOf(AgentSet breed, String name) {
        List breedOwns = (List)this.oldProgram.breedsOwn.get(breed.printName());
        if (breedOwns == null) {
            return -1;
        }
        int result = breedOwns.indexOf(name);
        if (result == -1) {
            return -1;
        }
        return this.oldProgram.turtlesOwn.size() + result;
    }

    public final String patchesOwnNameAt(int index) {
        return (String)this.program.patchesOwn.get(index);
    }

    public final int patchesOwnIndexOf(String name) {
        return this.program.patchesOwn.indexOf(name);
    }

    public final String observerOwnsNameAt(int index) {
        return (String)this.program.globals.get(index);
    }

    public final int observerOwnsIndexOf(String name) {
        return this.program.globals.indexOf(name);
    }

    public final boolean isBreed(AgentSet breed) {
        return this.program.breeds.containsValue(breed);
    }

    public final AgentSet getBreed(String breedName) {
        return (AgentSet)this.program.breeds.get(breedName);
    }

    public final int getVariablesArraySize(Observer observer) {
        return this.program.globals.size();
    }

    public final int getVariablesArraySize(Patch patch) {
        return this.program.patchesOwn.size();
    }

    public final int getVariablesArraySize(Turtle turtle, AgentSet breed) {
        if (breed == this.turtles) {
            return this.program.turtlesOwn.size();
        }
        List breedOwns = (List)this.program.breedsOwn.get(breed.printName());
        return this.program.turtlesOwn.size() + breedOwns.size();
    }

    public final String checkShapeName(String name) {
        if (this.shapeList.exists(name = name.toLowerCase())) {
            return name;
        }
        return null;
    }

    public final void invalidateTurtleShape(Shape shapeToInvalidate) {
        Iterator iter = this.turtles.iterator();
        while (iter.hasNext()) {
            Turtle turtle = (Turtle)iter.next();
            if (turtle.cachedShape() == null || !turtle.cachedShape().equals(shapeToInvalidate)) continue;
            turtle.cachedShape(null);
        }
    }

    public final Map getBreeds() {
        return this.program.breeds;
    }

    public final boolean breedOwns(AgentSet breed, String name) {
        if (breed == this.turtles) {
            return false;
        }
        List breedOwns = (List)this.program.breedsOwn.get(breed.printName());
        return breedOwns.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setUpBreedShapes(boolean clear) {
        Object object = this.breedShapesLock;
        synchronized (object) {
            HashMap<String, String> newBreedShapes;
            block5: {
                if (clear || this.breedShapes == null) {
                    this.breedShapes = new HashMap();
                }
                newBreedShapes = new HashMap<String, String>();
                if (this.program.breeds == null) break block5;
                Iterator iter = this.program.breeds.values().iterator();
                while (true) {
                    String breedName;
                    block6: {
                        if (iter.hasNext()) break block6;
                    }
                    String oldShape = (String)this.breedShapes.get(breedName = ((AgentSet)iter.next()).printName());
                    newBreedShapes.put(breedName, oldShape == null ? "__default" : oldShape);
                }
                String oldShape = (String)this.breedShapes.get("TURTLES");
                newBreedShapes.put("TURTLES", oldShape == null ? "default" : oldShape);
            }
            this.breedShapes = newBreedShapes;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void removeFromBreedShapes(String shapeName) {
        Object object = this.breedShapesLock;
        synchronized (object) {
            block4: {
                if (!this.breedShapes.containsValue(shapeName)) break block4;
                Set entries = this.breedShapes.entrySet();
                Iterator iter = entries.iterator();
                while (iter.hasNext()) {
                    Map.Entry breedShapePair = iter.next();
                    if (!breedShapePair.getValue().equals(shapeName)) continue;
                    breedShapePair.setValue("__default");
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String breedShape(AgentSet breed) {
        Object object = this.breedShapesLock;
        synchronized (object) {
            String result = (String)this.breedShapes.get(breed.printName());
            if (!result.equals("__default")) return result;
            return (String)this.breedShapes.get("TURTLES");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setBreedShape(AgentSet breed, String shapeName) {
        Object object = this.breedShapesLock;
        synchronized (object) {
            this.breedShapes.put(breed.printName(), shapeName);
            return;
        }
    }

    public final Program program() {
        return this.program;
    }

    public final void program(Program program) {
        if (program == null) {
            throw new NullPointerException("World.program cannot be set to null");
        }
        this.program = program;
    }

    public final Program oldProgram() {
        return this.oldProgram;
    }

    public final void oldProgram(Program program) {
        this.oldProgram = program;
    }

    public final boolean displayOn() {
        return this.displayOn;
    }

    public final void displayOn(boolean displayOn) {
        this.displayOn = displayOn;
    }

    public final void resetTimer() {
        this.timer = System.currentTimeMillis();
    }

    public final double getTimer() {
        return (double)(System.currentTimeMillis() - this.timer) / 1000.0;
    }

    public final long checksum() {
        CRC32 sum = new CRC32();
        this.addAgentToChecksum(sum, this.observer);
        Iterator iter = this.patches.iterator();
        while (iter.hasNext()) {
            this.addAgentToChecksum(sum, (Patch)iter.next());
        }
        iter = this.turtles.iterator();
        while (iter.hasNext()) {
            this.addAgentToChecksum(sum, (Turtle)iter.next());
        }
        return sum.getValue();
    }

    private final void addAgentToChecksum(CRC32 sum, Agent agent) {
        int i = 0;
        while (i < agent.variables.length) {
            this.addLogoObjectToChecksum(sum, agent.getVariable(i));
            ++i;
        }
    }

    private final void addLogoObjectToChecksum(CRC32 sum, Object object) {
        sum.update(Integer.toString(object.hashCode()).getBytes());
    }

    public final Object getObserverVariableByName(String var) {
        int index = this.program.globals.indexOf(var.toUpperCase());
        if (index >= 0 && index < this.observer.variables.length) {
            return this.observer.variables[index];
        }
        throw new IllegalArgumentException("\"" + var + "\" not found");
    }

    public final void setObserverVariableByName(String var, Object value) {
        int index;
        if (this.program.globals.contains(var = var.toUpperCase()) && -1 != (index = this.program.globals.indexOf(var)) && index < this.observer.variables.length) {
            this.observer.variables[index] = value;
            return;
        }
        throw new IllegalArgumentException("\"" + var + "\" not found");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.random = new MersenneTwisterFast();
        this.rootsTableSize = 0;
        this.observers = null;
        this.observer = null;
        this.patches = null;
        this.turtles = null;
        this.patchesAllBlack = true;
        this.patchesWithLabels = 0;
        this.breedShapesLock = new Object();
        this.breedShapes = null;
        this.program = new Program();
        this.oldProgram = new Program();
        this.displayOn = true;
        this.timer = System.currentTimeMillis();
    }

    public World(Shape defaultShape) {
        this.this();
        this.shapeList = defaultShape == null ? new DummyShapeList() : new ShapeList(defaultShape);
        this.observer = new Observer(this);
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = World.class("[Lorg.nlogo.agent.Observer;", false);
        }
        this.observers = new AgentSet(clazz, 1, "observers", false, this);
        this.observers.add(this.observer);
    }
}

