/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.nlogo.agent.Agent;
import org.nlogo.app.Benchmarker;
import org.nlogo.app.DirtyMonitor;
import org.nlogo.app.EditMenu;
import org.nlogo.app.EditorColorizer;
import org.nlogo.app.FileMenu;
import org.nlogo.app.HelpMenu;
import org.nlogo.app.InterfacePanel;
import org.nlogo.app.MacHandlers;
import org.nlogo.app.PopUpManager;
import org.nlogo.app.Splash;
import org.nlogo.app.Tabs;
import org.nlogo.app.ToolsMenu;
import org.nlogo.app.WidgetWrapper;
import org.nlogo.app.ZoomMenu;
import org.nlogo.app.agentmon.MonitorManager;
import org.nlogo.awt.Utils;
import org.nlogo.compiler.CompilerException;
import org.nlogo.event.AppEvent;
import org.nlogo.event.BeforeLoadEvent;
import org.nlogo.event.CompileAllEvent;
import org.nlogo.event.Event;
import org.nlogo.event.EventLinkContainer;
import org.nlogo.event.IconifiedEvent;
import org.nlogo.event.LoadBeginEvent;
import org.nlogo.event.LoadEndEvent;
import org.nlogo.event.ModelSavedEvent;
import org.nlogo.event.SwitchedTabsEvent;
import org.nlogo.hubnet.HubNetManager;
import org.nlogo.lab.gui.LabManager;
import org.nlogo.nvm.LogoException;
import org.nlogo.swing.OptionDialog;
import org.nlogo.util.Exceptions;
import org.nlogo.util.ExceptionsHandler;
import org.nlogo.util.FileIO;
import org.nlogo.util.UserCancelException;
import org.nlogo.util.Version;
import org.nlogo.window.ButtonWidget;
import org.nlogo.window.CompilerManager;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.RuntimeErrorDialog;
import org.nlogo.window.Widget;
import org.nlogo.workspace.Evaluator;
import org.nlogo.workspace.HubNetInterface;
import org.nlogo.workspace.Library;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class App
extends JFrame
implements ExceptionsHandler,
EventLinkContainer,
IconifiedEvent.Raiser,
CompileAllEvent.Raiser,
AppEvent.Handler,
BeforeLoadEvent.Handler,
LoadBeginEvent.Handler,
LoadEndEvent.Handler,
ModelSavedEvent.Handler,
SwitchedTabsEvent.Handler {
    private static boolean benchmarksMode = false;
    private static String commandLineModel;
    public static App app;
    public final GUIWorkspace workspace;
    final Tabs tabs;
    final DirtyMonitor dirtyMonitor;
    HelpMenu helpMenu;
    FileMenu fileMenu;
    ZoomMenu zoomMenu;
    final MonitorManager monitorManager;
    private LabManager labManager;
    final PopUpManager popUpManager;
    private Benchmarker benchmarker;
    private boolean wasAtPreferredSizeBeforeLoadBegan;
    private Dimension preferredSizeAtLoadEndTime;
    final Action behaviorSpaceAction;
    private final List linkComponents;
    static /* synthetic */ Class class$org$nlogo$agent$Observer;

    public static void main(String[] args) {
        System.setProperty("apple.awt.showGrowBox", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        if (System.getProperty("os.name").startsWith("Mac")) {
            MacHandlers.init();
        }
        Workspace.isApp(true);
        Workspace.isApplet(false);
        org.nlogo.swing.Utils.detectBadJVMs();
        App.processCommandLineArguments(args);
        Splash.beginSplash();
        app = new App();
        Utils.invokeLater(new Runnable(){

            public final void run() {
                app.finishStartup();
            }
        });
    }

    private final void finishStartup() {
        this.tabs.init();
        JMenuBar menuBar = new JMenuBar();
        this.fileMenu = new FileMenu(this);
        menuBar.add(this.fileMenu);
        menuBar.add(new EditMenu());
        menuBar.add(new ToolsMenu(this));
        this.zoomMenu = new ZoomMenu(this);
        menuBar.add(this.zoomMenu);
        menuBar.add(this.tabs.tabsMenu);
        this.helpMenu = new HelpMenu();
        menuBar.add(this.helpMenu);
        try {
            if (Workspace.isApp()) {
                menuBar.setHelpMenu(this.helpMenu);
            }
        }
        catch (Error e) {
            Exceptions.ignore(e);
        }
        this.setJMenuBar(menuBar);
        RuntimeErrorDialog.init(this);
        this.pack();
        this.loadDefaultModel();
        this.smartPack(this.getPreferredSize());
        if (!System.getProperty("os.name").startsWith("Mac")) {
            Utils.center(this, null);
        }
        Splash.endSplash();
        this.setVisible(true);
        if (System.getProperty("os.name").startsWith("Mac")) {
            MacHandlers.ready(this);
        }
        if (benchmarksMode) {
            this.benchmarker.runAllBenchmarks(-1, true);
        }
    }

    private final void loadDefaultModel() {
        try {
            if (commandLineModel != null) {
                this.libraryOpen(commandLineModel);
            } else {
                this.fileMenu.newModel();
            }
        }
        catch (UserCancelException ex) {
            Exceptions.handle(ex);
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    private static final void processCommandLineArguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--events")) {
                Event.logEvents = true;
            } else if (args[i].equals("--benchmarks")) {
                benchmarksMode = true;
            } else if (args[i].equals("--open")) {
                commandLineModel = new File(args[++i]).getAbsolutePath();
            } else if (args[i].equals("--version")) {
                System.out.println(Version.version());
                System.exit(0);
            } else if (args[i].equals("--shortversion")) {
                System.out.println(Version.versionNoRev());
                System.exit(0);
            }
            ++i;
        }
    }

    public void handleAppEvent(AppEvent e) {
        Object[] args = e.getArgs();
        switch (e.getType()) {
            case 0: {
                this.reload();
                break;
            }
            case 1: {
                this.magicOpen((String)args[0]);
                break;
            }
        }
    }

    private final void reload() {
        int modelType = this.workspace.getModelType();
        String path = this.workspace.getModelPath();
        try {
            if (modelType != 0 && path != null) {
                this.openFromSource(FileIO.file2String(path), path, modelType);
            } else {
                this.commandLater("print \"can't, new model\"");
            }
        }
        catch (IOException e) {
            Exceptions.handle(e);
        }
        catch (CompilerException e) {
            Exceptions.handle(e);
        }
    }

    private final void magicOpen(String name) {
        try {
            List matches = Library.findModelsBySubstring(name);
            if (matches.size() == 0) {
                this.commandLater("print \"no models matching \\\"" + name + "\\\" found\"");
            } else {
                Object fullName = null;
                if (matches.size() == 1) {
                    fullName = (String)matches.get(0);
                } else {
                    Object[] options = matches.toArray(new String[matches.size()]);
                    int i = OptionDialog.showAsList(Utils.getFrame(this), "Magic Model Matcher", "You must choose!", options);
                    if (i != -1) {
                        fullName = options[i];
                    }
                }
                if (fullName != null) {
                    final String path = Library.getModelPath((String)fullName);
                    final String source = FileIO.file2String(path);
                    Utils.invokeLater(new Runnable(){

                        public final void run() {
                            App.this.openFromSource(source, path, 2);
                        }
                    });
                }
            }
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
        catch (CompilerException error) {
            Exceptions.handle(error);
        }
    }

    public void handleSwitchedTabsEvent(SwitchedTabsEvent e) {
        if (e.newTab() == this.tabs.interfaceTab) {
            this.monitorManager.showAll();
            this.toFront();
        } else if (e.oldTab() == this.tabs.interfaceTab) {
            this.monitorManager.hideAll();
        }
    }

    public void handleModelSavedEvent(ModelSavedEvent e) {
        this.workspace.modelSaved(e.getModelPath());
        RuntimeErrorDialog.modelName = this.workspace.modelNameForDisplay();
        if (Workspace.isApp()) {
            this.setTitle(this.makeFrameTitle());
        }
    }

    public void handleLoadBeginEvent(LoadBeginEvent e) {
        String modelName;
        if (this.labManager != null) {
            this.labManager.close();
        }
        RuntimeErrorDialog.modelName = modelName = this.workspace.modelNameForDisplay();
        if (Workspace.isApp()) {
            this.setTitle(this.makeFrameTitle());
        }
    }

    public void handleBeforeLoadEvent(BeforeLoadEvent e) {
        boolean bl = false;
        if (this.preferredSizeAtLoadEndTime == null || this.getSize().equals(this.preferredSizeAtLoadEndTime) || this.getSize().equals(this.getPreferredSize())) {
            bl = true;
        }
        this.wasAtPreferredSizeBeforeLoadBegan = bl;
    }

    public void handleLoadEndEvent(LoadEndEvent e) {
        if (Workspace.isApp()) {
            this.tabs.interfaceTab.getInterfacePanel().revalidate();
            if (this.wasAtPreferredSizeBeforeLoadBegan) {
                this.smartPack(this.getPreferredSize());
            } else {
                int newHeight;
                Dimension currentSize = this.getSize();
                Dimension preferredSize = this.getPreferredSize();
                int newWidth = currentSize.width;
                if (preferredSize.width > newWidth) {
                    newWidth = preferredSize.width;
                }
                if (preferredSize.height > (newHeight = currentSize.height)) {
                    newHeight = preferredSize.height;
                }
                if (newWidth != currentSize.width || newHeight != currentSize.height) {
                    this.smartPack(new Dimension(newWidth, newHeight));
                }
            }
            this.preferredSizeAtLoadEndTime = this.getPreferredSize();
        }
        this.tabs.interfaceTab.requestFocus();
    }

    public void requestFocus() {
        this.toFront();
        this.tabs.requestFocus();
    }

    void smartPack(Dimension targetSize) {
        Rectangle maxBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int maxX = maxBounds.x + maxBounds.width;
        int maxY = maxBounds.y + maxBounds.height;
        int newWidth = StrictMath.min(targetSize.width, maxBounds.width);
        int newHeight = StrictMath.min(targetSize.height, maxBounds.height);
        int moveLeft = StrictMath.max(0, this.getLocation().x + newWidth - maxX);
        int moveUp = StrictMath.max(0, this.getLocation().y + newHeight - maxY);
        int newX = StrictMath.max(maxBounds.x, this.getLocation().x - moveLeft);
        int newY = StrictMath.max(maxBounds.y, this.getLocation().y - moveUp);
        newWidth = StrictMath.min(newWidth, maxX - newX);
        newHeight = StrictMath.min(newHeight, maxY - newY);
        this.setBounds(newX, newY, newWidth, newHeight);
        this.validate();
        this.tabs.requestFocus();
    }

    private final String makeFrameTitle() {
        switch (this.workspace.getModelType()) {
            case 0: 
            case 2: {
                return "NetLogo: " + this.workspace.modelNameForDisplay();
            }
            case 1: 
            case 3: {
                return "NetLogo: " + this.workspace.modelNameForDisplay() + " {" + this.workspace.getModelDir() + '}';
            }
        }
        return "NetLogo: " + this.workspace.modelNameForDisplay();
    }

    public void handle(final Throwable throwable) {
        try {
            boolean logo = throwable instanceof LogoException;
            final Thread thread = Thread.currentThread();
            if (logo) {
                Utils.invokeLater(new Runnable(){

                    public final void run() {
                        RuntimeErrorDialog.show("Runtime Error", null, null, thread, throwable);
                    }
                });
            } else if (RuntimeErrorDialog.suppressJavaExceptionDialogs) {
                throwable.printStackTrace();
            } else {
                throwable.printStackTrace();
                if (!RuntimeErrorDialog.alreadyVisible()) {
                    Utils.invokeLater(new Runnable(){

                        public final void run() {
                            RuntimeErrorDialog.show("Internal Error", null, null, thread, throwable);
                        }
                    });
                }
            }
        }
        catch (RuntimeException e2) {
            e2.printStackTrace();
        }
    }

    public void open(String path) {
        Utils.mustBeEventDispatchThread();
        this.fileMenu.openFromPath(path, 1);
    }

    void libraryOpen(String path) {
        Utils.mustBeEventDispatchThread();
        this.fileMenu.openFromPath(path, 2);
    }

    public void openFromSource(String name, String source) {
        this.openFromSource(source, name, 1);
    }

    void openFromSource(String source, String path, int modelType) {
        Utils.mustBeEventDispatchThread();
        try {
            this.fileMenu.openFromSource(source, path, "Loading...", modelType);
        }
        catch (UserCancelException ex) {
            Exceptions.ignore(ex);
        }
    }

    public void command(String source) throws CompilerException {
        Utils.cantBeEventDispatchThread();
        Evaluator evaluator = this.workspace.evaluator;
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = App.class("[Lorg.nlogo.agent.Observer;", false);
        }
        evaluator.evaluateCommands(source, clazz, true);
    }

    public void commandLater(String source) throws CompilerException {
        Evaluator evaluator = this.workspace.evaluator;
        Class clazz = class$org$nlogo$agent$Observer;
        if (clazz == null) {
            clazz = class$org$nlogo$agent$Observer = App.class("[Lorg.nlogo.agent.Observer;", false);
        }
        evaluator.evaluateCommands(source, clazz, false);
    }

    public Object report(String source) throws CompilerException {
        Utils.cantBeEventDispatchThread();
        return this.workspace.evaluator.evaluateReporter(source, this.workspace.world.observer());
    }

    public String getProcedures() {
        Utils.mustBeEventDispatchThread();
        return this.tabs.proceduresTab.innerSource();
    }

    public void setProcedures(String source) {
        Utils.mustBeEventDispatchThread();
        this.tabs.proceduresTab.innerSource(source);
    }

    public void compile() {
        Utils.mustBeEventDispatchThread();
        new CompileAllEvent(this).raise();
    }

    public void selectTab(int number) {
        Utils.mustBeEventDispatchThread();
        this.tabs.setSelectedIndex(number);
    }

    public void pressButton(String name) {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException("can't call on event thread");
        }
        final ButtonWidget button = this.findButton(name);
        try {
            if (button.forever()) {
                button.foreverOn(button.foreverOn() ^ true);
                Utils.invokeAndWait(new Runnable(){

                    public final void run() {
                        button.buttonUp(button.foreverOn() ^ true);
                        button.action();
                    }
                });
            } else {
                Utils.invokeAndWait(new Runnable(){

                    public final void run() {
                        button.buttonUp(false);
                        button.action();
                    }
                });
                while (button.running()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        Exceptions.ignore(ex);
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            Exceptions.handle(ex);
            return;
        }
    }

    public void makeWidget(String text) {
        Utils.mustBeEventDispatchThread();
        InterfacePanel iP = this.tabs.interfaceTab.getInterfacePanel();
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        String[] strings = result.toArray(new String[result.size()]);
        iP.loadWidget(strings, Version.version());
    }

    private final ButtonWidget findButton(String name) {
        InterfacePanel iP = this.tabs.interfaceTab.getInterfacePanel();
        int i = 0;
        while (i < iP.getComponentCount()) {
            ButtonWidget button;
            Widget comp;
            if (iP.getComponent(i) instanceof WidgetWrapper && (comp = ((WidgetWrapper)iP.getComponent(i)).widget()) instanceof ButtonWidget && name.equals((button = (ButtonWidget)comp).displayName())) {
                return button;
            }
            ++i;
        }
        throw new RuntimeException("button '" + name + "' not found");
    }

    public void addLinkComponent(Object c) {
        this.linkComponents.add(c);
    }

    public Object[] getLinkComponents() {
        return this.linkComponents.toArray();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.labManager = null;
        this.wasAtPreferredSizeBeforeLoadBegan = false;
        this.behaviorSpaceAction = new AbstractAction("BehaviorSpace"){

            public final void actionPerformed(ActionEvent e) {
                if (App.this.labManager == null) {
                    App.this.labManager = new LabManager(App.this.workspace, new EditorColorizer(App.this.workspace));
                }
                App.this.labManager.show();
            }
        };
        this.linkComponents = new ArrayList();
    }

    protected App() {
        super("NetLogo");
        this.this();
        this.setIconImage(Utils.loadImageResource("/images/arrowhead.gif"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                App.this.fileMenu.quit();
            }

            public final void windowIconified(WindowEvent e) {
                new IconifiedEvent(App.this, App.this, true).raise();
            }

            public final void windowDeiconified(WindowEvent e) {
                new IconifiedEvent(App.this, App.this, false).raise();
            }
        });
        org.nlogo.swing.Utils.setSystemLookAndFeel();
        this.getContentPane().setLayout(new BorderLayout());
        this.workspace = new GUIWorkspace(0, this, new Workspace.HubNetManagerFactory(){

            public final HubNetInterface newInstance(Workspace workspace) {
                return new HubNetManager(workspace);
            }
        }){

            public final void inspectAgent(Class agentClass, Agent agent) {
                App.this.monitorManager.inspect(agentClass, agent);
            }
        };
        this.addLinkComponent(this.workspace);
        this.dirtyMonitor = new DirtyMonitor(this);
        this.addLinkComponent(this.dirtyMonitor);
        this.monitorManager = new MonitorManager(this.workspace);
        this.addLinkComponent(this.monitorManager);
        this.tabs = new Tabs(this.workspace);
        this.getContentPane().add((Component)this.tabs, "Center");
        this.popUpManager = new PopUpManager(this.workspace);
        this.addLinkComponent(this.popUpManager);
        CompilerManager compilerManager = new CompilerManager(this.workspace, this.tabs.proceduresTab);
        this.addLinkComponent(compilerManager);
        this.benchmarker = new Benchmarker(this);
        this.addLinkComponent(this.benchmarker);
        Exceptions.setHandler(this);
    }
}

