/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Frame;
import java.io.IOException;
import org.nlogo.app.InterfacePanel;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.util.Exceptions;
import org.nlogo.util.FileIO;
import org.nlogo.util.Utils;
import org.nlogo.util.Version;

strictfp class AppletSaver {
    static void save(Frame frame, InterfacePanel iP, String modelName, final String path, String fileName, String infoText) {
        final StringBuffer buf = new StringBuffer();
        int width = iP.getPreferredSize((boolean)true).width;
        int height = iP.getPreferredSize((boolean)true).height;
        AppletSaver.build(buf, modelName, fileName, width, height, infoText);
        new ModalProgressTask(frame, new Runnable(){

            public final void run() {
                try {
                    FileIO.writeFile(path, buf.toString());
                }
                catch (IOException ex) {
                    Exceptions.handle(ex);
                }
            }
        }, "Saving...");
        OptionDialog.show(frame, "Applet Saved", "The HTML file you have saved contains instructions for arranging the necessary files on your web server.  You may view or edit the HTML file in any text editor.", new String[]{"OK"});
    }

    private static final void build(StringBuffer buf, String modelName, String fileName, int width, int height, String infoText) {
        String eol = System.getProperty("line.separator");
        buf.append("<html>" + eol);
        buf.append("<head>" + eol);
        buf.append("<title>" + modelName + "</title>" + eol);
        buf.append("</head>" + eol);
        buf.append("<body>" + eol);
        buf.append(eol);
        buf.append("<p>This page was automatically generated by " + Version.version() + '.' + eol);
        buf.append("Questions, problems?  Contact <a href=\"mailto:feedback@ccl.northwestern.edu\"> feedback@ccl.northwestern.edu</a>.</p>" + eol);
        buf.append(eol);
        buf.append("<p>The applet requires Java 1.4.1 or higher to run.  It will not run on" + eol);
        buf.append("Windows 95 or Mac OS 8 or 9.  Mac users must have OS X 10.2.6 or higher and use" + eol);
        buf.append("a browser that supports Java 1.4 applets (Safari works, IE does not)." + eol);
        buf.append("On other operating systems, you may obtain the latest Java plugin from" + eol);
        buf.append("<a href=\"http://java.sun.com/getjava/download.html\">Sun's Java site</a>.</p>" + eol);
        buf.append(eol);
        buf.append("<p><hr>" + eol);
        buf.append(eol);
        buf.append("<p><font size=\"-1\">In order for this to work, this file, your model file" + eol);
        buf.append("(" + fileName + "), and the file NetLogoLite.jar" + eol);
        buf.append("must all be in the same directory.  (You can copy NetLogoLite.jar" + eol);
        buf.append("from the directory where you installed NetLogo.)</font></p>" + eol);
        buf.append(eol);
        buf.append("<p><font size=\"-1\">On some systems, you can test the applet locally on your computer" + eol);
        buf.append("before uploading it to a web server.  It doesn't work on all systems," + eol);
        buf.append("though, so if it doesn't work from your hard drive, please try" + eol);
        buf.append("uploading it to a web server.</font></p>" + eol);
        buf.append(eol);
        buf.append("<p><font size=\"-1\">You don't need to include everything in this file in your page." + eol);
        buf.append("If you want, you can just take the HTML code beginning with" + eol);
        buf.append("&lt;applet&gt; and ending with &lt;/applet&gt;, and paste it into any HTML" + eol);
        buf.append("file you want.  It's even OK to put multiple &lt;applet&gt; tags" + eol);
        buf.append("on a single page.</font></p>" + eol);
        buf.append(eol);
        buf.append("<p><font size=\"-1\">If NetLogoLite.jar and your model are in different" + eol);
        buf.append("directories, you must modify the archive= and value= lines" + eol);
        buf.append("in the HTML code to point to their actual locations." + eol);
        buf.append("(For example, if you have multiple applets in different" + eol);
        buf.append("directories on the same web server, you may want to put " + eol);
        buf.append("a single copy of NetLogoLite.jar in one central place and" + eol);
        buf.append("change the archive= lines of all the HTML files to point" + eol);
        buf.append("to that one central copy.  This will save disk space for" + eol);
        buf.append("you and download time for your user.)</font></p>" + eol);
        buf.append(eol);
        buf.append("<p>" + eol);
        buf.append("<applet code=\"org.nlogo.window.Applet\"" + eol);
        buf.append("        archive=\"NetLogoLite.jar\"" + eol);
        buf.append("        width=\"" + width + "\" height=\"" + height + "\">" + eol);
        buf.append("  <param name=\"DefaultModel\"" + eol);
        buf.append("         value=\"" + Utils.escapeSpacesInURL(fileName) + "\">" + eol);
        buf.append("</applet>" + eol);
        buf.append("</p>" + eol);
        buf.append(eol);
        buf.append("<p>created with" + eol);
        buf.append("<a target=\"_blank\" href=\"http://ccl.northwestern.edu/netlogo/\">NetLogo</a></p>" + eol);
        buf.append(eol);
        buf.append("<p>view/download model file:" + eol);
        buf.append("<a href=\"" + Utils.escapeSpacesInURL(fileName) + "\">" + fileName + "</a>" + eol + "</p>");
        buf.append(eol);
        buf.append("<p><tt>" + Utils.replace(infoText, "\n", "\n<br>") + "</tt></p>" + eol);
        buf.append(eol);
        buf.append("</body>" + eol);
        buf.append("</html>" + eol);
    }

    private AppletSaver() {
        throw new IllegalStateException();
    }
}

