/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.io.File;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import org.nlogo.agent.LogoList;
import org.nlogo.app.App;
import org.nlogo.awt.Utils;
import org.nlogo.command.Procedure;
import org.nlogo.compiler.CompilerException;
import org.nlogo.event.AppEvent;
import org.nlogo.util.Exceptions;
import org.nlogo.util.Version;
import org.nlogo.workspace.Library;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class Benchmarker
implements AppEvent.Handler {
    private boolean compilingLots;
    private final App app;

    public void handleAppEvent(AppEvent e) {
        Object[] args = e.getArgs();
        switch (e.getType()) {
            case 2: {
                this.benchmark((String)args[0], (Integer)args[1], (Boolean)args[2]);
                break;
            }
            case 3: {
                this.dumpModels();
                break;
            }
            case 4: {
                this.makePreviews((Boolean)args[0]);
                break;
            }
            case 5: {
                this.compileLots((Integer)args[0], (LogoList)args[1]);
                break;
            }
        }
    }

    void benchmark(final String name, final int iterations, final boolean withGraphics) {
        new Thread("Benchmarker"){

            public final void run() {
                System.out.println("@@@@@@ benchmarking " + Version.version());
                if (name == null) {
                    Benchmarker.this.runAllBenchmarks(iterations, withGraphics);
                } else {
                    Benchmarker.this.runBenchmark(name.equals("") ? "" : "models/benchmarks/" + name + ".nlogo", iterations, withGraphics);
                }
            }
        }.start();
    }

    private final void dumpModels() {
        String[] modelPaths = Library.getModelPaths();
        int i = 0;
        while (i < modelPaths.length) {
            this.app.libraryOpen(modelPaths[i]);
            this.dumpModel();
            ++i;
        }
    }

    private final void dumpModel() {
        String path = this.app.workspace.getModelPath();
        if (path.toUpperCase().indexOf("HUBNET") != -1) {
            return;
        }
        if (!this.app.workspace.world.program().getProcedures().hasNext()) {
            System.out.println("FAILED: " + path);
            return;
        }
        System.out.println();
        System.out.println();
        System.out.println("=============================");
        System.out.println("MODEL: " + path);
        System.out.println();
        System.out.println(this.app.workspace.world.program().dump());
        Iterator procs = this.app.workspace.world.program().getProcedures();
        while (procs.hasNext()) {
            Procedure proc = (Procedure)procs.next();
            System.out.println(proc.dump());
        }
    }

    private final void makePreviews(boolean allModels) {
        if (allModels) {
            new Thread(){

                public final void run() {
                    String[] modelPaths = Library.getModelPaths();
                    int i = 0;
                    while (i < modelPaths.length) {
                        String previewPath;
                        final String modelPath = modelPaths[i];
                        if (modelPath.toUpperCase().indexOf("HUBNET") == -1 && modelPath.toUpperCase().indexOf("P2P") == -1 && modelPath.toUpperCase().indexOf("/TEXAS/") == -1 && modelPath.toUpperCase().indexOf("/ENACTMENT 2002/") == -1 && modelPath.toUpperCase().indexOf("/BENCHMARKS/") == -1 && !new File(previewPath = modelPath.substring(0, modelPath.lastIndexOf(".nlogo")) + ".png").exists()) {
                            try {
                                Utils.invokeAndWait(new Runnable(){

                                    public final void run() {
                                        Benchmarker.this.app.libraryOpen(modelPath);
                                    }
                                });
                            }
                            catch (InterruptedException ex) {
                                Exceptions.handle(ex);
                            }
                            Benchmarker.this.makePreview(previewPath);
                        }
                        ++i;
                    }
                    System.out.println("done!");
                }
            }.start();
        } else {
            new Thread(){

                public final void run() {
                    String modelPath = ((Benchmarker)Benchmarker.this).app.workspace.getModelPath();
                    Benchmarker.this.makePreview(modelPath.substring(0, modelPath.lastIndexOf(".nlogo")) + ".png");
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void makePreview(String previewPath) {
        this.app.workspace.displaySwitchOn(false);
        try {
            try {
                String previewCommands = this.app.workspace.previewCommands;
                if (previewCommands.trim().equals("")) {
                    previewCommands = "setup repeat 75 [ go ]";
                }
                this.app.command("random-seed 0");
                this.app.command(previewCommands);
                this.app.workspace.displaySwitchOn(true);
                this.app.command("export-graphics \"" + previewPath + '\"');
                System.out.println("GENERATED: " + previewPath);
            }
            catch (CompilerException ex) {
                System.out.println("FAILED: " + previewPath + " (" + ex.getDescription() + ')');
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.app.workspace.displaySwitchOn(true);
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.app.workspace.displaySwitchOn(true);
            return;
        }
    }

    void runAllBenchmarks(int iterations, boolean withGraphics) {
        this.runBenchmark("models/benchmarks/Let Benchmark.nlogo", iterations, false);
        this.runBenchmark("models/benchmarks/Let Inside Ask Benchmark.nlogo", iterations, false);
        this.runBenchmark("models/benchmarks/Ants Benchmark.nlogo", iterations, withGraphics);
        this.runBenchmark("models/benchmarks/Fire Benchmark.nlogo", iterations, withGraphics);
        this.runBenchmark("models/benchmarks/Flocking Benchmark.nlogo", iterations, withGraphics);
        this.runBenchmark("models/benchmarks/GasLab Benchmark.nlogo", iterations, withGraphics);
        this.runBenchmark("models/benchmarks/GasLab New Benchmark.nlogo", iterations, withGraphics);
        this.runBenchmark("models/benchmarks/Ising Benchmark.nlogo", iterations, withGraphics);
        this.runBenchmark("models/benchmarks/Life Benchmark.nlogo", iterations, withGraphics);
        this.runBenchmark("models/benchmarks/Termites Benchmark.nlogo", iterations, withGraphics);
        this.runBenchmark("models/benchmarks/Wolf Sheep Benchmark.nlogo", iterations, withGraphics);
        if (withGraphics) {
            this.runBenchmark("models/benchmarks/WolfSheepShape Benchmark.nlogo", iterations, withGraphics);
        }
        this.runBenchmark("models/benchmarks/CA1D Benchmark.nlogo", iterations, withGraphics);
        this.runBenchmark("models/benchmarks/B-Z Benchmark.nlogo", iterations, withGraphics);
        this.runBenchmark("models/benchmarks/Fire (Big) Benchmark.nlogo", iterations, withGraphics);
        System.out.println("done!");
    }

    private final void runBenchmark(String path, int iterations, boolean withGraphics) {
        try {
            this.runBenchmark2(path, iterations, withGraphics);
        }
        catch (CompilerException error) {
            Exceptions.handle(error);
        }
    }

    private final void runBenchmark2(final String path, int iterations, boolean withGraphics) throws CompilerException {
        if (!path.equals("")) {
            try {
                Utils.invokeAndWait(new Runnable(){

                    public final void run() {
                        Benchmarker.this.app.libraryOpen(path);
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.handle(ex);
                return;
            }
        }
        double average = 0.0;
        double displayOffAverage = 0.0;
        DecimalFormat formatter = new DecimalFormat("0.00");
        DecimalFormat formatter4 = new DecimalFormat("0.0000");
        int j = 0;
        while (j < withGraphics + 1) {
            if (j != 0 || !path.equals("models/benchmarks/WolfSheepShape Benchmark.nlogo")) {
                this.app.command("set display? " + (j == 0 ? "false" : "true"));
                this.app.command("print \"display? = \" + display?");
                System.gc();
                average = 0.0;
                LogoList times = new LogoList();
                int i = 0;
                while (iterations == -1 || i < iterations + 1) {
                    if (i == 1) {
                        this.app.command("print \"that run was a warmup; ignoring\"");
                    }
                    this.app.command("benchmark");
                    double time = ((Number)this.app.report("result")).doubleValue();
                    if (i > 0 || iterations == 0) {
                        times.add(new Double(time));
                        double total = 0.0;
                        int k = 0;
                        while (k < times.size()) {
                            double t = (Double)times.get(k);
                            total += t;
                            ++k;
                        }
                        average = total / (double)times.size();
                        if (iterations == -1 && times.size() >= 2) {
                            double squareOfDifference = 0.0;
                            int k2 = 0;
                            while (k2 < times.size()) {
                                double t = (Double)times.get(k2);
                                squareOfDifference += StrictMath.pow(t - average, 2);
                                ++k2;
                            }
                            double stddev = StrictMath.sqrt(squareOfDifference / (double)times.size());
                            int runs = (int)StrictMath.ceil(StrictMath.pow(1.65 * stddev / (0.005 * average), 2));
                            this.app.command("print \"" + times.size() + '/' + runs + " (mean=" + formatter.format(average) + ", stddev=" + formatter4.format(stddev) + ")\"");
                            double minMinutes = 2;
                            double maxMinutes = 10.0;
                            if (times.size() >= 10 && total > minMinutes * 60.0 && (times.size() >= runs || total > maxMinutes * 60.0)) {
                                if (total > maxMinutes * 60.0) {
                                    System.out.println("warning: stopped after " + maxMinutes + " minutes:");
                                    System.out.println("" + times.size() + '/' + runs + " (mean=" + formatter.format(average) + ", stddev=" + formatter4.format(stddev) + ')');
                                }
                                System.out.println(path + ": " + times.size() + " runs, " + formatter.format(total) + " seconds total");
                                break;
                            }
                        }
                    }
                    ++i;
                }
                this.app.command("print \"average = " + formatter.format(average) + '\"');
                if (j == 0) {
                    displayOffAverage = average;
                }
            }
            ++j;
        }
        if (withGraphics) {
            System.out.println("@@@ " + path.substring(path.lastIndexOf(47) + 1) + ": " + formatter.format(average) + " (" + formatter.format(displayOffAverage) + ')');
        } else {
            System.out.println("@@@ " + path.substring(path.lastIndexOf(47) + 1) + ": (" + formatter.format(displayOffAverage) + ')');
        }
    }

    void compileLots(final int sleepTime, final LogoList buttonNames) {
        this.compilingLots ^= true;
        if (this.compilingLots) {
            new Thread("App/CompileLots"){
                private boolean addingText;
                private String textToAdd;

                private final String text() {
                    return App.app.getProcedures();
                }

                public final void run() {
                    this.setName("compilingLots");
                    System.out.println("compiling lots");
                    int temp = 0;
                    while (Benchmarker.this.compilingLots) {
                        System.out.print("switching to procedures" + (temp % 100 == 0 ? " - " + new Date() : ""));
                        try {
                            Utils.invokeAndWait(new Runnable(){

                                public final void run() {
                                    App.app.selectTab(2);
                                    System.out.print("\tadding/removing text");
                                    addingText = addingText ^ true;
                                    if (addingText) {
                                        App.app.setProcedures(this.text() + textToAdd);
                                    } else {
                                        int textLength = this.text().length();
                                        App.app.setProcedures(this.text().substring(0, textLength - textToAdd.length()));
                                    }
                                }
                            });
                            int randomDelay = (int)(new Random().nextDouble() * 1000.0);
                            System.out.print("\tdelaying " + randomDelay + "...");
                            try {
                                5.sleep(randomDelay);
                            }
                            catch (InterruptedException ie) {
                                Exceptions.handle(ie);
                            }
                            System.out.print("\tswitching to interface");
                            Utils.invokeAndWait(new Runnable(){

                                public final void run() {
                                    App.app.selectTab(0);
                                    System.out.print("\tcompiling...");
                                    App.app.compile();
                                }
                            });
                            int i = 0;
                            while (i < buttonNames.size()) {
                                App.app.pressButton((String)buttonNames.get(i));
                                ++i;
                            }
                        }
                        catch (InterruptedException ex) {
                            Exceptions.handle(ex);
                            Benchmarker.this.compilingLots = false;
                            return;
                        }
                        System.out.println("\tdone compiling - sleeping for " + sleepTime);
                        try {
                            5.sleep(sleepTime);
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace();
                        }
                        ++temp;
                        temp %= 100;
                    }
                    System.out.println("done compiling lots");
                }

                private final /* synthetic */ void this() {
                    this.addingText = false;
                    this.textToAdd = "\nto foo\nshow 1\nend";
                }
                {
                    super($1);
                    this.this();
                }
            }.start();
        }
    }

    private final /* synthetic */ void this() {
        this.compilingLots = false;
    }

    Benchmarker(App app) {
        this.this();
        this.app = app;
    }
}

