/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.nlogo.app.EditorColorizer;
import org.nlogo.app.ErrorDisplay;
import org.nlogo.app.ErrorList;
import org.nlogo.app.ProceduresMenu;
import org.nlogo.app.ProceduresMenuTarget;
import org.nlogo.app.ProceduresTab;
import org.nlogo.app.Tabs;
import org.nlogo.app.cc.CommandLine;
import org.nlogo.compiler.CompilerException;
import org.nlogo.editor.EditorArea;
import org.nlogo.event.CompileAllEvent;
import org.nlogo.event.CompileMoreSourceEvent;
import org.nlogo.event.CompiledEvent;
import org.nlogo.event.DirtyEvent;
import org.nlogo.event.LoadBeginEvent;
import org.nlogo.event.SwitchedTabsEvent;
import org.nlogo.event.ZoomedEvent;
import org.nlogo.nvm.JobOwner;
import org.nlogo.nvm.SourceOwner;
import org.nlogo.swing.FindDialog;
import org.nlogo.swing.Printable;
import org.nlogo.swing.PrinterManager;
import org.nlogo.swing.ToolBar;
import org.nlogo.window.PopUpInterface;
import org.nlogo.workspace.Workspace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class ErrorsTab
extends JPanel
implements ProceduresMenuTarget,
CompileAllEvent.Raiser,
CompileMoreSourceEvent.Raiser,
CompiledEvent.Handler,
LoadBeginEvent.Handler,
SwitchedTabsEvent.Handler,
ZoomedEvent.Handler,
DirtyEvent.Raiser,
Printable {
    private static final String NO_SOURCE = "---";
    private String oldText;
    final EditorArea code;
    private final JLabel locationLabel;
    private ErrorList errorList;
    private Object foregroundView;
    final Action compileAction;
    private final ToolBar toolBar;
    private final JPanel centerPanel;
    private final Tabs tabs;
    ErrorDisplay selectedError;
    private int originalFontSize;
    private double zoomFactor;
    static /* synthetic */ Class class$org$nlogo$app$ErrorsTab;

    public Dimension getPreferredSize() {
        return this.toolBar.getPreferredSize();
    }

    public void requestFocus() {
        if (this.code != null && this.selectedError != null) {
            this.code.requestFocus();
        }
    }

    SourceOwner sourceOwner() {
        return this.selectedError == null ? null : this.selectedError.sourceOwner();
    }

    void clearErrors() {
        this.errorList.removeAll();
        if (this.selectedError != null) {
            this.code.setText("");
            this.code.setEnabled(false);
            this.oldText = "";
            this.locationLabel.setText(NO_SOURCE);
            this.repaint();
            this.selectedError = null;
        }
    }

    private final void addError(String description, CompilerException compilerError, SourceOwner sourceOwner) {
        this.errorList.addError(description, compilerError, sourceOwner);
        if (this.selectedError == null && this.errorList.errors.size() > 0) {
            this.selectError(true);
        }
    }

    private final void setErrors(CompiledEvent e) {
        this.clearErrors();
        SourceOwner sourceOwner = e.sourceOwner();
        CompilerException err = e.getError();
        if (err != null) {
            if (sourceOwner instanceof ProceduresTab) {
                this.addError(err.toString(), err, sourceOwner);
            } else if (!(sourceOwner instanceof PopUpInterface)) {
                this.addError(err.getDescription(), err, sourceOwner);
            }
        }
        this.validate();
        this.repaint();
        if (err == null) {
            this.selectError(false);
        }
    }

    void selectError(boolean selected) {
        if (this.selectedError != null) {
            this.selectedError.sourceOwner().innerSource(this.code.getText());
        }
        if (selected) {
            this.selectedError = (ErrorDisplay)this.errorList.errors.get(0);
            SourceOwner sourceOwner = this.selectedError.sourceOwner();
            if (sourceOwner != null) {
                this.locationLabel.setText(sourceOwner.classDisplayName());
            } else {
                this.locationLabel.setText("Unknown Source");
            }
            int offset = 0;
            String str = sourceOwner.innerSource();
            this.code.setEnabled(true);
            this.code.setText(str);
            this.oldText = str;
            String header = sourceOwner.headerSource();
            if (header != null) {
                offset = header.length();
            }
            if (this.foregroundView == this) {
                this.showError(this.selectedError.compilerError, offset);
            }
        } else {
            this.tabs.errorFixed();
        }
        this.validate();
        this.repaint();
    }

    private final void showError(CompilerException error, int offset) {
        this.code.select(error.getStartPosition() - offset, error.getEndPosition() - offset);
        this.code.requestFocus();
    }

    public void handleZoomedEvent(ZoomedEvent e) {
        if (this.zoomFactor != e.zoomFactor()) {
            this.zoomFactor = e.zoomFactor();
            if (this.originalFontSize == -1) {
                this.originalFontSize = this.code.getFont().getSize();
            }
            this.code.setFont(this.code.getFont().deriveFont((float)StrictMath.ceil((double)this.originalFontSize * this.zoomFactor)));
        }
    }

    public void handleCompiledEvent(CompiledEvent e) {
        if (!(e.sourceOwner() instanceof CommandLine) && !(e.sourceOwner() instanceof PopUpInterface)) {
            this.setErrors(e);
            this.invalidate();
            this.repaint();
        }
    }

    public void handleLoadBeginEvent(LoadBeginEvent e) {
        this.clearErrors();
    }

    public void handleSwitchedTabsEvent(SwitchedTabsEvent e) {
        this.foregroundView = e.newTab();
        if (e.oldTab() == this) {
            this.refreshSource(false);
        } else if (this.foregroundView == this && this.selectedError != null) {
            String header;
            SourceOwner sourceOwner = this.selectedError.sourceOwner();
            int offset = 0;
            if (sourceOwner != null && (header = sourceOwner.headerSource()) != null) {
                offset = header.length();
            }
            this.showError(this.selectedError.compilerError, offset);
        }
    }

    public void refreshSource(boolean compileButtonPressed) {
        boolean raiseSourceEvent = false;
        SourceOwner sourceOwner = null;
        if (this.selectedError != null) {
            raiseSourceEvent = true;
            String text = this.code.getText();
            sourceOwner = this.selectedError.sourceOwner();
            if (!(!text.equals(this.oldText) || compileButtonPressed && sourceOwner instanceof CommandLine)) {
                raiseSourceEvent = false;
            } else {
                sourceOwner.innerSource(text);
            }
        }
        if (compileButtonPressed) {
            new CompileAllEvent(this).raise();
        }
        if (raiseSourceEvent) {
            if (sourceOwner == this.tabs.proceduresTab) {
                ((ProceduresTab)sourceOwner).recompile();
            } else if (sourceOwner instanceof JobOwner) {
                new CompileMoreSourceEvent(this, (JobOwner)sourceOwner).raise();
            }
        }
    }

    public void select(int pos1, int pos2) {
        this.code.select(pos1, pos2);
    }

    public String getText() {
        return this.code.getText();
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex, PrinterManager printer) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.centerPanel.printAll(g2d);
        return 0;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.locationLabel = new JLabel(NO_SOURCE);
        this.errorList = new ErrorList();
        this.compileAction = new CompileAction();
        this.toolBar = new ToolBar(){

            protected final void addControls() {
                this.add(new JButton(FindDialog.FIND_ACTION));
                this.add(new JButton(FindDialog.FIND_AGAIN_ACTION));
                this.add(new ToolBar.Separator());
                this.add(new JButton(ErrorsTab.this.compileAction));
                this.add(new ToolBar.Separator());
                this.add(new ProceduresMenu(ErrorsTab.this));
            }
        };
        this.centerPanel = new JPanel();
        this.selectedError = null;
        this.originalFontSize = -1;
        this.zoomFactor = 1.0;
    }

    ErrorsTab(Workspace workspace, Tabs tabs) {
        this.this();
        this.tabs = tabs;
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.centerPanel, "Center");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.centerPanel.setLayout(gridbag);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        c.gridheight = 1;
        gridbag.setConstraints(this.errorList, c);
        this.centerPanel.add(this.errorList);
        c.insets = new Insets(6, 5, 3, 0);
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.gridheight = -1;
        gridbag.setConstraints(this.locationLabel, c);
        this.centerPanel.add(this.locationLabel);
        this.locationLabel.setFont(this.locationLabel.getFont().deriveFont(1));
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridheight = 0;
        this.code = new EditorArea(1, 1, true, new TextListener(){

            public final void textValueChanged(TextEvent e) {
                new DirtyEvent(ErrorsTab.this).raise();
            }
        }, new EditorColorizer(workspace));
        this.code.setEnabled(false);
        this.code.setBorder(BorderFactory.createEmptyBorder(4, 7, 4, 7));
        JScrollPane scrollPane = new JScrollPane(this.code, 22, 32);
        gridbag.setConstraints(scrollPane, c);
        this.centerPanel.add(scrollPane);
        this.oldText = "";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CompileAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            ErrorsTab.this.refreshSource(true);
        }

        CompileAction() {
            super("Check");
            Class clazz = class$org$nlogo$app$ErrorsTab;
            if (clazz == null) {
                clazz = class$org$nlogo$app$ErrorsTab = ErrorsTab.class("[Lorg.nlogo.app.ErrorsTab;", false);
            }
            this.putValue("SmallIcon", new ImageIcon(clazz.getResource("/images/compile.gif")));
        }
    }
}

