/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.nlogo.app.App;
import org.nlogo.app.AppletSaver;
import org.nlogo.app.LibraryDialog;
import org.nlogo.app.ModelSaver;
import org.nlogo.awt.Utils;
import org.nlogo.event.AboutToQuitEvent;
import org.nlogo.event.ExportOutputEvent;
import org.nlogo.event.ExportPlotEvent;
import org.nlogo.event.PopUpOpenEvent;
import org.nlogo.nvm.LogoException;
import org.nlogo.swing.FileDialog;
import org.nlogo.swing.Menu;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.util.Exceptions;
import org.nlogo.util.FileIO;
import org.nlogo.util.UserCancelException;
import org.nlogo.util.Version;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.ModelLoader;
import org.nlogo.workspace.ModelReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class FileMenu
extends Menu
implements AboutToQuitEvent.Raiser,
ExportOutputEvent.Raiser,
ExportPlotEvent.Raiser,
PopUpOpenEvent.Raiser {
    private static final String NEW_MODEL = "/system/NewModel.txt";
    private final App app;
    private boolean firstLoad;

    void quit() {
        try {
            this.offerSave();
            new AboutToQuitEvent(this).raise();
            System.exit(0);
        }
        catch (UserCancelException ex) {
            Exceptions.ignore(ex);
        }
    }

    private final String guessFileName() {
        String fileName = this.app.workspace.getModelFileName();
        if (fileName == null) {
            return "untitled.nlogo";
        }
        return fileName;
    }

    void newModel() throws UserCancelException, IOException {
        this.openFromURL(NEW_MODEL);
    }

    private final void openFromURL(String model) throws UserCancelException, IOException {
        String source = org.nlogo.util.Utils.url2String(model);
        if (model.equals(NEW_MODEL)) {
            this.openFromSource(source, null, "Clearing...", 0);
        } else {
            this.openFromSource(source, null, "Loading...", 2);
        }
    }

    public void openFromPath(String path, int modelType) {
        try {
            String source = FileIO.file2String(path);
            if (source == null) {
                throw new RuntimeException("couldn't open: '" + path + '\'');
            }
            this.openFromSource(source, path, "Loading...", modelType);
        }
        catch (UserCancelException ex) {
            Exceptions.ignore(ex);
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
    }

    void openFromSource(String source, String path, String message, int modelType) throws UserCancelException {
        String version;
        Map map = ModelReader.parseString(source);
        if (map == null) {
            this.notifyUserNotValidFile();
        }
        if (!(version = ModelReader.parseVersion(map)).startsWith("NetLogo")) {
            this.notifyUserNotValidFile();
        }
        if (!Version.knownVersion(version)) {
            this.checkWithUserBeforeOpeningModelFromFutureVersion(version);
        }
        this.openFromMap(map, path, message, modelType);
    }

    private final void openFromMap(final Map map, final String path, String message, final int modelType) {
        if (this.firstLoad) {
            this.firstLoad = false;
            ModelLoader.load((Container)this, path, modelType, map);
        } else {
            Runnable loader = new Runnable(){

                public final void run() {
                    ModelLoader.load((Container)FileMenu.this, path, modelType, map);
                }
            };
            new ModalProgressTask(Utils.getFrame(this), loader, message);
            this.app.tabs.requestFocus();
        }
    }

    private final void save() throws UserCancelException {
        if (this.app.workspace.forceSaveAs()) {
            this.saveAs();
        } else {
            this.doSave(this.app.workspace.getModelPath());
        }
    }

    private final void saveAs() throws UserCancelException {
        this.doSave(this.userChooseSavePath());
    }

    private final void doSave(String path) throws UserCancelException {
        Saver saver = new Saver(path);
        new ModalProgressTask(Utils.getFrame(this), saver, "Saving...");
        if (saver.exception != null) {
            JOptionPane.showMessageDialog(this, "Save failed.  Error: " + saver.exception.getMessage(), "Save Failed", 0);
        }
        if (!saver.saveResult) {
            throw new UserCancelException();
        }
    }

    public void offerSave() throws UserCancelException {
        if (this.app.workspace instanceof GUIWorkspace && this.app.workspace.movieEncoder != null) {
            String message = "There is a movie in progress. Are you sure you want to exit this model? You will lose the contents of your movie.";
            Object[] options = new String[]{"OK", "Cancel"};
            if (OptionDialog.show(this, "Warning", message, options) == 1) {
                throw new UserCancelException();
            }
            this.app.workspace.movieEncoder.cancel();
            this.app.workspace.movieEncoder = null;
        }
        if (this.app.dirtyMonitor.dirty() && this.userWantsToSaveFirst()) {
            this.save();
        }
    }

    private final String userChooseLoadPath() throws UserCancelException {
        return FileDialog.show(this, "Open: NetLogo Model", 0, null);
    }

    private final String userChooseSavePath() throws UserCancelException {
        String newFileName = this.guessFileName();
        String newDirectoryName = null;
        if (this.app.workspace.getModelType() == 1 || this.app.workspace.getModelType() == 3) {
            newDirectoryName = this.app.workspace.getModelDir();
        }
        while (true) {
            FileDialog.setDirectory(newDirectoryName);
            String path = FileDialog.show(this, "Save: NetLogo Model", 1, newFileName);
            File file = new File(path);
            newFileName = file.getName();
            newDirectoryName = path.substring(0, path.lastIndexOf(newFileName));
            int suffixIndex = newFileName.lastIndexOf(".nlogo");
            if (suffixIndex > 0 && suffixIndex == newFileName.length() - 6) {
                return path;
            }
            int dotIndex = newFileName.lastIndexOf(".");
            if (dotIndex != -1) {
                newFileName = newFileName.substring(0, dotIndex);
            }
            newFileName = newFileName + ".nlogo";
            Object[] options = new String[]{"Try Again"};
            String message = "You must choose a name ending with: .nlogo";
            OptionDialog.show(this, "Error", message, options);
        }
    }

    private final boolean userWantsToSaveFirst() throws UserCancelException {
        Object[] options = new String[]{"Save", "Discard", "Cancel"};
        String message = "Do you want to save the changes you made to this model?";
        switch (OptionDialog.show(this, "Warning", message, options)) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        throw new UserCancelException();
    }

    private final void checkWithUserBeforeOpeningModelFromFutureVersion(String version) throws UserCancelException {
        Object[] options = new String[]{"Continue", "Cancel"};
        String message = "You are attempting to open a model that was created in a newer version of NetLogo.  (This is " + Version.versionNoRev() + "; the model was created in " + version + ".) NetLogo can try to open the model, but it may or may not work.";
        if (OptionDialog.show(this, "Warning", message, options) != 0) {
            throw new UserCancelException();
        }
    }

    private final void notifyUserNotValidFile() throws UserCancelException {
        Object[] options = new String[]{"OK"};
        OptionDialog.show(this, "Error", "The file is not a valid NetLogo model file.", options);
        throw new UserCancelException();
    }

    private final /* synthetic */ void this() {
        this.firstLoad = true;
    }

    FileMenu(App app) {
        super("File");
        this.this();
        this.app = app;
        this.addMenuItem('N', (Action)new NewAction());
        this.addMenuItem('O', (Action)new OpenAction());
        if (Version.isCities()) {
            this.addMenuItem('E', (Action)new OpenSourceEditorAction());
        }
        this.addMenuItem('M', (Action)new ModelsLibraryAction());
        this.addSeparator();
        this.addMenuItem('S', (Action)new SaveAction());
        this.addMenuItem(new SaveAsAction());
        this.addMenuItem(new SaveAppletAction());
        this.addSeparator();
        this.addMenuItem("Print...", 'P', app.tabs.printAction);
        this.addSeparator();
        Menu exportMenu = new Menu("Export");
        exportMenu.addMenuItem(new ExportWorldAction());
        exportMenu.addMenuItem(new ExportPlotAction());
        exportMenu.addMenuItem(new ExportAllPlotsAction());
        exportMenu.addMenuItem(new ExportGraphicsAction());
        exportMenu.addMenuItem(new ExportInterfaceAction());
        exportMenu.addMenuItem(new ExportOutputAction());
        this.add(exportMenu);
        this.addSeparator();
        this.addMenuItem(new ImportWorldAction());
        if (!System.getProperty("os.name").startsWith("Mac")) {
            this.addSeparator();
            this.addMenuItem('Q', (Action)new QuitAction());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Saver
    implements Runnable {
        private boolean saveResult;
        private IOException exception;
        private final String path;

        public void run() {
            try {
                this.saveResult = ModelSaver.save(FileMenu.this, this.path, ((FileMenu)FileMenu.this).app.tabs);
            }
            catch (IOException ex) {
                this.saveResult = false;
                this.exception = ex;
            }
        }

        Saver(String path) {
            this.path = path;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NewAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            FileMenu.this.offerSave();
            FileMenu.this.newModel();
        }

        NewAction() {
            super("New");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class OpenAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            FileMenu.this.offerSave();
            FileMenu.this.openFromPath(FileMenu.this.userChooseLoadPath(), 1);
        }

        OpenAction() {
            super("Open...");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class OpenSourceEditorAction
    extends FileMenuAction {
        void action() throws UserCancelException {
            String path = FileDialog.show(FileMenu.this, "Open: NetLogo Source File", 0, null);
            if (path.endsWith(".nls")) {
                new PopUpOpenEvent(FileMenu.this, path).raise();
            } else {
                Exceptions.handle(new LogoException("Source file must end in *.nls"));
            }
        }

        OpenSourceEditorAction() {
            super("Open Source File...");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ModelsLibraryAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            FileMenu.this.offerSave();
            String source = LibraryDialog.open(Utils.getFrame(FileMenu.this));
            String modelPath = LibraryDialog.getModelPath();
            FileMenu.this.openFromSource(source, modelPath, "Loading...", 2);
        }

        ModelsLibraryAction() {
            super("Models Library");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SaveAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            FileMenu.this.save();
        }

        SaveAction() {
            super("Save");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SaveAsAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            FileMenu.this.saveAs();
        }

        SaveAsAction() {
            super("Save As...");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SaveAppletAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            FileMenu.this.save();
            String suggestedFileName = ((FileMenu)FileMenu.this).app.workspace.getModelFileName();
            int suffixIndex = suggestedFileName.lastIndexOf(".nlogo");
            if (suffixIndex > 0 && suffixIndex == suggestedFileName.length() - 6) {
                suggestedFileName = suggestedFileName.substring(0, suggestedFileName.length() - 6);
            }
            suggestedFileName = suggestedFileName + ".html";
            String exportPath = FileDialog.show(FileMenu.this, "Saving as Applet", 1, suggestedFileName);
            ((FileMenu)FileMenu.this).app.zoomMenu.reset();
            AppletSaver.save(Utils.getFrame(FileMenu.this), ((FileMenu)FileMenu.this).app.tabs.interfaceTab.getInterfacePanel(), ((FileMenu)FileMenu.this).app.workspace.modelNameForDisplay(), exportPath, ((FileMenu)FileMenu.this).app.workspace.getModelFileName(), ((FileMenu)FileMenu.this).app.tabs.infoTab.info());
        }

        SaveAppletAction() {
            super("Save As Applet...");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ExportWorldAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            final String exportPath = FileDialog.show(FileMenu.this, "Exporting", 1, "world.csv");
            final IOException[] exception = new IOException[1];
            new ModalProgressTask(Utils.getFrame(FileMenu.this), new Runnable(){

                public final void run() {
                    try {
                        ((FileMenu)FileMenu.this).app.workspace.exportWorld(exportPath);
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            }, "Exporting...");
            if (exception[0] != null) {
                throw exception[0];
            }
        }

        ExportWorldAction() {
            super("World...");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ExportPlotAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            final String exportPath = FileDialog.show(FileMenu.this, "Exporting", 1, "plot.csv");
            new ModalProgressTask(Utils.getFrame(FileMenu.this), new Runnable(){

                public final void run() {
                    new ExportPlotEvent(FileMenu.this, 0, null, exportPath).raise();
                }
            }, "Exporting...");
        }

        ExportPlotAction() {
            super("Plot...");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ExportAllPlotsAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            final String exportPath = FileDialog.show(FileMenu.this, "Exporting", 1, "plots.csv");
            new ModalProgressTask(Utils.getFrame(FileMenu.this), new Runnable(){

                public final void run() {
                    new ExportPlotEvent(FileMenu.this, 1, null, exportPath).raise();
                }
            }, "Exporting...");
        }

        ExportAllPlotsAction() {
            super("All Plots...");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ExportGraphicsAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            final String exportPath = FileDialog.show(FileMenu.this, "Exporting", 1, "graphics.png");
            final IOException[] exception = new IOException[1];
            new ModalProgressTask(Utils.getFrame(FileMenu.this), new Runnable(){

                public final void run() {
                    try {
                        ((FileMenu)FileMenu.this).app.workspace.exportGraphics(exportPath, "png");
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            }, "Exporting...");
            if (exception[0] != null) {
                throw exception[0];
            }
        }

        ExportGraphicsAction() {
            super("Graphics...");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ExportInterfaceAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            final String exportPath = FileDialog.show(FileMenu.this, "Exporting", 1, "interface.png");
            final IOException[] exception = new IOException[1];
            new ModalProgressTask(Utils.getFrame(FileMenu.this), new Runnable(){

                public final void run() {
                    try {
                        ((FileMenu)FileMenu.this).app.workspace.exportInterface(exportPath);
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            }, "Exporting...");
            if (exception[0] != null) {
                throw exception[0];
            }
        }

        ExportInterfaceAction() {
            super("Interface...");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ExportOutputAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            final String exportPath = FileDialog.show(FileMenu.this, "Exporting", 1, "output.txt");
            new ModalProgressTask(Utils.getFrame(FileMenu.this), new Runnable(){

                public final void run() {
                    new ExportOutputEvent(FileMenu.this, exportPath).raise();
                }
            }, "Exporting...");
        }

        ExportOutputAction() {
            super("Output...");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ImportWorldAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            final String importPath = FileDialog.show(FileMenu.this, "Importing", 0, null);
            final IOException[] exception = new IOException[1];
            new ModalProgressTask(Utils.getFrame(FileMenu.this), new Runnable(){

                public final void run() {
                    try {
                        ((FileMenu)FileMenu.this).app.workspace.importWorld(importPath);
                        ((FileMenu)FileMenu.this).app.workspace.graphicsWindow.dirty();
                        ((FileMenu)FileMenu.this).app.workspace.graphicsWindow.repaint();
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            }, "Importing...");
            if (exception[0] != null) {
                throw exception[0];
            }
        }

        ImportWorldAction() {
            super("Import World...");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class QuitAction
    extends FileMenuAction {
        void action() throws UserCancelException, IOException {
            FileMenu.this.quit();
        }

        QuitAction() {
            super("Quit");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private abstract class FileMenuAction
    extends AbstractAction {
        abstract void action() throws UserCancelException, IOException;

        public void actionPerformed(ActionEvent e) {
            try {
                this.action();
            }
            catch (UserCancelException ex) {
                Exceptions.ignore(ex);
            }
            catch (IOException ex) {
                Exceptions.handle(ex);
            }
            catch (RuntimeException ex) {
                Exceptions.handle(ex);
            }
        }

        FileMenuAction(String name) {
            super(name);
        }
    }
}

