/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.app.ProceduresTab;
import org.nlogo.compiler.Compiler;
import org.nlogo.event.PopUpOpenEvent;
import org.nlogo.swing.ToolBarMenu;

public strictfp class IncludesMenu
extends ToolBarMenu
implements PopUpOpenEvent.Raiser {
    ProceduresTab target;
    private Map includesTable;

    protected Map getIncludesTable() {
        return Compiler.findIncludes(this.target.workspace.getModelPath(), this.target.getText());
    }

    protected void populate(JPopupMenu menu) {
        this.includesTable = this.getIncludesTable();
        ArrayList<String> includes = new ArrayList<String>();
        Iterator includesIter = this.includesTable.keySet().iterator();
        while (includesIter.hasNext()) {
            includes.add((String)includesIter.next());
        }
        if (includes.isEmpty()) {
            JMenuItem nullItem = new JMenuItem("<No Includes Defined>");
            nullItem.setEnabled(false);
            menu.add(nullItem);
        } else {
            Collections.sort(includes, String.CASE_INSENSITIVE_ORDER);
            int i = 0;
            while (i < includes.size()) {
                final String include = (String)includes.get(i);
                JMenuItem item = new JMenuItem(include);
                item.addActionListener(new ActionListener(){

                    public final void actionPerformed(ActionEvent e) {
                        IncludesMenu.this.menuSelection(include);
                    }
                });
                menu.add(item);
                ++i;
            }
        }
    }

    protected void menuSelection(String s) {
        String filename = (String)this.includesTable.get(s);
        new PopUpOpenEvent(this, filename).raise();
    }

    IncludesMenu() {
        super("Includes");
        this.target = null;
    }

    IncludesMenu(ProceduresTab target) {
        super("Includes");
        this.target = target;
    }
}

