/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.nlogo.event.DirtyEvent;
import org.nlogo.event.LoadSectionEvent;
import org.nlogo.event.ZoomedEvent;
import org.nlogo.swing.FindDialog;
import org.nlogo.swing.Printable;
import org.nlogo.swing.PrinterManager;
import org.nlogo.swing.ToolBar;
import org.nlogo.swing.UndoManager;
import org.nlogo.util.Exceptions;
import org.nlogo.workspace.ModelReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class InfoTab
extends JPanel
implements DocumentListener,
DirtyEvent.Raiser,
LoadSectionEvent.Handler,
ZoomedEvent.Handler,
Printable {
    private final JTextArea textArea;
    private int numberOfSetTextEvents;
    private final UndoManager undoManager;
    private int originalFontSize;
    private double zoomFactor;

    public void doLayout() {
        int extraWidth = this.getWidth() - this.textArea.getPreferredScrollableViewportSize().width - 7;
        extraWidth = StrictMath.max(7, extraWidth);
        this.textArea.setBorder(BorderFactory.createEmptyBorder(4, 7, 4, extraWidth));
        super.doLayout();
    }

    private final ToolBar getToolBar() {
        return new ToolBar(){

            protected final void addControls() {
                this.add(new JButton(FindDialog.FIND_ACTION));
                this.add(new JButton(FindDialog.FIND_AGAIN_ACTION));
            }
        };
    }

    public void requestFocus() {
        this.textArea.requestFocus();
    }

    public void info(String str) {
        try {
            if (!str.equals(this.info())) {
                ++this.numberOfSetTextEvents;
                this.textArea.setText(str);
                this.textArea.setCaretPosition(0);
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
        this.undoManager.discardAllEdits();
    }

    public String info() {
        return this.textArea.getText();
    }

    public void handleLoadSectionEvent(LoadSectionEvent e) {
        if (e.section() == ModelReader.INFO) {
            this.info(e.text());
        }
    }

    public void handleZoomedEvent(ZoomedEvent e) {
        if (this.zoomFactor != e.zoomFactor()) {
            this.zoomFactor = e.zoomFactor();
            if (this.originalFontSize == -1) {
                this.originalFontSize = this.textArea.getFont().getSize();
            }
            this.textArea.setFont(this.textArea.getFont().deriveFont((float)StrictMath.ceil((double)this.originalFontSize * this.zoomFactor)));
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public void changedUpdate(DocumentEvent e) {
        this.changed();
    }

    public void insertUpdate(DocumentEvent e) {
        this.changed();
    }

    public void removeUpdate(DocumentEvent e) {
        this.changed();
    }

    private final void changed() {
        try {
            if (this.numberOfSetTextEvents <= 0) {
                this.numberOfSetTextEvents = 0;
                new DirtyEvent(this).raise();
            } else {
                --this.numberOfSetTextEvents;
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex, PrinterManager printer) throws PrinterException {
        return printer.printText(g, pageFormat, pageIndex, this.textArea.getText());
    }

    private final /* synthetic */ void this() {
        this.textArea = new JTextArea(0, 90);
        this.numberOfSetTextEvents = 0;
        this.undoManager = new UndoManager();
        this.originalFontSize = -1;
        this.zoomFactor = 1.0;
    }

    InfoTab() {
        this.this();
        this.textArea.addFocusListener(new FocusListener(){

            public final void focusGained(FocusEvent fe) {
                FindDialog.setActionsEnabled(true);
                UndoManager.setCurrentManager(InfoTab.this.undoManager);
            }

            public final void focusLost(FocusEvent fe) {
                FindDialog.setActionsEnabled(false);
                if (!fe.isTemporary()) {
                    UndoManager.setCurrentManager(null);
                }
            }
        });
        this.textArea.setDragEnabled(false);
        this.textArea.setEditable(true);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.getDocument().addDocumentListener(this);
        this.textArea.getDocument().addUndoableEditListener(this.undoManager);
        this.textArea.setFont(new Font(System.getProperty("os.name").startsWith("Mac") ? "Monaco" : "Monospaced", 0, 12));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getToolBar(), "North");
        JScrollPane scrollPane = new JScrollPane(this.textArea, 22, 30);
        this.add((Component)scrollPane, "Center");
        if (System.getProperty("os.name").startsWith("Mac") && System.getProperty("os.version").startsWith("10.2.")) {
            JComponent macHackComponent = new JComponent(){

                public final Dimension getMinimumSize() {
                    return new Dimension(0, 14);
                }

                public final Dimension getPreferredSize() {
                    return new Dimension(0, 14);
                }
            };
            this.add((Component)macHackComponent, "South");
        }
    }
}

